<?php $__env->startPush('meta'); ?>
    <title><?php echo e("Zasady dotyczące prywatności - $website_title"); ?></title>
    <meta name="description" content="<?php echo e("Zobacz, na co zwraca uwagę $website_title, aby chronić Twoje dane. Polityka prywatności wyjaśnia, jak postępujemy w kwestii transparentności danych."); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container page-inner pt-5">
        <h1>Polityka prywatności</h1>
        <main>
            <p><span class="b"><?php echo e(aiTrans('Dostawca', $locale)); ?></span> (“<?php echo e(aiTrans('my', $locale)); ?>”,
                “<?php echo e(aiTrans('my', $locale)); ?>”, lub “<?php echo e(aiTrans('nasz', $locale)); ?>”) <?php echo e(aiTrans('działa na', $locale)); ?>

                <span class="u"><?php echo e($website_title); ?></span> <?php echo e(aiTrans('stronie internetowej (zwanej „Usługą”).', $locale)); ?></p>
            <p><?php echo e(aiTrans('Ta strona informuje Cię o naszych zasadach dotyczących zbierania, wykorzystywania i ujawniania danych osobowych, gdy korzystasz z naszej Usługi oraz wyborach, które masz związane z tymi danymi.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('My,', $locale)); ?> <a href="<?php echo e(route('home', $country)); ?>"><?php echo e($website_title); ?></a>,
                <?php echo e(aiTrans('używamy Twoich danych do świadczenia i ulepszania Usługi. Korzystając z Usługi, zgadzasz się na zbieranie i wykorzystywanie informacji zgodnie z tą polityką. O ile nie zdefiniowano inaczej w tej Polityce prywatności, terminy używane w tej Polityce prywatności mają te same znaczenia, co w naszych Warunkach korzystania, dostępnych pod adresem', $locale)); ?>

                <span class="u"><?php echo e($website_title); ?></span></p>
            <div id="toc_container" class="no_bullets">
                <ul class="toc_list">
                    <ul>
                        <li>
                            <ul>
                                <li><a href="#Definicje"><span class="toc_number toc_depth_3">0.0.1</span>
                                        <?php echo e(aiTrans('Definicje', $locale)); ?></a>
                                    <ul>
                                        <li><a href="#Usługa"><span class="toc_number toc_depth_4">0.0.1.1</span>
                                                <?php echo e(aiTrans('Usługa', $locale)); ?></a></li>
                                    </ul>
                                </li>
                                <li><a href="#Dane_osobowe"><span class="toc_number toc_depth_3">0.0.2</span>
                                        <?php echo e(aiTrans('Dane osobowe', $locale)); ?></a></li>
                                <li><a href="#Dane_użytkowania"><span class="toc_number toc_depth_3">0.0.3</span>
                                        <?php echo e(aiTrans('Dane użytkowania', $locale)); ?></a></li>
                                <li><a href="#Ciasteczka"><span class="toc_number toc_depth_3">0.0.4</span>
                                        <?php echo e(aiTrans('Ciasteczka', $locale)); ?></a></li>
                                <li><a href="#Administrator_danych"><span class="toc_number toc_depth_3">0.0.5</span>
                                        <?php echo e(aiTrans('Administrator danych', $locale)); ?></a></li>
                                <li><a href="#Podmioty_przetwarzające_lub_dostawcy_usług"><span
                                            class="toc_number toc_depth_3">0.0.6</span>
                                        <?php echo e(aiTrans('Podmioty przetwarzające dane (lub dostawcy usług)', $locale)); ?></a></li>
                                <li><a href="#Podmiot_danych_lub_użytkownik"><span class="toc_number toc_depth_3">0.0.7</span>
                                        <?php echo e(aiTrans('Podmiot danych (lub użytkownik)', $locale)); ?></a></li>
                            </ul>
                        </li>
                    </ul>
                    <li><a href="#Zbieranie_i_użytkowanie_informacji"><span class="toc_number toc_depth_1">1</span>
                            <?php echo e(aiTrans('Zbieranie i użytkowanie informacji', $locale)); ?></a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Rodzaje_zbieranych_danych"><span class="toc_number toc_depth_3">1.0.1</span>
                                            <?php echo e(aiTrans('Rodzaje zbieranych danych', $locale)); ?></a></li>
                                    <li><a href="#Dane_osobowe-2"><span class="toc_number toc_depth_3">1.0.2</span>
                                            <?php echo e(aiTrans('Dane osobowe', $locale)); ?></a></li>
                                    <li><a href="#Dane_użytkowania-2"><span class="toc_number toc_depth_3">1.0.3</span>
                                            <?php echo e(aiTrans('Dane użytkowania', $locale)); ?></a></li>
                                    <li><a href="#Dane_ciasteczek_śledzących"><span class="toc_number toc_depth_3">1.0.4</span>
                                            <?php echo e(aiTrans('Dane ciasteczek śledzących', $locale)); ?></a></li>
                                    <li><a href="#Wykorzystanie_danych"><span class="toc_number toc_depth_3">1.0.5</span>
                                            <?php echo e(aiTrans('Wykorzystanie danych', $locale)); ?></a></li>
                                    <li><a
                                            href="#Podstawa_prawna_przetwarzania_danych_osobowych_zgodnie_z_Rozporządzeniem_o_ochronie_danych_osobowych_GDPR"><span
                                                class="toc_number toc_depth_3">1.0.6</span>
                                            <?php echo e(aiTrans('Podstawa prawna przetwarzania danych osobowych zgodnie z ogólnym rozporządzeniem o ochronie danych (GDPR)', $locale)); ?></a>
                                    </li>
                                    <li><a href="#Przechowywanie_danych"><span class="toc_number toc_depth_3">1.0.7</span>
                                            <?php echo e(aiTrans('Przechowywanie danych', $locale)); ?></a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#Transfer_danych"><span class="toc_number toc_depth_1">2</span>
                            <?php echo e(aiTrans('Transfer danych', $locale)); ?></a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Ujawnienie_danych"><span class="toc_number toc_depth_3">2.0.1</span>
                                            <?php echo e(aiTrans('Ujawnienie danych', $locale)); ?></a>
                                        <ul>
                                            <li><a href="#Transakcja_gospodarcza"><span
                                                        class="toc_number toc_depth_4">2.0.1.1</span>
                                                    <?php echo e(aiTrans('Transakcja gospodarcza', $locale)); ?></a></li>
                                        </ul>
                                    </li>
                                    <li><a href="#Wymagania_prawne"><span class="toc_number toc_depth_3">2.0.2</span>
                                            <?php echo e(aiTrans('Wymagania prawne', $locale)); ?></a></li>
                                    <li><a href="#Bezpieczeństwo_danych"><span class="toc_number toc_depth_3">2.0.3</span>
                                            <?php echo e(aiTrans('Bezpieczeństwo danych', $locale)); ?></a></li>
                                    <li><a
                                            href="#Twoje_prawa_ochrony_danych_zgodnie_z_Rozporządzeniem_o_ochronie_danych_osobowych_GDPR"><span
                                                class="toc_number toc_depth_3">2.0.4</span>
                                            <?php echo e(aiTrans('Twoje prawa ochrony danych zgodnie z ogólnym rozporządzeniem o ochronie danych (GDPR)', $locale)); ?></a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#Dostawcy_usług"><span class="toc_number toc_depth_1">3</span>
                            <?php echo e(aiTrans('Dostawcy usług', $locale)); ?></a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Analiza"><span class="toc_number toc_depth_3">3.0.1</span>
                                            <?php echo e(aiTrans('Analiza', $locale)); ?></a></li>
                                    <li><a href="#Reklama"><span class="toc_number toc_depth_3">3.0.2</span>
                                            <?php echo e(aiTrans('Reklama', $locale)); ?></a></li>
                                    <li><a href="#Remarketing_behawioralny"><span class="toc_number toc_depth_3">3.0.3</span>
                                            <?php echo e(aiTrans('Remarketing behawioralny', $locale)); ?></a></li>
                                    <li><a href="#Linki_do_innych_stron"><span class="toc_number toc_depth_3">3.0.4</span>
                                            <?php echo e(aiTrans('Linki do innych stron', $locale)); ?></a></li>
                                    <li><a href="#Prywatność_dzieci"><span class="toc_number toc_depth_3">3.0.5</span>
                                            <?php echo e(aiTrans('Prywatność dzieci', $locale)); ?></a></li>
                                    <li><a href="#Zmiany_w_tym_polityka_prywatności"><span
                                                class="toc_number toc_depth_3">3.0.6</span>
                                            <?php echo e(aiTrans('Zmiany w tej polityce prywatności', $locale)); ?></a></li>
                                    <li><a href="#Skontaktuj_się_z_nami"><span class="toc_number toc_depth_3">3.0.7</span>
                                            <?php echo e(aiTrans('Skontaktuj się z nami', $locale)); ?></a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
            <h4><span id="Definicje"><?php echo e(aiTrans('Definicje', $locale)); ?></span></h4>
            <h5><span id="Usługa"><?php echo e(aiTrans('Usługa', $locale)); ?></span></h5>
            <p><?php echo e(aiTrans('Usługa to', $locale)); ?> <span class="u"><?php echo e($website_title); ?></span>
                <?php echo e(aiTrans('strona internetowa prowadzona przez', $locale)); ?> <span class="b">Dostawcę</span></p>
            <h4><span id="Dane_osobowe"><?php echo e(aiTrans('Dane osobowe', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Dane osobowe oznaczają dane dotyczące żywej osoby, która może być identyfikowana na podstawie tych danych (lub na podstawie tych i innych informacji, które są w naszej posiadaniu lub które mogą znaleźć się w naszej posiadaniu).', $locale)); ?>

            </p>
            <h4><span id="Dane_użytkowania"><?php echo e(aiTrans('Dane użytkowania', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Dane użytkowania to dane zbierane automatycznie, generowane przez korzystanie z Usługi lub z infrastruktury Usługi (na przykład czas wizyty na stronie).', $locale)); ?>

            </p>
            <h4><span id="Ciasteczka"><?php echo e(aiTrans('Ciasteczka', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Ciasteczka to małe pliki danych przechowywane na Twoim urządzeniu (komputerze lub urządzeniu mobilnym).', $locale)); ?>

            </p>
            <h4><span id="Administrator_danych"><?php echo e(aiTrans('Administrator danych', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Administrator danych oznacza osobę fizyczną lub prawną, która (samodzielnie lub wspólnie z innymi osobami) określa cele i sposób przetwarzania danych osobowych. Na potrzeby tej Polityki prywatności jesteśmy administratorem danych Twoich danych osobowych.', $locale)); ?>

            </p>
            <h4><span
                    id="Podmioty_przetwarzające_lub_dostawcy_usług"><?php echo e(aiTrans('Podmioty przetwarzające dane (lub dostawcy usług)', $locale)); ?></span>
            </h4>
            <p><?php echo e(aiTrans('Podmiot przetwarzający (lub dostawca usług) oznacza każdą osobę fizyczną lub prawną, która przetwarza dane w imieniu administratora danych. Możemy korzystać z usług różnych dostawców usług, aby skuteczniej przetwarzać Twoje dane.', $locale)); ?>

            </p>
            <h4><span id="Podmiot_danych_lub_użytkownik"><?php echo e(aiTrans('Podmiot danych (lub użytkownik)', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Podmiot danych to każda żywa osoba, która korzysta z naszej Usługi i jest przedmiotem danych osobowych.', $locale)); ?>

            </p>
            <h2><span id="Zbieranie_i_użytkowanie_informacji"><?php echo e(aiTrans('Zbieranie i użytkowanie informacji', $locale)); ?></span>
            </h2>
            <p><?php echo e(aiTrans('Zbieramy kilka różnych rodzajów informacji w różnych celach, aby zapewnić i ulepszyć naszą Usługę dla Ciebie.', $locale)); ?>

            </p>
            <h4><span id="Rodzaje_zbieranych_danych"><?php echo e(aiTrans('Rodzaje zbieranych danych', $locale)); ?></span></h4>
            <h4><span id="Dane_osobowe-2"><?php echo e(aiTrans('Dane osobowe', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Korzystając z naszej Usługi, możemy poprosić Cię o podanie nam pewnych danych osobowych, które mogą być używane do kontaktu lub identyfikacji Ciebie (“Dane osobowe”). Dane osobowe mogą obejmować, ale nie są ograniczone do:', $locale)); ?>

            </p>
            <ul>
                <li><?php echo e(aiTrans('Adres e-mail', $locale)); ?></li>
                <li><?php echo e(aiTrans('Imię i nazwisko', $locale)); ?></li>
                <li><?php echo e(aiTrans('Numer telefonu', $locale)); ?></li>
                <li><?php echo e(aiTrans('Adres, stan, prowincja, kod pocztowy, miasto', $locale)); ?></li>
                <li><?php echo e(aiTrans('Ciasteczka i dane użytkowania', $locale)); ?></li>
            </ul>
            <p><?php echo e(aiTrans('Możemy używać Twoich danych osobowych, aby kontaktować się z Tobą w sprawie newsletterów, materiałów marketingowych lub promocyjnych oraz innych informacji, które mogą Cię zainteresować. Możesz zrezygnować z otrzymywania dowolnej lub wszystkich tych komunikacji od nas, klikając link rezygnacji lub postępując zgodnie z instrukcjami zawartymi w dowolnym e-mailu, który wysyłamy, lub kontaktując się z nami.', $locale)); ?>

            </p>
            <h4><span id="Dane_użytkowania-2"><?php echo e(aiTrans('Dane użytkowania', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Możemy również zbierać informacje o tym, jak Usługa jest uzyskiwana i używana (“Dane użytkowania”). Te Dane użytkowania mogą zawierać informacje, takie jak adres protokołu internetowego (np. adres IP) Twojego komputera, typ przeglądarki, wersja przeglądarki, strony naszej Usługi, które odwiedzasz, czas i datę wizyty, czas spędzony na tych stronach, unikalne identyfikatory urządzenia i inne dane diagnostyczne.', $locale)); ?>

            </p>
            <h4><span id="Dane_ciasteczek_śledzących"><?php echo e(aiTrans('Dane ciasteczek śledzących', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Używamy ciasteczek i podobnych technologii śledzenia, aby śledzić aktywność na naszej Usłudze i przechowywać określone informacje.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Ciasteczka to pliki z niewielką ilością danych, które mogą zawierać anonimowy unikalny identyfikator. Ciasteczka są wysyłane do Twojej przeglądarki z witryny internetowej i przechowywane na Twoim urządzeniu. Inne technologie śledzące to sygnały, tagi i skrypty, które zbierają i śledzą informacje oraz poprawiają i analizują naszą Usługę.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Możesz poinstruować swoją przeglądarkę, aby odrzucała wszystkie ciasteczka lub informowała, gdy ciasteczko jest wysyłane. Jednak jeśli nie zaakceptujesz ciasteczek, możesz nie być w stanie korzystać z niektórych części naszej Usługi.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Przykłady ciasteczek, które używamy:', $locale)); ?></p>
            <ul>
                <li><strong><?php echo e(aiTrans('Ciasteczka sesyjne.', $locale)); ?></strong>
                    <?php echo e(aiTrans('Używamy ciasteczek sesyjnych do działania naszej Usługi.', $locale)); ?></li>
                <li><strong><?php echo e(aiTrans('Ciasteczka preferencyjne.', $locale)); ?></strong>
                    <?php echo e(aiTrans('Używamy ciasteczek preferencyjnych, aby zapamiętać Twoje preferencje i różne ustawienia.', $locale)); ?>

                </li>
                <li><strong><?php echo e(aiTrans('Ciasteczka zabezpieczające.', $locale)); ?></strong>
                    <?php echo e(aiTrans('Używamy ciasteczek zabezpieczających w celach bezpieczeństwa.', $locale)); ?></li>
                <li><strong><?php echo e(aiTrans('Ciasteczka reklamowe.', $locale)); ?></strong>
                    <?php echo e(aiTrans('Ciasteczka reklamowe są używane do serwowania reklam, które mogą być istotne dla Ciebie i Twoich zainteresowań.', $locale)); ?>

                </li>
            </ul>
            <h4><span id="Wykorzystanie_danych"><?php echo e(aiTrans('Wykorzystanie danych', $locale)); ?></span></h4>
            <p><span class="b">Dostawca</span> <?php echo e(aiTrans('używa zebranych danych do różnych celów:', $locale)); ?>

            </p>
            <ul>
                <li><?php echo e(aiTrans('Aby zapewnić i utrzymać naszą Usługę', $locale)); ?></li>
                <li><?php echo e(aiTrans('Aby powiadomić Cię o zmianach w naszej Usłudze', $locale)); ?></li>
                <li><?php echo e(aiTrans('Aby umożliwić Ci udział w interaktywnych funkcjach naszej Usługi, gdy zdecydujesz się to zrobić', $locale)); ?>

                </li>
                <li><?php echo e(aiTrans('Aby zapewnić wsparcie klienta', $locale)); ?></li>
                <li><?php echo e(aiTrans('Aby zbierać analizy lub wartościowe informacje, abyśmy mogli poprawić naszą Usługę', $locale)); ?>

                </li>
                <li><?php echo e(aiTrans('Aby monitorować korzystanie z naszej Usługi', $locale)); ?></li>
                <li><?php echo e(aiTrans('Aby wykrywać, zapobiegać i rozwiązywać problemy techniczne', $locale)); ?></li>
                <li><?php echo e(aiTrans('Aby dostarczać Ci wiadomości, oferty specjalne i ogólne informacje o innych towarach, usługach i wydarzeniach, które oferujemy i które są podobne do tych, które już kupiłeś lub o które pytałeś, chyba że zdecydowałeś się nie otrzymywać takich informacji', $locale)); ?>

                </li>
            </ul>
            <h4><span
                    id="Podstawa_prawna_przetwarzania_danych_osobowych_zgodnie_z_Rozporządzeniem_o_ochronie_danych_osobowych_GDPR"><?php echo e(aiTrans('Podstawa prawna przetwarzania danych osobowych zgodnie z ogólnym rozporządzeniem o ochronie danych (GDPR)', $locale)); ?></span>
            </h4>
            <p><?php echo e(aiTrans('Jeśli jesteś z Europejskiego Obszaru Gospodarczego (EOG),', $locale)); ?> <span
                    class="b">Dostawca</span>
                <?php echo e(aiTrans('podstawa prawna zbierania i wykorzystywania danych osobowych opisanych w tej Polityce prywatności zależy od danych osobowych, które zbieramy, oraz konkretnego kontekstu, w którym je zbieramy.', $locale)); ?>

            </p>
            <p><span class="b">Dostawca</span> <?php echo e(aiTrans('może przetwarzać Twoje dane osobowe, ponieważ:', $locale)); ?></p>
            <ul>
                <li><?php echo e(aiTrans('Musimy wykonać umowę z Tobą', $locale)); ?></li>
                <li><?php echo e(aiTrans('Dałeś nam pozwolenie na to', $locale)); ?></li>
                <li><?php echo e(aiTrans('Przetwarzanie leży w naszych uzasadnionych interesach i nie jest nadrzędne w stosunku do Twoich praw', $locale)); ?>

                </li>
                <li><?php echo e(aiTrans('Aby przestrzegać prawa', $locale)); ?></li>
            </ul>
            <h4><span id="Przechowywanie_danych"><?php echo e(aiTrans('Przechowywanie danych', $locale)); ?></span></h4>
            <p><span class="b">Dostawca</span>
                <?php echo e(aiTrans('będzie przechowywał Twoje dane osobowe tylko tak długo, jak to konieczne w celu realizacji celów określonych w tej Polityce prywatności. Będziemy przechowywać i wykorzystywać Twoje dane osobowe w zakresie koniecznym do przestrzegania naszych zobowiązań prawnych (na przykład, jeśli jesteśmy zobowiązani do przechowywania Twoich danych, aby przestrzegać obowiązujących przepisów prawa), rozwiązywać spory i egzekwować nasze umowy prawne i polityki.', $locale)); ?>

            </p>
            <p><span class="b">Dostawca</span>
                <?php echo e(aiTrans('będzie również przechowywał dane użytkowania do celów analizy wewnętrznej. Dane użytkowania są generalnie przechowywane przez krótszy okres, chyba że te dane są wykorzystywane do wzmocnienia bezpieczeństwa lub poprawy funkcjonalności naszej Usługi, lub jesteśmy prawnie zobowiązani do przechowywania tych danych przez dłuższy czas.', $locale)); ?>

            </p>
            <h2><span id="Transfer_danych"><?php echo e(aiTrans('Transfer danych', $locale)); ?></span></h2>
            <p><?php echo e(aiTrans('Twoje informacje, w tym dane osobowe, mogą być przesyłane do — i przechowywane na — komputerach znajdujących się poza Twoim stanem, prowincją, krajem lub inną jurysdykcją rządową, gdzie przepisy dotyczące ochrony danych mogą różnić się od tych w Twojej jurysdykcji.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Jeśli znajdujesz się poza Bułgarią i zdecydujesz się dostarczyć nam informacje, pamiętaj, że przesyłamy dane, w tym dane osobowe, do Bułgarii i przetwarzamy je tam.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Twoja zgoda na tę Politykę prywatności, poprzedzona przesłaniem takich informacji, stanowi Twoją zgodę na ten transfer.', $locale)); ?>

            </p>
            <p><span class="b">Dostawca</span>
                <?php echo e(aiTrans('podejmie wszystkie kroki, które są rozsądnie konieczne, aby zapewnić, że Twoje dane są traktowane w sposób bezpieczny i zgodnie z tą Polityką prywatności, a transfer Twoich danych osobowych nie będzie miał miejsca do organizacji ani kraju, chyba że będą zapewnione odpowiednie zabezpieczenia, w tym bezpieczeństwo Twoich danych i innych informacji osobistych.', $locale)); ?>

            </p>
            <h4><span id="Ujawnienie_danych"><?php echo e(aiTrans('Ujawnienie danych', $locale)); ?></span></h4>
            <h5><span id="Transakcja_gospodarcza"><?php echo e(aiTrans('Transakcja gospodarcza', $locale)); ?></span></h5>
            <p><?php echo e(aiTrans('Jeśli', $locale)); ?> <span class="b">Dostawca</span>
                <?php echo e(aiTrans('jest zaangażowany w fuzję, przejęcie lub sprzedaż aktywów, Twoje dane osobowe mogą być przesyłane. Poinformujemy Cię przed tym, jak Twoje dane osobowe zostaną przesłane i będą podlegały innej Polityce prywatności.', $locale)); ?>

            </p>
            <h4><span id="Wymagania_prawne"><?php echo e(aiTrans('Wymagania prawne', $locale)); ?></span></h4>
            <p><span class="b">Dostawca</span>
                <?php echo e(aiTrans('może ujawnić Twoje dane osobowe w dobrej wierze, że takie działanie jest konieczne, aby:', $locale)); ?>

            </p>
            <ul>
                <li><?php echo e(aiTrans('Aby przestrzegać zobowiązania prawnego', $locale)); ?></li>
                <li><?php echo e(aiTrans('Aby chronić i bronić praw lub własności', $locale)); ?> <span
                        class="b">Dostawcy</span></li>
                <li><?php echo e(aiTrans('Aby zapobiegać lub prowadzić dochodzenia w sprawie potencjalnych nadużyć w związku z Usługą', $locale)); ?>

                </li>
                <li><?php echo e(aiTrans('Aby chronić bezpieczeństwo osobiste użytkowników Usługi lub społeczeństwa', $locale)); ?></li>
                <li><?php echo e(aiTrans('Aby chronić przed odpowiedzialnością prawną', $locale)); ?></li>
            </ul>
            <h4><span id="Bezpieczeństwo_danych"><?php echo e(aiTrans('Bezpieczeństwo danych', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Bezpieczeństwo Twoich danych jest dla nas ważne, ale pamiętaj, że żadna metoda transmisji przez Internet ani metoda przechowywania elektronicznego nie jest w 100% bezpieczna. Choć staramy się korzystać z akceptowanych komercyjnie środków w celu ochrony Twoich danych osobowych, nie możemy zagwarantować ich całkowitego bezpieczeństwa.', $locale)); ?>

            </p>
            <h4><span
                    id="Twoje_prawa_ochrony_danych_zgodnie_z_Rozporządzeniem_o_ochronie_danych_osobowych_GDPR"><?php echo e(aiTrans('Twoje prawa ochrony danych zgodnie z ogólnym rozporządzeniem o ochronie danych (GDPR)', $locale)); ?></span>
            </h4>
            <p><?php echo e(aiTrans('Jeśli jesteś mieszkańcem Europejskiego Obszaru Gospodarczego (EOG), masz określone prawa dotyczące ochrony danych.', $locale)); ?>

                <span class="b">Dostawca</span>
                <?php echo e(aiTrans('dąży do podjęcia rozsądnych kroków, aby umożliwić Ci poprawienie, zmodyfikowanie, usunięcie lub ograniczenie korzystania z Twoich danych osobowych.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Jeśli chcesz wiedzieć, jakie dane osobowe posiadamy o Tobie i chcesz, aby zostały one usunięte z naszych systemów, skontaktuj się z nami.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('W niektórych okolicznościach masz następujące prawa dotyczące ochrony danych:', $locale)); ?></p>
            <p><strong><?php echo e(aiTrans('Prawo do dostępu, aktualizacji lub usunięcia informacji, które mamy o Tobie.', $locale)); ?></strong>
                <?php echo e(aiTrans('Gdy tylko to możliwe, możesz uzyskać dostęp, zaktualizować lub zażądać usunięcia swoich danych osobowych bezpośrednio w sekcji ustawień swojego konta. Jeśli nie jesteś w stanie samodzielnie wykonać tych działań, skontaktuj się z nami, aby Ci w tym pomóc.', $locale)); ?><br>
                <strong><?php echo e(aiTrans('Prawo do poprawienia danych.', $locale)); ?></strong>
                <?php echo e(aiTrans('Masz prawo do poprawienia swoich informacji, jeśli te informacje są niedokładne lub niekompletne.', $locale)); ?><br>
                <strong><?php echo e(aiTrans('Prawo do sprzeciwu.', $locale)); ?></strong>
                <?php echo e(aiTrans('Masz prawo sprzeciwić się przetwarzaniu Twoich danych osobowych.', $locale)); ?><br>
                <strong><?php echo e(aiTrans('Prawo do ograniczenia przetwarzania.', $locale)); ?></strong>
                <?php echo e(aiTrans('Masz prawo do zażądania ograniczenia przetwarzania Twoich informacji osobowych.', $locale)); ?><br>
                <strong><?php echo e(aiTrans('Prawo do przenoszenia danych.', $locale)); ?></strong>
                <?php echo e(aiTrans('Masz prawo do otrzymania kopii informacji, które mamy o Tobie w strukturalnym, nadającym się do przetwarzania maszynowego i powszechnie używanym formacie.', $locale)); ?><br>
                <strong><?php echo e(aiTrans('Prawo do wycofania zgody.', $locale)); ?></strong>
                <?php echo e(aiTrans('Masz również prawo do wycofania swojej zgody w dowolnym momencie, gdy', $locale)); ?> <span
                    class="b">Dostawca</span>
                <?php echo e(aiTrans('polegał na Twojej zgodzie, aby przetwarzać Twoje informacje osobowe.', $locale)); ?></p>
            <p><?php echo e(aiTrans('Pamiętaj, że możemy poprosić Cię o potwierdzenie tożsamości przed odpowiedzią na takie prośby.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Masz prawo do złożenia skargi do organu ochrony danych w sprawie naszego zbierania i wykorzystywania Twoich danych osobowych. Aby uzyskać więcej informacji, skontaktuj się z lokalnym organem ochrony danych w Europejskim Obszarze Gospodarczym (EOG).', $locale)); ?>

            </p>
            <h2><span id="Dostawcy_usług"><?php echo e(aiTrans('Dostawcy usług', $locale)); ?></span></h2>
            <p><?php echo e(aiTrans('Możemy zatrudniać firmy i osoby trzecie w celu ułatwienia naszej Usługi („Dostawcy usług”), aby świadczyć Usługę w naszym imieniu, wykonywać usługi związane z Usługą lub pomagać nam w analizowaniu, jak nasza Usługa jest używana.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Ci zewnętrzni dostawcy mają dostęp do Twoich danych osobowych tylko w celu wykonania tych zadań w naszym imieniu i są zobowiązani do nieujawniania ani nieużywania ich do żadnych innych celów.', $locale)); ?>

            </p>
            <h4><span id="Analiza"><?php echo e(aiTrans('Analiza', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Możemy korzystać z usług dostawców zewnętrznych w celu monitorowania i analizowania korzystania z naszej Usługi.', $locale)); ?>

            </p>
            <p><strong><?php echo e(aiTrans('Google Analytics', $locale)); ?></strong><br>
                <?php echo e(aiTrans('Google Analytics to usługa analizy internetowej oferowana przez Google, która śledzi i raportuje ruch na stronie internetowej. Google wykorzystuje zebrane dane do śledzenia i monitorowania korzystania z naszej Usługi. Te dane są udostępniane innym usługom Google. Google może używać zebranych danych do kontekstualizacji i personalizacji reklam własnej sieci reklamowej. Możesz zrezygnować z udostępnienia swojej aktywności w Usłudze Google Analytics, instalując dodatek do przeglądarki do rezygnacji z Google Analytics. Dodatek zapobiega, aby JavaScript Google Analytics (ga.js, analytics.js i dc.js) dzielił się informacjami z Google Analytics o aktywności wizyt. Aby uzyskać więcej informacji na temat praktyk prywatności Google, odwiedź stronę internetową warunków prywatności Google:', $locale)); ?>

                <a href="https://www.google.com/intl/en/policies/privacy/" target="_blank"
                    rel="noopener">http://www.google.com/intl/en/policies/privacy/</a></p>
            <h4><span id="Reklama"><?php echo e(aiTrans('Reklama', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Możemy korzystać z dostawców zewnętrznych, aby wyświetlać reklamy dla Ciebie, aby wspierać i utrzymywać naszą Usługę.', $locale)); ?>

            </p>
            <p><strong><?php echo e(aiTrans('Ciasteczko Google AdSense DoubleClick', $locale)); ?></strong><br>
                <?php echo e(aiTrans('Google, jako zewnętrzny dostawca, używa ciasteczek do wyświetlania reklam na naszej Usłudze. Użycie ciasteczka DoubleClick przez Google umożliwia jemu i jego partnerom wyświetlanie reklam naszym użytkownikom na podstawie ich wizyty w naszej Usłudze lub innych stronach internetowych w Internecie. Możesz zrezygnować z używania ciasteczka DoubleClick w reklamach opartych na zainteresowaniach, odwiedzając stronę internetową ustawień reklam Google:', $locale)); ?>

                <a href="https://www.google.com/ads/preferences/" target="_blank"
                    rel="noopener">http://www.google.com/ads/preferences/</a></p>
            <h4><span id="Remarketing_behawioralny"><?php echo e(aiTrans('Remarketing behawioralny', $locale)); ?></span></h4>
            <p><span class="b">Dostawca</span>
                <?php echo e(aiTrans('używa usług remarketingowych do reklamowania się na stronach trzecich po tym, jak odwiedziłeś naszą Usługę. My i nasi zewnętrzni dostawcy używamy ciasteczek, aby informować, optymalizować i serwować reklamy na podstawie Twoich wcześniejszych wizyt w naszej Usłudze.', $locale)); ?>

            </p>
            <p><strong><?php echo e(aiTrans('Google AdWords', $locale)); ?></strong><br>
                <?php echo e(aiTrans('Usługa remarketingu Google AdWords jest świadczona przez Google Inc. Możesz zrezygnować z Google Analytics w celu reklamy displayowej i dostosować reklamy sieci Google Display, odwiedzając stronę ustawień reklam Google: http://www.google.com/settings/ads Google zaleca również zainstalowanie dodatku do przeglądarki Google Analytics Opt-out – https://tools.google.com/dlpage/gaoptout – dla Twojej przeglądarki internetowej. Dodatek Google Analytics Opt-out daje odwiedzającym możliwość zapobiegania zbieraniu i wykorzystywaniu ich danych przez Google Analytics. Aby uzyskać więcej informacji na temat praktyk prywatności Google, odwiedź stronę internetową warunków prywatności Google:', $locale)); ?>

                <a href="https://www.google.com/intl/en/policies/privacy/" target="_blank"
                    rel="noopener">http://www.google.com/intl/en/policies/privacy/</a></p>
            <p><strong><?php echo e(aiTrans('Facebook', $locale)); ?></strong><br>
                <?php echo e(aiTrans('Usługa remarketingu Facebooka jest świadczona przez Facebook Inc. Możesz dowiedzieć się więcej o reklamach opartych na zainteresowaniach z Facebooka, odwiedzając tę stronę:', $locale)); ?>

                <a href="https://www.facebook.com/help/164968693837950" target="_blank"
                    rel="noopener">https://www.facebook.com/help/164968693837950</a>
                <?php echo e(aiTrans('Aby zrezygnować z reklam opartych na zainteresowaniach Facebooka, postępuj zgodnie z tymi instrukcjami od Facebooka:', $locale)); ?>

                <a href="https://www.facebook.com/help/568137493302217" target="_blank"
                    rel="noopener">https://www.facebook.com/help/568137493302217</a>
                <?php echo e(aiTrans('Facebook przestrzega zasad samoregulacyjnych dla reklam behawioralnych w Internecie ustanowionych przez Digital Advertising Alliance. Możesz również zrezygnować z Facebooka i innych uczestniczących firm poprzez Digital Advertising Alliance w USA', $locale)); ?>

                <a href="http://www.aboutads.info/choices/" target="_blank"
                    rel="noopener">http://www.aboutads.info/choices/</a>,
                <?php echo e(aiTrans('Digital Advertising Alliance of Canada w Kanadzie', $locale)); ?> <a
                    href="http://youradchoices.ca/" target="_blank" rel="noopener">http://youradchoices.ca/</a>
                <?php echo e(aiTrans('lub Europejska Interaktywna Digital Advertising Alliance w Europie', $locale)); ?> <a
                    href="http://www.youronlinechoices.eu/" target="_blank"
                    rel="noopener">http://www.youronlinechoices.eu/</a>,
                <?php echo e(aiTrans('lub zrezygnować, korzystając z ustawień urządzenia mobilnego. Aby uzyskać więcej informacji na temat praktyk prywatności Facebooka, odwiedź stronę Polityki danych Facebooka:', $locale)); ?>

                <a href="https://www.facebook.com/privacy/explanation" target="_blank"
                    rel="noopener">https://www.facebook.com/privacy/explanation</a></p>
            <h4><span id="Linki_do_innych_stron"><?php echo e(aiTrans('Linki do innych stron', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Nasza Usługa może zawierać linki do innych witryn, które nie są przez nas obsługiwane. Jeśli klikniesz w link do strony trzeciej, zostaniesz przekierowany na stronę tej strony trzeciej. Zdecydowanie zalecamy zapoznanie się z Polityką prywatności każdej witryny, którą odwiedzasz.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Nie mamy kontroli nad ani nie ponosimy odpowiedzialności za treści, polityki prywatności lub praktyki jakichkolwiek stron lub usług osób trzecich.', $locale)); ?>

            </p>
            <h4><span id="Prywatność_dzieci"><?php echo e(aiTrans('Prywatność dzieci', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Nasza Usługa nie jest skierowana do nikogo poniżej 18 roku życia (“Dzieci”).', $locale)); ?></p>
            <p><?php echo e(aiTrans('Nie zbieramy świadomie danych osobowych od nikogo poniżej 18 roku życia. Jeśli jesteś rodzicem lub opiekunem i wiesz, że Twoje Dzieci przekazały nam dane osobowe, skontaktuj się z nami. Jeśli dowiemy się, że zebraliśmy dane osobowe od dzieci bez weryfikacji zgody rodziców, podejmiemy kroki, aby usunąć te informacje z naszych serwerów.', $locale)); ?>

            </p>
            <h4><span id="Zmiany_w_tym_polityka_prywatności"><?php echo e(aiTrans('Zmiany w tej polityce prywatności', $locale)); ?></span>
            </h4>
            <p><?php echo e(aiTrans('Możemy aktualizować naszą Politykę prywatności od czasu do czasu. Poinformujemy Cię o wszelkich zmianach, publikując nową Politykę prywatności na tej stronie.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Powiadomimy Cię za pomocą wiadomości e-mail i/lub wyraźnego powiadomienia na naszej Usłudze, przed tym, jak zmiana wejdzie w życie, i zaktualizujemy “datę wejścia w życie” na górze tej Polityki prywatności.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Zaleca się okresowe przeglądanie tej Polityki prywatności w celu sprawdzenia wszelkich zmian. Zmiany w tej Polityce prywatności są skuteczne, gdy zostaną opublikowane na tej stronie.', $locale)); ?>

            </p>
            <h4><span id="Skontaktuj_się_z_nami"><?php echo e(aiTrans('Skontaktuj się z nami', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Jeśli masz jakiekolwiek pytania dotyczące tej Polityki prywatności, skontaktuj się z nami za pośrednictwem e-maila.', $locale)); ?>

            </p>
        </main>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/eenn281/public_html/cor28en1.com/resources/views/frontend/pl/privacy.blade.php ENDPATH**/ ?>