<?php $__env->startPush('meta'); ?>
    <title><?php echo e("Sulla tutela dei dati su $website_title"); ?></title>
    <meta name="description" content="<?php echo e("Conosci le soluzioni di sicurezza applicate da $website_title per tutelare i tuoi dati identificabili. Esamina la nostra policy sulla privacy."); ?>" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container page-inner pt-5">
        <h1>Informativa sulla Privacy</h1>
        <main>
            <p><span class="b">Provider</span> (“noi”, “ci”, o “nostro”) gestisce il sito web <span
                    class="u"><?php echo e($website_title); ?></span> (il “Servizio”).</p>
            <p><?php echo e(aiTrans('Questa pagina ti informa sulle nostre politiche riguardanti la raccolta, l’uso e la divulgazione dei dati personali quando utilizzi il nostro Servizio e le scelte che hai associate a quei dati.')); ?>

            </p>
            <p>Noi, <a href="<?php echo e(route('home', $country)); ?>"><?php echo e($website_title); ?></a>,
                <?php echo e(aiTrans('utilizziamo i tuoi dati per fornire e migliorare il Servizio. Utilizzando il Servizio, accetti la raccolta e l’uso delle informazioni in conformità a questa politica. Salvo diversa definizione in questa Informativa sulla privacy, i termini utilizzati in questa Informativa sulla privacy hanno gli stessi significati come nei nostri Termini e Condizioni, accessibili da')); ?>

                <span class="u"><?php echo e($website_title); ?></span></p>
            <div id="toc_container" class="no_bullets">
                <ul class="toc_list">
                    <ul>
                        <li>
                            <ul>
                                <li><a href="#Definitions"><span class="toc_number toc_depth_3">0.0.1</span>
                                        <?php echo e(aiTrans('Definizioni')); ?></a>
                                    <ul>
                                        <li><a href="#Service"><span class="toc_number toc_depth_4">0.0.1.1</span>
                                                <?php echo e(aiTrans('Servizio')); ?></a></li>
                                    </ul>
                                </li>
                                <li><a href="#Personal_Data"><span class="toc_number toc_depth_3">0.0.2</span>
                                        <?php echo e(aiTrans('Dati Personali')); ?></a></li>
                                <li><a href="#Usage_Data"><span class="toc_number toc_depth_3">0.0.3</span>
                                        <?php echo e(aiTrans('Dati di Utilizzo')); ?></a></li>
                                <li><a href="#Cookies"><span class="toc_number toc_depth_3">0.0.4</span>
                                        <?php echo e(aiTrans('Cookie')); ?></a></li>
                                <li><a href="#Data_Controller"><span class="toc_number toc_depth_3">0.0.5</span>
                                        <?php echo e(aiTrans('Titolare del Trattamento dei Dati')); ?></a></li>
                                <li><a href="#Data_Processors_or_Service_Providers"><span
                                            class="toc_number toc_depth_3">0.0.6</span>
                                        <?php echo e(aiTrans('Responsabili del Trattamento (o Fornitori di Servizi)')); ?></a></li>
                                <li><a href="#Data_Subject_or_User"><span class="toc_number toc_depth_3">0.0.7</span>
                                        <?php echo e(aiTrans('Soggetto dei Dati (o Utente)')); ?></a></li>
                            </ul>
                        </li>
                    </ul>
                    <li><a href="#Information_Collection_And_Use"><span
                                class="toc_number toc_depth_1">1</span><?php echo e(aiTrans(' Raccolta e Uso delle Informazioni')); ?></a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Types_of_Data_Collected"><span
                                                class="toc_number toc_depth_3">1.0.1</span><?php echo e(aiTrans(' Tipi di Dati Raccolti')); ?></a>
                                    </li>
                                    <li><a href="#Personal_Data-2"><span
                                                class="toc_number toc_depth_3">1.0.2</span><?php echo e(aiTrans(' Dati Personali')); ?></a>
                                    </li>
                                    <li><a href="#Usage_Data-2"><span
                                                class="toc_number toc_depth_3">1.0.3</span><?php echo e(aiTrans(' Dati di Utilizzo')); ?></a>
                                    </li>
                                    <li><a href="#Tracking_Cookies_Data"><span
                                                class="toc_number toc_depth_3">1.0.4</span><?php echo e(aiTrans(' Dati dei Cookie di Monitoraggio')); ?></a>
                                    </li>
                                    <li><a href="#Use_of_Data"><span
                                                class="toc_number toc_depth_3">1.0.5</span><?php echo e(aiTrans(' Uso dei Dati')); ?></a>
                                    </li>
                                    <li><a
                                            href="#Legal_Basis_for_Processing_Personal_Data_Under_General_Data_Protection_Regulation_GDPR"><span
                                                class="toc_number toc_depth_3">1.0.6</span><?php echo e(aiTrans(' Base Giuridica per il Trattamento dei Dati Personali ai sensi del Regolamento Generale sulla Protezione dei Dati (GDPR)')); ?></a>
                                    </li>
                                    <li><a href="#Retention_of_Data"><span
                                                class="toc_number toc_depth_3">1.0.7</span><?php echo e(aiTrans(' Conservazione dei Dati')); ?></a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#Transfer_Of_Data"><span
                                class="toc_number toc_depth_1">2</span><?php echo e(aiTrans(' Trasferimento dei Dati')); ?></a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Disclosure_Of_Data"><span
                                                class="toc_number toc_depth_3">2.0.1</span><?php echo e(aiTrans(' Divulgazione dei Dati')); ?>

                                            </a>
                                        <ul>
                                            <li><a href="#Business_Transaction"><span
                                                        class="toc_number toc_depth_4">2.0.1.1</span><?php echo e(aiTrans(' Transazione Commerciale')); ?></a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li><a href="#Legal_Requirements"><span
                                                class="toc_number toc_depth_3">2.0.2</span><?php echo e(aiTrans(' Requisiti Legali')); ?></a>
                                    </li>
                                    <li><a href="#Security_Of_Data"><span
                                                class="toc_number toc_depth_3">2.0.3</span><?php echo e(aiTrans(' Sicurezza dei Dati')); ?></a>
                                    </li>
                                    <li><a
                                            href="#Your_Data_Protection_Rights_Under_General_Data_Protection_Regulation_GDPR"><span
                                                class="toc_number toc_depth_3">2.0.4</span><?php echo e(aiTrans(' I Tuoi Diritti di Protezione dei Dati ai sensi del Regolamento Generale sulla Protezione dei Dati (GDPR)')); ?></a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#Service_Providers"><span
                                class="toc_number toc_depth_1">3</span><?php echo e(aiTrans('Fornitori di Servizi')); ?></a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Analytics"><span
                                                class="toc_number toc_depth_3">3.0.1</span><?php echo e(aiTrans(' Analisi')); ?></a>
                                    </li>
                                    <li><a href="#Advertising"><span
                                                class="toc_number toc_depth_3">3.0.2</span><?php echo e(aiTrans(' Pubblicità')); ?></a>
                                    </li>
                                    <li><a href="#Behavioral_Remarketing"><span
                                                class="toc_number toc_depth_3">3.0.3</span><?php echo e(aiTrans(' Remarketing Comportamentale')); ?></a>
                                    </li>
                                    <li><a href="#Links_To_Other_Sites"><span
                                                class="toc_number toc_depth_3">3.0.4</span><?php echo e(aiTrans(' Link ad Altri Siti')); ?></a>
                                    </li>
                                    <li><a href="#Children8217s_Privacy"><span
                                                class="toc_number toc_depth_3">3.0.5</span><?php echo e(aiTrans(' Privacy dei Bambini')); ?></a>
                                    </li>
                                    <li><a href="#Changes_To_This_Privacy_Policy"><span
                                                class="toc_number toc_depth_3">3.0.6</span><?php echo e(aiTrans(' Modifiche a Questa Informativa sulla Privacy')); ?></a>
                                    </li>
                                    <li><a href="#Contact_Us"><span
                                                class="toc_number toc_depth_3">3.0.7</span><?php echo e(aiTrans(' Contattaci')); ?></a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
            <h4><span id="Definitions"><?php echo e(aiTrans('Definizioni')); ?></span></h4>
            <h5><span id="Service"><?php echo e(aiTrans('Servizio')); ?></span></h5>
            <p>Il Servizio è il <span class="u"><?php echo e($website_title); ?></span> <?php echo e(aiTrans('sito web gestito da')); ?> <span
                    class="b"><?php echo e(aiTrans('Provider')); ?></span></p>
            <h4><span id="Personal_Data"><?php echo e(aiTrans('Dati Personali')); ?></span></h4>
            <p><?php echo e(aiTrans('I Dati Personali sono dati relativi a una persona vivente che può essere identificata da tali dati (o da questi e altre informazioni in nostro possesso o che è probabile che entrino in nostro possesso).')); ?>

            </p>
            <h4><span id="Usage_Data"><?php echo e(aiTrans('Dati di Utilizzo')); ?></span></h4>
            <p><?php echo e(aiTrans('I Dati di Utilizzo sono dati raccolti automaticamente, generati dall’uso del Servizio o dall’infrastruttura stessa del Servizio (ad esempio, la durata di una visita a una pagina).', $locale)); ?>

            </p>
            <h4><span id="Cookies"><?php echo e(aiTrans('Cookie', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('I cookie sono piccoli pezzi di dati memorizzati sul tuo dispositivo (computer o dispositivo mobile).', $locale)); ?>

            </p>
            <h4><span id="Data_Controller"><?php echo e(aiTrans('Titolare del Trattamento dei Dati', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Il Titolare del Trattamento dei Dati è la persona fisica o giuridica che (singolarmente o insieme ad altre persone) determina le finalità e le modalità del trattamento dei dati personali. Ai fini della presente Informativa sulla Privacy, noi siamo Titolari del Trattamento dei tuoi Dati Personali.', $locale)); ?>

            </p>
            <h4><span
                    id="Data_Processors_or_Service_Providers"><?php echo e(aiTrans('Responsabili del Trattamento (o Fornitori di Servizi)', $locale)); ?></span>
            </h4>
            <p><?php echo e(aiTrans('Il Responsabile del Trattamento (o Fornitore di Servizi) è qualsiasi persona fisica o giuridica che tratta i dati per conto del Titolare del Trattamento. Potremmo utilizzare i servizi di vari Fornitori di Servizi per elaborare i tuoi dati in modo più efficace.', $locale)); ?>

            </p>
            <h4><span id="Data_Subject_or_User"><?php echo e(aiTrans('Soggetto dei Dati (o Utente)', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Il Soggetto dei Dati è qualsiasi persona vivente che utilizza il nostro Servizio ed è oggetto dei Dati Personali.', $locale)); ?>

            </p>
            <h2><span id="Information_Collection_And_Use"><?php echo e(aiTrans('Raccolta e Uso delle Informazioni', $locale)); ?></span>
            </h2>
            <p><?php echo e(aiTrans('Raccogliamo diversi tipi di informazioni per vari scopi per fornire e migliorare il nostro Servizio per te.', $locale)); ?>

            </p>
            <h4><span id="Types_of_Data_Collected"><?php echo e(aiTrans('Tipi di Dati Raccolti', $locale)); ?></span></h4>
            <h4><span id="Personal_Data-2"><?php echo e(aiTrans('Dati Personali', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Durante l’utilizzo del nostro Servizio, potremmo chiederti di fornirci alcune informazioni personali identificabili che possono essere utilizzate per contattarti o identificarti (“Dati Personali”). Le informazioni personali identificabili possono includere, ma non sono limitate a:', $locale)); ?>

            </p>
            <ul>
                <li><?php echo e(aiTrans('Indirizzo email', $locale)); ?></li>
                <li><?php echo e(aiTrans('Nome e cognome', $locale)); ?></li>
                <li><?php echo e(aiTrans('Numero di telefono', $locale)); ?></li>
                <li><?php echo e(aiTrans('Indirizzo, Stato, Provincia, CAP, Città', $locale)); ?></li>
                <li><?php echo e(aiTrans('Cookie e Dati di Utilizzo', $locale)); ?></li>
            </ul>
            <p><?php echo e(aiTrans('Potremmo utilizzare i tuoi Dati Personali per contattarti con newsletter, materiali di marketing o promozionali e altre informazioni che potrebbero interessarti. Puoi disiscriverti dalla ricezione di tali comunicazioni seguendo il link di disiscrizione o le istruzioni fornite in qualsiasi email che inviamo o contattandoci.', $locale)); ?>

            </p>
            <h4><span id="Usage_Data-2"><?php echo e(aiTrans('Dati di Utilizzo', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Potremmo anche raccogliere informazioni su come il Servizio viene accesso e utilizzato (“Dati di Utilizzo”). Questi Dati di Utilizzo possono includere informazioni come l’indirizzo IP del computer (ad es. indirizzo IP), tipo di browser, versione del browser, le pagine del nostro Servizio che visiti, l’ora e la data della tua visita, il tempo trascorso su quelle pagine, identificatori unici del dispositivo e altri dati diagnostici.', $locale)); ?>

            </p>
            <h4><span id="Tracking_Cookies_Data"><?php echo e(aiTrans('Dati dei Cookie di Monitoraggio', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Utilizziamo i cookie e tecnologie di tracciamento simili per monitorare l’attività sul nostro Servizio e mantenere determinate informazioni.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('I cookie sono file con piccole quantità di dati che possono includere un identificatore unico anonimo. I cookie vengono inviati al tuo browser da un sito web e memorizzati sul tuo dispositivo. Le tecnologie di tracciamento utilizzate includono anche beacon, tag e script per raccogliere e tracciare informazioni e per migliorare e analizzare il nostro Servizio.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Puoi istruire il tuo browser a rifiutare tutti i cookie o ad indicare quando viene inviato un cookie. Tuttavia, se non accetti i cookie, potresti non essere in grado di utilizzare alcune parti del nostro Servizio.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Esempi di Cookie che utilizziamo:', $locale)); ?></p>
            <ul>
                <li><strong><?php echo e(aiTrans('Cookie di Sessione.', $locale)); ?></strong>
                    <?php echo e(aiTrans('Utilizziamo i Cookie di Sessione per gestire il nostro Servizio.', $locale)); ?></li>
                <li><strong><?php echo e(aiTrans('Cookie di Preferenza.', $locale)); ?></strong>
                    <?php echo e(aiTrans('Utilizziamo i Cookie di Preferenza per ricordare le tue preferenze e varie impostazioni.', $locale)); ?>

                </li>
                <li><strong><?php echo e(aiTrans('Cookie di Sicurezza.', $locale)); ?></strong>
                    <?php echo e(aiTrans('Utilizziamo i Cookie di Sicurezza per motivi di sicurezza.', $locale)); ?></li>
                <li><strong><?php echo e(aiTrans('Cookie Pubblicitari.', $locale)); ?></strong>
                    <?php echo e(aiTrans('I Cookie Pubblicitari vengono utilizzati per fornirti annunci che potrebbero essere rilevanti per te e per i tuoi interessi.', $locale)); ?>

                </li>
            </ul>
            <h4><span id="Use_of_Data"><?php echo e(aiTrans('Uso dei Dati', $locale)); ?></span></h4>
            <p><span class="b"><?php echo e(aiTrans('Provider', $locale)); ?></span>
                <?php echo e(aiTrans('utilizza i dati raccolti per vari scopi:', $locale)); ?></p>
            <ul>
                <li><?php echo e(aiTrans('Per fornire e mantenere il nostro Servizio', $locale)); ?></li>
                <li><?php echo e(aiTrans('Per notificarti eventuali modifiche al nostro Servizio', $locale)); ?></li>
                <li><?php echo e(aiTrans('Per permetterti di partecipare a funzioni interattive del nostro Servizio quando scegli di farlo', $locale)); ?>

                </li>
                <li><?php echo e(aiTrans('Per fornire assistenza clienti', $locale)); ?></li>
                <li><?php echo e(aiTrans('Per raccogliere analisi o informazioni preziose per poter migliorare il nostro Servizio', $locale)); ?>

                </li>
                <li><?php echo e(aiTrans('Per monitorare l’utilizzo del nostro Servizio', $locale)); ?></li>
                <li><?php echo e(aiTrans('Per rilevare, prevenire e risolvere problemi tecnici', $locale)); ?></li>
                <li><?php echo e(aiTrans('Per fornirti notizie, offerte speciali e informazioni generali su altri beni, servizi ed eventi che offriamo simili a quelli che hai già acquistato o richiesto, a meno che tu non abbia scelto di non ricevere tali informazioni', $locale)); ?>

                </li>
            </ul>
            <h4><span id="Legal_Basis_for_Processing_Personal_Data_Under_General_Data_Protection_Regulation_GDPR">Base
                    Giuridica per il Trattamento dei Dati Personali ai sensi del Regolamento Generale sulla Protezione dei Dati (GDPR)</span></h4>
            <h4><span
                    id="Legal_Basis_for_Processing_Personal_Data_Under_General_Data_Protection_Regulation_GDPR"><?php echo e(aiTrans('Base Giuridica per il Trattamento dei Dati Personali ai sensi del Regolamento Generale sulla Protezione dei Dati (GDPR)', $locale)); ?></span>
            </h4>
            <p><?php echo e(aiTrans('Se sei residente nell’Area Economica Europea (EEA),', $locale)); ?> <span
                    class="b"><?php echo e(aiTrans('Provider', $locale)); ?></span>
                <?php echo e(aiTrans('la base giuridica per la raccolta e l’uso delle informazioni personali descritte in questa Informativa sulla privacy dipende dai Dati Personali che raccogliamo e dal contesto specifico in cui li raccogliamo.', $locale)); ?>

            </p>
            <p><span class="b"><?php echo e(aiTrans('Provider', $locale)); ?></span>
                <?php echo e(aiTrans('può trattare i tuoi Dati Personali perché:', $locale)); ?></p>
            <ul>
                <li><?php echo e(aiTrans('Abbiamo bisogno di eseguire un contratto con te', $locale)); ?></li>
                <li><?php echo e(aiTrans('Ci hai dato il permesso di farlo', $locale)); ?></li>
                <li><?php echo e(aiTrans('Il trattamento è nei nostri interessi legittimi e non è superato dai tuoi diritti', $locale)); ?>

                </li>
                <li><?php echo e(aiTrans('Per ottemperare alla legge', $locale)); ?></li>
            </ul>
            <h4><span id="Retention_of_Data"><?php echo e(aiTrans('Conservazione dei Dati', $locale)); ?></span></h4>
            <p><span class="b"><?php echo e(aiTrans('Provider', $locale)); ?></span>
                <?php echo e(aiTrans('conserverà i tuoi Dati Personali solo per il tempo necessario a soddisfare le finalità indicate in questa Informativa sulla privacy. Conserveremo e utilizzeremo i tuoi Dati Personali nella misura necessaria per ottemperare ai nostri obblighi legali (ad esempio, se siamo tenuti a conservare i tuoi dati per rispettare leggi applicabili), risolvere controversie e far rispettare i nostri accordi legali e le nostre politiche.', $locale)); ?>

            </p>
            <p><span class="b"><?php echo e(aiTrans('Provider', $locale)); ?></span>
                <?php echo e(aiTrans('conserverà anche i Dati di Utilizzo per fini di analisi interna. I Dati di Utilizzo vengono generalmente conservati per un periodo di tempo più breve, tranne quando questi dati vengono utilizzati per rafforzare la sicurezza o per migliorare la funzionalità del nostro Servizio, o siamo legalmente obbligati a conservare questi dati per periodi di tempo più lunghi.', $locale)); ?>

            </p>
            <h2><span id="Transfer_Of_Data"><?php echo e(aiTrans('Trasferimento dei Dati', $locale)); ?></span></h2>
            <p><?php echo e(aiTrans('Le tue informazioni, inclusi i Dati Personali, possono essere trasferite a — e mantenute su — computer situati al di fuori del tuo stato, provincia, paese o altra giurisdizione governativa dove le leggi sulla protezione dei dati possono differire da quelle della tua giurisdizione.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Se ti trovi al di fuori della Bulgaria e scegli di fornirci informazioni, ti preghiamo di notare che trasferiamo i dati, inclusi i Dati Personali, in Bulgaria e li trattiamo lì.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Il tuo consenso a questa Informativa sulla privacy seguito dalla tua sottomissione di tali informazioni rappresenta il tuo accordo a tale trasferimento.', $locale)); ?>

            </p>
            <p><span class="b"><?php echo e(aiTrans('Provider', $locale)); ?></span>
                <?php echo e(aiTrans('prenderà tutte le misure ragionevolmente necessarie per garantire che i tuoi dati siano trattati in modo sicuro e in conformità a questa Informativa sulla privacy e nessun trasferimento dei tuoi Dati Personali avrà luogo a un’organizzazione o a un paese a meno che non siano in atto controlli adeguati, inclusa la sicurezza dei tuoi dati e di altre informazioni personali.', $locale)); ?>

            </p>
            <h4><span id="Disclosure_Of_Data"><?php echo e(aiTrans('Divulgazione dei Dati', $locale)); ?></span></h4>
            <h5><span id="Business_Transaction"><?php echo e(aiTrans('Transazione Commerciale', $locale)); ?></span></h5>
            <p><?php echo e(aiTrans('Se', $locale)); ?> <span class="b"><?php echo e(aiTrans('Provider', $locale)); ?></span>
                <?php echo e(aiTrans('è coinvolto in una fusione, acquisizione o vendita di beni, i tuoi Dati Personali possono essere trasferiti. Ti informeremo prima che i tuoi Dati Personali siano trasferiti e diventino soggetti a un’Informativa sulla privacy diversa.', $locale)); ?>

            </p>
            <h4><span id="Legal_Requirements"><?php echo e(aiTrans('Requisiti Legali', $locale)); ?></span></h4>
            <p><span class="b"><?php echo e(aiTrans('Provider', $locale)); ?></span>
                <?php echo e(aiTrans('può divulgare i tuoi Dati Personali in buona fede ritenendo che tale azione sia necessaria per:', $locale)); ?>

            </p>
            <ul>
                <li><?php echo e(aiTrans('Ottemperare a un obbligo legale', $locale)); ?></li>
                <li><?php echo e(aiTrans('Proteggere e difendere i diritti o la proprietà di', $locale)); ?> <span
                        class="b"><?php echo e(aiTrans('Provider', $locale)); ?></span></li>
                <li><?php echo e(aiTrans('Prevenire o indagare possibili comportamenti illeciti in relazione al Servizio', $locale)); ?>

                </li>
                <li><?php echo e(aiTrans('Proteggere la sicurezza personale degli utenti del Servizio o del pubblico', $locale)); ?></li>
                <li><?php echo e(aiTrans('Proteggere contro responsabilità legali', $locale)); ?></li>
            </ul>
            <h4><span id="Security_Of_Data"><?php echo e(aiTrans('Sicurezza dei Dati', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('La sicurezza dei tuoi dati è importante per noi, ma ricorda che nessun metodo di trasmissione su Internet o metodo di archiviazione elettronica è 100% sicuro. Mentre ci sforziamo di utilizzare mezzi commercialmente accettabili per proteggere i tuoi Dati Personali, non possiamo garantire la loro sicurezza assoluta.', $locale)); ?>

            </p>
            <h4><span
                    id="Your_Data_Protection_Rights_Under_General_Data_Protection_Regulation_GDPR"><?php echo e(aiTrans('I Tuoi Diritti di Protezione dei Dati ai sensi del Regolamento Generale sulla Protezione dei Dati (GDPR)', $locale)); ?></span>
            </h4>
            <p><?php echo e(aiTrans('Se sei residente nell’Area Economica Europea (EEA), hai determinati diritti di protezione dei dati.', $locale)); ?>

                <span class="b"><?php echo e(aiTrans('Provider', $locale)); ?></span>
                <?php echo e(aiTrans('si impegna a compiere sforzi ragionevoli per consentirti di correggere, modificare, eliminare o limitare l’uso dei tuoi Dati Personali.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Se desideri essere informato sui Dati Personali che possediamo su di te e se desideri che vengano rimossi dai nostri sistemi, ti preghiamo di contattarci.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('In determinate circostanze, hai i seguenti diritti di protezione dei dati:', $locale)); ?></p>
            <p><strong><?php echo e(aiTrans('Il diritto di accesso, aggiornamento o eliminazione delle informazioni che abbiamo su di te.', $locale)); ?></strong>
                <?php echo e(aiTrans('Quando possibile, puoi accedere, aggiornare o richiedere l’eliminazione dei tuoi Dati Personali direttamente nella sezione delle impostazioni del tuo account. Se non sei in grado di eseguire queste azioni da solo, ti preghiamo di contattarci per assisterti.', $locale)); ?><br>
                <strong><?php echo e(aiTrans('Il diritto di rettifica.', $locale)); ?></strong>
                <?php echo e(aiTrans('Hai il diritto di avere le tue informazioni rettificate se queste informazioni sono imprecise o incomplete.', $locale)); ?><br>
                <strong><?php echo e(aiTrans('Il diritto di opposizione.', $locale)); ?></strong>
                <?php echo e(aiTrans('Hai il diritto di opporsi al nostro trattamento dei tuoi Dati Personali.', $locale)); ?><br>
                <strong><?php echo e(aiTrans('Il diritto di limitazione.', $locale)); ?></strong>
                <?php echo e(aiTrans('Hai il diritto di richiedere che limitiamo il trattamento delle tue informazioni personali.', $locale)); ?><br>
                <strong><?php echo e(aiTrans('Il diritto alla portabilità dei dati.', $locale)); ?></strong>
                <?php echo e(aiTrans('Hai il diritto di ricevere una copia delle informazioni che abbiamo su di te in un formato strutturato, leggibile da una macchina e comunemente usato.', $locale)); ?><br>
                <strong><?php echo e(aiTrans('Il diritto di revoca del consenso.', $locale)); ?></strong>
                <?php echo e(aiTrans('Hai anche il diritto di revocare il tuo consenso in qualsiasi momento in cui', $locale)); ?> <span
                    class="b"><?php echo e(aiTrans('Provider', $locale)); ?></span>
                <?php echo e(aiTrans('si è basato sul tuo consenso per trattare le tue informazioni personali.', $locale)); ?></p>
            <p><?php echo e(aiTrans('Ti preghiamo di notare che potremmo chiederti di verificare la tua identità prima di rispondere a tali richieste.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Hai il diritto di presentare un reclamo a un’autorità di protezione dei dati riguardo alla nostra raccolta e utilizzo dei tuoi Dati Personali. Per ulteriori informazioni, ti preghiamo di contattare l’autorità locale di protezione dei dati nell’Area Economica Europea (EEA).', $locale)); ?>

            </p>
            <h2><span id="Service_Providers"><?php echo e(aiTrans('Fornitori di Servizi', $locale)); ?></span></h2>
            <p><?php echo e(aiTrans('Potremmo avvalerci di aziende e persone terze per facilitare il nostro Servizio (“Fornitori di Servizi”), per fornire il Servizio per nostro conto, per eseguire servizi correlati al Servizio o per assisterci nell’analisi di come viene utilizzato il nostro Servizio.', $locale)); ?>

            </p>
            <p><?php echo e(aiTrans('Queste terze parti hanno accesso ai tuoi Dati Personali solo per svolgere questi compiti per nostro conto e sono obbligate a non divulgare o utilizzare i tuoi dati per nessun altro scopo.', $locale)); ?>

            </p>
            <h4><span id="Analytics"><?php echo e(aiTrans('Analisi', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Potremmo utilizzare fornitori di servizi terzi per monitorare e analizzare l’uso del nostro Servizio.', $locale)); ?>

            </p>
            <p><strong><?php echo e(aiTrans('Google Analytics', $locale)); ?></strong><br>
                <?php echo e(aiTrans('Google Analytics è un servizio di analisi web offerto da Google che traccia e riporta il traffico del sito web. Google utilizza i dati raccolti per monitorare e analizzare l’uso del nostro Servizio. Questi dati vengono condivisi con altri servizi Google. Google può utilizzare i dati raccolti per contestualizzare e personalizzare gli annunci della propria rete pubblicitaria. Puoi scegliere di non avere le tue attività sul Servizio disponibili per Google Analytics installando il componente aggiuntivo del browser di esclusione di Google Analytics. Il componente aggiuntivo impedisce al JavaScript di Google Analytics (ga.js, analytics.js e dc.js) di condividere informazioni con Google Analytics sulle attività di visita. Per ulteriori informazioni sulle pratiche di privacy di Google, ti preghiamo di visitare la pagina web dei Termini sulla Privacy di Google:', $locale)); ?>

                <a href="https://www.google.com/intl/en/policies/privacy/" target="_blank"
                    rel="noopener"><?php echo e(aiTrans('http://www.google.com/intl/en/policies/privacy/', $locale)); ?></a></p>
            <h4><span id="Advertising"><?php echo e(aiTrans('Pubblicità', $locale)); ?></span></h4>
            <p><?php echo e(aiTrans('Potremmo utilizzare fornitori di servizi terzi per mostrarti pubblicità per aiutare a supportare e mantenere il nostro Servizio.', $locale)); ?>

            </p>
            <p><strong><?php echo e(aiTrans('Google AdSense Cookie DoubleClick', $locale)); ?></strong><br>
                <?php echo e(aiTrans('Google, in quanto fornitore terzo, utilizza cookie per pubblicare annunci sul nostro Servizio. L’uso del cookie DoubleClick da parte di Google consente a lui e ai suoi partner di pubblicare annunci ai nostri utenti in base alla loro visita al nostro Servizio o ad altri siti web su Internet. Puoi scegliere di non utilizzare il cookie DoubleClick per la pubblicità basata sugli interessi visitando la pagina delle Impostazioni Annunci di Google:', $locale)); ?>

                <a href="https://www.google.com/ads/preferences/" target="_blank"
                    rel="noopener"><?php echo e(aiTrans('http://www.google.com/ads/preferences/', $locale)); ?></a></p>
            <h4><span id="Behavioral_Remarketing"><?php echo e(aiTrans('Remarketing Comportamentale', $locale)); ?></span></h4>
            <p><span class="b"><?php echo e(aiTrans('Provider', $locale)); ?></span>
                <?php echo e(aiTrans('utilizza servizi di remarketing per pubblicizzare su siti web di terze parti dopo che hai visitato il nostro Servizio. Noi e i nostri fornitori terzi utilizziamo i cookie per informare, ottimizzare e servire annunci basati sulle tue visite passate al nostro Servizio.', $locale)); ?>

            </p>
            <p><strong><?php echo e(aiTrans('Google AdWords', $locale)); ?></strong><br>
                <?php echo e(aiTrans('Il servizio di remarketing di Google AdWords è fornito da Google Inc. Puoi scegliere di non utilizzare Google Analytics per la Pubblicità Display e personalizzare gli annunci della Rete Display di Google visitando la pagina delle Impostazioni Annunci di Google:', $locale)); ?>

                <a href="http://www.google.com/settings/ads" target="_blank"
                    rel="noopener"><?php echo e(aiTrans('http://www.google.com/settings/ads', $locale)); ?></a>
                <?php echo e(aiTrans('Google raccomanda anche di installare il componente aggiuntivo del browser di esclusione di Google Analytics –', $locale)); ?>

                <a href="https://tools.google.com/dlpage/gaoptout" target="_blank"
                    rel="noopener"><?php echo e(aiTrans('https://tools.google.com/dlpage/gaoptout', $locale)); ?></a>
                <?php echo e(aiTrans('– per il tuo browser web. Il componente aggiuntivo del browser di esclusione di Google Analytics fornisce ai visitatori la possibilità di impedire la raccolta e l’uso dei loro dati da parte di Google Analytics. Per ulteriori informazioni sulle pratiche di privacy di Google, ti preghiamo di visitare la pagina web dei Termini sulla Privacy di Google:', $locale)); ?>

                <a href="https://www.google.com/intl/en/policies/privacy/" target="_blank"
                    rel="noopener"><?php echo e(aiTrans('http://www.google.com/intl/en/policies/privacy/', $locale)); ?></a></p>
                    <p><strong><?php echo e(aiTrans('Facebook', $locale)); ?></strong><br>
    <?php echo e(aiTrans('Il servizio di remarketing di Facebook è fornito da Facebook Inc. Puoi saperne di più sulla pubblicità basata sugli interessi di Facebook visitando questa pagina:', $locale)); ?>

    <a href="https://www.facebook.com/help/164968693837950" target="_blank"
        rel="noopener"><?php echo e(aiTrans('https://www.facebook.com/help/164968693837950', $locale)); ?></a>
</p>
<?php echo e(aiTrans('Per disattivare la pubblicità basata sugli interessi di Facebook, segui queste istruzioni di Facebook:', $locale)); ?>

<a href="https://www.facebook.com/help/568137493302217" target="_blank"
    rel="noopener"><?php echo e(aiTrans('https://www.facebook.com/help/568137493302217', $locale)); ?></a>
<?php echo e(aiTrans('Facebook aderisce ai Principi di Autoregolamentazione per la Pubblicità Comportamentale Online stabiliti dall’Alliance for Digital Advertising. Puoi anche scegliere di non ricevere pubblicità da Facebook e da altre aziende partecipanti attraverso l’Alliance for Digital Advertising negli Stati Uniti', $locale)); ?>

<a href="http://www.aboutads.info/choices/" target="_blank"
    rel="noopener"><?php echo e(aiTrans('http://www.aboutads.info/choices/', $locale)); ?></a>,
<?php echo e(aiTrans('l’Alliance for Digital Advertising del Canada in Canada', $locale)); ?> <a
    href="http://youradchoices.ca/" target="_blank"
    rel="noopener"><?php echo e(aiTrans('http://youradchoices.ca/', $locale)); ?></a>
<?php echo e(aiTrans('o l’Alliance for Digital Advertising Interattiva in Europa', $locale)); ?> <a
    href="http://www.youronlinechoices.eu/" target="_blank"
    rel="noopener"><?php echo e(aiTrans('http://www.youronlinechoices.eu/', $locale)); ?></a>,
<?php echo e(aiTrans('o disattivando le impostazioni del tuo dispositivo mobile. Per ulteriori informazioni sulle pratiche di privacy di Facebook, ti preghiamo di visitare la Politica dei Dati di Facebook:', $locale)); ?>

<a href="https://www.facebook.com/privacy/explanation" target="_blank"
    rel="noopener"><?php echo e(aiTrans('https://www.facebook.com/privacy/explanation', $locale)); ?></a></p>
<h4><span id="Links_To_Other_Sites"><?php echo e(aiTrans('Link ad Altri Siti', $locale)); ?></span></h4>
<p><?php echo e(aiTrans('Il nostro Servizio può contenere link ad altri siti che non sono gestiti da noi. Se clicchi su un link di terze parti, sarai diretto al sito di quella terza parte. Ti consigliamo vivamente di rivedere l’Informativa sulla Privacy di ogni sito che visiti.', $locale)); ?>

</p>
<p><?php echo e(aiTrans('Non abbiamo alcun controllo e non ci assumiamo alcuna responsabilità per il contenuto, le politiche sulla privacy o le pratiche di siti o servizi di terze parti.', $locale)); ?>

</p>
<h4><span id="Children8217s_Privacy"><?php echo e(aiTrans('Privacy dei Bambini', $locale)); ?></span></h4>
<p><?php echo e(aiTrans('Il nostro Servizio non è rivolto a persone di età inferiore ai 18 anni (“Bambini”).', $locale)); ?></p>
<p><?php echo e(aiTrans('Non raccogliamo consapevolmente informazioni personali identificabili da nessuno sotto i 18 anni. Se sei un genitore o un tutore e sei a conoscenza che i tuoi Bambini ci hanno fornito Dati Personali, ti preghiamo di contattarci. Se veniamo a conoscenza di aver raccolto Dati Personali da bambini senza verifica del consenso parentale, adottiamo misure per rimuovere tali informazioni dai nostri server.', $locale)); ?>

</p>
<h4><span id="Changes_To_This_Privacy_Policy"><?php echo e(aiTrans('Modifiche a Questa Informativa sulla Privacy', $locale)); ?></span>
</h4>
<p><?php echo e(aiTrans('Potremmo aggiornare la nostra Informativa sulla Privacy di tanto in tanto. Ti notificheremo eventuali cambiamenti pubblicando la nuova Informativa sulla Privacy su questa pagina.', $locale)); ?>

</p>
<p><?php echo e(aiTrans('Ti informeremo via email e/o con un avviso ben visibile sul nostro Servizio, prima che la modifica diventi effettiva e aggiorneremo la “data di efficacia” nella parte superiore di questa Informativa sulla Privacy.', $locale)); ?>

</p>
<p><?php echo e(aiTrans('Ti consigliamo di rivedere periodicamente questa Informativa sulla Privacy per eventuali modifiche. Le modifiche a questa Informativa sulla Privacy sono efficaci quando vengono pubblicate su questa pagina.', $locale)); ?>

</p>
<h4><span id="Contact_Us"><?php echo e(aiTrans('Contattaci', $locale)); ?></span></h4>
<p><?php echo e(aiTrans('Se hai domande su questa Informativa sulla Privacy, ti preghiamo di contattarci .', $locale)); ?>

</p>

</main>
    </div>
                    
                    
                    

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/eenn281/public_html/cor28en1.com/resources/views/frontend/it/privacy.blade.php ENDPATH**/ ?>