
<?php $__env->startPush('meta'); ?>
    <title><?php echo e("$website_title ™ | Resmi web sitesi 2025"); ?></title>
    <meta name="description" content="<?php echo e("Dünya çapında trend olan kripto ticareti hakkında bilgi edinmek için güvenilir platform $website_title Fırsatları keşfedin ve bilginizi geliştirin!"); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <section class="banner banner-shift pt-5">
        <div class="container">
            <h1 class="banner-title display-4 fw-bold text-center mb-4"><?php echo e($website_title); ?></h1>
            <div class="fs-4 mb-5 text-center">
                <h2><strong class="change-by-command"><?php echo e("$website_title Kripto Ticarette Kazanımlarınızı Artırma: Kazançlı Yatırım Stratejileri"); ?></strong>
                </h2>
                <p><strong class="change-by-command"><?php echo e("$website_title Kazançlı Yatırım Stratejileriyle Kripto Ticaretinizde Başarı Sağlayın"); ?></strong>
                </p>
            </div>
            <div class="row">
                <div class="col-lg-8">
                    <div class="banner-image">
                        <picture>
                            <source
                                srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/922_922__922_66aa039d43477_immediate_alora_3000.webp"
                                type="image/webp">
                            <source
                                srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/922_922__922_66aa039d43477_immediate_alora_3000.jpg"
                                type="image/jpeg">
                            <img src="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/922_922__922_66aa039d43477_immediate_alora_3000.jpg"
                                class="w-100 shadow-lg" loading="eager" width="908" height="498" alt="">
                        </picture>

                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="shadow form-height">
                        <?php echo $__env->make('frontend.tr.components.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-md-8">
                    <h2 class="display-5 fw-bold mb-4">
                        <?php echo e(aiTrans('[website_title] nedir?', $locale, ['website_title' => $website_title])); ?>

                    </h2>
                    <div>
                        <p><strong>
                                <?php echo e(aiTrans(
                                    'Şevkle, [website_title] gayretli öğrenciler ve yatırım bilgisi dünyası arasında bağlantılar kurar. Belirli yatırım rehberliği dağıtmaktan kaçınıyoruz, bunun yerine kendimizi yatırım alanının inceliklerine hakim olmak için bir portal olarak konumlandırıyoruz. Bizimle birlikte, içgörünün yatırım ustalığına giden yolu açtığı aydınlatıcı bir keşif gezisine çıkın.',
                                    $locale,
                                    ['website_title' => $website_title],
                                )); ?>

                            </strong></p>
                        <p>
                            <?php echo e(aiTrans(
                                '[website_title]\'ın özü, meraklı zihinleri ve finans akademisinin aydınlatıcı salonlarını bir araya getirme arayışında yatmaktadır.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                        <p>
                            <?php echo e(aiTrans(
                                'Verilerle dolup taşan modern çağda yelken açarken, yatırım seçeneklerinin labirenti zorlu bir zorluk sunuyor. Birçoğu için engel sadece kavramları kavramak değil, aynı zamanda başlangıç çizgisini tam olarak belirlemektir. Burada, [website_title] bu karmaşık arazilerde usta rehberiniz olarak devreye giriyor ve yatırım dünyasının gizemini çözmek için bir yol haritası sunuyor. Bizimle bir adım öne geçin ve güvenle yürüyün.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                        <p>
                            <?php echo e(aiTrans(
                                'Uçsuz bucaksız yatırım bilgeliği evrenindeki yolculuk, çeşitli görüşler, dolambaçlı diller ve çok
                            sayıda bakış açısı dile getiren sayısız kaynakla cesur yüreklileri bile korkutabilir.
                            [website_title]\'nin kararlı navigatörünüz olarak hareket etmesine, gürültüyü kesmesine ve
                            dolambaçlı yatırım alanına netlik getirmesine izin verin.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                            </p>
                        <p>
                            <?php echo e(aiTrans(
                                'Platformumuz, hacimli veri denizinde size rehberlik eden bir işarettir. Amaçsız aramanın tuzaklarından kaçının; [website_title], eğitim zenginliklerini zahmetsizce gözden geçirmenize yardımcı olmaya hazırdır.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                        <p>
                            <?php echo e(aiTrans(
                                'Öğrencinin yolculuğuna odaklanan [website_title], bilgi arayışının yönetilebilir olmasını sağlar. Bilginin kalibresini ve uygunluğunu savunuyor, fazlalıktan kaçınıyoruz.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                        <p>
                            <?php echo e(aiTrans(
                                'Ayrıca, sadece bilgilendirici değil, aynı zamanda sürükleyici ve ödüllendirici bir eğitim yolu oluşturmaya kararlıyız. Öğrenci ve akademisyen arasındaki aracı olarak [website_title], öğrenme yolculuğunu iyileştirerek onu hem zenginleştirici hem de zevkli hale getirir.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-center">
                    <picture>
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_459_66aa03a1eceb7_immediate alora 3000.jpeg"
                            type="image/webp">
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_459_66aa03a1eceb7_immediate alora 3000.jpeg"
                            type="image/jpeg">
                        <img src="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_459_66aa03a1eceb7_immediate alora 3000.jpeg"
                            loading="lazy" width="459" height="459" alt="">
                    </picture>

                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <div class="row flex-md-row flex-column-reverse ">
                <div class="col-md-4 d-flex align-items-center">
                    <picture>
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/459_459__459_66aa03a6d2930_immediate-alora-3000.webp"
                            type="image/webp">
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/459_459__459_66aa03a6d2930_immediate-alora-3000.webp"
                            type="image/jpeg">
                        <img src="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/459_459__459_66aa03a6d2930_immediate-alora-3000.webp"
                            loading="lazy" width="459" height="459" alt="">
                    </picture>

                </div>
                <div class="col-md-8">
                    <input type="checkbox" id="about2-checkbox">
                    <div>
                        <h2><?php echo e(aiTrans('Yatırım öğrenimi için psikolojik içgörülerden yararlanma')); ?></h2>
                        <p></p>
                        <h3><?php echo e(aiTrans('Duygusal Dürtülere Karşı Koyma')); ?></h3>
                        <p>
                            <?php echo e(aiTrans(
                                'Yatırım seçimleri genellikle bir duygu girdabı ve kökleşmiş davranışlar tarafından sallanır. [website_title] platformundaki sağlam bir eğitim stratejisi, bu psikolojik nüansları araştırır, duygusal tepkilere hakim olmak ve finansal seçimler üzerindeki aşırı etkilerini durdurmak için stratejiler sunar.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                        <h3><?php echo e(aiTrans('Gelecek için bir vizyon aşılamak')); ?></h3>
                        <p>
                            <?php echo e(aiTrans(
                                '[website_title] resmi web sitesinde sağlanan müfredat, ileri görüşlü bir yatırım zihniyetinin zorunlu doğasının altını çizmektedir. Azmin esası için bir takdir geliştirir ve daha geniş ufku gözden kaçıran aceleci, kâr peşinde koşan eylemlerin cazibesine karşı tavsiyelerde bulunur.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                        <h3><?php echo e(aiTrans('Analitik Ayırt Etmeyi Savunmak')); ?></h3>
                        <p>
                            <?php echo e(aiTrans(
                                '[website_title] uygulaması aracılığıyla bireyler, değerlendirme becerilerini keskinleştirme ve keskin bir analitik zihin geliştirme becerisi kazanırlar. Bu önemli yetenekler, hakim bilişsel çarpıtmalara karşı bir siper görevi görerek yatırım ortamında gezinmek için daha ölçülü ve kasıtlı bir çerçeve oluşturur.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                        <label for="about2-checkbox"
                            class="text-decoration-underline fw-bold fs-5"><?php echo e(aiTrans('Tümünü Oku')); ?></label>
                    </div>
                    <div class="text-md-start text-center mt-3 mt-md-4 mb-4 mb-md-0">
                        <button
                            class="show-modal btn btn-primary btn-lg shadow-lg px-3 px-md-5 fs-4"><?php echo e(aiTrans('Daha fazla bilgi edinin')); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container mb-5">
            <div class="row">
                <div class="col-md-10">
                    <h2 class="display-5 fw-bold mb-4">
                        <?php echo e(aiTrans('Yatırım, Eğitim ve Duygular Arasındaki Etkileşimi Keşfetmek')); ?></h2>
                    <p><strong><?php echo e(aiTrans('Yatırım alanına giriş, genellikle çalkantılı piyasaların, dolambaçlı hesaplamaların ve ezici rakam dizilerinin vizyonlarını çağrıştırır. Yine de bu arazi, keşfedilmeye değer ek katmanlarla zengindir. Örneğin duygular, yatırımcıların finansal tercihleri üzerinde derin bir etkiye sahiptir.')); ?></strong>
                    </p>
                    <p><?php echo e(aiTrans('Duygusal akımları ve davranışsal eğilimleri ayırt etme sanatında ustalaşmak, yatırım karmaşıklığının yarattığı stresi hafifletmede zorlu bir müttefik olabilir. Eğitim bu duygusal yönlere yayıldığında, bireyler, aksi takdirde net düşünmeyi gizleyebilecek önyargıları etkisiz hale getirmek için taktikler keşfedebilirler. Bu, onları fırsatları soğukkanlılıkla değerlendirmek için gereken bakış açısıyla güçlendirir ve hedefleriyle uyumlu planlar hazırlar.')); ?>

                    </p>
                    <p><?php echo e(aiTrans('Yatırım, doğası gereği risk ve belirsizlikle iç içedir. Bu alandaki insan duyarlılığının etkileşimi, olumsuz sonuçlara karşı duyarlılığı artırabilir. Hiçbir eğitim yolu kayıpları geçersiz kılamaz veya başarıyı garanti edemezken, bütünsel bir pedagojik yaklaşım, öğrencilere kararları akıllıca yönlendirme ve denemeler arasında direnç oluşturma zekası verir.')); ?>

                    </p>
                    <p>&nbsp;</p>
                    <h3><?php echo e(aiTrans('Yatırım Bilgisinin Zorunluluğu')); ?></h3>
                    <p><?php echo e(aiTrans('Yatırım sektörüyle etkileşim zorunlu değildir, ancak anlayışının peşinde koşmak birçokları için kritik öneme sahiptir. Eğitim, risk için her derde deva ya da sonuç garantisi olmasa da, yatırım teşebbüslerinin içine yerleştirilmiş incelikler için ayırt etme ve takdir etme konusunda esastır.')); ?>

                    </p>
                    <p><?php echo e(aiTrans('Yatırım eğitimi yoluyla yolculuk zorlu ve uzun görünebilir, ancak aslında finansal zekaya giden bir kanaldır. Cıvıl cıvıl yatırım alanına girmeden önce, kendini sağlam bir bilgi temeli ile donatmak zorunludur. Eğitim kurumlarıyla ittifak, öğrenme sürecini kolaylaştırmak için bir dizi kaynağa erişim sağlayarak bu eğitim serüvenini güçlendirebilir.')); ?>

                    </p>
                    <h3><?php echo e(aiTrans('Eğitim Sağlayıcılarından Öğrenme Araçlarının Bolluğu')); ?></h3>
                    <p><?php echo e(aiTrans('Eğitim kuruluşları, yalnızca temel yatırım kavramlarına ışık tutmakla kalmaz, aynı zamanda eğitim yolculuğunu desteklemek için bir dizi eğitici medya sunar. Bu tür kaynaklar arasında öğreticiler, dijital kitaplar, video açıklayıcılar, piyasa incelemesi için analitik araçlar, web tabanlı kurslar ve daha fazlası yer alabilir.')); ?>

                    </p>
                    <h3><?php echo e(aiTrans('Finansal Piyasalara Açılan Kapı')); ?></h3>
                    <p>
                        <?php echo e(aiTrans(
                            'Finansal ortamı analiz etmek, eğitim sürecinin temel taşıdır, ancak ne [website_title] ne de müttefik kuruluşları bu pazarlara doğrudan giriş sağlamaz. Yatırımın temel ilkeleri ve diğer önemli konuların anlaşılmasını beslemeye vurgu yapılır.',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                    </p>
                    <h3><?php echo e(aiTrans('Eğitim Materyallerinde Çeşitlilik')); ?></h3>
                    <p>
                        <?php echo e(aiTrans(
                            '[website_title] ile uyumlu yatırım eğitimi sağlayıcıları aracılığıyla sunulan eğitim yardımlarının yelpazesi değişir. Bununla birlikte, birincil hedefleri, öğrenme deneyimini zenginleştiren kaynak erişimi sunarak bireylerin yatırım zekasını genişletmektir.',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                    </p>
                    <h3><?php echo e(aiTrans('Yatırım Eğitimi Sağlayıcılarıyla Etkileşim Kriterleri')); ?></h3>
                    <p>
                        <?php echo e(aiTrans(
                            'Özünde, yatırım öğrenimine dalmaya hevesli olan herkes, [website_title] aracılığıyla bir eğitim firmasıyla bağlantı kurabilir. Bu platform kapsayıcıdır ancak bir uyarıya sahiptir: kullanıcıların reşit olma yaşına ulaşmış olması ve hizmetlerin yalnızca 18 yaş ve üstü kişilerin erişebilmesi gerekir.',
                            $locale,
                            ['website_title' => $website_title],
                        )); ?>

                    </p>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="row">
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">HIZLI VE UYGUN MALIYETLI SÜREÇLER</h3>
                            <input type="checkbox" id="howworks-checkbox0">
                            <div>
                                <p><?php echo e(aiTrans('Yüksek maliyetler genellikle yatırım merkezli eğitim materyallerine giden yolu engeller. Bilgilerini genişletmeye hevesli çok sayıda öğrenci, kendilerini parasal sınırlamalarla kısıtlanmış bulurlar.')); ?>

                                </p>
                                <label for="howworks-checkbox0"
                                    class="text-decoration-underline fw-bold fs-5"><?php echo e(aiTrans('Tümünü Oku')); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase"><?php echo e(aiTrans('YENI BAŞLAYANLAR IÇIN UYGUN PLATFORM')); ?></h3>
                            <input type="checkbox" id="howworks-checkbox1">
                            <div>
                                <p>
                                    <?php echo e(aiTrans(
                                        '[website_title], yatırım öğrenimi alanını dönüştürdü ve acemilerin piyasaya girmesi için kapılar açtı. [website_title] platformu, finansal zekaları ne olursa olsun bireyleri ağırlar ve katılmak için sıfır arka plan gerektirir. Ayrıca, [website_title] acemi yatırımcıları saygın eğitim kurumlarıyla buluşturarak, yatırım ortamının en temelden itibaren zahmetsiz ve kapsamlı bir şekilde anlaşılmasını sağlar.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    )); ?>

                                </p>
                                <label for="howworks-checkbox1"
                                    class="text-decoration-underline fw-bold fs-5"><?php echo e(aiTrans('Tümünü Oku')); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase"><?php echo e(aiTrans('BIRDEN ÇOK DIL DESTEĞI')); ?></h3>
                            <input type="checkbox" id="howworks-checkbox2">
                            <div>
                                <p>
                                    <?php echo e(aiTrans(
                                        'Dilsel eşitsizliklerin finansal okuryazarlık yolculuğunu engelleyebileceğini anlayan [website_title], uyarlanabilir bir dil özelliği sunar. Bu işlev, kullanıcıların [website_title] resmi web sitesinde Fransızca, Almanca, İspanyolca veya Portekizce dahil ancak bunlarla sınırlı olmamak üzere çeşitli dillerde gezinmelerini sağlar ve temel taşı İngilizce olur. Bu tür bir kapsayıcılık, [website_title] platformunun 2025\'de erişilebilir ve kullanıcı dostu kalmasını sağlayarak küresel bir kitleyi yatırım eğitimine katılmaya davet eder.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    )); ?>

                                </p>
                                <label for="howworks-checkbox2"
                                    class="text-decoration-underline fw-bold fs-5"><?php echo e(aiTrans('Tümünü Oku')); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6  mb-4">
                    <div class="h-100 card border-0 shadow-lg border border-4 border-bottom border-primary">
                        <div class="card-body p-4">
                            <h3 class="fw-bold text-uppercase">
                                <?php echo e(aiTrans('[website_title] ILE BIR ÖĞRENME YOLCULUĞUNA ÇIKMAK', $locale, ['website_title' => $website_title])); ?>

                            </h3>
                            <input type="checkbox" id="howworks-checkbox3">
                            <div>
                                <p>
                                    <?php echo e(aiTrans(
                                        'Yatırım ortamının karmaşıklığı iyi silahlanmış bir yaklaşım gerektirir ve [website_title] her yatırımcıyı ilk adımı atma güvencesiyle donatmaya kararlı bir şekilde inanmaktadır. 2025 ortaya çıktıkça, kullanıcıları güçlendirme ve onları finansal okuryazarlık yoluna yönlendirme taahhüdümüzü yerine getiriyoruz.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    )); ?>

                                </p>
                                <p>

                                    <?php echo e(aiTrans(
                                        '[website_title] platformumuz, öğrencileri önemli eğitim materyallerine bağlayarak yatırım ilkelerinin derinlemesine ve aydınlatıcı bir şekilde keşfedilmesini teşvik eder. Kendinizi özel içgörülere kaptırın ve [website_title] resmi web sitesi ile yolculuğunuza başlayın. [website_title] uygulamamızı keşfedin ve anlayışınızı ve yeterliliğinizi zenginleştirmek için [website_title] inceleme bölümünü inceleyin.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    )); ?>

                                </p>
                                <label for="howworks-checkbox3"
                                    class="text-decoration-underline fw-bold fs-5"><?php echo e(aiTrans('Tümünü Oku')); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn btn-primary btn-lg text-uppercase shadow-lg px-3 px-md-5 fs-4">
                    Daha fazla bilgi edinin
                </button>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container mb-5">
            <div class="row">
                <div class="col-md-10">
                    <h2 class="display-5 fw-bold mb-4">
                        <?php echo e(aiTrans('[website_title]\'nin Yatırım Eğitimindeki Rolü', $locale, ['website_title' => $website_title])); ?>

                    </h2>
                    <div class="">
                        <p><strong><?php echo e(aiTrans('Yatırım bilgisi alanına girildiğinde, bu tür içgörülerin karmaşık yatırım alanını geçenler için kritik olduğu açıkça ortaya çıkıyor. Yine de, engel, üst düzey yatırım eğitimine kolaylıkla ulaşma alanında devam ediyor.')); ?></strong>
                        </p>
                        <p>
                            <?php echo e(aiTrans(
                                '[website_title]\'nin ortaya çıkışı, bireyleri eğitim serüvenlerini zenginleştirmede usta varlıklara bağlayan bir kanal görevi gören öncü bir [website_title] platformu sunan bir çözüm feneri anlamına gelir.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                        <p>

                            <?php echo e(aiTrans(
                                '[website_title], gayretli akademisyenleri yatırım vesayeti alanında üstün olan saygın akademik kurumlarla sorunsuz bir şekilde birbirine bağlayan temel taşı olarak duruyor. [website_title] resmi web sitesi, sezgisel ve zahmetsiz bir deneyim sunarak, yatırım alanının sürekli gelişen akımları arasında gezinmek için önemli bir danışmanın yanı sıra zengin bir bilgi birikiminin hazır olmasını sağlar.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                        <p>

                            <?php echo e(aiTrans(
                                'Çığır açan ruhuyla [website_title], [website_title] uygulaması aracılığıyla yatırım eğitiminin adil bir şekilde yaygınlaştırılmasında çok önemlidir. Ufukları genişletir, bir bireyler mozaiğinin güvence ve derin içgörü ile donanmış bilimsel arayışlarına başlamasına izin verir.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="row align-items-center mb-5">
                <div class="col-md-8">
                    <h3 class="display-7 fw-bold"><?php echo e(aiTrans('YATIRIM BİLGİLERİNİN GENİŞLETİLME')); ?></h3>
                    <div class="">
                        <p><?php echo e(aiTrans('Yatırım eğitimine dalmak, bireyleri ekonomik ilkeler ve yatırım stratejileri hakkında derinlemesine bir anlayışla donatır. Bu tür bir aydınlanma, güvence ve sağduyu doğurur ve onları mali karmaşıklıkların labirentinde ustaca manevra yapma gücü verir.')); ?>

                        </p>
                        <p>
                            <?php echo e(aiTrans(
                                'Bu eğitim arayışı salt bilişsel kazanımın ötesine geçer; Bireyleri yeniliğin ve girişimci ruhun benimsenmesine doğru iter. Bu bilgiyle dolu olarak, yeni kavramlar aramaya ve [website_title] platformundaki yatırım ortamında cesurca bakir bölgelere girmeye teşvik edilirler.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                    </div>
                </div>
                <div class="border border-5 text-center border-white col-md-4 px-md-0 px-5">
                    <picture>
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/330_449__473_65e732911ebfb_img-1-parametersList.webp"
                            type="image/webp">
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_473_65e732911ebfb_img-1-parametersList.jpg"
                            type="image/jpeg">
                        <img src="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_473_65e732911ebfb_img-1-parametersList.jpg"
                            loading="lazy" class="w-100 mw-400 shadow-lg" width="449" height="330" alt="">
                    </picture>

                </div>
            </div>
            <div class="row align-items-center mb-5">
                <div class="col-md-8">
                    <h3 class="display-7 fw-bold"><?php echo e(aiTrans('YATIRIMIN TEMELLERI HAKKINDA BILGI EDINMEK')); ?></h3>
                    <div class="">
                        <div>
                            <p><strong><?php echo e($website_title); ?></strong>
                                <?php echo e(aiTrans('yatırım stratejilerinin gizemini çözmeye çalışanlar için bir bilgelik feneri olarak parlıyor.')); ?>

                            </p>
                            <p><?php echo e(aiTrans('Yatırım vesayetimizin özü, bu alemin doğasında var olan ince karmaşıklıkları aydınlatmakta yatmaktadır. Finans alanındaki maceracılar, sohbete hakim olan çeşitli metodolojileri, temel ilkeleri, saygın varlıkları ve varlık tahsisi için stratejiler keşfeder.')); ?>

                            </p>
                            <p><?php echo e(aiTrans('Yine de, bu içgörüler, yatırım alanında ustalaşmak söz konusu olduğunda, meşhur buzdağının yalnızca görünen kısmını temsil ediyor. Bütünsel eğitim planımız, dengeli bir bakış açısı sağlamaya çalışarak, adayları yatırım kararlarına bağlı ilgili verilerin ve sonuçların tamamını kabul etmeye zorlar.')); ?>

                            </p>
                        </div>
                    </div>
                </div>
                <div class="border border-5 text-center border-white col-md-4 px-md-0 px-5">
                    <picture>
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/349_449__473_65e73298efe63_img-2-parametersList.webp"
                            type="image/webp">
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_473_65e73298efe63_img-2-parametersList.jpg"
                            type="image/jpeg">
                        <img src="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_473_65e73298efe63_img-2-parametersList.jpg"
                            loading="lazy" class="w-100 mw-400 shadow-lg" width="449" height="349" alt="">
                    </picture>
                </div>
            </div>
            <div class="row align-items-center mb-5">
                <div class="col-md-8">
                    <h3 class="display-7 fw-bold">
                        <?php echo e(aiTrans('[website_title]\'IN YATIRIM VE VERGILERE YAKLAŞIMI', $locale, ['website_title' => $website_title])); ?>

                    </h3>
                    <div class="">
                        <p>

                            <?php echo e(aiTrans(
                                '[website_title], kendisi bir vergi eğitimi tedarikçisi olmasa da, mali stratejiler ve yatırım çabaları arasındaki ayrılmaz bağı kabul eder. [website_title] platformu, kullanıcılarını vergi dünyasının inceliklerini açığa çıkarmakta usta olan saygın eğitim kurumlarıyla tanıştıran ve böylece yatırımcıların portföy yönetiminin temel karmaşıklıklarını ustaca yönlendirmelerini sağlayan bir kanal görevi görür.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                    </div>
                </div>
                <div class="border border-5 text-center border-white col-md-4 px-md-0 px-5">
                    <picture>
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/313_449__473_65e7329fd7992_img-3-parametersList.webp"
                            type="image/webp">
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_473_65e7329fd7992_img-3-parametersList.jpg"
                            type="image/jpeg">
                        <img src="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_473_65e7329fd7992_img-3-parametersList.jpg"
                            loading="lazy" class="w-100 mw-400 shadow-lg" width="449" height="313" alt="">
                    </picture>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn btn-primary btn-lg text-uppercase shadow-lg px-3 px-md-5 fs-4">
                    <?php echo e(aiTrans('Daha fazlasını keşfedin')); ?>

                </button>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container mb-5">
            <div class="row">
                <div class="col-md-10">
                    <h2 class="display-5 fw-bold mb-4"><?php echo e(aiTrans('Yatırım Eğitiminde Daha Fazlasını Keşfetmek')); ?></h2>
                    <div>
                        <p><?php echo e(aiTrans('Yatırım sanatında yeterlilik arayışına girmek hem aydınlatıcı hem de karmaşıktır. Yolculuk, güvenle ilerlemek için sağlam bir temel bilginin oluşturulmasını gerektirir.')); ?>

                        </p>
                        <p>
                            <?php echo e(aiTrans(
                                '[website_title], yatırımın [website_title] inceliklerine incelikle hakim olmak için zorunlu olan temel bilgelik ve içgörülere giden yolu aydınlatan aydınlık bir rehber olarak ortaya çıkıyor.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                        <p><?php echo e(aiTrans('Yatırım evreninin uçsuz bucaksız genişliğinde, çok sayıda seçenek ve rota sizi bekliyor. Çok çeşitli varlıklar parmaklarınızın ucunda yatmaktadır ve bunların temel ilkelerini özümsemek zorunludur. Her bir benzersiz varlığın derinliklerine dalmadan önce, bireyleri yatırım alanını güvenle çizme inancıyla donatmak için kapsamlı bir anlayış tasarlanmıştır.')); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>

        <div class="container">
            <div class="row align-items-center mb-5">
                <div class="col-md-8">
                    <h3 class="display-7 fw-bold"> <?php echo e(aiTrans('YATIRIM İLKELERİ')); ?></h3>
                    <div class="">
                        <p><?php echo e(aiTrans('Yatırım alanı hem geniş hem de karmaşıktır, çok sayıda varlık sınıfıyla noktalanmıştır ve çeşitli piyasa dinamikleri tarafından şekillendirilmiştir. Bu geniş alanda gezinmek isteyen herkes için temel ilkelerine hakim olmak zorunludur.')); ?>

                        </p>
                        <p>

                            <?php echo e(aiTrans(
                                '[website_title], ziyaretçileri [website_title] platformundaki bu temel finansal ilkeleri aydınlatan ve detaylandıran bir materyal hazinesine bağlayarak üst düzey eğitim içeriği sunmayı taahhüt eder.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                    </div>
                </div>
                <div class="border border-5 text-center border-white col-md-4 px-md-0 px-5">
                    <picture>
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/330_449__473_659fe897b5c8a_img-4-mustKnowList.webp"
                            type="image/webp">
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_473_659fe897b5c8a_img-4-mustKnowList.jpg"
                            type="image/jpeg">
                        <img src="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_473_659fe897b5c8a_img-4-mustKnowList.jpg"
                            loading="lazy" class="w-100 mw-400 shadow-lg" width="449" height="330" alt="">
                    </picture>
                </div>
            </div>
            <div class="row align-items-center mb-5">
                <div class="col-md-8">
                    <h3 class="display-7 fw-bold"> YATIRIM TERMINOLOJISININ ÇÖZÜLMESI</h3>
                    <div class="">
                        <p><?php echo e(aiTrans('Yatırım dünyasına dalmak, özellikle gizli finansal dille bombardımana tutulduğunda, Herkülvari bir görev gibi görünebilir. Bu dili anlamak, karmaşık yatırım stratejileri ve operasyonları arasında ustaca manevra yapmak için çok önemlidir.')); ?>

                        </p>
                        <p>

                            <?php echo e(aiTrans(
                                '[website_title] platformu, bu karmaşık bölgede yol gösterici bir işaret olarak ortaya çıkıyor. Önde gelen eğitim kurumlarıyla bağlantılar kurarak, bir zamanlar bir jargon labirenti olan şeyi bir netlik manzarasına dönüştürüyor. Bu, [website_title] resmi web sitesinin yatırım bilgisinin gizemini çözmek için bir temel taşı haline gelmesini sağlar.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                    </div>
                </div>
                <div class="border border-5 text-center border-white col-md-4 px-md-0 px-5">
                    <picture>
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/349_449__473_659fe8ae54764_img-5-mustKnowList.webp"
                            type="image/webp">
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_473_659fe8ae54764_img-5-mustKnowList.jpg"
                            type="image/jpeg">
                        <img src="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_473_659fe8ae54764_img-5-mustKnowList.jpg"
                            loading="lazy" class="w-100 mw-400 shadow-lg" width="449" height="349" alt="">
                    </picture>
                </div>
            </div>
            <div class="row align-items-center mb-5">
                <div class="col-md-8">
                    <h3 class="display-7 fw-bold"> <?php echo e(aiTrans('VARLIK ÇEŞITLENDIRMESINI ANLAMA')); ?></h3>
                    <div class="">
                        <p>
                            <?php echo e(aiTrans(
                                'Varlık çeşitlendirmesi temel bir taktiğin ötesine geçer; Bilgi ve titiz müzakere gerektirir. Yatırım ortamı sürekli olarak değiştikçe, çeşitli varlık kategorileri arasında kaynak dağıtım sanatında ustalaşmak zorunlu hale geliyor. Çeşitli yatırım araçlarının akıllıca keşfedilmesiyle, [website_title] platformunun müşterileri, etkili varlık çeşitlendirmesinin ilkelerini ustaca kavrayabilir. [website_title] uygulaması bu bilgiyi zenginleştirirken, [website_title] incelemesi kullanıcı deneyimlerine ışık tutabilir.',
                                $locale,
                                ['website_title' => $website_title],
                            )); ?>

                        </p>
                    </div>
                </div>
                <div class="border border-5 text-center border-white col-md-4 px-md-0 px-5">
                    <picture>
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/313_449__473_659fe8c44c004_img-6-mustKnowList.webp"
                            type="image/webp">
                        <source
                            srcset="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_473_659fe8c44c004_img-6-mustKnowList.jpg"
                            type="image/jpeg">
                        <img src="<?php echo e(asset('frontend/assets/tr/dist')); ?>/images/_473_659fe8c44c004_img-6-mustKnowList.jpg"
                            loading="lazy" class="w-100 mw-400 shadow-lg" width="449" height="313" alt="">
                    </picture>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn btn-primary text-uppercase btn-lg shadow-lg px-3 px-md-5 fs-4">

                    <?php echo e(aiTrans('KEŞFET [website_title]', $locale, ['website_title' => $website_title])); ?>


                </button>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <h2 class="display-5 fw-bold mb-5 text-center">
                <?php echo e(aiTrans('En iyi 3 BTC tahmini!')); ?>

            </h2>
            <div class="row mb-0 mb-md-4">
                <div class="col-md-4 mb-4 mb-md-0">
                    <div class=" h-100 card border-0 shadow-lg border border-4 border-bottom border-primary"
                        key="{index}">
                        <div class="card-body row flex-row px-5 py-4">
                            <div class="position-absolute start-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26"
                                    fill="currentColor" class="bi bi-check-circle-fill text-success" viewBox="0 0 16 16">
                                    <path
                                        d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z">
                                    </path>
                                </svg>
                            </div>
                            <div>
                                <p><?php echo e(aiTrans('Bitcoin gelecek yıl %90 ana akım benimseme elde edecek - Matrixport')); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4 mb-md-0">
                    <div class=" h-100 card border-0 shadow-lg border border-4 border-bottom border-primary"
                        key="{index}">
                        <div class="card-body row flex-row px-5 py-4">
                            <div class="position-absolute start-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26"
                                    fill="currentColor" class="bi bi-check-circle-fill text-success" viewBox="0 0 16 16">
                                    <path
                                        d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z">
                                    </path>
                                </svg>
                            </div>
                            <div>
                                <p><?php echo e(aiTrans("Mart 2025'ye kadar 45.000 $ 'a kayda değer bir yükseliş gösteren tahminlerle bitcoin aleminde olağanüstü bir artış bekleyin.")); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4 mb-md-0">
                    <div class=" h-100 card border-0 shadow-lg border border-4 border-bottom border-primary"
                        key="{index}">
                        <div class="card-body row flex-row px-5 py-4">
                            <div class="position-absolute start-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26"
                                    fill="currentColor" class="bi bi-check-circle-fill text-success" viewBox="0 0 16 16">
                                    <path
                                        d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z">
                                    </path>
                                </svg>
                            </div>
                            <div>
                                <p><?php echo e(aiTrans('Bitcoin gelecek yılın sonuna kadar 130.000 dolara ulaşacak – Cointelegraph')); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <p class="fw-bold fs-4 text-center test-uppercase">
            </p>
            <p>
                <?php echo e(aiTrans(
                    '[website_title] ile kaydolarak dünyadaki birçok kişi gibi bir bitcoin tüccarı olabilirsiniz.',
                    $locale,
                    ['website_title' => $website_title],
                )); ?>

            </p>
            <p></p>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <h2 class="display-5 fw-bold mb-5 text-center">
                <?php echo e(aiTrans('Sıkça Sorulan Sorular')); ?>

            </h2>
            <div class="row">
                <div class="accordion mx-auto">
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading0">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse0" aria-expanded="false"
                                aria-controls="collapse0">

                                <?php echo e(aiTrans("[website_title]'a nasıl kayıt olabilirim?", $locale, ['website_title' => $website_title])); ?>


                            </button>
                        </h3>
                        <div id="collapse0" class="accordion-collapse collapse" aria-labelledby="heading0"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p><?php echo e(aiTrans('Yolculuğa çıkmak')); ?> <strong><?php echo e($website_title); ?></strong>
                                    <?php echo e(aiTrans('zahmetsizce basittir ve yalnızca birkaç adım gerektirir. Adaylar, kayıt belgesini kişisel bilgileriyle doldurmaya ve ilgili akademik kurumdan bir danışma görüşmesi beklemeye davet edilir.')); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading1">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="false"
                                aria-controls="collapse1">

                                <?php echo e(aiTrans("[website_title]'ın mobil uygulaması var mı?", $locale, ['website_title' => $website_title])); ?>


                            </button>
                        </h3>
                        <div id="collapse1" class="accordion-collapse collapse" aria-labelledby="heading1"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>
                                    <?php echo e(aiTrans(
                                        'Tarayıcı donanımlı herhangi bir cihaz üzerinden erişilebilen [website_title] platformu, 2025 içinde sorunsuz bağlantı sağlar. İster masaüstünde ister mobilde olun, [website_title] parmaklarınızın ucunda kalır.',
                                        $locale,
                                        ['website_title' => $website_title],
                                    )); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading2">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="false"
                                aria-controls="collapse2">

                                <?php echo e(aiTrans('[website_title] Yatırım Eğitimi Sağlıyor mu?', $locale, ['website_title' => $website_title])); ?>


                            </button>
                        </h3>
                        <div id="collapse2" class="accordion-collapse collapse" aria-labelledby="heading2"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>bu <strong><?php echo e($website_title); ?></strong> Platform, hevesli öğrenciler ile yatırımda vesayet
                                    sunan kuruluşlar arasındaki boşluğu dolduran özel bir kanal görevi görüyor. bu
                                    <em><?php echo e($website_title); ?></em> Resmi web sitesinin kendisi yatırım konularında doğrudan
                                    talimat vermez.</p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item mb-4">
                        <h3 class="accordion-header" id="heading3">
                            <button class="accordion-button collapsed rounded-3 fs-4 shadow-lg p-4" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="false"
                                aria-controls="collapse3">

                                <?php echo e(aiTrans('[website_title] Herkes Tarafından Erişilebilir mi?', $locale, ['website_title' => $website_title])); ?>


                            </button>
                        </h3>
                        <div id="collapse3" class="accordion-collapse collapse" aria-labelledby="heading3"
                            data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>

                                    <?php echo e(aiTrans(
                                        "[website_title]'nin misyonu, farklı bir kitleyi kucaklayarak yatırım bilgisi alanını demokratikleştirmektir. Bu, finansal sınırlamalarla karşı karşıya kalan kişileri, İngilizce'nin ana dili olmayanları ve yatırım dünyasında acemileri içerir. [website_title] platformu, kapsayıcılık taahhüdü ile tasarlanmıştır ve bu da onu herkes için erişilebilir bir kaynak haline getirir.",
                                        $locale,
                                        ['website_title' => $website_title],
                                    )); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center mt-3 mt-md-4">
                <button class="show-modal btn  text-white btn-primary text-uppercase btn-lg shadow-lg px-3 px-md-5 fs-4">
                    <?php echo e(aiTrans('Platform hizmetleri hakkında daha fazla bilgi edinin')); ?>

                </button>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <h2 class="display-5 fw-bold mb-5 text-center">

                <?php echo e(aiTrans('[website_title] Öne Çıkanlar', $locale, ['website_title' => $website_title])); ?>


            </h2>
            <div class="row">
                <figure class="table">
                    <table>
                        <tbody>
                            <tr>
                                <td><strong>🤖 </strong><?php echo e(aiTrans('Kayıt Maliyeti')); ?></td>
                                <td><?php echo e(aiTrans('Ücretsiz')); ?></td>
                            </tr>
                            <tr>
                                <td><?php echo e(aiTrans('📋 Kayıt')); ?></td>
                                <td><?php echo e(aiTrans('Hızlı ve Basit Süreç')); ?></td>
                            </tr>
                            <tr>
                                <td><?php echo e(aiTrans('💰 Finansal Masraflar')); ?></td>
                                <td><?php echo e(aiTrans('Ek Ücret Yok')); ?></td>
                            </tr>
                            <tr>
                                <td><strong>💱</strong><?php echo e(aiTrans(' Eğitim Odaklılık')); ?></td>
                                <td><?php echo e(aiTrans('Kripto para birimleri, Forex, yatırım fonları ve diğer')); ?></td>
                            </tr>
                            <tr>
                                <td><?php echo e(aiTrans('📊 Platform türü')); ?></td>
                                <td><?php echo e(aiTrans('İnternet tabanlı, herhangi bir web tarayıcısı üzerinden erişilebilir')); ?>

                                </td>
                            </tr>
                            <tr>
                                <td><?php echo e(aiTrans('🌎 Ülke')); ?></td>
                                <td><?php echo e(aiTrans('Çoğu ülke - ABD hariç')); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </figure>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/eenn281/public_html/cor28en1.com/resources/views/frontend/tr/home.blade.php ENDPATH**/ ?>