@php($head = 'frontend.'.$country.'.components.header.head')
@php($header = 'frontend.'.$country.'.components.header.header')
@php($toolbar = 'frontend.'.$country.'.components.header.toolbar')
@php($footer ='frontend.'.$country.'.components.footer.footer')
@php($scripts ='frontend.'.$country.'.components.scripts')



<!DOCTYPE html>
<html lang="{{$country}}" dir="{{($country == 'ar') ? 'rtl' : 'ltr'}}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    @stack('meta')
    @if(view()->exists($head))
        @include($head)
    @else
        {{-- Fallback or error message if head component is not found --}}
    @endif
    @stack('css')

    {!! setting('website_script_header') !!}

</head>
<body>
@if(view()->exists($toolbar))
    @include($toolbar)
@endif

@if(view()->exists($header))
    @include($header)
@endif

<div id="content" class="site-main">
    <div id="primary" class="content-area">
        <main>
            @yield('content')
        </main>
    </div>
</div>

@if(view()->exists($footer))
    @include($footer)
@endif

@if(view()->exists($scripts))
    @include($scripts)
@endif
<script src="{{asset('frontend/assets/en/dist/js/jquery-3.1.1.min.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@24.5.0/build/js/intlTelInput.min.js"></script>

<script>
    $(document).ready(function() {

        // Select all phone inputs with the class "phonejs"
        let phoneInputs = document.querySelectorAll(".phonejs");

// Loop through each phone input and initialize intlTelInput for each one
        phoneInputs.forEach(function(input) {
            let intlTel = window.intlTelInput(input, {
                nationalMode: true,
                autoHideDialCode: false,
                formatOnDisplay: false, // SET THIS!!!
                utilsScript: 'https://cdn.jsdelivr.net/npm/intl-tel-input@24.5.0/build/js/utils.js',
                separateDialCode: false,
                dropdownContainer: null,
                initialCountry: 'auto',
                geoIpLookup: function (callback) {
                    $.get('https://ipinfo.io', function () {}, "jsonp")
                        .always(function (resp) {
                            let countryCode = (resp && resp.country) ? resp.country : $("#country_code").val();
                            console.log('country '+countryCode);
                            callback(countryCode);
                        });
                }
            });

            // Handle the change in phone number input
            let handleChange = function () {
                // Use more specific selector within the same form group to find hidden fields

                let countryCode = $('.country_code');
                let country = $('.country_name');
                if (country) { // Ensure both fields exist
                    country.val(intlTel.getSelectedCountryData().iso2);
                } else {
                    console.error('Hidden fields #phone-value or #countryCode are missing');
                }
                if (countryCode) { // Ensure both fields exist
                    countryCode.val(intlTel.getSelectedCountryData().dialCode);
                } else {
                    console.error('Hidden fields #phone-value or #countryCode are missing');
                }
            }

            // Listen for changes in the input field and update values accordingly
            input.addEventListener("countrychange", function () {
                input.value = ''; // Clear input when country changes
                handleChange();
            });

            input.addEventListener('change', handleChange);
            input.addEventListener('keyup', handleChange);
        });

// Helper function to capitalize the first letter of the string
        function capitalizeFirstLetter(str) {
            if (str) {
                return str.toUpperCase();
            }
        }

            // Handle form submission
            $('.submitForm-api').on('submit', function(event) {
                event.preventDefault(); // Prevent default form submission

                var userLang = (navigator.language || navigator.userLanguage).slice(0,2).toUpperCase();            
            
            
            // Get form data
            let formData = $(this).serialize();

            formData += '&country=' + '{{ $country }}' + '&lang=' + userLang;

            // Detect the submit button or input
            let submitButton = $(this).find('button[type="submit"], input[type="submit"]');
            let originalText = submitButton.is('button') ? submitButton.html() : submitButton.val(); // Store original text

            // Change the button or input text to "Please wait"
            if (submitButton.is('button')) {
                submitButton.html('{{googleTrans('Please wait...',countryLang($country))}}'); // For <button> element
            } else if (submitButton.is('input')) {
                submitButton.val('{{googleTrans('Please wait...',countryLang($country))}}'); // For <input type="submit">
            }

            // Disable the submit button
            submitButton.prop('disabled', true);

            // Send the form data using AJAX
            $.ajax({
                url: '{{ route('submit-form') }}', // The action URL of the form
                type: 'POST', // Use POST request
                data: formData, // Send form data
                headers: {
                    'X-CSRF-TOKEN': $('input[name="_token"]').val() // Attach the CSRF token
                },
                success: function(response) {
                    // Handle successful response
                    console.log('Success:', response);

                    if (response.success) {
                        window.location.href = response.url;
                    } else {
                        console.error('Error:', response.message);
                        resetButton(); // Reset button on failure
                        if(response.type === 'brand_closed'){
                          window.location.href = response.url;
                        }else{
                            alert(response.message);
                        }
                    }
                },
                error: function(xhr, status, error) {
                    // Handle error response
                    console.error('Error:', error);
                    alert('There was an error submitting the form.');
                    resetButton(); // Reset button on error
                }
            });

            // Reset button function
            function resetButton() {
                if (submitButton.is('button')) {
                    submitButton.html(originalText); // Reset <button> text
                } else if (submitButton.is('input')) {
                    submitButton.val(originalText); // Reset <input type="submit">
                }
                submitButton.prop('disabled', false); // Enable the button
            }
        });


    });
</script>

@stack('js')
{!! setting('website_script_footer') !!}

</body>
</html>