@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title $website_name, se våra användarvillkor" }}</title>
    <meta name="description" content="{{ "Säker användning av $website_title tjänster och förståelse för dina rättigheter och skyldigheter är möjligt genom att noggrant granska våra villkor och bestämmelser." }}" />
@endpush
@section('content')


<section class="main">
        <div class="container">
            <h1 class="bold text-center">ANVÄNDNINGSVILLKOR FÖR WEBBPLATSEN OCH TJÄNSTERNA</h1>
            <h2 class="bold">1. Allmänt</h2>
            <div class="pl-3">
                <p>1.1. Välkommen till {{$website_title}} (”Webbplatsen”).</p>
                <p>Vår e-post <a href="mailto:info{{'@'.$website_title}}">info{{'@'.$website_title}}</a></p>
                <p>{{ aiTrans('1.2. Webbplatsen innehåller information om tredje parts plattformar (', $locale) }} <b>{{ aiTrans('”Tredje Part Plattformar”', $locale) }}</b> {{ aiTrans(') nämligen utbildningstjänster om allmänna investeringstekniker eller marknadsundersökning. Nearest Edge fungerar som en mellanhand och kopplar användare med sådana Tredje Part Plattformar (', $locale) }} <b>{{ aiTrans('”Tjänster”', $locale) }}</b>{{ aiTrans(').', $locale) }}</p>
                <p>{{ aiTrans('1.3. Dessa användningsvillkor (', $locale) }} <b>{{ aiTrans('”Villkor”', $locale) }}</b> {{ aiTrans(') styr din (', $locale) }} <b>{{ aiTrans('”Du”', $locale) }}</b>, <b>{{ aiTrans('”Dina”', $locale) }}</b> {{ aiTrans('eller', $locale) }} <b>{{ aiTrans('”Användare”', $locale) }}</b> {{ aiTrans(') användning av Webbplatsen och Tjänsterna. Dessa Villkor bör läsas noggrant av Dig i sin helhet innan Du använder Tjänsterna. Observera att dessa Villkor utgör ett juridiskt bindande avtal mellan Dig och Webbplatsens operatör Nearest Edge, info', $locale) }}{{'@'.$website_title}}. {{ aiTrans('Om Du inte går med på någon bestämmelse i dessa Villkor ska Du omedelbart sluta använda Webbplatsen. Genom att använda Webbplatsen godkänner Du Villkoren, som kan ändras från tid till annan.', $locale) }}</p>




<p>{{ aiTrans('Dessa Villkor inkluderar vår Integritetspolicy och genom att godkänna dessa Villkor bekräftar Du att Du också accepterar och går med på vår integritetspolicy (Du kan granska vår Integritetspolicy genom att', $locale) }} <a href="{{route('privacy',$country)}}">{{ aiTrans('klicka här', $locale) }}</a>{{ aiTrans(').', $locale) }}</p>
            </div>
            <h2 class="bold">{{ aiTrans('2. Beskrivning av Tjänsterna', $locale) }}</h2>
            <div class="pl-3">
                <p>{{ aiTrans('2.1. Vi är inte en handelsplattform, och vi sätter dig inte i kontakt med sådana handelsplattformar, om inte en sådan handelsplattform åtar sig att erbjuda dig endast utbildningstjänster eller marknadsundersökningar.', $locale) }}</p>
                <p>{{ aiTrans('2.2. Vi fungerar som en mellanhand för att koppla Dig med en tjänsteleverantör som kan erbjuda utbildningsinnehåll om allmänna investeringstekniker eller marknadsundersökningar inom deras intresseområden för Dig.', $locale) }}</p>
                <p>{{ aiTrans('2.3. En representant från den ovan nämnda tjänsteleverantören kommer att kontakta Dig efter att Du har registrerat dig på vår Webbplats genom att tillhandahålla fullständig och korrekt information.', $locale) }}</p>
                <p>{{ aiTrans('2.4. Representantens roll som nämns i 2.3. är att ge Dig information om allmänna investeringstekniker som stämmer överens med dina intressen eller som för närvarande är populära och förbättra din förståelse av investeringsstrategier.', $locale) }}</p>
            </div>
            <h2 class="bold">{{ aiTrans('3. Berättigande', $locale) }}</h2>
            <div class="pl-3">
                <p>{{ aiTrans('3.1. Du har endast rätt att använda Webbplatsen och dra nytta av Tjänsterna om Du uppfyller alla följande krav:', $locale) }}</p>
                <p>{{ aiTrans('3.1.1. Du är minst 18 år gammal;', $locale) }}</p>
                <p>{{ aiTrans('3.1.2. Du har rätt, befogenhet och kapacitet att ingå dessa Villkor och att följa alla villkor och bestämmelser i dessa Villkor;', $locale) }}</p>
                <p>{{ aiTrans('3.1.3. Du är inte förhindrad från att använda Webbplatsen och/eller Tjänsterna enligt lagarna i det land där Du bor eller befinner dig när Du använder Webbplatsen.', $locale) }}</p>
            </div>
            <h2 class="bold">{{ aiTrans('4. Begränsade territorier', $locale) }}</h2>
            <div class="pl-3">
                <p>{{ aiTrans('4.1. Utan att inskränka på allmängiltigheten av det föregående, kan vi begränsa tillgängligheten av Webbplatsen och/eller Tjänsterna (eller någon del därav) till Användare som är belägna i territorier där det juridiska och reglerande ramverket är oförenligt med tillhandahållandet av Tjänsterna.', $locale) }}</p>
                <p>{{ aiTrans('4.2. Vi kan införa ytterligare krav eller villkor innan vi accepterar Användare som är bosatta i eller från specifika länder där detta är nödvändigt för att följa lagarna i det territorium där Användarna är bosatta. Dessutom erkänns att om några Användare skulle resa till de Begränsade Territorierna kan Webbplatsen och/eller Tjänsterna vara otillgängliga och/eller blockerade där.', $locale) }}</p>
            </div>
            <h3 class="bold">{{ aiTrans('5. Förbjudna aktiviteter', $locale) }}</h3>


<div class="pl-3">
                <p>{{ aiTrans('5.1. Du åtar dig att använda Webbplatsen och Tjänsterna på ett respektfullt sätt, och Du åtar dig att inte:', $locale) }}</p>
                <p>{{ aiTrans('5.1.1. Länka till Webbplatsen och/eller använda Webbplatsen för syftet att ladda upp, ladda ner, distribuera, publicera eller överföra (a) information eller annat material på ett sätt som kränker några rättigheter, inklusive immateriella rättigheter, skydd av privatlivets rättigheter eller någon annan rätt; (b) information eller annat material som är förbjudet för publicering eller användning eftersom det utgör ett hot, skada, förolämpning, förtal, rasism eller olämpligt innehåll; (c) information eller annat material som inkluderar ett virus eller annan programvara som kan skada våra datorsystem eller någon tredje part eller på ett sätt som kan begränsa eller förhindra andra från att använda Webbplatsen; (d) information eller annat material som bryter mot någon lag; eller (e) information eller annat material som inkluderar en annons av något slag utan vårt föregående skriftliga tillstånd;', $locale) }}</p>
                <p>{{ aiTrans('5.1.2. Ta bort eller ändra några tillstånd, juridiska meddelanden eller andra äganderättsliga beteckningar eller etiketter på Webbplatsen;', $locale) }}</p>
                <p>{{ aiTrans('5.1.3. Använda Tjänsterna med något annat gränssnitt än Webbplatsen;', $locale) }}</p>
                <p>{{ aiTrans('5.1.4. Störa andra Användares användning av Webbplatsen och/eller Tjänsterna;', $locale) }}</p>
                <p>{{ aiTrans('5.1.5. Använda bots eller andra automatiserade metoder för att få åtkomst till eller använda Webbplatsen och/eller Tjänsterna;', $locale) }}</p>
                <p>{{ aiTrans('5.1.6. Ladda upp eller överföra (eller försöka ladda upp eller överföra), utan vårt uttryckliga tillstånd, något material som fungerar som en passiv eller aktiv informationsinsamling eller överföringsmekanism, inklusive, utan begränsning, webbbuggar, cookies eller andra liknande spionprogram;', $locale) }}</p>
                <p>{{ aiTrans('5.1.7. Delta i', $locale) }} <b>{{ aiTrans('“inramning,” “spegling,”', $locale) }}</b> {{ aiTrans('eller på annat sätt simulera utseendet eller funktionen av Tjänsterna;', $locale) }}</p>
                <p>{{ aiTrans('5.1.8. Bryta mot tillämpliga lagar eller förordningar, uppmuntra eller främja någon olaglig aktivitet inklusive, men inte begränsat till, upphovsrättsintrång, varumärkesintrång, förtal, intrång i privatlivet, identitetsstöld, hacking, cracking eller distribution av piratkopierad programvara;', $locale) }}</p>
                <p>{{ aiTrans('5.1.9. Göra några ändringar och/eller på något sätt ingripa i källkoden för Webbplatsen och ladda upp någon programvara och/eller applikation som kan skada eller orsaka skada på Webbplatsen eller någon annan tredje part;', $locale) }}</p>
                <p>{{ aiTrans('5.1.10. Demontera, dekompilera eller på annat sätt reverse-engineera någon programvara eller annan teknologi som ingår i Webbplatsen eller används för att tillhandahålla Tjänsterna.', $locale) }}</p>
                <p>{{ aiTrans('5.2. Du erkänner att utan att det påverkar någon annan rättighet vi kan ha, om vi fastställer att Din användning av Webbplatsen inte överensstämmer med bestämmelserna i dessa Villkor eller någon tillämplig lag, kan vi blockera Din åtkomst till Webbplatsen och/eller Tjänsterna.', $locale) }}</p>
            </div>
            <h3 class="bold">{{ aiTrans('6. Immateriella rättigheter', $locale) }}</h3>



<div class="pl-3">
                <p>{{ aiTrans('6.1. Webbplatsen och dess innehåll, inklusive videomaterial, text, foton, logotyper, designer, musik, ljud, figurer, varumärken och annat innehåll som ingår i Webbplatsen skyddas av våra eller tredje parts immateriella rättigheter.', $locale) }}</p>
                <p>{{ aiTrans('6.2. Mellan oss och Användaren behåller vi alla rättigheter, titlar och intressen i och till Webbplatsen och Tjänsterna. Användningen av Webbplatsen och/eller Tjänsterna ger inte Användaren några av de immateriella rättigheterna som ingår i Webbplatsen och/eller Tjänsterna, annat än rätten att använda Webbplatsen och/eller Tjänsterna i enlighet med villkoren i dessa Villkor.', $locale) }}</p>
                <p>{{ aiTrans('6.3. Användaren får endast använda Webbplatsen och/eller Tjänsterna för personligt och icke-kommersiellt bruk.', $locale) }}</p>
                <p>{{ aiTrans('6.4. Du får inte, och Du får inte tillåta någon annan part att ändra, dekompilera, demontera, reverse-engineera, kopiera, överföra, skapa derivatarbeten från, hyra ut, underlicensiera, distribuera, reproducera inramat, publicera på nytt, skrapa, ladda ner, visa, överföra, posta, hyra ut eller sälja på något sätt eller med något medel, helt eller delvis, använda för något annat syfte än att använda Webbplatsen eller Tjänsterna i enlighet med Villkoren eller på annat sätt utnyttja något av innehållet på Webbplatsen utan vår uttryckliga, skriftliga tillåtelse.', $locale) }}</p>
            </div>
            <h3 class="bold">{{ aiTrans('7. Ansvarsbegränsning', $locale) }}</h3>
            <div class="pl-3">
                <p>{{ aiTrans('7.1. Vi kan inte hållas ansvariga för förlust eller skada som uppstår till följd av bristande prestation eller felaktig prestation av dessa Villkor som kan tillskrivas (i) Dig eller (ii) oförutsebara och oöverstigliga handlingar av en tredje part i avtalet eller (iii) en force majeure-händelse.', $locale) }}</p>
                <p>{{ aiTrans('7.2. Inga delar av dessa villkor syftar till att utesluta eller begränsa vårt ansvar gentemot Dig där det skulle vara olagligt att göra så, särskilt i fall av:', $locale) }}</p>
                <p>{{ aiTrans('(i) Död eller personskada till följd av vår vårdslöshet,', $locale) }}</p>
                <p>{{ aiTrans('(ii) Bedrägeri eller bedräglig vilseledning, och', $locale) }}</p>
                <p>{{ aiTrans('(iii) något annat ansvar som inte kan uteslutas eller begränsas enligt fransk lag', $locale) }}</p>
                <p>{{ aiTrans('7.3. Utan att inskränka på allmängiltigheten av det föregående, påtar vi oss inget ansvar eller ansvar för några buggar, virus, trojaner eller liknande som kan överföras till eller genom Webbplatsen eller Tjänsterna av någon tredje part, om vi inte är skyldiga.', $locale) }}</p>
                <p>{{ aiTrans('7.4. Vi gör vårt bästa för att säkerställa att Webbplatsen är fri från fel, misstag eller felaktigheter i något innehåll. Om sådana fel, misstag eller felaktigheter inträffar kommer vi att åtgärda dem utan dröjsmål.', $locale) }}</p>
                <p>{{ aiTrans('7.5. Du godkänner att hålla oss skadeslösa för eventuella förluster som orsakas av tredje part, avseende Webbplatsen och/eller Tjänsterna som resulterar från att Du bryter mot dessa Villkor.', $locale) }}</p>
                <p>{{ aiTrans('7.6. Vi är inte ansvariga för några problem eller tekniska funktionsfel i några telefon- eller nätverkslinjer, datoronline-system, servrar eller leverantörer, hårdvara, mjukvara, fel på grund av tekniska problem eller trafikstockning på internet (eller otillgänglighet av internet) eller inkompatibilitet mellan Webbplatsen eller Tjänsterna och din webbläsare och/eller annan utrustning. Utan att inskränka på allmängiltigheten av det ovanstående, påtar vi oss inget ansvar eller risk för Din användning av internet.', $locale) }}</p>
            </div>
            <h3 class="bold">{{ aiTrans('8. Tredjepartstjänster eller innehåll', $locale) }}</h3>



            <div class="pl-3">
                <p>{{ aiTrans('8.1. När du använder Tjänsterna kan du se innehåll eller tjänster som tillhandahålls av tredje parter, inklusive annonser och recensioner angående Tredje Part Plattformar.', $locale) }}</p>
                <p>{{ aiTrans('8.2. Vi kontrollerar, stöder eller antar inte sådant innehåll eller sådana tjänster, och det kan inte alltid vara korrekt eller aktuellt.', $locale) }}</p>
                <p>{{ aiTrans('8.3. Därför rekommenderar vi att du oberoende verifierar all information innan du förlitar dig på den, och alla beslut eller åtgärder som vidtas baserat på sådan information är ditt eget ansvar.', $locale) }}</p>
            </div>

            <h3 class="bold">{{ aiTrans('9. Länkar', $locale) }}</h3>

            <div class="pl-3">
                <p>{{ aiTrans('9.1. Webbplatsen kan innehålla länkar, innehåll, annonser, kampanjer, logotyper och annat material från andra webbplatser eller programvara som kontrolleras eller erbjuds av tredje parter  Länkar . Vi varnar Dig att se till att Du förstår riskerna med att använda sådana webbplatser, programvara eller material innan Du hämtar, använder, förlitar dig på eller köper något via dessa webbplatser eller programvara, eller baserat på sådant material. Sådana Länkar tillhandahålls endast för Din bekvämlighet, och Du godkänner att Du under inga omständigheter kommer att hålla oss ansvariga för eventuella förluster eller skador som orsakas av användning av eller förlitande på något innehåll, varor eller tjänster som finns tillgängliga på andra webbplatser eller programvara.', $locale) }}</p>

                <p>{{ aiTrans('9.2. Inkluderingen av Länkar i Webbplatsen är inte ett stöd, auktorisering, sponsring, koppling, affiliering eller någon annan koppling mellan oss och dessa webbplatser, programvara eller deras operatörer.', $locale) }}</p>
<p>{{ aiTrans('9.3. Vi har inte granskat några eller alla sådana Länkar och är inte ansvariga för något av innehållet på de webbplatser eller programvara som refereras där. Vi varnar Dig att se till att Du förstår riskerna med att använda sådana webbplatser eller programvara innan Du hämtar, använder, förlitar dig på eller köper något via dessa webbplatser eller programvara. Under inga omständigheter kommer Du att hålla oss ansvariga för eventuella förluster eller skador som orsakas av användning av eller förlitande på något innehåll, varor eller tjänster som finns tillgängliga på andra webbplatser.', $locale) }}</p>
<p>{{ aiTrans('9.4. Det är Ditt ansvar att granska villkoren och policyn för sådana tredje parts webbplatser, och vi rekommenderar starkt att du noga granskar dessa innan du engagerar dig med sådana tredje parter.', $locale) }}</p>

            </div>
            <h3 class="bold">{{ aiTrans('10. Övrigt', $locale) }}</h3>
            <div class="pl-3">
                <p>{{ aiTrans('10.1. Vi kan ändra, modifiera eller avbryta, från tid till annan, några av Tjänsterna och/eller införa nya Tjänster med verkan för framtiden.', $locale) }}</p>
                <p>{{ aiTrans('10.2. Vi kan ändra dessa Villkor från tid till annan. När vi gör det kommer vi att informera Dig genom att publicera den aktuella versionen och revidera datumet högst upp på denna sida, och eventuella ändringar träder i kraft omedelbart vid sådan publicering. Genom att fortsätta använda Webbplatsen efter att några ändringar trätt i kraft, anses Du godkänna de reviderade Villkoren.', $locale) }}</p>
                <p>{{ aiTrans('10.3. Användaren godkänner att överföring av information till eller från Webbplatsen inte skapar något förhållande mellan oss som avviker från dem som anges i dessa Villkor.', $locale) }}</p>
                <p>{{ aiTrans('10.4. Dessa Villkor och Integritetspolicyn, som kan ändras från tid till annan, utgör de enda giltiga avtalen mellan oss och Användaren, och inga representationer, löften, samtycken eller åtaganden, vare sig skriftliga eller muntliga, som inte ingår i dessa Villkor eller Integritetspolicy, kommer att vara bindande för parterna.', $locale) }}</p>
                <p>{{ aiTrans('10.5. Ingen försening eller dröjsmål från vår sida att utöva någon rättighet, makt eller åtgärd under dessa Villkor ska fungera som en avstående från sådan rättighet, och ingen enkel eller partiell utövning av någon sådan rättighet, makt eller åtgärd ska hindra någon annan eller ytterligare utövning därav eller utövning av någon annan rättighet, makt eller åtgärd.', $locale) }}</p>
                <p>{{ aiTrans('10.6. Om någon bestämmelse i dessa Villkor anses av en domstol med behörighet vara ogenomförbar enligt tillämplig lag, ska sådan bestämmelse uteslutas från dessa Villkor och resterande bestämmelser ska tolkas som om sådan bestämmelse var så utesluten och ska vara verkställbara i enlighet med sina villkor; dock ska dessa Villkor i sådant fall tolkas så att de i största möjliga utsträckning ger effekt och följer betydelsen och avsikten av den uteslutna bestämmelsen som bestäms av en sådan behörig domstol.', $locale) }}</p>
                <p>{{ aiTrans('10.7. Vi kan överföra eller tilldela några och alla våra rättigheter och skyldigheter enligt dessa Villkor till någon tredje part förutsatt att detta inte negativt påverkar Dina rättigheter. Vidare, utan att inskränka på ovanstående, kan Webbplatsen och/eller någon av Tjänsterna drivas av tredje parter. Du får inte överföra, tilldela eller belåna på något sätt några av Dina rättigheter eller skyldigheter under dessa Villkor.', $locale) }}</p>
                <p>{{ aiTrans('10.8. Dessa villkor ska regleras av fransk lag.', $locale) }}</p>
                <p>{{ aiTrans('10.9. Den exklusiva jurisdiktionen för alla tvister som uppstår från eller i samband med dessa Villkor ska vara domstolarna i den jurisdiktion där Du bor.', $locale) }}</p>
            </div>

            
            
                    </div>
                            </div>
    </section>
@endsection
