@extends('layouts.app')
@push('meta')
    <title>{{ "$website_name $website_title | Sida för att nå oss" }}</title>
    <meta name="description" content="{{ "Vi på $website_title finns här för att guida dig och besvara alla dina frågor gällande kryptovalutor. Vänligen, kontakta oss när som helst." }}" />
@endpush
@section('content')
<section class="py-5">
    <div class="container" style="max-width: 900px;">
        <h1 class="text-center contact-header">{{aiTrans('Kontaktformul채r')}}:</h1>
        <h2 class="text-start contact-subheader">{{aiTrans('Kontaktformul채r')}}</h2>
        <form class="contact-form js-contact-form">
            <div class="form-input-wrap">
                <input type="text" id="name" class="form-input" placeholder="Ditt namn" required="">
            </div>
            <div class="form-input-wrap">
                <input type="email" id="email" class="form-input" placeholder="E-post" required="">
            </div>
            <div class="form-input-wrap">
                <textarea name="message" class="form-control" id="message" placeholder="Meddelande" cols="30" rows="10" required=""></textarea>
            </div>
            <div class="btn-wrapper">
                <button class="btn form-input form-button mw-100">{{aiTrans('SKICKA MEDDELANDE')}}</button>
            </div>
        </form>
    </div>
</section>
    @push('css')
        <style>
            /* Custom CSS for the success message */
            .success-message {
                background-color: #d4edda;
                color: #155724;
                padding: 15px;
                border: 1px solid #c3e6cb;
                border-radius: 5px;
                margin-bottom: 20px;
            }

            /* Hide the message by default */
            .d-none {
                display: none;
            }

            /* Custom button styling */
            .btn-submit {
                background-color: #28a745; /* Custom green color */
                color: white;
                padding: 10px 20px;
                border: none;
                border-radius: 5px;
                cursor: pointer;
                font-size: 18px;
            }

            .btn-submit:hover {
                background-color: #218838; /* Darker green on hover */
            }

            /* Basic form styling */
            .form-group input, .form-group textarea {
                width: 100%;
                padding: 10px;
                border: 1px solid #ccc;
                border-radius: 5px;
            }

        </style>
    @endpush
    @push('js')
        <script>
            document.getElementById('contactForm').addEventListener('submit', function(event) {
                event.preventDefault(); // Prevent traditional form submission

                // Simulate form submission
                setTimeout(function() {
                    // Show the success message
                    document.getElementById('successMessage').classList.remove('d-none');

                    // Optionally, clear the form fields
                    document.getElementById('contactForm').reset();
                }, 500); // Simulate server response delay
            });
        </script>
    @endpush
@endsection
