@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title | Side for personvernserklæringen" }}</title>
    <meta name="description" content="{{ "Utforsk $website_title's engasjement for å beskytte dine data. Vårt personvern legger stor vekt på sikkerhet og åpenhet." }}" />
@endpush
@section('content')
    <div class="container page-inner pt-5">
        <h1>{{ aiTrans('Personvernpolicy') }}</h1>
        <main>
            <p><span class="b">{{ aiTrans('Leverandør') }}</span> {{ aiTrans('("oss", "vi" eller "vår") driver med') }}
                <span class="u">{{$website_title}}</span>
                {{ aiTrans('nettsiden (den "Tjenesten").') }}</p>
            <p>{{ aiTrans('Denne siden informerer deg om våre retningslinjer angående innsamling, bruk og avsløring av personopplysninger når du bruker vår Tjeneste og valgene du har knyttet til de dataene.') }}
            </p>
            <p>{{ aiTrans('Denne siden informerer deg om våre retningslinjer angående innsamling, bruk og avsløring av personopplysninger når du bruker vår Tjeneste og valgene du har knyttet til de dataene.') }}
            </p>
            <p>{{ aiTrans('Vi,') }} <a href="{{ route('home', $country) }}"> {{ $website_title }}</a>,
                {{ aiTrans('bruker dataene dine for å tilby og forbedre Tjenesten. Ved å bruke Tjenesten, samtykker du til innsamling og bruk av informasjon i samsvar med denne policyen. Med mindre annet er definert i denne personvernpolicyen, har vilkårene som brukes i denne personvernpolicyen de samme betydningene som i våre vilkår og betingelser, tilgjengelig fra') }}
                <span class="u">{{$website_title}}</span></p>
            <div id="toc_container" class="no_bullets">
                <ul class="toc_list">
                    <ul>
                        <li>
                            <ul>
                                <li><a href="#Definisjoner"><span class="toc_number toc_depth_3">0.0.1</span>
                                        {{ aiTrans('Definisjoner') }}</a>
                                    <ul>
                                        <li><a href="#Tjeneste"><span class="toc_number toc_depth_4">0.0.1.1</span>
                                                {{ aiTrans('Tjeneste') }}</a></li>
                                    </ul>
                                </li>
                                <li><a href="#Personopplysninger"><span class="toc_number toc_depth_3">0.0.2</span>
                                        {{ aiTrans('Personopplysninger') }}</a></li>
                                <li><a href="#Bruksdata"><span class="toc_number toc_depth_3">0.0.3</span>
                                        {{ aiTrans('Bruksdata') }}</a></li>
                                <li><a href="#Informasjonskapsler"><span class="toc_number toc_depth_3">0.0.4</span>
                                        {{ aiTrans('Informasjonskapsler') }}</a></li>
                                <li><a href="#Dataansvarlig"><span class="toc_number toc_depth_3">0.0.5</span>
                                        {{ aiTrans('Dataansvarlig') }}</a></li>
                                <li><a href="#Databehandlere_eller_Tjenesteleverandører"><span
                                            class="toc_number toc_depth_3">0.0.6</span>
                                        {{ aiTrans('Databehandlere (eller Tjenesteleverandører)') }}</a></li>
                                <li><a href="#Registrert_eller_Bruker"><span class="toc_number toc_depth_3">0.0.7</span>
                                        {{ aiTrans('Registrert (eller Bruker)') }}</a></li>
                            </ul>
                        </li>
                    </ul>
                    <li><a href="#Innsamling_og_bruk_av_informasjon"><span class="toc_number toc_depth_1">1</span>
                            {{ aiTrans('Innsamling Og Bruk Av Informasjon') }}</a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Typer_av_innsamlede_data"><span class="toc_number toc_depth_3">1.0.1</span>
                                            {{ aiTrans('Typer Av Innsamlede Data') }}</a></li>
                                    <li><a href="#Personopplysninger-2"><span class="toc_number toc_depth_3">1.0.2</span>
                                            {{ aiTrans('Personopplysninger') }}</a></li>
                                    <li><a href="#Bruksdata-2"><span class="toc_number toc_depth_3">1.0.3</span>
                                            {{ aiTrans('Bruksdata') }}</a></li>
                                    <li><a href="#Sporingskapsler_data"><span class="toc_number toc_depth_3">1.0.4</span>
                                            {{ aiTrans('Sporingskapsler Data') }}</a></li>
                                    <li><a href="#Bruk_av_data"><span class="toc_number toc_depth_3">1.0.5</span>
                                            {{ aiTrans('Bruk av Data') }}</a></li>
                                    <li><a
                                            href="#Juridisk_basis_for_behandling_av_personopplysninger_i_henhold_til_personopplysningsforordningen_GDPR"><span
                                                class="toc_number toc_depth_3">1.0.6</span>
                                            {{ aiTrans('Juridisk Basis for Behandling av Personopplysninger I Henhold Til Personopplysningsforordningen (GDPR)') }}</a>
                                    </li>
                                    <li><a href="#Oppbevaring_av_data"><span class="toc_number toc_depth_3">1.0.7</span>
                                            {{ aiTrans('Oppbevaring av Data') }}</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#Overføring_av_data"><span class="toc_number toc_depth_1">2</span>
                            {{ aiTrans('Overføring av Data') }}</a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Avsløring_av_data"><span class="toc_number toc_depth_3">2.0.1</span>
                                            {{ aiTrans('Avsløring av Data') }}
                                            <ul>
                                                <li><a href="#Forretningstransaksjon"><span
                                                            class="toc_number toc_depth_4">2.0.1.1</span>
                                                        {{ aiTrans('Forretningstransaksjon') }}</a></li>
                                            </ul>
                                    </li>
                                    <li><a href="#Juridiske_krav"><span class="toc_number toc_depth_3">2.0.2</span>
                                            {{ aiTrans('Juridiske Krav') }}</a></li>
                                    <li><a href="#Sikkerhet_av_data"><span class="toc_number toc_depth_3">2.0.3</span>
                                            {{ aiTrans('Sikkerhet av Data') }}</a></li>
                                    <li><a
                                            href="#Dine_rettigheter_til_databeskyttelse_i_henhold_til_personopplysningsforordningen_GDPR"><span
                                                class="toc_number toc_depth_3">2.0.4</span>
                                            {{ aiTrans('Dine Rettigheter Til Databeskyttelse I Henhold Til Personopplysningsforordningen (GDPR)') }}</a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="#Tjenesteleverandører"><span class="toc_number toc_depth_1">3</span>
                            {{ aiTrans('Tjenesteleverandører') }}</a>
                        <ul>
                            <li>
                                <ul>
                                    <li><a href="#Analyse"><span class="toc_number toc_depth_3">3.0.1</span>
                                            {{ aiTrans('Analyse') }}</a></li>
                                    <li><a href="#Reklame"><span class="toc_number toc_depth_3">3.0.2</span>
                                            {{ aiTrans('Reklame') }}</a></li>
                                    <li><a href="#Atferdsremarketing"><span class="toc_number toc_depth_3">3.0.3</span>
                                            {{ aiTrans('Atferdsremarketing') }}</a></li>
                                    <li><a href="#Lenker_til_andre_nettsteder"><span class="toc_number toc_depth_3">3.0.4</span>
                                            {{ aiTrans('Lenker til Andre Nettsteder') }}</a></li>
                                    <li><a href="#Barnas_privacy"><span class="toc_number toc_depth_3">3.0.5</span>
                                            {{ aiTrans('Barnas Personvern') }}</a></li>
                                    <li><a href="#Endringer_i_denne_personvernpolicyen"><span
                                                class="toc_number toc_depth_3">3.0.6</span>
                                            {{ aiTrans('Endringer I Denne Personvernpolicyen') }}</a></li>
                                    <li><a href="#Kontakt_oss"><span class="toc_number toc_depth_3">3.0.7</span>
                                            {{ aiTrans('Kontakt Oss') }}</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
            <h4><span id="Definisjoner">{{ aiTrans('Definisjoner') }}</span></h4>
            <h5><span id="Tjeneste">{{ aiTrans('Tjeneste') }}</span></h5>
            <p>{{ aiTrans('Tjeneste er') }} <span class="u">{{$website_title}}</span>
                {{ aiTrans('nettsiden som drives av') }} <span class="b">{{ aiTrans('Leverandør') }}</span></p>
            <h4><span id="Personopplysninger">{{ aiTrans('Personopplysninger') }}</span></h4>
            <p>{{ aiTrans('Personopplysninger betyr data om en levende person som kan identifiseres fra disse dataene (eller fra disse og annen informasjon enten i vår besittelse eller sannsynligvis vil komme inn i vår besittelse).') }}
            </p>
            <h4><span id="Bruksdata">{{ aiTrans('Bruksdata') }}</span></h4>
            <p>{{ aiTrans('Bruksdata er data som samles inn automatisk enten generert ved bruk av Tjenesten eller fra Tjenestens infrastruktur selv (for eksempel, varigheten av et sidebesøk).') }}
            </p>
            <h4><span id="Informasjonskapsler">{{ aiTrans('Informasjonskapsler') }}</span></h4>
            <p>{{ aiTrans('Informasjonskapsler er små datastykker lagret på enheten din (datamaskin eller mobil enhet).') }}</p>
            <h4><span id="Dataansvarlig">{{ aiTrans('Dataansvarlig') }}</span></h4>
            <p>{{ aiTrans('Dataansvarlig betyr den fysiske eller juridiske personen som (enten alene eller sammen med andre personer) bestemmer formålene med og måten personopplysninger behandles. For formålet med denne personvernpolicyen er vi en Dataansvarlig for dine Personopplysninger.') }}
            </p>
            <h4><span
                    id="Databehandlere_eller_Tjenesteleverandører">{{ aiTrans('Databehandlere (eller Tjenesteleverandører)') }}</span>
            </h4>
            <p>{{ aiTrans('Databehandler (eller Tjenesteleverandør) betyr enhver fysisk eller juridisk person som behandler data på vegne av Dataansvarlig. Vi kan bruke tjenestene til forskjellige Tjenesteleverandører for å behandle dataene dine mer effektivt.') }}
            </p>
            <h4><span id="Registrert_eller_Bruker">{{ aiTrans('Registrert (eller Bruker)') }}</span></h4>
            <p>{{ aiTrans('Registrert er enhver levende person som bruker vår Tjeneste og er gjenstand for Personopplysninger.') }}
            </p>
            <h2><span id="Innsamling_og_bruk_av_informasjon">{{ aiTrans('Innsamling Og Bruk Av Informasjon') }}</span></h2>
            <p>{{ aiTrans('Vi samler inn flere forskjellige typer informasjon for ulike formål for å tilby og forbedre vår Tjeneste til deg.') }}
            </p>
            <h4><span id="Typer_av_innsamlede_data">{{ aiTrans('Typer av Innsamlede Data') }}</span></h4>
            <h4><span id="Personopplysninger-2">{{ aiTrans('Personopplysninger') }}</span></h4>
            <p>{{ aiTrans('Når du bruker vår Tjeneste, kan vi be deg om å gi oss visse personlig identifiserbare opplysninger som kan brukes til å kontakte eller identifisere deg (“Personopplysninger”). Personlig identifiserbare opplysninger kan inkludere, men er ikke begrenset til:') }}
            </p>
            <ul>
                <li>{{ aiTrans('E-postadresse') }}</li>
                <li>{{ aiTrans('Fornavn og etternavn') }}</li>
                <li>{{ aiTrans('Telefonnummer') }}</li>
                <li>{{ aiTrans('Adresse, Stat, Fylke, Postnummer, By') }}</li>
                <li>{{ aiTrans('Informasjonskapsler og Bruksdata') }}</li>
            </ul>
            <p>{{ aiTrans('Vi kan bruke dine Personopplysninger til å kontakte deg med nyhetsbrev, markedsførings- eller reklame-materiale og annen informasjon som kan være av interesse for deg. Du kan velge å ikke motta noen eller alle disse kommunikasjonene fra oss ved å følge avmeldingslenken eller instruksjonene som gis i enhver e-post vi sender eller ved å kontakte oss.') }}
            </p>
            <h4><span id="Bruksdata-2">{{ aiTrans('Bruksdata') }}</span></h4>
            <p>{{ aiTrans('Vi kan også samle inn informasjon om hvordan Tjenesten får tilgang til og brukes (“Bruksdata”). Denne Bruksdata kan inkludere informasjon som din datamaskins Internet Protocol-adresse (f.eks. IP-adresse), nettlesertype, nettleserversjon, sidene i vår Tjeneste som du besøker, dato og klokkeslett for besøket, tiden brukt på de sidene, unike enhetsidentifikatorer og annen diagnostisk data.') }}
            </p>
            <h4><span id="Sporingskapsler_data">{{ aiTrans('Sporingskapsler Data') }}</span></h4>
            <p>{{ aiTrans('Vi bruker informasjonskapsler og lignende sporings teknologier for å spore aktiviteten på vår Tjeneste og holde visse informasjon.') }}
            </p>
            <p>{{ aiTrans('Informasjonskapsler er filer med små mengder data som kan inkludere en anonym unik identifikator. Informasjonskapsler sendes til nettleseren din fra et nettsted og lagres på enheten din. Sporings teknologier som også brukes er beacons, merker, og skript for å samle inn og spore informasjon og for å forbedre og analysere vår Tjeneste.') }}
            </p>
            <p>{{ aiTrans('Du kan instruere nettleseren din til å nekte alle informasjonskapsler eller til å indikere når en informasjonskapsel sendes. Men hvis du ikke godtar informasjonskapsler, kan det hende du ikke får tilgang til noen deler av vår Tjeneste.') }}
            </p>
            <p>{{ aiTrans('Eksempler på informasjonskapsler vi bruker:') }}</p>
            <ul>
                <li><strong>{{ aiTrans('Sesjonskapsler.') }}</strong>
                    {{ aiTrans('Vi bruker Sesjonskapsler for å drive vår Tjeneste.') }}</li>
                <li><strong>{{ aiTrans('Preferansekapsler.') }}</strong>
                    {{ aiTrans('Vi bruker Preferansekapsler for å huske dine preferanser og forskjellige innstillinger.') }}</li>
                <li><strong>{{ aiTrans('Sikkerhetskapsler.') }}</strong>
                    {{ aiTrans('Vi bruker Sikkerhetskapsler for sikkerhetsformål.') }}</li>
                <li><strong>{{ aiTrans('Reklamekapsler.') }}</strong>
                    {{ aiTrans('Reklamekapsler brukes til å vise annonser som kan være relevante for deg og dine interesser.') }}
                </li>
            </ul>
            <h4><span id="Bruk_av_data">{{ aiTrans('Bruk av Data') }}</span></h4>
            <p><span class="b">{{ aiTrans('Leverandør') }}</span>
                {{ aiTrans('bruker de innsamlede dataene til forskjellige formål:') }}</p>
            <ul>
                <li>{{ aiTrans('For å tilby og opprettholde vår Tjeneste') }}</li>
                <li>{{ aiTrans('For å informere deg om endringer i vår Tjeneste') }}</li>
                <li>{{ aiTrans('For å la deg delta i interaktive funksjoner i vår Tjeneste når du velger å gjøre det') }}
                </li>
                <li>{{ aiTrans('For å tilby kundesupport') }}</li>
                <li>{{ aiTrans('For å samle inn analyser eller verdifull informasjon slik at vi kan forbedre vår Tjeneste') }}</li>
                <li>{{ aiTrans('For å overvåke bruken av vår Tjeneste') }}</li>
                <li>{{ aiTrans('For å oppdage, forhindre og adressere tekniske problemer') }}</li>
                <li>{{ aiTrans('For å gi deg nyheter, spesialtilbud og generell informasjon om andre varer, tjenester og arrangementer som vi tilbyr som er lignende de du allerede har kjøpt eller spurt om med mindre du har valgt å ikke motta slik informasjon') }}
                </li>
            </ul>
            <h4><span
                    id="Juridisk_basis_for_behandling_av_personopplysninger_i_henhold_til_personopplysningsforordningen_GDPR">{{ aiTrans('Juridisk Basis for Behandling av Personopplysninger I Henhold Til Personopplysningsforordningen (GDPR)') }}</span>
            </h4>
            <p>{{ aiTrans('Hvis du er fra Det europeiske økonomiske området (EØS),') }} <span
                    class="b">{{ aiTrans('Leverandør') }}</span>
                {{ aiTrans('juridisk grunnlag for innsamling og bruk av de personlige opplysningene beskrevet i denne personvernpolicyen avhenger av de personopplysningene vi samler inn og den spesifikke konteksten der vi samler inn dem.') }}
            </p>
            <p><span class="b">{{ aiTrans('Leverandør') }}</span>
                {{ aiTrans('kan behandle dine personopplysninger fordi:') }}</p>
            <ul>
                <li>{{ aiTrans('Vi trenger å utføre en kontrakt med deg') }}</li>
                <li>{{ aiTrans('Du har gitt oss tillatelse til å gjøre det') }}</li>
                <li>{{ aiTrans('Behandlingen er i våre legitime interesser og den overstyres ikke av dine rettigheter') }}
                </li>
                <li>{{ aiTrans('For å overholde loven') }}</li>
            </ul>
            <h4><span id="Oppbevaring_av_data">{{ aiTrans('Oppbevaring av Data') }}</span></h4>
            <p><span class="b">{{ aiTrans('Leverandør') }}</span>
                {{ aiTrans('vil oppbevare dine personopplysninger kun så lenge som nødvendig for formålene angitt i denne personvernpolicyen. Vi vil oppbevare og bruke dine personopplysninger i den grad som er nødvendig for å overholde våre juridiske forpliktelser (for eksempel, hvis vi er pålagt å oppbevare dataene dine for å overholde gjeldende lover), løse tvister, og håndheve våre juridiske avtaler og retningslinjer.') }}
            </p>
            <p><span class="b">{{ aiTrans('Leverandør') }}</span>
                {{ aiTrans('vil også oppbevare Bruksdata for interne analyseformål. Bruksdata oppbevares generelt i kortere perioder, med mindre denne dataen brukes til å styrke sikkerheten eller for å forbedre funksjonaliteten til vår Tjeneste, eller vi er juridisk forpliktet til å oppbevare denne dataen i lengre tidsperioder.') }}
            </p>
            <h2><span id="Overføring_av_data">{{ aiTrans('Overføring av Data') }}</span></h2>
            <p>{{ aiTrans('Din informasjon, inkludert personopplysninger, kan bli overført til — og oppbevart på — datamaskiner som ligger utenfor din stat, provins, land eller annen offentlig jurisdiksjon der databeskyttelseslovene kan avvike fra dem i din jurisdiksjon.') }}
            </p>
            <p>{{ aiTrans('Hvis du befinner deg utenfor Bulgaria og velger å gi oss informasjon, vennligst merk at vi overfører dataene, inkludert personopplysninger, til Bulgaria og behandler det der.') }}
            </p>
            <p>{{ aiTrans('Ditt samtykke til denne personvernpolicyen etterfulgt av din innsending av slik informasjon representerer din avtale om den overføringen.') }}
            </p>
            <p><span class="b">{{ aiTrans('Leverandør') }}</span>
                {{ aiTrans('vil ta alle rimelige skritt som er nødvendige for å sikre at dataene dine behandles sikkert og i samsvar med denne personvernpolicyen og ingen overføring av dine personopplysninger vil finne sted til en organisasjon eller et land med mindre det er tilstrekkelige kontroller på plass, inkludert sikkerheten til dataene dine og annen personlig informasjon.') }}
            </p>
            <h4><span id="Avsløring_av_data">{{ aiTrans('Avsløring av Data') }}</span></h4>
            <h5><span id="Forretningstransaksjon">{{ aiTrans('Forretningstransaksjon') }}</span></h5>
            <p>{{ aiTrans('Hvis') }} <span class="b">{{ aiTrans('Leverandør') }}</span>
                {{ aiTrans('er involvert i en fusjon, oppkjøp eller salg av eiendeler, kan dine personopplysninger bli overført. Vi vil gi varsel før dine personopplysninger overføres og blir underlagt en annen personvernpolicy.') }}
            </p>
            <h4><span id="Juridiske_krav">{{ aiTrans('Juridiske Krav') }}</span></h4>
            <p><span class="b">{{ aiTrans('Leverandør') }}</span>
                {{ aiTrans('kan avsløre dine personopplysninger i den gode tro at en slik handling er nødvendig for å:') }}
            </p>
            <ul>
                <li>{{ aiTrans('For å overholde en juridisk forpliktelse') }}</li>
                <li>{{ aiTrans('For å beskytte og forsvare rettighetene eller eiendommen til') }} <span
                        class="b">{{ aiTrans('Leverandør') }}</span></li>
                <li>{{ aiTrans('For å forhindre eller undersøke mulig feil i forbindelse med Tjenesten') }}</li>
                <li>{{ aiTrans('For å beskytte den personlige sikkerheten til brukere av Tjenesten eller offentligheten') }}</li>
                <li>{{ aiTrans('For å beskytte mot juridisk ansvar') }}</li>
            </ul>
            <h4><span id="Sikkerhet_av_data">{{ aiTrans('Sikkerhet av Data') }}</span></h4>
            <p>{{ aiTrans('Sikkerheten til dataene dine er viktig for oss, men husk at ingen metode for overføring over internett, eller metode for elektronisk lagring er 100% sikker. Mens vi streber etter å bruke kommersielt akseptable midler for å beskytte dine personopplysninger, kan vi ikke garantere deres absolutte sikkerhet.') }}
            </p>
            <h4><span
                    id="Dine_rettigheter_til_databeskyttelse_i_henhold_til_personopplysningsforordningen_GDPR">{{ aiTrans('Dine Rettigheter Til Databeskyttelse I Henhold Til Personopplysningsforordningen (GDPR)') }}</span>
            </h4>
            <p>{{ aiTrans('Hvis du er bosatt i Det europeiske økonomiske området (EØS), har du visse databeskyttelsesrettigheter.') }}
                <span class="b">{{ aiTrans('Leverandør') }}</span>
                {{ aiTrans('har som mål å ta rimelige skritt for å tillate deg å korrigere, endre, slette eller begrense bruken av dine personopplysninger.') }}
            </p>
            <p>{{ aiTrans('Hvis du ønsker å bli informert om hvilke personopplysninger vi har om deg og om du vil ha det fjernet fra våre systemer, vennligst kontakt oss.') }}
            </p>
            <p>{{ aiTrans('I visse omstendigheter har du følgende databeskyttelsesrettigheter:') }}</p>
            <p><strong>{{ aiTrans('Rett til å få tilgang til, oppdatere eller slette informasjonen vi har om deg.') }}</strong>
                {{ aiTrans('Når det er mulig, kan du få tilgang til, oppdatere eller be om sletting av dine personopplysninger direkte i kontoinnstillingene dine. Hvis du ikke kan utføre disse handlingene selv, vennligst kontakt oss for å hjelpe deg.') }}<br>
                <strong>{{ aiTrans('Rett til rettelse.') }}</strong>
                {{ aiTrans('Du har rett til å få informasjonen din rettet hvis denne informasjonen er unøyaktig eller ufullstendig.') }}<br>
                <strong>{{ aiTrans('Rett til å protestere.') }}</strong>
                {{ aiTrans('Du har rett til å protestere mot vår behandling av dine personopplysninger.') }}<br>
                <strong>{{ aiTrans('Rett til begrensning.') }}</strong>
                {{ aiTrans('Du har rett til å be om at vi begrenser behandlingen av dine personopplysninger.') }}<br>
                <strong>{{ aiTrans('Rett til dataportabilitet.') }}</strong>
                {{ aiTrans('Du har rett til å få en kopi av informasjonen vi har om deg i et strukturert, maskinlesbart og vanligvis brukt format.') }}<br>
                <strong>{{ aiTrans('Rett til å trekke tilbake samtykke.') }}</strong>
                {{ aiTrans('Du har også rett til å trekke tilbake samtykket ditt når som helst der') }} <span
                    class="b">{{ aiTrans('Leverandør') }}</span>
                {{ aiTrans('støttet seg på ditt samtykke for å behandle dine personopplysninger.') }}</p>
            <p>{{ aiTrans('Vennligst merk at vi kan be deg om å bekrefte identiteten din før vi svarer på slike forespørsel.') }}
            </p>
            <p>{{ aiTrans('Du har rett til å klage til en Databeskyttelsesmyndighet om vår innsamling og bruk av dine personopplysninger. For mer informasjon, vennligst kontakt din lokale databeskyttelsesmyndighet i Det europeiske økonomiske området (EØS).') }}
            </p>
            <h2><span id="Tjenesteleverandører">{{ aiTrans('Tjenesteleverandører') }}</span></h2>
            <p>{{ aiTrans('Vi kan ansette tredjeparts selskaper og enkeltpersoner for å legge til rette for vår Tjeneste (“Tjenesteleverandører”), for å tilby Tjenesten på vegne av oss, for å utføre tjenester relatert til Tjenesten eller for å hjelpe oss med å analysere hvordan vår Tjeneste brukes.') }}
            </p>
            <p>{{ aiTrans('Disse tredjepartene har tilgang til dine personopplysninger kun for å utføre disse oppgavene på våre vegne og er forpliktet til ikke å avsløre eller bruke dem til noe annet formål.') }}
            </p>
            <h4><span id="Analyse">{{ aiTrans('Analyse') }}</span></h4>
            <p>{{ aiTrans('Vi kan bruke tredjeparts Tjenesteleverandører til å overvåke og analysere bruken av vår Tjeneste.') }}
            </p>
            <p><strong>{{ aiTrans('Google Analytics') }}</strong><br>
                {{ aiTrans('Google Analytics er en webanalyse tjeneste tilbudt av Google som sporer og rapporterer nettsteds trafikk. Google bruker dataene som samles inn for å spore og overvåke bruken av vår Tjeneste. Disse dataene deles med andre Google-tjenester. Google kan bruke de innsamlede dataene til å kontekstualisere og tilpasse annonsene i sitt eget annonse nettverk. Du kan velge bort å gjøre aktiviteten din på Tjenesten tilgjengelig for Google Analytics ved å installere Google Analytics opt-out nettleser tillegg. Tillegget forhindrer Google Analytics JavaScript (ga.js, analytics.js, og dc.js) fra å dele informasjon med Google Analytics om besøksaktivitet. For mer informasjon om personvernpraksisene til Google, vennligst besøk Googles personvernvilkår nettside:') }}
                <a href="{{ route('home', $country) }}" target="_blank"
                    rel="noopener">{{ aiTrans('http://www.google.com/intl/en/policies/privacy/') }}</a></p>
            <h4><span id="Reklame">{{ aiTrans('Reklame') }}</span></h4>
            <p>{{ aiTrans('Vi kan bruke tredjeparts Tjenesteleverandører for å vise annonser til deg for å hjelpe til med å støtte og opprettholde vår Tjeneste.') }}
            </p>
            <p><strong>{{ aiTrans('Google AdSense DoubleClick Kapsel') }}</strong><br>
                {{ aiTrans('Google, som en tredjeparts leverandør, bruker informasjonskapsler for å vise annonser på vår Tjeneste. Googles bruk av DoubleClick-informasjonskapselen gjør det mulig for dem og deres partnere å vise annonser til våre brukere basert på deres besøk til vår Tjeneste eller andre nettsteder på Internett. Du kan velge bort bruken av DoubleClick-informasjonskapselen for interessestyrt annonsering ved å besøke Googles annonseinnstillingssiden:') }}
                <a href="{{ route('home', $country) }}" target="_blank"
                    rel="noopener">http://www.google.com/ads/preferences</a></p>
            <h4><span id="Atferdsremarketing">{{ aiTrans('Atferdsremarketing') }}</span></h4>
            <p><span class="b">{{ aiTrans('Leverandør') }}</span>
                {{ aiTrans('bruker remarketingtjenester for å reklamere på tredjeparts nettsteder til deg etter at du har besøkt vår Tjeneste. Vi og våre tredjepartsleverandører bruker informasjonskapsler for å informere, optimalisere og vise annonser basert på dine tidligere besøk til vår Tjeneste.') }}
            </p>
            <p><strong>{{ aiTrans('Google AdWords') }}</strong><br>
                {{ aiTrans('Google AdWords remarketingtjeneste tilbys av Google Inc. Du kan velge bort Google Analytics for Display Advertising og tilpasse Google Display Network-annonsene ved å besøke Googles annonseinnstillingssiden:') }}
                <a href="http://www.google.com/settings/ads" target="_blank"
                    rel="noopener">{{ aiTrans('http://www.google.com/settings/ads') }}</a>
                {{ aiTrans('Google anbefaler også å installere Google Analytics Opt-out nettleser tillegg –') }} <a
                    href="https://tools.google.com/dlpage/gaoptout" target="_blank"
                    rel="noopener">https://tools.google.com/dlpage/gaoptout</a> –
                {{ aiTrans('for din nettleser. Google Analytics Opt-out nettleser tillegg gir besøkende mulighet til å forhindre at dataene deres samles inn og brukes av Google Analytics. For mer informasjon om personvernpraksisene til Google, vennligst besøk Googles personvernvilkår nettside:') }}
                <a href="https://www.google.com/intl/en/policies/privacy/" target="_blank"
                    rel="noopener">http://www.google.com/intl/en/policies/privacy</a></p>
            <p><strong>{{ aiTrans('Facebook') }}</strong><br>
                {{ aiTrans('Facebook remarketingtjeneste tilbys av Facebook Inc. Du kan lære mer om interessestyrt annonsering fra Facebook ved å besøke denne siden:') }}
                <a href="{{ route('home', $country) }}" target="_blank"
                    rel="noopener">{{ route('home', $country) }}</a>
                {{ aiTrans('For å velge bort Facebooks interessestyrte annonser, følg disse instruksjonene fra Facebook:') }} <a
                    href="{{ route('home', $country) }}" target="_blank"
                    rel="noopener">{{ aiTrans('https://www.facebook.com/help/568137493302217') }}</a>
                {{ aiTrans('Facebook følger de selvregulerende prinsippene for online atferdsreklame fastsatt av Digital Advertising Alliance. Du kan også velge bort Facebook og andre deltakende selskaper gjennom Digital Advertising Alliance i USA') }}
                <a href="{{ route('home', $country) }}" target="_blank"
                    rel="noopener">{{ route('home', $country) }}</a>,
                {{ aiTrans('Digital Advertising Alliance of Canada i Canada') }} <a
                    href="{{ route('home', $country) }}" target="_blank"
                    rel="noopener">{{ route('home', $country) }}</a>
                {{ aiTrans('eller European Interactive Digital Advertising Alliance i Europa') }} <a
                    href="{{ route('home', $country) }}" target="_blank" rel="noopener">{{ route('home', $country) }}
                </a>,
                {{ aiTrans('eller velge bort ved å bruke innstillingene på mobilenheten din. For mer informasjon om personvernpraksisene til Facebook, vennligst besøk Facebooks datavilkår:') }}
                <a href="{{ route('home', $country) }}" target="_blank"
                    rel="noopener">{{ route('home', $country) }}</a></p>
            <h4><span id="Lenker_til_andre_nettsteder">{{ aiTrans('Lenker til Andre Nettsteder') }}</span></h4>
            <p>{{ aiTrans('Vår Tjeneste kan inneholde lenker til andre nettsteder som ikke drives av oss. Hvis du klikker på en tredjepartslenke, vil du bli sendt til den tredjeparts nettstedet. Vi anbefaler sterkt at du gjennomgår personvernpolicyen til hver nettsted du besøker.') }}
            </p>
            <p>{{ aiTrans('Vi har ingen kontroll over og påtar oss ikke ansvar for innholdet, personvernpolicyene eller praksisene til noen tredjeparts nettsteder eller tjenester.') }}
            </p>
            <h4><span id="Barnas_privacy">{{ aiTrans('Barnas Personvern') }}</span></h4>
            <p>{{ aiTrans('Vår Tjeneste henvender seg ikke til noen under 18 år (“Barn”).') }}</p>
            <p>{{ aiTrans('Vi samler ikke bevisst inn personlig identifiserbar informasjon fra noen under 18 år. Hvis du er en forelder eller verge og du er klar over at barna dine har gitt oss personopplysninger, vennligst kontakt oss. Hvis vi blir klar over at vi har samlet inn personopplysninger fra barn uten verifisering av foreldresamtykke, vil vi ta tiltak for å fjerne den informasjonen fra serverne våre.') }}
            </p>
            <h4><span id="Endringer_i_denne_personvernpolicyen">{{ aiTrans('Endringer I Denne Personvernpolicyen') }}</span></h4>
            <p>{{ aiTrans('Vi kan oppdatere vår personvernpolicy fra tid til annen. Vi vil varsle deg om eventuelle endringer ved å legge ut den nye personvernpolicyen på denne siden.') }}
            </p>
            <p>{{ aiTrans('Vi vil informere deg via e-post og/eller en fremtredende melding på vår Tjeneste, før endringen trer i kraft og oppdatere "ikrafttredelsesdatoen" øverst i denne personvernpolicyen.') }}
            </p>
            <p>{{ aiTrans('Det anbefales at du periodisk gjennomgår denne personvernpolicyen for eventuelle endringer. Endringer til denne personvernpolicyen er effektive når de publiseres på denne siden.') }}
            </p>
            <h4><span id="Kontakt_oss">{{ aiTrans('Kontakt Oss') }}</span></h4>
            <p>{{ aiTrans('Hvis du har spørsmål om denne personvernpolicyen, vennligst kontakt oss via e-post.') }}</p>
        </main>
    </div>
@endsection
