@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title | Uw Privacybeleid op Onze Site" }}</title>
    <meta name="description" content="{{ "Ontdek de maatregelen die $website_title neemt voor de veiligheid van uw data. Wij beloven duidelijkheid in de omgang met uw persoonlijke gegevens." }}" />
    
@endpush
@section('content')
    <section class="uk-section">
        <div class="uk-container uk-margin-xlarge-bottom">
            <div class="gb-container gb-container-21e3081f alignwide">

                <h1 class="uk-text-center">Privacybeleid</h1>

                <div>
                    <p>Wij zijn toegewijd aan het beveiligen van uw Persoonlijke Gegevens en uw privacy.</p>
                    <p>Dit Privacybeleid informeert u over hoe wij de informatie die u verstrekt op de website {{ $website_title }} beheren, verzamelen en gebruiken.</p>
                    <p>{{ aiTrans('We will uphold the following principles:', $locale) }}</p>
                    <ul class="wp-block-list">
                        <li>{{ aiTrans('To be transparent in respect of the collection and processing of Personal Data about you:', $locale) }}</li>
                    </ul>
                    <p>{{ aiTrans('Het is belangrijk voor ons dat u over alle informatie beschikt om weloverwogen beslissingen te nemen.', $locale) }}</p>
                    <p>{{ aiTrans('U kunt ons bereiken via: info@', $locale) }} {{ $website_title }}</p>
                    <ul class="wp-block-list">
                        <li>{{ aiTrans('Om Persoonlijke Gegevens over u uitsluitend te verwerken voor de doeleinden zoals uiteengezet in het Beleid:', $locale) }}</li>
                    </ul>
                    <p>{{ aiTrans('Wij verwerken Persoonlijke Gegevens voor doeleinden zoals het aanbieden van de Website en het verbeteren van onze diensten.', $locale) }}</p>
                    <p>{{ aiTrans('Wij besteden middelen om uw rechten te respecteren.', $locale) }}</p>
                    <p>{{ aiTrans('Wij beschermen uw Persoonlijke Gegevens met passende maatregelen.', $locale) }}</p>
                    <p>{{ aiTrans('Ons Privacybeleid', $locale) }}</p>
                    <p>{{ aiTrans('1. Reikwijdte:', $locale) }}</p>
                    <p>{{ aiTrans('Dit Beleid beschrijft de soorten Persoonlijke Gegevens die we verzamelen en hoe we deze gebruiken.', $locale) }}</p>
                    <p>{{ aiTrans('2. Wanneer Verzamelen Wij Persoonlijke Gegevens:', $locale) }}</p>
                    <p>{{ aiTrans('Wij verzamelen Persoonlijke Gegevens wanneer u de Diensten gebruikt.', $locale) }}</p>
                    <p>{{ aiTrans('3. Geen Verplichting:', $locale) }}</p>
                    <p>{{ aiTrans('U bent niet verplicht om ons Persoonlijke Gegevens te verstrekken.', $locale) }}</p>
                    <p>{{ aiTrans('4. Welke Gegevens Verzamelen Wij:', $locale) }}</p>
                    <p>{{ aiTrans('Wij verzamelen gegevens zoals IP-adres en gebruikspatronen.', $locale) }}</p>
                    <p>{{ aiTrans('5. Doeleinden van Verwerking:', $locale) }}</p>
                    <p>{{ aiTrans('Wij verwerken gegevens voor klantenservice en verbetering van de diensten.', $locale) }}</p>
                    <p>{{ aiTrans('6. Delen met Derden:', $locale) }}</p>
                    <p>{{ aiTrans('Wij delen gegevens met derden voor de dienstverlening.', $locale) }}</p>
                    <p>{{ aiTrans('7. Cookies:', $locale) }}</p>
                    <p>{{ aiTrans('Wij gebruiken cookies om uw ervaring te verbeteren.', $locale) }}</p>
                    <p>{{ aiTrans('8. Bewaring van Gegevens:', $locale) }}</p>
                    <p>{{ aiTrans('Wij bewaren uw gegevens niet langer dan nodig is.', $locale) }}</p>
                    <p>{{ aiTrans('9. Rechten van Gebruikers:', $locale) }}</p>
                    <p>{{ aiTrans('U heeft rechten met betrekking tot uw Persoonlijke Gegevens.', $locale) }}</p>
                    <p>{{ aiTrans('10. Wijzigingen:', $locale) }}</p>
                    <p>{{ aiTrans('Wij kunnen dit Beleid van tijd tot tijd wijzigen.', $locale) }}</p>
                </div>

            </div>
        </div>
    </section>
@endsection
