@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title | Tentang Kebijakan Privasi Situs" }}</title>
    <meta name="description" content="{{ "Yuk temukan, bagaimana $website_title menjaga data Anda tetap aman. Rincian cara kami menciptakan transparansi akan dijelaskan di kebijakan privasi kami." }}" />
@endpush

@section('content')
    <section class="privacy-policy wf-section">
        <div class="container w-container">
            <h1 class="privacy-policy-title">KEBIJAKAN PRIBADI</h1>
            <div class="breadcrumbs">
                <ol>
                    <li><a href="{{ route('home', $country) }}">{{ $website_title }}</a></li>
                    <li>{{ aiTrans('Kebijakan pribadi') }}</li>
                </ol>
            </div>
            <div class="privacy-policy-text">

                <p>
                    <b>Last updated:</b> September 2022
                </p>
                <h3>{{ aiTrans('1. Introduction', $locale) }}</h3>
                <p>
                    {{ aiTrans('Pernyataan ini menjelaskan kebijakan privasi yang diadopsi oleh', $locale) }} {{ $website_title }}
                    {{ aiTrans('("kami," "kita," atau "milik kami") terkait dengan produk dan layanan kami (the "Layanan") dan', $locale) }}
                    <a href="{{ route('home', $country) }}">{{ aiTrans('website', $locale) }}</a>
                    {{ aiTrans('(the "Website"). Melindungi privasi Anda dan kerahasiaan informasi Anda sangat penting bagi kami dalam memberikan Layanan kami dan mengoperasikan Website.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Layanan dan Website kami dapat terhubung ke situs dan layanan pihak ketiga. Kami tidak bertanggung jawab atas praktik privasi entitas pihak ketiga ini. Disarankan untuk meninjau kebijakan privasi mereka sebelum menggunakannya.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Semua informasi yang diperoleh oleh kami sehubungan dengan Layanan kami diperlakukan sebagai rahasia. Kami menggunakan langkah-langkah teknis, keamanan, dan organisasi yang kuat untuk melindungi Data Pribadi (sebagaimana didefinisikan di bawah) dari pemrosesan yang tidak sah, kehilangan, penghancuran, kerusakan, pencurian, atau pengungkapan yang tidak diinginkan.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Saat mengirimkan informasi Anda melalui website kami, Anda mungkin diminta untuk memberikan informasi pribadi, (misalnya) nama Anda, email, nomor telepon, tanggal lahir, dan berbagai detail identifikasi. Informasi ini mungkin digunakan, antara lain, untuk memverifikasi identitas, mengelola informasi, menawarkan dukungan teknis, dan memenuhi kewajiban kontraktual dan hukum. Kami dapat mengkomunikasikan detail penting melalui pemberitahuan, dan dengan persetujuan Anda, memberikan informasi tentang produk dan layanan melalui SMS, email, dll. Anda memiliki opsi untuk mengelola preferensi pemberitahuan dan berhenti berlangganan dari komunikasi tertentu.', $locale) }}
                </p>
                <h3>{{ aiTrans('2. Website; Pengunjung dan Pengguna', $locale) }}</h3>
                <h4>{{ aiTrans('2.1. Umum', $locale) }}</h4>
                <p>
                    {{ aiTrans('Bagian ini menguraikan rincian pengumpulan data dari berbagai kelompok: Pengunjung Website ("Pengunjung"), pengguna ("Pengguna"), dan mitra bisnis (secara kolektif "Mitra"). Data Pribadi mencakup alamat IP, nama, detail kontak, dan informasi tentang hubungan dengan kami, sebagaimana didefinisikan oleh peraturan perlindungan data yang berlaku.', $locale) }}
                </p>
                <h4>{{ aiTrans('2.2. Pengumpulan dan Penggunaan', $locale) }}</h4>
                <p>
                    {{ aiTrans('Dengan mengunjungi Website, Anda menyetujui pengumpulan dan penggunaan Data Pribadi Anda. Ketidaksetujuan terhadap ketentuan ini seharusnya menghalangi Anda untuk mengunjungi Website. Kami dapat mengumpulkan informasi melalui aktivitas tampilan halaman, alamat IP, dan cookie. Selain itu, kami memproses data yang diberikan secara sukarela dari formulir dan pendaftaran.', $locale) }}
                </p>
                <h4>{{ aiTrans('2.3. Tujuan Pemrosesan Data Pribadi', $locale) }}</h4>
                <p>
                    {{ aiTrans('Kami memproses Data Pribadi untuk meningkatkan, memahami, dan mempersonalisasi Website dan Layanan kami. Ini mencakup peningkatan akurasi, komunikasi tentang Layanan, dukungan, kewajiban kontraktual, dan kolaborasi dengan mitra. Persetujuan atau dasar hukum penting untuk setiap pemrosesan.', $locale) }}
                </p>
                <p>{{ aiTrans('Berikut adalah rincian tujuan dan dasar hukum untuk pemrosesan Data Pribadi:', $locale) }}
                </p>
                <table>
                    <tbody>
                        <tr>
                            <td>{{ aiTrans('Pendaftaran sebagai pemegang akun', $locale) }}</td>
                            <td>{{ aiTrans('Persetujuan Anda; Pelaksanaan Layanan atau kewajiban kontrak', $locale) }}
                            </td>
                        </tr>
                        <tr>
                            <td>{{ aiTrans('Memberikan dan menggunakan Layanan', $locale) }}</td>
                            <td>{{ aiTrans('Pelaksanaan Layanan atau kewajiban kontrak', $locale) }}</td>
                        </tr>
                        <tr>
                            <td>{{ aiTrans('Pembaruan operasional', $locale) }}</td>
                            <td>{{ aiTrans('Pelaksanaan Layanan atau kewajiban kontrak', $locale) }}</td>
                        </tr>
                        <tr>
                            <td>{{ aiTrans('Menanggapi pertanyaan dan memberikan dukungan', $locale) }}</td>
                            <td>{{ aiTrans('Kepentingan yang sah atau pelaksanaan Layanan', $locale) }}</td>
                        </tr>
                        <tr>
                            <td>{{ aiTrans('Layanan yang disesuaikan, periklanan, dan pemasaran', $locale) }}</td>
                            <td>{{ aiTrans('Kepentingan yang sah atau persetujuan Anda', $locale) }}</td>
                        </tr>
                        <tr>
                            <td>{{ aiTrans('Meningkatkan dan menawarkan Layanan baru', $locale) }}</td>
                            <td>{{ aiTrans('Persetujuan dan kepentingan yang sah', $locale) }}</td>
                        </tr>
                        <tr>
                            <td>{{ aiTrans('Mengirimkan materi periklanan dan pemasaran', $locale) }}</td>
                            <td>{{ aiTrans('Persetujuan Anda', $locale) }}</td>
                        </tr>
                        <tr>
                            <td>{{ aiTrans('Menganalisis efektivitas kampanye pemasaran', $locale) }}</td>
                            <td>{{ aiTrans('Kepentingan yang sah atau persetujuan', $locale) }}</td>
                        </tr>
                        <tr>
                            <td>{{ aiTrans('Melakukan berbagai kegiatan dukungan', $locale) }}</td>
                            <td>{{ aiTrans('Kepentingan yang sah atau pelaksanaan Layanan', $locale) }}</td>
                        </tr>
                        <tr>
                            <td>{{ aiTrans('Analisis, termasuk analisis statistik', $locale) }}</td>
                            <td>{{ aiTrans('Kepentingan yang sah', $locale) }}</td>
                        </tr>
                        <tr>
                            <td>{{ aiTrans('Melindungi kepentingan, hak, dan aset', $locale) }}</td>
                            <td>{{ aiTrans('Kepentingan yang sah atau kewajiban hukum', $locale) }}</td>
                        </tr>
                    </tbody>
                </table>
                <h4>{{ aiTrans('2.4. Berbagi Data Pribadi', $locale) }}</h4>
                <p>
                    {{ aiTrans('Kami dapat berbagi informasi dengan vendor layanan, Mitra, dan kontraktor. Untuk Pengunjung dan Pengguna di Wilayah Data Eropa, pemrosesan data mematuhi GDPR dan Hukum Perlindungan Data serta peraturan yang berlaku.', $locale) }}
                </p>
                <h3>{{ aiTrans('3. Mitra', $locale) }}</h3>
                <h4>{{ aiTrans('3.1. Umum', $locale) }}</h4>
                <p>
                    {{ aiTrans('Untuk memberikan Layanan dan berkolaborasi dengan Mitra, kami mengumpulkan dan memproses jenis data tertentu. Mitra bertanggung jawab atas data mereka, dan kami dapat mengaksesnya melalui cara yang aman.', $locale) }}
                </p>
                <h4>{{ aiTrans('3.2. Pemrosesan Data Pribadi', $locale) }}</h4>
                <p>
                    {{ aiTrans('Kami bergantung pada persetujuan Mitra atau kepentingan yang sah untuk memproses Data Pribadi. Agregasi Data dapat dibuat untuk pengembangan dan peningkatan kualitas.', $locale) }}
                </p>
                <h4>{{ aiTrans('3.3. Pengendali/Pemroses', $locale) }}</h4>
                <p>{{ aiTrans('Kami dapat bertindak sebagai Pengendali atau Pemroses tergantung pada jenis data:', $locale) }}</p>
                <ul>
                    <li>{{ aiTrans('Data Pengunjung/Pengguna: Pengendali', $locale) }}</li>
                    <li>{{ aiTrans('Data Mitra: Pemroses', $locale) }}</li>
                    <li>{{ aiTrans('Semua data dihosting dengan aman, mengikuti standar keamanan tertinggi. Kami menerapkan langkah-langkah perlindungan fisik, teknis, dan organisasi.', $locale) }}
                    </li>
                </ul>
                <h4>{{ aiTrans('3.4. Perlindungan Data Pihak Ketiga', $locale) }}</h4>
                <p>{{ aiTrans('Jika Layanan melibatkan pemrosesan Data Pribadi di platform pihak ketiga:', $locale) }}</p>
                <ul>
                    <li>{{ aiTrans('Kami bertindak sebagai Pemroses', $locale) }}</li>
                    <li>{{ aiTrans('Mematuhi instruksi pihak ketiga', $locale) }}</li>
                    <li>{{ aiTrans('Menerapkan langkah-langkah keamanan', $locale) }}</li>
                    <li>{{ aiTrans('Memberitahukan tentang pelanggaran data', $locale) }}</li>
                    <li>{{ aiTrans('Tidak melakukan subkontrak tanpa persetujuan', $locale) }}</li>
                    <li>{{ aiTrans('Tidak memproses data di luar Kawasan Ekonomi Eropa tanpa persetujuan', $locale) }}
                    </li>
                    <li>{{ aiTrans('Untuk komunikasi pemasaran elektronik, persetujuan dan opsi untuk berhenti berlangganan dijamin.', $locale) }}
                    </li>
                </ul>
                <h3>{{ aiTrans('4. Keamanan', $locale) }}</h3>
                <p>
                    {{ aiTrans('Kami menggunakan langkah-langkah administratif, organisasi, dan teknis untuk melindungi Data Pribadi dari akses, pengungkapan, perubahan, kehilangan, penyalahgunaan, atau kerusakan yang tidak sah. Saat berbagi data dengan pihak ketiga, kami memastikan mereka mematuhi standar perlindungan data yang sama, dan kewajiban kontraktual ditetapkan untuk pemrosesan eksklusif dan aman sesuai dengan Kebijakan ini.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Jika ada keyakinan bahwa interaksi dengan kami telah terkompromi, Pengunjung, Pengguna, atau Mitra harus segera memberi tahu kami. Penting untuk dicatat bahwa, meskipun langkah-langkah keamanan kami, kami tidak dapat menjamin perlindungan penuh dari peretasan pihak ketiga. Pengguna mengakui risiko yang melekat dan kemungkinan pelanggaran.', $locale) }}
                </p>
                <h3>{{ aiTrans('5. Cookie', $locale) }}</h3>
                <p>
                    {{ aiTrans('Silakan lihat Kebijakan Cookie kami untuk informasi terperinci tentang jenis cookie dan teknologi pelacakan yang digunakan di Website, alasan penggunaan, dan cara menerima atau menolaknya.', $locale) }}
                </p>
                <h3>{{ aiTrans('6. Tautan ke Situs Lain', $locale) }}</h3>
                <p>
                    {{ aiTrans('Saat menjelajahi Website, Pengguna mungkin menemui tautan ke situs eksternal di luar kendali kami. Kami tidak bertanggung jawab atas konten atau kebijakan privasi situs-situs ini. Pengguna disarankan untuk meninjau kebijakan privasi situs dan layanan pihak ketiga tersebut sebelum mengungkapkan Data Pribadi.', $locale) }}
                </p>
                <h3>{{ aiTrans('7. Retensi dan Penghapusan', $locale) }}</h3>
                <p>
                    {{ aiTrans('Data, termasuk Data Pribadi, tidak akan disimpan lebih lama dari yang diperlukan. Pengunjung dan/atau Pengguna dengan akun aktif bertanggung jawab untuk penghapusan data secara tepat waktu. Setelah penghentian akun atau kemitraan, Data Pribadi terkait yang dikumpulkan melalui Website dan/atau Layanan akan dihapus sesuai dengan hukum yang berlaku dan kebijakan internal kami.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Pencabutan persetujuan untuk memproses Data Pribadi dapat membatasi akses ke beberapa atau semua Layanan yang diminta, tanpa klaim atau keberatan yang akan tersedia.', $locale) }}
                </p>
                <h3>{{ aiTrans('8. Hak Anda', $locale) }}</h3>
                <p>{{ aiTrans('Pengguna berhak atas hak tertentu terkait Data Pribadi mereka:', $locale) }}</p>
                <h4>{{ aiTrans('8.1. Hak Akses', $locale) }}</h4>
                <ul>
                    <li>{{ aiTrans('Mengonfirmasi apakah Data Pribadi diproses', $locale) }}</li>
                    <li>{{ aiTrans('Akses Data Pribadi dan informasi terkait', $locale) }}</li>
                    <li>{{ aiTrans('Informasi tentang tujuan pemrosesan, kategori, penerima, durasi penyimpanan, hak, dan keberadaan profil', $locale) }}
                    </li>
                </ul>
                <h4>{{ aiTrans('8.2. Hak untuk Memperbaiki', $locale) }}</h4>
                <ul>
                    <li>{{ aiTrans('Memperbaiki Data Pribadi yang tidak akurat', $locale) }}</li>
                    <li>{{ aiTrans('Menyelesaikan Data Pribadi yang tidak lengkap', $locale) }}</li>
                </ul>
                <h4>{{ aiTrans('8.3. Hak untuk Menghapus', $locale) }}</h4>
                <ul>
                    <li>{{ aiTrans('Meminta penghapusan Data Pribadi berdasarkan alasan tertentu', $locale) }}</li>
                </ul>
                <h4>{{ aiTrans('8.4. Hak Pembatasan Pemrosesan', $locale) }}</h4>
                <ul>
                    <li>{{ aiTrans('Memperoleh pembatasan pemrosesan dalam keadaan tertentu', $locale) }}</li>
                </ul>
                <h4>{{ aiTrans('8.5. Hak untuk Portabilitas Data', $locale) }}</h4>
                <ul>
                    <li>{{ aiTrans('Menerima Data Pribadi dalam format terstruktur, dapat dibaca mesin', $locale) }}</li>
                    <li>{{ aiTrans('Mentransfer Data Pribadi ke pengendali lain', $locale) }}</li>
                </ul>
                <h4>{{ aiTrans('8.6. Hak untuk Menentang', $locale) }}</h4>
                <ul>
                    <li>{{ aiTrans('Menentang pemrosesan berdasarkan kepentingan yang sah atau pemasaran langsung', $locale) }}
                    </li>
                    <li>{{ aiTrans('Menghentikan pemrosesan kecuali alasan yang meyakinkan dan/atau hukum berlaku', $locale) }}</li>
                </ul>
                <h4>{{ aiTrans('8.7. Hak untuk Menarik Persetujuan', $locale) }}</h4>
                <ul>
                    <li>{{ aiTrans('Menarik persetujuan untuk memproses Data Pribadi kapan saja', $locale) }}</li>
                </ul>
                <h3>{{ aiTrans('9. Materi Periklanan dan Pemasaran', $locale) }}</h3>
                <p>
                    {{ aiTrans('Persetujuan diperoleh untuk menggunakan Data Pribadi dan detail kontak untuk menyediakan materi periklanan dan pemasaran. Penarikan persetujuan dimungkinkan dengan mengirimkan pemberitahuan tertulis ke alamat email yang disediakan.', $locale) }}
                </p>
                <h3>{{ aiTrans('10. Penerimaan Kebijakan ini', $locale) }}</h3>
                <p>
                    {{ aiTrans('Dengan menggunakan Website dan/atau Layanan, Pengunjung, Pengguna, dan/atau Mitra dianggap telah membaca dan setuju dengan Kebijakan ini. Ketidaksetujuan berarti menahan diri dari penggunaan platform. Kami berhak untuk memodifikasi Kebijakan, dan Pengguna didorong untuk memeriksa pembaruan secara berkala. Penggunaan terus menerus setelah perubahan menunjukkan penerimaan.', $locale) }}
                </p>
                <h3>{{ aiTrans('11. Kewajiban Hukum untuk Mengungkap Data Pribadi', $locale) }}</h3>
                <p>
                    {{ aiTrans('Data Pribadi dapat diungkapkan tanpa izin sebelumnya jika ada keyakinan bahwa itu diperlukan untuk menetapkan identitas, kontak, atau memulai tindakan hukum terhadap individu yang diduga melanggar hak atau properti. Pengungkapan akan dilakukan ketika secara hukum diperlukan.', $locale) }}
                </p>
                <h3>{{ aiTrans('12. Pejabat Perlindungan Data', $locale) }}</h3>
                <p>
                    {{ aiTrans('Untuk masalah privasi dan perlindungan data, "Pejabat Perlindungan Data" yang ditunjuk dapat dihubungi di', $locale) }}
                    <span>info{{ '@' . $website_title }}</span>
                </p>
                <script>
                    const emails = document.getElementsByClassName('email');
                    for (const email of emails) {
                        email.innerText = `info@${location.hostname}`;
                    }
                </script>
            </div>
        </div>
    </section>
@endsection
