@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title | Situs ini: Informasi yang Anda Butuhkan" }}</title>
    <meta name="description" content="{{ "Telusuri cara $website_title bisa membantu Anda memperkuat keterampilan trading kripto melalui alat modern dan dukungan yang efektif." }}" />
@endpush

@section('content')
<section class="what-is w-clearfix wf-section">
    <div class="container w-container">
        <h1 class="about-title">
        {{ aiTrans(
                'Temukan Dunia Inovatif [website_title]',
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h1>
        <div class="breadcrumbs">
            <ol>
                <li><a href="{{ route('home', $country) }}">{{ $website_title }}</a></li>
                <li>{{aiTrans('Tentang kami')}}</li>
            </ol>
        </div>
    </div>
    <img loading="lazy" src="{{ asset('frontend/assets/id/dist') }}/images/about-img.webp"  alt="{{ $website_title }} - {{aiTrans('Mengungkap Manfaat Perangkat Lunak Perdagangan')}} {{ $website_title }}" class="what-is-img">
    <div class="container about-what-is-section w-container">
        <h2 class="about-what_is-title">{{aiTrans('Mengungkap Manfaat Perangkat Lunak Perdagangan')}} {{ $website_title }}</h2>
        <div class="about-what_is-text">
            {{ aiTrans(
                'xFNFN adalah platform inovatif yang merevolusi industri mata uang digital. Memanfaatkan teknologi mutakhir, kami menganalisis pola dan fluktuasi Bitcoin dan mata uang kripto lainnya. Platform kami memberikan evaluasi dan studi komprehensif tentang aset digital dalam lingkungan perdagangan langsung, memberdayakan pedagang di seluruh dunia dengan riset pasar dan data yang tepat. Dengan antarmuka yang ramah pengguna, algoritme canggih, dan kemampuan aplikasi seluler, [website_title] menarik pedagang global untuk menjelajahi beragam dunia mata uang digital.',
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="about-what_is-text margin-bottom-40">
            {{ aiTrans(
                'xFNxxx mendobrak hambatan dengan membuat perdagangan Bitcoin dan kripto dapat diakses oleh semua orang. Melalui teknologi canggih kami, pengguna dapat mengevaluasi beberapa aset kripto secara bersamaan, mengidentifikasi mata uang virtual yang paling cocok untuk diperdagangkan. Akses antarmuka online kami yang ramah pengguna dengan lancar di berbagai perangkat, nikmati pengalaman perdagangan mata uang kripto yang nyaman kapan saja, di mana saja. Bergabunglah dengan komunitas [website_title] yang berkembang hari ini dan buka akun VIP gratis Anda untuk berdagang seperti profesional berpengalaman.',
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="about-action_button_wrapper">
            <a href="{{ route('home', $country) }}" class="button w-button">RASAKAN KEKUATAN {{ $website_title }} SEKARANG</a>
        </div>
    </div>
</section>


<section class="our-team w-clearfix wf-section"><img loading="lazy" src="{{ asset('frontend/assets/id/dist') }}/images/our-team-img.webp"  alt="{{ $website_title }} - Temui Tim {{ $website_title }} Kami - Inti dari Merek kami" class="our-team-img">
    <div class="container about-our_team-container w-container">
        <h2 class="our_team-title">
            {{ aiTrans(
                'Temui Tim [website_title] Kami - Inti dari Merek kami',
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="our_team-text">
            {{ aiTrans(
                'Dengan pemahaman mendalam tentang industri mata uang kripto, tim [website_title] kami telah melewati fluktuasi pasar yang tak terhitung jumlahnya. Misi kami adalah memberdayakan trader pemula dan berpengalaman melalui perangkat lunak perdagangan mutakhir, memungkinkan mereka untuk terlibat dengan percaya diri di pasar mata uang digital. Para ahli kami berasal dari berbagai latar belakang dalam teknologi blockchain dan rekayasa informasi, yang dipersenjatai dengan pengetahuan praktis tentang sistem perdagangan online. Dengan [website_title], perdagangan mata uang kripto menjadi proses yang lancar dan mudah, memastikan peluang yang sama bagi semua orang.<br><br> Setelah pengembangan yang cermat, kami dengan senang hati mempersembahkan aplikasi kripto kami yang canggih! Setiap detail telah dirancang dengan cermat untuk menawarkan pengalaman pengguna yang sempurna. Algoritme dan fitur canggih kami memberikan kinerja optimal, mewujudkan masa depan mata uang kripto menjadi kenyataan. Berkomitmen untuk perbaikan terus-menerus, kami terus meningkatkan perangkat lunak revolusioner ini dengan penyempurnaan unik yang eksklusif untuk [website_title]. Jangan menunggu lebih lama lagi! Raih peluang ini dan bergabunglah bersama kami dalam membuka kemungkinan tak terbatas dalam pasar kripto yang terus berkembang!',
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="our_team-action_button_wrapper">
            <a href="{{ route('home', $country) }}" class="button w-button">{{aiTrans('AMBIL LANGKAH PERTAMA - KLAIM AKUN GRATIS ANDA')}}</a>
        </div>
    </div>
</section>
@endsection
