@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title ™ | web Službena 2025" }}</title>
    <meta name="description" content="{{ "Otkrijte kako $website_title podržava vaše strategije ulaganja u kriptovalute. Naša platforma nudi napredne alate i podršku za uspješno trgovanje." }}" />
@endpush
@section('content')
<section id="hero" class="hero-section">
    <div class="uk-container">
        <div class="hero-inner">

            <div class="hero-meta uk-text-center">
                <h1>{{ $website_title }}</h1>
                <h2 class="change-by-command">{{ "$website_title Otkrijte tajnu kriptotržišta s" }}</h2>
            </div>

            <div class="uk-grid-small" uk-grid>
                <div class="uk-width-expand@s">
                    <img class="hero-img" src="{{ asset('frontend/assets/hr/dist') }}/images/block-chain.jpg" alt="">
                </div>
                <div class="uk-width-1-2@s">
                    <div class="hero-form">
                        <div class="main-form-title">
                            <h2>{{aiTrans('Otkriti')}} <span>{{ $website_title }}</span></h2>
                        </div>

                        <div class="form_panel">
                            @include('frontend.hr.components.form')
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>
</section>



<section class="section2">
    <div class="uk-container">
        <div class="uk-grid-large" uk-grid>
            <div class="uk-width-expand@s">
                <h2>{{ aiTrans('[website_title]: gdje se ulaganje susreće s obrazovanjem', $locale, ['website_title' => $website_title]) }}</h2>
                <p>{{ aiTrans('Ključ ulaganja je znanje! Krenite na put financijskog prosvjetljenja s [website_title]. Pokreće nas misija koja nadilazi puko obrazovanje: naš cilj je izravno vas povezati s prestižnim obrazovnim tvrtkama koje su specijalizirane za nijanse ulaganja. Shvaćamo da snalaženje u svijetu ulaganja može biti složeno i tu dolazi Immediate Light: da pojednostavi, obrazuje i osnaži.', $locale, ['website_title' => $website_title]) }}</p>
                <p>{{ aiTrans('[website_title] To je više od same platforme; Naša predanost osnaživanju nadilazi puko obrazovanje, s ciljem da usadimo osjećaj financijske pismenosti koji korisnicima omogućuje snalaženje u složenosti investicijskog krajolika s kompetencijom i samopouzdanjem. Nastojimo pružiti alate i resurse potrebne za uspješno investicijsko putovanje. [website_title] je osebujna platforma koja spaja korisnike i prestižne obrazovne tvrtke u području dinamičnog investiranja.', $locale, ['website_title' => $website_title]) }}</p>
                <p>{{ aiTrans('Kad započnete svoje obrazovanje o ulaganju, odaberite [website_title], vaša referentna platforma za otvaranje vrata financijskoj mudrosti.', $locale, ['website_title' => $website_title]) }}&nbsp;</p>
            </div>
            <div class="uk-width-1-3@s">
                <img class="br20" src="{{ asset('frontend/assets/hr/dist') }}/images/forex-8207730_1280.jpg" alt="">
            </div>
        </div>
    </div>
</section>

<section class="section-dark section2 section-white">
    <div class="uk-container">
        <div class="uk-text-center">
            <h2>{{ aiTrans('Otkrivajući snagu [website_title] - Vaš pristup informiranom ulaganju', $locale, ['website_title' => $website_title]) }}</h2>
            <img src="{{ asset('frontend/assets/hr/dist') }}/images/bitcoin-6985363_1280.png" alt="">
            <p class="f20">{{ aiTrans('Istražite mnoštvo značajki osmišljenih da poboljšaju vaše investicijsko obrazovanje [website_title]. Pomno smo osmislili svaku značajku kako bismo osigurali glatko i obogaćujuće iskustvo učenja. Zahvalni smo na prilici da se pridružimo vašem putu do financijske kompetencije.', $locale, ['website_title' => $website_title]) }}</p>
        </div>

        <div class="uk-grid-medium uk-margin-medium-top" uk-grid>
            <div class="uk-width-1-1@s">
                <div class="gird-box">
                    <svg aria-hidden="true" class="e-font-icon-svg e-fas-book-reader" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M352 96c0-53.02-42.98-96-96-96s-96 42.98-96 96 42.98 96 96 96 96-42.98 96-96zM233.59 241.1c-59.33-36.32-155.43-46.3-203.79-49.05C13.55 191.13 0 203.51 0 219.14v222.8c0 14.33 11.59 26.28 26.49 27.05 43.66 2.29 131.99 10.68 193.04 41.43 9.37 4.72 20.48-1.71 20.48-11.87V252.56c-.01-4.67-2.32-8.95-6.42-11.46zm248.61-49.05c-48.35 2.74-144.46 12.73-203.78 49.05-4.1 2.51-6.41 6.96-6.41 11.63v245.79c0 10.19 11.14 16.63 20.54 11.9 61.04-30.72 149.32-39.11 192.97-41.4 14.9-.78 26.49-12.73 26.49-27.06V219.14c-.01-15.63-13.56-28.01-29.81-27.09z"></path>
                    </svg>
                    <h3>{{ aiTrans('Širok izbor tečajeva', $locale) }}</h3>
                    <p>{{ aiTrans('Naši partneri nude opsežan katalog tečajeva koji odgovaraju različitim razinama vještina i interesima ulaganja. Bilo da ste početnik ili iskusan investitor, [website_title] može vas povezati s odabranim tečajevima koji odgovaraju vašim potrebama učenja. Pridružiti [website_title] da istražite ovo bogato skladište obrazovnih izvora, osiguravajući vam uvid u koncepte ulaganja i izgradnju čvrstih temelja za vaše financijsko putovanje. To je više od kataloga; je vaš putokaz prema ekonomskom osnaživanju kroz sveobuhvatno i dostupno obrazovanje.', $locale, ['website_title' => $website_title]) }}</p>
                </div>
            </div>

            <div class="uk-width-1-3@s uk-grid-item-match">
                <div class="gird-box">
                    <svg aria-hidden="true" class="e-font-icon-svg e-far-chart-bar" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M396.8 352h22.4c6.4 0 12.8-6.4 12.8-12.8V108.8c0-6.4-6.4-12.8-12.8-12.8h-22.4c-6.4 0-12.8 6.4-12.8 12.8v230.4c0 6.4 6.4 12.8 12.8 12.8zm-192 0h22.4c6.4 0 12.8-6.4 12.8-12.8V140.8c0-6.4-6.4-12.8-12.8-12.8h-22.4c-6.4 0-12.8 6.4-12.8 12.8v198.4c0 6.4 6.4 12.8 12.8 12.8zm96 0h22.4c6.4 0 12.8-6.4 12.8-12.8V204.8c0-6.4-6.4-12.8-12.8-12.8h-22.4c-6.4 0-12.8 6.4-12.8 12.8v134.4c0 6.4 6.4 12.8 12.8 12.8zM496 400H48V80c0-8.84-7.16-16-16-16H16C7.16 64 0 71.16 0 80v336c0 17.67 14.33 32 32 32h464c8.84 0 16-7.16 16-16v-16c0-8.84-7.16-16-16-16zm-387.2-48h22.4c6.4 0 12.8-6.4 12.8-12.8v-70.4c0-6.4-6.4-12.8-12.8-12.8h-22.4c-6.4 0-12.8 6.4-12.8 12.8v70.4c0 6.4 6.4 12.8 12.8 12.8z"></path>
                    </svg>
                    <h3>{{ aiTrans('Instant izvješća', $locale) }}</h3>
                    <p>{{ aiTrans('[website_title] osigurava da naši partneri pružaju trenutačno izvješćivanje, omogućujući vam da pratite svoj napredak u stvarnom vremenu i ostanete ispred u svom obrazovanju o ulaganju. Primanje brzih ažuriranja o vašem napretku i ključnim mjernim podacima ključno je kako biste bili uvijek dobro informirani o svom putu učenja.', $locale, ['website_title' => $website_title]) }}</p>
                </div>
            </div>

            <div class="uk-width-1-3@s uk-grid-item-match">
                <div class="gird-box">
                    <svg aria-hidden="true" class="e-font-icon-svg e-fas-hands-helping" viewBox="0 0 640 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M488 192H336v56c0 39.7-32.3 72-72 72s-72-32.3-72-72V126.4l-64.9 39C107.8 176.9 96 197.8 96 220.2v47.3l-80 46.2C.7 322.5-4.6 342.1 4.3 357.4l80 138.6c8.8 15.3 28.4 20.5 43.7 11.7L231.4 448H368c35.3 0 64-28.7 64-64h16c17.7 0 32-14.3 32-32v-64h8c13.3 0 24-10.7 24-24v-48c0-13.3-10.7-24-24-24zm147.7-37.4L555.7 16C546.9.7 527.3-4.5 512 4.3L408.6 64H306.4c-12 0-23.7 3.4-33.9 9.7L239 94.6c-9.4 5.8-15 16.1-15 27.1V248c0 22.1 17.9 40 40 40s40-17.9 40-40v-88h184c30.9 0 56 25.1 56 56v28.5l80-46.2c15.3-8.9 20.5-28.4 11.7-43.7z"></path>
                    </svg>
                    <h3>{{ aiTrans('Višejezična podrška', $locale) }}</h3>
                    <p>{{ aiTrans('Uronite u obrazovno iskustvo uz našu višejezičnu podršku. [website_title] osigurava da jezik nikada nije prepreka, omogućujući vam da učite na jeziku koji vam najviše odgovara. Naši partneri nude svoje sučelje, opise tečajeva i druge informativne sadržaje na više jezika, pomažući korisnicima koji se bolje snalaze u drugim jezicima osim engleskog da se učinkovitije kreću i koriste platformom.', $locale, ['website_title' => $website_title]) }}</p>
                </div>
            </div>

            <div class="uk-width-1-3@s uk-grid-item-match">
                <div class="gird-box">
                    <svg aria-hidden="true" class="e-font-icon-svg e-fas-hand-paper" viewBox="0 0 448 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M408.781 128.007C386.356 127.578 368 146.36 368 168.79V256h-8V79.79c0-22.43-18.356-41.212-40.781-40.783C297.488 39.423 280 57.169 280 79v177h-8V40.79C272 18.36 253.644-.422 231.219.007 209.488.423 192 18.169 192 40v216h-8V80.79c0-22.43-18.356-41.212-40.781-40.783C121.488 40.423 104 58.169 104 80v235.992l-31.648-43.519c-12.993-17.866-38.009-21.817-55.877-8.823-17.865 12.994-21.815 38.01-8.822 55.877l125.601 172.705A48 48 0 0 0 172.073 512h197.59c22.274 0 41.622-15.324 46.724-37.006l26.508-112.66a192.011 192.011 0 0 0 5.104-43.975V168c.001-21.831-17.487-39.577-39.218-39.993z"></path>
                    </svg>
                    <h3>{{ aiTrans('Stručnjaci u području ulaganja', $locale) }}</h3>
                    <p>{{ aiTrans('Iskoristite izravni pristup stručnjacima u tom području putem naših veza. [website_title] olakšava besprijekornu interakciju sa stručnjacima iz industrije koji pružaju vrijedne uvide, odgovaraju na vaša pitanja i vode vas da postanete dobro informirani investitor.', $locale, ['website_title' => $website_title]) }}</p>
                </div>
            </div>

            <div class="uk-width-1-1@s">
                <div class="gird-box">
                    <svg aria-hidden="true" class="e-font-icon-svg e-fas-tools" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                        <path d="M501.1 395.7L384 278.6c-23.1-23.1-57.6-27.6-85.4-13.9L192 158.1V96L64 0 0 64l96 128h62.1l106.6 106.6c-13.6 27.8-9.2 62.3 13.9 85.4l117.1 117.1c14.6 14.6 38.2 14.6 52.7 0l52.7-52.7c14.5-14.6 14.5-38.2 0-52.7zM331.7 225c28.3 0 54.9 11 74.9 31l19.4 19.4c15.8-6.9 30.8-16.5 43.8-29.5 37.1-37.1 49.7-89.3 37.9-136.7-2.2-9-13.5-12.1-20.1-5.5l-74.4 74.4-67.9-11.3L334 98.9l74.4-74.4c6.6-6.6 3.4-17.9-5.7-20.2-47.4-11.7-99.6.9-136.6 37.9-28.5 28.5-41.9 66.1-41.2 103.6l82.1 82.1c8.1-1.9 16.5-2.9 24.7-2.9zm-103.9 82l-56.7-56.7L18.7 402.8c-25 25-25 65.5 0 90.5s65.5 25 90.5 0l123.6-123.6c-7.6-19.9-9.9-41.6-5-62.7zM64 472c-13.2 0-24-10.8-24-24 0-13.3 10.7-24 24-24s24 10.7 24 24c0 13.2-10.7 24-24 24z"></path>
                    </svg>
                    <h3>{{ aiTrans('Napredni alati', $locale) }}</h3>
                    <p>{{ aiTrans('Uronite u obogaćeno iskustvo učenja uz integraciju naprednih alata. Obrazovne tvrtke koriste rafiniranu analitiku podataka kako bi pružile uvid u ponašanje korisnika, pomažući u prilagođavanju strategija ulaganja i poboljšanju ponude tečajeva. Kao rezultat toga, naši akademski partneri pružaju izvrsna korisnička sučelja kako bi osigurali privlačnije i korisniku prilagođenije iskustvo platforme. Ovi će alati nadopuniti vaše obrazovno putovanje, pružajući vam praktično znanje i poboljšavajući vaše razumijevanje koncepata ulaganja.', $locale) }}</p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="section2">
    <div class="uk-container">
        <div class="uk-grid-small" uk-grid>
            <div class="uk-width-1-3@s">
                <img class="br20" src="{{ asset('frontend/assets/hr/dist') }}/images/minimalistic-still-life-assortment-with-cryptocurrency-768x1151.jpg" alt="">
            </div>
            <div class="uk-width-expand@s">
                <div class="uk-padding-small">
                    <h2>{{ aiTrans('[website_title]: zašto je važno znati o investicijama', $locale, ['website_title' => $website_title]) }}</h2>
                    <p>{{ aiTrans('Dobro razumijevanje koncepata ulaganja ključno je za financijsku sigurnost. Ovo znanje osposobljava ljude za donošenje razumnih i proračunatih odluka o ulaganju. Dugoročno, ove opcije mogu povećati bogatstvo kako ulaganja rastu, stvarajući čvrste temelje za financijski prosperitet. Vođena znanjem, strateška ulaganja također mogu stvoriti pouzdane pasivne izvore prihoda. Bilo da kupujete dom, financirate obrazovanje ili se upuštate u zanimljive projekte, znanje o ulaganju je katalizator za ostvarenje vaših financijskih težnji. Pretvorite svoje ciljeve iz dalekih snova u dostižne prekretnice.', $locale) }}</p>
                    <p>{{ aiTrans('Znanje o ulaganjima ključno je za izgradnju solidnog mirovinskog plana. Pojedinci mogu osigurati sigurnu i udobnu mirovinu donošenjem informiranih odluka o mirovinskim računima, nositeljima ulaganja i strategijama umirovljenja. Znanje o ulaganju nije samo alat; To je vaš kompas za navigaciju kroz složenost financijskog svijeta. Ukratko, investicijsko znanje ključna je imovina za budućnost obilježenu stabilnošću i otpornošću.', $locale) }}</p>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="section-dark section2 section-white">
    <div class="uk-container">
        <div class="uk-text-center">
            <h2>{{ aiTrans('Ključne investicijske teme za ispitivanje', $locale) }}</h2>
        </div>
        <div class="uk-grid-medium uk-margin-medium-top" uk-grid>
            <div class="uk-width-1-1@s">
                <div class="gird-box">
                    <h3 class="uk-margin-remove-top">{{ aiTrans('Kriptovaluta i Blockchain', $locale) }}</h3>
                    <p>{{ aiTrans('Uronite u dinamično carstvo digitalne imovine i istražite potencijal kriptovaluta koje su stekle globalnu popularnost među ulagačima. Istražite transformativni utjecaj blockchain tehnologije na financijske sustave i razumite nijanse koje definiraju ovaj krajolik u razvoju.', $locale) }}</p>
                </div>
            </div>
            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3 class="uk-margin-remove-top">{{ aiTrans('Inflacija i investicije', $locale) }}</h3>
                    <p>{{ aiTrans('[website_title] pomoći će vam da steknete uvid u strategije koje se koriste za učinkovito upravljanje i ublažavanje utjecaja inflacije. Pridružite se tvrtki Imediate Light u borbi protiv inflacije opremajući se znanjem kako biste ojačali svoj investicijski portfelj u borbi protiv izazova koje postavljaju fluktuirajući ekonomski uvjeti.', $locale, ['website_title' => $website_title]) }}</p>
                </div>
            </div>
            <div class="uk-width-1-2@s uk-grid-item-match">
                <div class="gird-box">
                    <h3 class="uk-margin-remove-top">{{ aiTrans('Sirovine', $locale) }}</h3>
                    <p>{{ aiTrans('Naučite kako strateški integrirati robu u svoj investicijski portfelj za veću diverzifikaciju. Roba može uključivati ​​plemenite metale, poljoprivredne proizvode i energetske resurse. Uključite se u opsežne alate za učenje koji otkrivaju složenost trgovanja robom, poboljšavajući vaše razumijevanje ovog kritičnog segmenta u financijskom krajoliku.', $locale) }}</p>
                </div>
            </div>
            <div class="uk-width-1-1@s">
                <div class="gird-box">
                    <h3 class="uk-margin-remove-top">{{ aiTrans('Tehnička analiza', $locale) }}</h3>
                    <p>{{ aiTrans('Ovladajte umijećem točne analize tržišnih trendova i obrazaca. Tehnička analiza ključna je vještina za uspješne trgovce jer vam omogućuje tumačenje grafikona, prepoznavanje uzoraka i razumijevanje tržišnih pokazatelja.', $locale) }}</p>
                    <p>{{ aiTrans('Iako tehnička analiza ima svoje kritičare, njezina široka uporaba i popularnost ukazuju na njezinu učinkovitost za mnoge sudionike na tržištu. Trgovci obično koriste kombinaciju tehničke i fundamentalne analize za donošenje utemeljenih odluka o ulaganju. Kroz duboko znanje i praktične primjene, [website_title] vodi vas u donošenju informiranih odluka temeljenih na podacima u dinamičnom svijetu trgovanja.', $locale, ['website_title' => $website_title]) }}</p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="section2">
    <div class="uk-container">
        <div class="uk-grid-small" uk-grid>
            <div class="uk-width-expand@s">
                <div class="uk-padding-small">
                    <h2>{{ aiTrans('Kontinuirano učenje sa [website_title]', $locale, ['website_title' => $website_title]) }}</h2>
                    <p class="gt-block p1">{{ aiTrans('Krenuti na obrazovno putovanje u svijet ulaganja može biti jednostavno. [website_title] je tu da stvari učini jednostavnijima, posebno za početnike. Istražimo kako ova platforma osigurava da vaše iskustvo učenja bude besprijekorno i korisno.', $locale, ['website_title' => $website_title]) }}<span style="font-style: inherit; font-weight: inherit;">{{ aiTrans('Implementacija složenosti investicijskog obrazovanja lakša je uz značajku izravne stručne pomoći [website_title]. Za početnike koji traže jasnoću, ova značajka nudi izravnu vezu s iskusnim profesionalcima. Možete postavljati pitanja, tražiti savjete i primati smjernice od stručnjaka, stvarajući personalizirano iskustvo učenja prilagođeno vašim potrebama.', $locale, ['website_title' => $website_title]) }}&nbsp;</span></p>
                    <p class="gt-block p1"><span style="font-style: inherit; font-weight: inherit;">{{ aiTrans('Dizajn [website_title] Strukturiran je posebno za početnike. Intuitivno sučelje platforme omogućuje jednostavnu navigaciju do tečajeva i resursa naših partnera. Bilo da istražujete kriptovalute ili se bavite tehničkom analizom, dizajn prilagođen korisniku osigurava da se možete usredotočiti na učenje bez nepotrebnih složenosti.', $locale, ['website_title' => $website_title]) }}</span><span style="font-style: inherit; font-weight: inherit;">{{ aiTrans('[website_title] To nadilazi tečajeve; Surađujemo s obrazovnim tvrtkama koje nude kompletan set alata za vaše obrazovno putovanje. Pronaći ćete resurse koji odgovaraju različitim stilovima učenja, od detaljnih članaka do interaktivnih alata. Ovaj holistički pristup osigurava vam temeljito razumijevanje koncepata ulaganja i njihovu primjenu s povjerenjem.', $locale, ['website_title' => $website_title]) }}</span></p>
                    <p class="p1">{{ aiTrans('U svojoj srži, kontinuirano učenje je stvaranje obrazovnog okruženja koje je kohezivno, jednostavno za korištenje i prilagodljivo individualnim potrebama, omogućavajući kontinuirani i neprekinuti protok znanja.', $locale) }}</p>
                </div>
            </div>
            <div class="uk-width-1-3@s">
                <img class="br20" src="{{ asset('frontend/assets/hr/dist') }}/images/close-up-shot-brokerage-company-employee-indicating-display-real-time-profit-growth-market-trend-hedge-fund-agency-trader-pointing-out-positive-market-trend-professional-display-1536x1024.jpg" alt="">
            </div>
        </div>
    </div>
</section>


<section class="section-dark">
    <div class="uk-container uk-container-small">
        <h2 class="uk-text-center f70">{{ aiTrans('Često postavljana pitanja o [website_title]', $locale, ['website_title' => $website_title]) }}</h2>
        <div class="uk-container uk-container-xsmall">
            <ul uk-accordion="collapsible: false: ; active: false">
                <li>
                    <a class="uk-accordion-title" href>
                        <svg class="e-font-icon-svg e-fas-caret-right" viewBox="0 0 192 512" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0 384.662V127.338c0-17.818 21.543-26.741 34.142-14.142l128.662 128.662c7.81 7.81 7.81 20.474 0 28.284L34.142 398.804C21.543 411.404 0 402.48 0 384.662z"></path>
                        </svg>{{ aiTrans('Kako mogu otkazati svoju pretplatu ili račun?', $locale) }}
                    </a>
                    <div class="uk-accordion-content">
                        <p>{{ aiTrans('[website_title] Besplatno je, tako da nijedna pretplata nije izravno povezana s našom platformom. Međutim, nakon što vas povežemo s obrazovnom tvrtkom, moći ćete se pretplatiti ili prijaviti na njihove usluge, što može imati povezane troškove. Morate slijediti njihove posebne postupke otkazivanja da biste otkazali bilo koju pretplatu ili račun kod ovih obrazovnih tvrtki. Svaka tvrtka ima vlastiti skup postupaka za upravljanje i otkazivanje pretplata.', $locale, ['website_title' => $website_title]) }}</p>
                    </div>
                </li>
                <li>
                    <a class="uk-accordion-title" href>
                        <svg class="e-font-icon-svg e-fas-caret-right" viewBox="0 0 192 512" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0 384.662V127.338c0-17.818 21.543-26.741 34.142-14.142l128.662 128.662c7.81 7.81 7.81 20.474 0 28.284L34.142 398.804C21.543 411.404 0 402.48 0 384.662z"></path>
                        </svg>{{ aiTrans('[website_title] Nudite li personalizirane putove učenja?', $locale, ['website_title' => $website_title]) }}
                    </a>
                    <div class="uk-accordion-content">
                        <p>{{ aiTrans('[website_title] sama ne nudi tečajeve izravno. Međutim, obrazovne tvrtke s kojima vas povezujemo specijalizirane su za pružanje personaliziranih iskustava učenja. Nakon što vas povežemo s jednom od ovih tvrtki putem naše platforme, moći ćete iskoristiti njihove personalizirane putove učenja koji zadovoljavaju vaše individualne potrebe učenja i ciljeve ulaganja. Ovi obrazovni partneri procjenjuju vašu razinu vještina, interese i ciljeve kako bi stvorili putovanje učenja koje je izričito prilagođeno vama.', $locale, ['website_title' => $website_title]) }}</p>
                    </div>
                </li>
                <li>
                    <a class="uk-accordion-title" href>
                        <svg class="e-font-icon-svg e-fas-caret-right" viewBox="0 0 192 512" xmlns="http://www.w3.org/2000/svg">
                            <path d="M0 384.662V127.338c0-17.818 21.543-26.741 34.142-14.142l128.662 128.662c7.81 7.81 7.81 20.474 0 28.284L34.142 398.804C21.543 411.404 0 402.48 0 384.662z"></path>
                        </svg>{{ aiTrans('Kako se registrirati na platformi [website_title]?', $locale, ['website_title' => $website_title]) }}
                    </a>
                    <div class="uk-accordion-content">
                        <p class="p1">{{ aiTrans('Registrirajte se na platformi [website_title] To je jednostavan postupak u tri koraka:', $locale, ['website_title' => $website_title]) }}</p>
                        <ol class="ol1">
                            <li class="li2"><b>{{ aiTrans('Ispunite obrazac za registraciju', $locale) }}</b> - {{ aiTrans('Započnite ispunjavanjem obrasca na vrhu naše početne stranice. Navedite svoje ime, adresu e-pošte i broj telefona.', $locale) }}</li>
                            <li class="li2"><b>{{ aiTrans('Povezivanje s obrazovnom tvrtkom', $locale) }}</b> - {{ aiTrans('Nakon što pošaljete obrazac, spojit ćemo vas s obrazovnom tvrtkom u vašem području. Ova vam veza jamči pristup najboljim mogućim resursima za potrebe vaše investicijske edukacije.', $locale) }}</li>
                            <li class="li1"><b>{{ aiTrans('Savjetovanje stručnjaka', $locale) }}</b> - {{ aiTrans('Nakon što vas registriramo u obrazovnu tvrtku koju ste odabrali, moći ćete izravno razgovarati s investicijskim stručnjakom. Ovaj stručnjak može odgovoriti na sva pitanja i uputiti vas kako nastaviti svoje putovanje učenja o ulaganju.', $locale) }}</li>
                        </ol>
                        <p class="p1">{{ aiTrans('Slijedeći ove korake, dobit ćete pristup investicijskom znanju i iskustvu prilagođenom vašim potrebama i ciljevima.', $locale) }}</p>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</section>
@endsection
