@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title | Makipag-ugnayan sa amin kaagad" }}</title>
    <meta name="description" content="{{ "Ang iyong tiwala sa mga sagot at tulong sa pag-trade ng cryptocurrency ay naka-salig sa $website_title ." }}" />
@endpush
@section('content')
<main class="content">
    <div class="intro-section"></div>
    <div class="contact-section">
        <div class="container w-container">
            <h1 class="intro-title abt">{{aiTrans('Makipag-ugnayan sa amin')}}<br>
            </h1>
        </div>
        <div class="container w-container">
            <div class="breadcrumbs white">
                <ol>
                    <li><a href="#">{{$website_title}}</a></li>
                    <li>{{aiTrans('Makipag-ugnayan sa amin')}}</li>
                </ol>
            </div>
            <div class="forms-wrap contact">
                <div class="contact-form-wrap">
                    <h2 class="contact-title">{{aiTrans('Makipag-ugnayan sa amin')}}<br>
                    </h2>
                    <div class="w-form-wrapper">
                        <form data-name="" action="contact.html" method="post" id="email-form" name="email-form" class="contact-form" data-wf-page-id="6491bb2724e98a32141230e3" data-wf-element-id="9ce0d269-d730-1200-37da-01b24308b245" novalidate="novalidate">
                            <div class="contact-cell">
                                <div class="form-group ctc">
                                    <input type="text" class="form-control control-bordered w-input" maxlength="256" name="FunnelContactForm[name]" data-name="FunnelContactForm[name]" placeholder="Ilagay ang pangalan">
                                    <div class="warning-icon"></div>
                                </div>
                                <div class="form-group ctc">
                                    <input type="email" class="form-control control-bordered w-input" maxlength="256" name="FunnelContactForm[email]" data-name="FunnelContactForm[email]" placeholder="Ilagay ang email address">
                                    <div class="warning-icon"></div>
                                </div>
                            </div>
                            <div class="contact-cell">
                                <div class="form-group ctc-mes-group">
                                    <textarea placeholder="Maglagay ng mensahe..." maxlength="5000" data-name="FunnelContactForm[message]" name="FunnelContactForm[message]" id="field" class="form-control control-bordered textarea w-input"></textarea>
                                    <div class="warning-icon"></div>
                                </div>
                            </div>
                            <div class="contact-btn-wra"><button type="submit" data-wait="Please wait ..." class="btn contact-btn w-button">Magpadala ng Mensahe</button></div>
                        </form>
                        <div class="w-form-done">
                            <div>{{aiTrans('Thank you! Your submission has been received!')}}</div>
                        </div>
                        <div class="w-form-fail">
                            <div>{{aiTrans('Oops! Something went wrong while submitting the form.')}}</div>
                        </div>
                    </div>
                </div>
                <div class="contact-img-wrap w-clearfix"><img loading="lazy" src="dist/images/scam.webp" sizes="(max-width: 479px) 100vw, (max-width: 767px) 67vw, (max-width: 991px) 58vw, 33vw" srcset="dist/images/scam-p-500.webp 500w, dist/images/scam.webp 731w" alt="{{$website_title}} - Makipag-ugnayan sa amin" class="contact-img"></div>
            </div>
        </div>
    </div>
</main>
    @push('css')
        <style>
            /* Custom CSS for the success message */
            .success-message {
                background-color: #d4edda;
                color: #155724;
                padding: 15px;
                border: 1px solid #c3e6cb;
                border-radius: 5px;
                margin-bottom: 20px;
            }

            /* Hide the message by default */
            .d-none {
                display: none;
            }

            /* Custom button styling */
            .btn-submit {
                background-color: #28a745; /* Custom green color */
                color: white;
                padding: 10px 20px;
                border: none;
                border-radius: 5px;
                cursor: pointer;
                font-size: 18px;
            }

            .btn-submit:hover {
                background-color: #218838; /* Darker green on hover */
            }

            /* Basic form styling */
            .form-group input, .form-group textarea {
                width: 100%;
                padding: 10px;
                border: 1px solid #ccc;
                border-radius: 5px;
            }

        </style>
    @endpush
    @push('js')
        <script>
            document.getElementById('contactForm').addEventListener('submit', function(event) {
                event.preventDefault(); // Prevent traditional form submission

                // Simulate form submission
                setTimeout(function() {
                    // Show the success message
                    document.getElementById('successMessage').classList.remove('d-none');

                    // Optionally, clear the form fields
                    document.getElementById('contactForm').reset();
                }, 500); // Simulate server response delay
            });
        </script>
    @endpush
@endsection
