@extends('layouts.app')
@push('meta')
    <title>{{ "Your Comprehensive $website_title Inside $website_name Journey" }}</title>

    <meta name="description" content="{{ "In-depth Understanding of Your Rights, Duties, and $website_title's Safe Services: Terms of Service explanation" }}" />
        <meta name="robots" content="noindex, nofollow">

@endpush

@section('content')
    <div class="container page-inner pt-5">
        <h1>{{ aiTrans('Terms Of Use') }}</h1>
        <main>
            <p><span style="font-weight: 400;">{{ aiTrans('Provider (the “Company“, “us“, “our” or “we“) provides vicariously through its designated software and website (the “Website“) certain marketing, advertising, promotion and related services (the “Service“; the Service users shall be referred to as the “Users“, “you“or “your“). These Terms of Use (the “Terms“) govern the Users access and use of the Website and Services. Users must agree to these Terms prior to using the Website.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('Please read these Terms carefully. These Terms govern your access to and use of the Website and Services. By accessing, registering to use, downloading, sharing or otherwise using the Website or using any software scripts provided by us in order to make the Website available or usable, you signify your assent to both these Terms and our Privacy Policy, and which may be modified or otherwise changed from time to time at our sole discretion. Your continued use of the Website will be deemed acceptance to any such amended or updated terms.') }} </span><span style="font-weight: 400;">{{ aiTrans('If you do not agree to any of these Terms, please do not click “ACCEPT” and do not use the Website.') }}</span></p>
            <p><strong>{{ aiTrans('Website') }}</strong> {{ aiTrans('refers to [website_title], accessible from' ,$locale,['website_title' => $website_title]) }} <a href="{{ route('home', $country) }}">{{$website_title}}</a></p>
            <div id="toc_container" class="no_bullets">
                <ul class="toc_list">
                    <ul>
                        <li><a href="#1_Use_of_Website_and_Services"><span class="toc_number toc_depth_2">0.1</span> {{ aiTrans('1. Use of Website and Services') }}</a></li>
                    </ul>
                    <li><a href="#2_Restrictions"><span class="toc_number toc_depth_1">1</span> {{ aiTrans('2. Restrictions') }}</a></li>
                    <li><a href="#3_Promotional_Materials_and_Newsletters"><span class="toc_number toc_depth_1">2</span> {{ aiTrans('3. Promotional Materials and Newsletters') }}</a></li>
                    <li><a href="#4_Intellectual_Property"><span class="toc_number toc_depth_1">3</span> {{ aiTrans('4. Intellectual Property') }}</a></li>
                    <li><a href="#5_Privacy"><span class="toc_number toc_depth_1">4</span> {{ aiTrans('5. Privacy') }}</a></li>
                    <li><a href="#6_Links"><span class="toc_number toc_depth_1">5</span> {{ aiTrans('6. Links') }}</a></li>
                    <li><a href="#7_Prohibited_Uses"><span class="toc_number toc_depth_1">6</span> {{ aiTrans('7. Prohibited Uses') }}</a></li>
                    <li><a href="#8_Support"><span class="toc_number toc_depth_1">7</span> {{ aiTrans('8. Support') }}</a></li>
                    <li><a href="#9_Disclaimers"><span class="toc_number toc_depth_1">8</span> {{ aiTrans('9. Disclaimers') }}</a></li>
                    <li><a href="#10_Limitation_of_Liability"><span class="toc_number toc_depth_1">9</span> {{ aiTrans('10. Limitation of Liability') }}</a></li>
                    <li><a href="#11_Indemnification"><span class="toc_number toc_depth_1">10</span> {{ aiTrans('11. Indemnification') }}</a></li>
                    <li><a href="#12_Miscellaneous"><span class="toc_number toc_depth_1">11</span> {{ aiTrans('12. Miscellaneous') }}</a></li>
                </ul>
            </div>
            <h5><span id="1_Use_of_Website_and_Services"><b>{{ aiTrans('1. Use of Website and Services') }}</b></span></h5>
            <p><span style="font-weight: 400;">{{ aiTrans('Subject to the terms and conditions set forth herein, you may access and use the Website for the purpose of using the Services on a non-exclusive basis. You acknowledge that the Company may, in its sole discretion and at any time, modify, update or otherwise change the Website or Services, including discontinuing providing any part or all of the Website and/or Services or modify or delete any content available through the Website or Services, without prior notice.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('Use of the Website and Services is void where prohibited. By using the Website and Services you represent and warrant that: (a) any information you submit (if applicable) is truthful and accurate; (b) you will maintain the accuracy of such information; (c) you are at least the age of majority in your jurisdiction; and (d) your use of the Website or Services does not violate or promote the violation of any applicable law or regulation or any legal or contractual obligation you may have to a third party and you have and will at all times comply with all applicable laws, rules and regulations in connection with your use of the Services and Website, any services arranged through the Services and Website, including without limitation such services connected in any way to the Products or Third Parties, as such terms are defined herein.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('Subsections (a)-(d) shall be referred to, jointly, as the') }} </span><b>{{ aiTrans('“Users Undertakings and Warranties“') }}</b><span style="font-weight: 400;">.</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('By using the Services or Website you understand and agree that the Company may in its sole discretion, but is not required to, verify that any or all of the Users Undertakings and Warranties are met by any User and you further agree that the Company is not responsible for assuring that the Users Undertakings and Warranties are met or for any failure to suspend, terminate or prevent the use of the Services or Website by Users who do not meet the Users Undertakings and Warranties. You understand that you are solely responsible for making your own evaluations, decisions and assessments about whether to engage with any Third Parties or otherwise interact with any Third Parties in any way. If you become aware of any violation to the Users Undertakings and Warranties you are encouraged to report it to the Company.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('The Company reserves the right not to provide you with any Services with or without notice in its sole discretion, whether it becomes aware of any violation to the Users Undertakings and Warranties (either by reports provided to it by other Users or any other means) by you or any other User, or for any other reason. Without derogating from the above, the Company expressly disclaims, and you expressly release the Company from, any and all liability whatsoever for any controversies, claims, suits, injuries, loss, harm and/or damages arising from and/or in any way related to: (i) any inaccuracy, untimeliness or incompleteness of a User’s or Third Party’s representations; and (ii) misstatements and/or misrepresentations made, either in connection with or by any of the Third Parties or other Users, Products or otherwise. By using the Website and Services you understand and agree that the Services merely offer a platform designated to assist Users to reach, purchase and/or use various products and services provided by third party vendors and/or services providers, through the ads or promotions run by us (respectively, the “Products” and the “Third Parties“, respectively).') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('You understand and agree that the Company: (a) does not employ, recommend or endorse any Third Parties or Products, as relevant, or any related party thereof, and has no control over the acts or omissions of any Third Party, their business, their products or services; (b) makes no representations or warranties about the Third Parties and Products, including their quality, pricing, compatibility, availability or any other features, or about your interactions or dealings with any Third Parties; (c) makes no representations or warranties about the proprietary rights or other rights or features or regulatory aspects related to the Products, including any required authorization, permits or licenses for the upload, sharing or otherwise making available, and for the use, sale and purchase of such Products; and (d) is not responsible for the performance or conduct of any User or other third parties in any way using or having used the Services, and/or on or off the Website. The Company is not obligated to screen or otherwise to verify any information regarding Third Parties and/or Users, the Products or any other feature related to the Website or Services and therefore, you should exercise caution and perform your own examinations and checks before engaging with anyone through the Services or Website or otherwise interacting with anyone.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('The Company expressly disclaims, and you expressly release the Company from, any and all liability whatsoever for any controversies, claims, suits, injuries, loss, harm and/or damages arising from and/or in any way related to the Third Parties, Products, Services and Website or your interactions or dealings with any Third Parties, including without limitation any acts and/or omissions of Third Parties in any way using or connected to the Services or Website in any means. By using the Services or Website, you acknowledge that you are solely responsible for such use and the connections, interactions, purchases or any other action you make and that all use of the Services or Website is at your sole risk. For the avoidance of any doubt, the Company is not selling, licensing or otherwise making available to you any Products or services (other than the Services) and shall not have any liability for any Products or services purchased by you from any Third Party, including without limitations, with respect to any support and maintenance, defaults, errors, failures, damages or costs of any kind.') }}</span></p>
            <h4><span id="2_Restrictions"><span style="font-weight: 400;">{{ aiTrans('2. Restrictions') }}</span></span></h4>
            <p><span style="font-weight: 400;">{{ aiTrans('Without derogating from the provisions of Section 1 thereof, you shall not, and shall not permit any third party, to: (a) reverse engineer or attempt to find the underlying code of the Website or Services; (b) use the Website or Services in violation of any applicable law or regulation, including but not limited to, post, publish, share or otherwise transfer any illegal or offensive material; (c) copy, modify, or create derivative works of the Website, Services or content of any of the Website or Services; (d) attempt to disable or circumvent any security or access control mechanism of the Website or Services; (e) design or assist in designing cheats, exploits, automation software, bots, hacks, modes or any other unauthorized third-party software to modify or interfere with the Website or Services; (f) use the Website or Services or engage with other Users for any purpose that is in violation of any applicable law or regulation; (g) attempt to gain unauthorized access to the Website or Services, other User Accounts, as defined below, or other device, computer system, phone systems, or networks connected to the Website or Services; and (h) harvest or otherwise collect information about Users without their consent.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('If you post, publish, share or otherwise transfer through the Website and/or using the Services any content, you represent and warrant that such content provides an accurate and complete picture of any products or services described therein, complies with these Terms herein, and does not: (a) infringe the intellectual property, moral or publicity rights of any third party; (b) contain any defamatory, libelous, obscene, sexually suggestive or otherwise offensive content (including material promoting or glorifying hate, violence, or bigotry); (c) contain any worms, viruses or otherwise malicious software; (d) violate any applicable law or regulation, including any law or regulation concerning advertising or marketing; and (e) take any action that imposes an unreasonable or disproportionately large load on our infrastructure.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('By posting, uploading, publishing, sharing or otherwise transferring any content using the Website or Services, you hereby irrevocably grant the Company and any of its affiliates and/or sublicenses a worldwide, non-exclusive, perpetual, royalty-free license to publish, share, display and otherwise transfer such content in any reasonable form as shall be in the Company’s sole discretion. The Company reserves the right to remove, suspend access to or permanently delete any content in accordance with its sole discretion without prior notice, including without limitation any content that violates the warranties set forth above or the Company’s business interests, and you shall have no right or claim in respect of any such decisions and actions.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('The Company is not, and shall not be, liable for any content provided, posted, uploaded, shared or otherwise made available by Users, any products or services related to such content provided, posted, uploaded, shared or otherwise made available by Users. Each User using the Website or Services hereby represents to take full responsibility in respect thereof, and the Company shall bear no liability with respect to the foregoing.') }}</span></p>
            <h4><span id="3_Promotional_Materials_and_Newsletters"><span style="font-weight: 400;">{{ aiTrans('3. Promotional Materials and Newsletters') }}</span></span></h4>
            <p><span style="font-weight: 400;">{{ aiTrans('In addition to the provisions of Section 3 above, the User gives his express consents to the Company to provide the User with promotional materials and newsletters (the “Promotional Materials and Newsletters“) by any means available, including via email, text and SMS messages, fax, post, automated dialing services or any other means, all in accordance with the Company’s sole discretion as shall be from time to time, and to receive such Promotional Materials and Newsletters.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('The User further acknowledges that the Promotional Materials and Newsletters may include the advertisement of third parties, and he expressly consents to the receipt of such advertisements as part of the Promotional Materials and Newsletters. The User may contact the Company at any time by sending a request via email notifying the Company of his refusal to further receive the Promotional Materials and Newsletters.') }}</span></p>
            <h4><span id="4_Intellectual_Property"><span style="font-weight: 400;">{{ aiTrans('4. Intellectual Property') }}</span></span></h4>
            <p><span style="font-weight: 400;">{{ aiTrans('The Company is the owner of all worldwide rights, titles and interests in: (a) the Website and Services, enhancements, derivatives, bug fixes or improvements to the Website and Services; and (b) trade names, trademarks, and logos of the Company, and shall at all times remain solely with the Company. All references in these Terms or any other communications to the sale, resale or purchase of the foregoing shall mean only the right to use the Website and Services pursuant to these Terms. Users bear sole liability for any and all content, including any intellectual property rights thereof, provided, shared or otherwise made available by the Users using the Website and/or the Services, and the Company makes no representation with respect to any such content. The Company will not be liable for any losses or damages incurred by such content, and Users agree to indemnify and hold the Company harmless for any damage or loss arising from the above.') }}</span></p>
            <h4><span id="5_Privacy"><span style="font-weight: 400;">{{ aiTrans('5. Privacy') }}</span></span></h4>
            <p><span style="font-weight: 400;">{{ aiTrans('You undertake not to save, collect or otherwise maintain in your possession and use any content provided by the Services and Website without the prior written consent of the Company. You further acknowledge that the Company reserves the right, in its sole discretion, to save, collect or otherwise maintain in its possession and use any content and public information, including information that may personally identify you or any other User or Third Party or describe your personal interests. The Company reserves the right to make any and all permitted use under any applicable law of such content and public information as set forth in the Company Privacy Policy. Without derogating from the provisions of Section 1 above, the Company does not review, test, confirm, approve or otherwise verify any such content or public information. Each User posting, uploading, sharing or otherwise making available such content or public information shall bear the sole responsibility for the content or public information, including any and all third-party information and required consents. The Company will not be liable for any loss or damage incurred by not complying with the above, and you agree to indemnify and hold the Company harmless for any damage or loss arising from the above. NOTWITHSTANDING THE FOREGOING, YOU UNDERSTAND AND ACKNOWLEDGE THAT THE COMAPNY IS NOT A CONTENT STORAGE SERVICE. THE COMPANY SHALL HAVE NO LIABILITY FOR ANY LOST OR ERASED CONTENT OR PUBLIC INFORMATION. YOU SHOULD BE AWARE THAT ANY Content postED, uploadED, sharED or otherwise made available MAY BE READ, COLLECTED, AND USED BY OTHER USERS, AND COULD BE USED TO SEND UNSOLICITED CONTENT.') }}</span></p>
            <h4><span id="6_Links"><span style="font-weight: 400;">{{ aiTrans('6. Links') }}</span></span></h4>
            <p><span style="font-weight: 400;">{{ aiTrans('The Website or Services may contain links or other content related to websites, advertisers, publishers or Products offered by third parties. The Company has no control and makes no representation with respect to the same or any information provided or transmitted via the same, or otherwise provided by any such third party. YOU UNDERSTAND AND AGREE THAT USE OF SUCH LINKS OR OTHER CONTENT IS AT YOUR OWN RISK, THAT SUCH LINKS OR OTHER CONTENT ARE GOVERNED BY SUCH THIRD PARTIES’ TERMS OF USE AND PRIVACY POLICIES, AND THAT THE COMPANY IS NOT RESPONSIBLE FOR THE PRIVACY OR BUSINESS PRACTICES OR OTHER POLICIES OF SUCH THIRD PARTIES. YOU should carefully review the applicable terms and policies that apply to any SUCH Third Party. THE COMPANY IS NOT RESPONSIBLE OR LIABLE IN ANY MANNER FOR SUCH THIRD PARTY, OR FOR ANY LOSS OR DAMAGE OF ANY SORT INCURRED AS THE RESULT THEREOF, AND THE COMPANY EXPRESSLY DISCLAIMS, AND YOU EXPRESSLY RELEASES THE COMPANY FROM, ANY AND ALL LIABILITY WHATSOEVER FOR ANY CONTROVERSIES, CLAIMS, SUITS, INJURIES, LOSS, HARM AND/OR DAMAGES, ARISING FROM AND/OR IN ANY WAY RELATED TO SUCH THIRD PARTYIES, INCLUDING WITHOUT LIMITATION RELATING TO AVAILABILITY, TERMS OF USE, PRIVACY, INFORMATION, CONTENT, MATERIALS, ADVERTISING, CHARGES, PRODUCTS AND/OR SERVICES.') }}</span></p>
            <h4><span id="7_Prohibited_Uses"><span style="font-weight: 400;">{{ aiTrans('7. Prohibited Uses') }}</span></span></h4>
            <p><span style="font-weight: 400;">{{ aiTrans('The Website and Services may not be used in connection with any commercial endeavors (unless otherwise permitted by the Company in connecting Users to any Third Parties) without the express written consent of the Company. The Website and Services may not be used by any person or organization to recruit for another website, solicit, advertise, or contact in any form Users for employment, contracting, or any other purpose for a business not affiliated with the Company without express written permission from the Company. You agree not to use the Services and Website in order to contact, advertise, solicit, or sell to any other User without their express consent, unless otherwise permitted under these Terms.') }}</span></p>
            <h4><span id="8_Support"><span style="font-weight: 400;">{{ aiTrans('8. Support') }}</span></span></h4>
            <p><span style="font-weight: 400;">{{ aiTrans('Users may contact the Company with regard to support for the Website and Services by sending an email') }}</span></p>
            <h4><span id="9_Disclaimers"><span style="font-weight: 400;">{{ aiTrans('9. Disclaimers') }}</span></span></h4>
            <p><span style="font-weight: 400;">{{ aiTrans('The Company makes reasonable efforts to ensure that its technology keeps the Website and Services safe and secure. However, no technology is 100% secure. Therefore, while we strive to use commercially acceptable means to protect your personal information, we cannot guarantee its absolute security. Except as expressly set forth herein, your use of the Website and Services is at your sole discretion and risk. The Website and Services are provided on an “AS IS” and “AS AVAILABLE” basis without warranties of any kind. The Company expressly disclaims all implied or statutory warranties of any kind relating to the Website and Services, including without limitation the warranties of title, merchantability, fitness for a particular purpose, non-infringement of proprietary rights, course of dealing or course of performance. The Company does not give any advice regarding the risk or suitability of any trade, transaction or engagement. The Company assumes no responsibility for any transaction or engagement made by you and you acknowledge that you are solely responsible for the assessment of your transactions and engagements. You shall not hold the Company, its officers, employees or affiliates liable for any transaction or engagement choices made by you. No advice or information, whether oral or written, obtained by you from the Company or its officers, employees or affiliates, shall create any warranty not expressly stated in these Terms. If you choose to rely on such information, you do so solely at your own risk. Some states or jurisdictions do not allow the exclusion of certain warranties. Accordingly, some of the above exclusions may not apply to you.') }}</span></p>
            <h4><span id="10_Limitation_of_Liability"><span style="font-weight: 400;">{{ aiTrans('10. Limitation of Liability') }}</span></span></h4>
            <p><span style="font-weight: 400;">{{ aiTrans('The Company does not guarantee the value, quality, compatibility or any other feature of the Third Parties, Products or any other information provided, consumed or otherwise made available (hereinafter in this Section: the “Features“). Any Feature is under the sole responsibility of the applicable Third Party or User using it, as applicable, or using the Services or Website. The Company does not undertake to monitor such compliance and may act where non-compliance is detected as shall be decided in accordance with its sole discretion, as described in these Terms. You understand and agree that you may be exposed to content or other information that is inaccurate, objectionable, inappropriate for children, or otherwise unsuited for you.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('The Company is not responsible for any problems or technical malfunction of any telephone network or lines, computer online systems, servers or providers, computer equipment, software, failure of any email due to technical problems or traffic congestion on the Internet or on any of the Website or Services or combination thereof, including any injury or damage to Users or to any person’s computer, mobile phone or any other device related to or resulting from participation or downloading materials in connection with the Website or Services. Under no circumstances shall the Company be responsible for the conduct of third parties, including any Users, whether online or offline, and operators of external sites.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('In no event shall the Company or any of its officers, directors, employees, or agents be liable to you for any indirect, incidental, special, punitive, or consequential damages, arising out of or in connection with your use of the Website or Services, whether or not the damages are foreseeable and whether or not the Company has been advised of the possibility of such damages. The foregoing limitation of liability shall apply to the fullest extent permitted by law in the applicable jurisdiction.') }}</span></p>
            <h4><span id="11_Indemnification"><span style="font-weight: 400;">{{ aiTrans('11. Indemnification') }}</span></span></h4>
            <p><span style="font-weight: 400;">{{ aiTrans('You will defend, indemnify and hold the Company harmless from and against any and all suits, proceedings, assertions, damages, costs, liabilities or expenses (including court costs and reasonable attorneys’ legal fees) which the Company may suffer or incur in connection with any actual claim, demand, action or other proceeding by any third party arising from or relating to any breach of these Terms by you or any use by you of the Website or Services not in accordance with applicable law.') }}</span></p>
            <h4><span id="12_Miscellaneous"><span style="font-weight: 400;">{{ aiTrans('12. Miscellaneous') }}</span></span></h4>
            <p><span style="font-weight: 400;">{{ aiTrans('These Terms shall be governed by the laws of England, exclusive of its choice of law rules, and without regard to the United Nations Convention on the International Sales of Goods. Your conduct may also be subject to other local, state, and national laws. Any dispute arising under these Terms or concerning the Website or Service shall be finally settled by the competent courts of England. You may not advance any class action claims against the Company, and by using the Website or Services you agree to waive your rights to advance any such class actions claims.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('Any cause of action against the Company must be brought within one (1) year of the date such cause of action arose. In the event that any provision of these Terms is held to be unenforceable, such provision shall be replaced with an enforceable provision which most closely achieves the effect of the original provision, and the remaining terms of these Terms shall remain in full force and effect. Nothing in these Terms creates any agency, employment, joint venture, or partnership relationship between you and the Company or enables you to act on behalf of the Company. Except as may be expressly stated in these Terms, these Terms constitute the entire agreement between the Company and you pertaining to the subject matter hereof.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('Any notices that we may be required to provide to you, whether under law or according to these Terms, may be provided by the Company to any contact information you have provided in your Account information or other, either directly or indirectly, including through email. You expressly agree to the receipt of such communications and notices in such manner.') }}</span></p>
            <p><span style="font-weight: 400;">{{ aiTrans('You may not assign any rights hereunder without our prior written consent. Nothing contained in these Terms shall be construed to limit the actions or remedies available to the Company with respect to any prohibited activity or conduct. Non-enforcement of any term of these Terms does not constitute consent or waiver, and the Company reserves the right to enforce such term at its sole discretion. No waiver of any breach or default hereunder shall be deemed to be a waiver of any preceding or subsequent breach or default.') }}</span></p>
            <p> </p>
        </main>
    </div>


@endsection
