@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title επίσημος ιστότοπος 2025" }}</title>
    <meta name="description" content="{{ "Το $website_title είναι η πύλη για την εις βάθος και αυθεντική επενδυτική εκπαίδευση στον 21ο αιώνα και την οικονομική διαφώτιση." }}" />
@endpush
@section('content')
<section class="main">
    <div class="container text-center mb-md-5">
        <h1 class="main-header">{{$website_title}}</h1>
        <h2 class="main-subheader"><span class="change-by-command">{{ "$website_title Η Κατεύθυνσή Σας προς Περιεκτική Επενδυτική Εκπαίδευση" }}</span> </h2>
    </div>
    <div class="container" style="max-width: 1350px;">
        <div class="row align-items-center">
            <div class="col-lg-7">
                <div class="main-image">
                    <picture>
                        <source type="image/webp" srcset="{{asset('frontend/assets/el/dist')}}/images/video-image.webp">
                        <source type="image/png" srcset="{{asset('frontend/assets/el/dist')}}/images/video-image.png">
                        <img src="{{asset('frontend/assets/el/dist')}}/images/video-image.png" width="831" height="584" alt="[website_title] Main">
                    </picture>
                </div>
            </div>
            <div class="col-lg-5">
                <div id="req-form-section" class="main-form">
                    @include('frontend.el.components.form')

                </div>
            </div>
        </div>
    </div>
</section>

<section class="half-1 bg-gray">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="title">
                    {{ aiTrans(
                        'Τι Είναι το [website_title];',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </h2>
                <p><b>
                    {{ aiTrans(
                        'Όταν σκέφτεστε ένα συνδέτη, το [website_title] ταιριάζει τέλεια σε αυτόν τον ρόλο. Το ιστοτόπος
                        συνδέει άτομα που είναι παθιασμένα με την απόκτηση γνώσεων στον τομέα των επενδύσεων με
                        εταιρείες που έχουν μεγάλη εμπειρία, έχουν κυριαρχήσει σε αυτό το θέμα και μπορούν να
                        μεταφέρουν αποτελεσματικά τις γνώσεις σε αυτούς.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </b></p>
                <div class="group-text-wrap">
                    <input type="checkbox" id="group-text-1">
                    <div class="group-text">
                        <p>{{aiTrans('Ως ένας ιστότοπος σύνδεσης, στοχεύει να εκθέσει πολλούς ανθρώπους στα διάφορα τμήματα και
                            κλάδους των επενδύσεων μέσω των εταιρειών εκπαίδευσης που ειδικεύονται σε αυτό. Μετά την
                            εγγραφή, οι άνθρωποι θα επεκτείνουν το λεξιλόγιο τους στον τομέα των επενδύσεων, θα
                            σκέφτονται και θα μιλούν όπως οι ειδικοί, θα χτίζουν το δίκτυό τους και θα εκπαιδεύονται
                            να προβαίνουν σε αξιόπιστες οικονομικές αποφάσεις.')}}</p>
                        <p>
                            {{ aiTrans(
                                'Δημιουργημένο για να ικανοποιεί τις σύγχρονες ανάγκες, το [website_title] διαθέτει μια
                                άψογη διεπαφή χρήστη που μεταφράζεται σε μια εξαιρετική εμπειρία χρήστη. Ο ιστότοπος
                                είναι προσβάσιμος και εύκολος για όσους έχουν μηδενικές ή ελάχιστες γνώσεις στον τομέα
                                των επενδύσεων.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>
                            {{ aiTrans(
                                'Για να γίνει ο διαδικασία εγγραφής πιο ομαλή και λιγότερο στρεσαριστική, οι
                                ενδιαφερόμενοι μαθητές θα λαμβάνουν οδηγίες από τους εκπροσώπους των εταιρειών
                                εκπαίδευσης στις οποίες συνδέει το [website_title]. Επίσης, θα λαμβάνουν στοιχεία
                                σύνδεσης, προγράμματα μελέτης, πηγές μελέτης κ.λπ. από τις εταιρείες με τις οποίες
                                εγγράφονται.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                        <p>
                            {{ aiTrans(
                                'Το [website_title] είναι δωρεάν για εγγραφή. Οι ενδιαφερόμενοι μαθητές δεν χρειάζεται να
                                πληρώσουν ούτε ένα λεπτό για να συνδεθούν με μια εταιρεία επενδύσεων.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                    <label for="group-text-1" class="group-text-more">{{aiTrans('Διαβάστε όλα')}} </label>
                </div>
            </div>
        </div>
        <div class="mt-3 mt-md-4" style="text-align: center;">
            <a href="#req-form-section" class="main-form-btn">{{aiTrans('ΕΓΓΡΑΦΕΙΤΕ ΕΔΩ')}}</a>
        </div>
    </div>
</section>

<section class="padding-60">
    <div class="container">
        <div class="col-12">
            <div class="row text-center justify-content-center">
                <h2 class="title text-center">{{aiTrans('Αποκτήστε Καλά Θεμελιωμένη Επενδυτική Εκπαίδευση')}}</h2>
                <p><b>
                    {{ aiTrans(
                        'Αποκτήστε βασικές και προηγμένες γνώσεις του τοπίου των επενδύσεων και λάβετε εκλεπτυσμένες
                        επενδυτικές αποφάσεις όταν συνδεθείτε με ειδικούς μέσω του [website_title].',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </b></p>
            </div>
        </div>
    </div>
</section>

<section class="half-3 bg-gray">
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-4">
                <h2 class="title">{{aiTrans('Δημιουργήστε την Εκπαίδευση Επενδύσεών Σας')}}</h2>
                <h3 class="subtitle">{{aiTrans('Γίνετε Ειδικός στις Επενδύσεις μέσω της Μάθησης')}}</h3>
                <p>
                    {{ aiTrans(
                        'Ανεβείτε γρήγορα τη σκάλα του εξειδικευμένου γνωστικού επιπέδου καθώς συνδέεστε με μια
                        εξειδικευμένη εταιρεία επενδυτικής εκπαίδευσης με τη βοήθεια του [website_title]. Μην πέφτετε
                        θύματα εκπαιδευτικών με επιστημονικές γνώσεις και απομιμητές στον κόσμο των επενδύσεων.
                        Κατανοήστε όρους, κατηγορίες, στρατηγικές, τύπους, τάσεις, κινδύνους και διαδικασίες διαχείρισης
                        κινδύνων.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </p>
            </div>
        </div>
    </div>
</section>

<section class="half-4">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="title">{{aiTrans('Απορρήτου Δεδομένων')}}</h2>
                <h3 class="subtitle">
                    {{ aiTrans(
                        'Απολαύστε το Απόρρητο Δεδομένων με τον [website_title]',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </h3>
                <p class="checked-paragraph">
                    {{ aiTrans(
                        '- Το [website_title] σας συνδέει με εκπαιδευτικούς που είναι διαφανείς σχετικά με τη συλλογή, χρήση, αποθήκευση, μεταφορά ή απόρριψη δεδομένων.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                
                    </p>
                <p class="checked-paragraph">
                    {{ aiTrans(
                        '- Με τον [website_title], μπορείτε να είστε βέβαιοι ότι τα δεδομένα σας θα χρησιμοποιηθούν σύμφωνα με τις προδιαγραφές.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </p>
            </div>
        </div>
    </div>
</section>

<section class="half-5 bg-gray">
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-4">
                <h2 class="title">{{aiTrans('Εξαιρετική Διεπαφή Χρήστη')}}</h2>
                <h3 class="subtitle">{{aiTrans('Εγγυημένη Θετική Εμπειρία Χρήστη')}}</h3>
                <p class="checked-paragraph">
                    {{ aiTrans(
                        '- Χωρίς κρυφά μηνύματα ή κρυφές ατζέντες. Λάβετε σαφείς οδηγίες μέσω
                        του [website_title]. Αποκτήστε πρόσβαση σε βασικές πληροφορίες μέσω σαφών αντιγράφων και
                        κατευθείαν κουμπιά CTA.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </p>
                <p class="checked-paragraph">
                    {{ aiTrans(
                        '- Συμπληρώστε γρήγορα τις φόρμες εγγραφής. Δεν απαιτείται
                        προγραμματισμός, προγραμματισμός, μηχανική ή άλλες προηγμένες τεχνικές δεξιότητες για να
                        χρησιμοποιήσετε τον [website_title].',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </p>
            </div>
        </div>
    </div>
</section>

<section class="half-6">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="title">{{aiTrans('Αυξήστε τις επενδυτικές σας δεξιότητες')}}</h2>
                <h3 class="subtitle">{{aiTrans('Χωρίς Όροι και Προϋποθέσεις')}}</h3>
                <p>
                    {{ aiTrans(
                        'Συχνά, οι ιστότοποι και οι παροχείς υπηρεσιών εφαρμόζουν όρους και προϋποθέσεις στις προσφορές
                        τους. Στην περίπτωση του [website_title] και των εκπαιδευτικών εταιρειών επενδύσεων που
                        παρατίθενται, δεν ισχύουν όροι και προϋποθέσεις για τα άτομα που εγγράφονται για να μάθουν για
                        τις επενδύσεις.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </p>
                <h3 class="subtitle">{{aiTrans('Ομαλή Διαδικασία Εγγραφής')}}</h3>
                <div class="group-text-wrap">
                    <input type="checkbox" id="group-text-2">
                    <div class="group-text">
                        <p>
                            {{ aiTrans(
                                'Εγγραφείτε γρήγορα συμπληρώνοντας ένα έντυπο εγγραφής στον [website_title]. Δεν υπάρχουν
                                πολλά βήματα εγγραφής. Παρέχετε σωστές προσωπικές λεπτομέρειες: όνομα, επώνυμο,
                                διεύθυνση email και αριθμό τηλεφώνου, και είστε έτοιμοι. Αναμένετε ένα τηλεφώνημα από
                                την εταιρεία εκπαίδευσης στις επενδύσεις με την οποία σας συσχετίζουμε για να σας
                                καλωσορίσει και να προετοιμαστεί για το ταξίδι της μάθησής σας.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                    <label for="group-text-2" class="group-text-more">{{aiTrans('Διαβάστε όλα')}} </label>
                </div>
            </div>
        </div>
        <div class="mt-3 mt-md-4" style="text-align: center;">
            <a href="#req-form-section" class="main-form-btn">{{aiTrans('ΕΓΓΡΑΦΕΙΤΕ ΔΩΡΕΑΝ')}}</a>
        </div>
    </div>
</section>

<section class="bg-image-2 padding-60">
    <div class="container text-center mb-md-5" style="max-width: 1170px;">
        <h2 class="title white">{{aiTrans('Τι είναι Μια Επένδυση;')}}</h2>
    </div>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="py-4 text-center">
                    <picture>
                        <source type="image/webp" srcset="{{asset('frontend/assets/el/dist')}}/images/half-7-img.webp">
                        <source type="image/png" srcset="{{asset('frontend/assets/el/dist')}}/images/half-7-img.png">
                        <img src="{{asset('frontend/assets/el/dist')}}/images/half-7-img.png" width="1189" height="250" alt="[website_title] Main">
                    </picture>
                </div>
            </div>
            <div class="col-md-6">
                <div>
                    <p><b>{{aiTrans('Στην επιχειρηματικότητα και τη χρηματοοικονομική, μια επένδυση αναφέρεται στην ανταλλαγή
                            χρημάτων για περιουσιακά στοιχεία που θα αυξήσουν την αξία τους και θα φέρουν κέρδος
                            κατά την πώλησή τους. Ένα άτομο μπορεί να επιλέξει να επενδύσει σε διάφορα είδη
                            περιουσιακών στοιχείων: hedge funds, μετοχές, αμοιβαία κεφάλαια, κλπ. Ωστόσο, η επένδυση
                            σε αυτά τα περιουσιακά στοιχεία συνεπάγεται ποικίλους τύπους κινδύνων. Κάποιοι όροι
                            επενδυτικών που θα μάθετε περισσότερα είναι:')}}</b></p>
                </div>
                <div class="info-item">
                    <input type="checkbox">
                    <h3 class="info-item-title">{{aiTrans('Κατανομή Περιουσιακών Στοιχείων')}}</h3>
                    <div class="info-item-content">
                        <p>{{aiTrans('Η κατανομή περιουσιακών στοιχείων ισορροπεί τις επενδύσεις σας για να περιορίσει τους
                            κινδύνους στους οποίους θα εκτίθεστε. Ισορροπεί τον κίνδυνο έναντι της ανταμοιβής. Για
                            να το πετύχει αυτό, προσαρμόζει το ποσοστό κάθε περιουσιακού στοιχείου σε ένα
                            χαρτοφυλάκιο με βάση τους στόχους και την ανεκτικότητα στον κίνδυνο σας.')}}</p>
                    </div>
                </div>
                <div class="info-item">
                    <input type="checkbox">
                    <h3 class="info-item-title">{{aiTrans('Μπλε Μάρκα')}}</h3>
                    <div class="info-item-content">
                        <p>{{aiTrans('Η μπλε μάρκα είναι μια επένδυση (μετοχή) μιας εταιρείας που έχει αποδώσει καλά μετά από
                            καιρό. Συχνά, η μετοχή είναι χαμηλού κινδύνου και υψηλής ποιότητας. Οι εταιρείες με
                            αυτήν την επένδυση είναι συχνά μεγάλες, λειτουργούν εδώ και πολλά χρόνια, έχουν τεράστια
                            κέρδη και καταβάλλουν μερίσματα.')}}</p>
                    </div>
                </div>
                <div class="info-item">
                    <input type="checkbox">
                    <h3 class="info-item-title">{{aiTrans('Διάκριση Κόστους Δολαρίου')}}</h3>
                    <div class="info-item-content">
                        <p>{{aiTrans('Η διάκριση κόστους δολαρίου είναι η επένδυση του ίδιου ποσού χρημάτων. Η επένδυση
                            λαμβάνει συχνά χώρα σε συγκεκριμένα χρονικά διαστήματα κατά μήκος ενός μεγάλου χρονικού
                            διαστήματος. Στην περίπτωση της διάκρισης κόστους δολαρίου, ένα άτομο επενδύει ένα
                            σταθερό ποσό για να αγοράσει περισσότερες μετοχές όταν οι τιμές των περιουσιακών
                            στοιχείων είναι χαμηλές. Επίσης, αγοράζουν λιγότερο όταν οι τιμές είναι υψηλές.')}}</p>
                    </div>
                </div>
            </div>
        </div>

    </div>
</section>

<section class="half-8">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="title">{{aiTrans('Τι είναι η Μάθηση Επενδύσεων;')}}</h2>
                <p><b>{{aiTrans('Η μάθηση είναι ένα ατελείωτο κύκλος. Δεν περιορίζεται στους τέσσερις τοίχους κολεγίων, σχολών
                        οδήγησης, επαγγελματικών κέντρων εκπαίδευσης, κλπ. Καθώς οι άνθρωποι μαθαίνουν εντατικά για
                        άλλα θέματα, έτσι και ο κόσμος των επενδύσεων είναι ανοιχτός στη μάθηση.')}}</b></p>
                <div class="group-text-wrap">
                    <input type="checkbox" id="group-text-3">
                    <div class="group-text">
                        <p>{{aiTrans('Η μάθηση επενδύσεων σημαίνει να αποκτά κανείς λεπτομερείς και πρακτικές γνώσεις και
                            δεξιότητες σχετικά με την αγορά περιουσιακών στοιχείων. Μέσω της εκπαίδευσης στις
                            επενδύσεις, οι άνθρωποι μαθαίνουν τα διάφορα είδη περιουσιακών στοιχείων στα οποία
                            μπορούν να επενδύσουν, πώς να επενδύσουν στο σωστό είδος περιουσιακών στοιχείων, πώς να
                            χρησιμοποιούν στατιστικά στοιχεία επενδύσεων για να λαμβάνουν αποφάσεις και πώς να
                            στρατηγικεύονται.')}}</p>
                        <p>
                            {{ aiTrans(
                                'Οι ενδιαφερόμενοι για τη μάθηση για τις επενδύσεις θα ανακαλύψουν τους κινδύνους των
                                επενδύσεων στις διάφορες τους μορφές και πώς να τους διαχειρίζονται. Επίσης, θα
                                ανακαλύψουν παράγοντες που επηρεάζουν την απόδοση των επενδύσεων. Αυτό θα βοηθήσει τους
                                ανθρώπους να γίνουν λιγότερο στρεσαρισμένοι ή απογοητευμένοι με λιγότερο εισόδημα ή
                                κέρδος. Όλα αυτά είναι στόχος του [website_title] για να εξασφαλίσει ότι οι άνθρωποι
                                λαμβάνουν εκπαίδευση στις επενδύσεις.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                    <label for="group-text-3" class="group-text-more">{{aiTrans('Διαβάστε όλα')}} </label>
                </div>
            </div>
        </div>
        <div class="mt-3 mt-md-4" style="text-align: center;">
            <a href="#req-form-section" class="main-form-btn">{{aiTrans('ΕΓΓΡΑΦΕΙΤΕ ΤΩΡΑ')}}</a>
        </div>
    </div>
</section>

<section class="padding-60 bg-gray">
    <div class="container">
        <h2 class="title text-center">{{aiTrans('Τύποι Επενδύσεων')}}</h2>
        <div class="py-4 text-center">
            <picture>
                <source type="image/webp" srcset="{{asset('frontend/assets/el/dist')}}/images/half-9.webp">
                <source type="image/png" srcset="{{asset('frontend/assets/el/dist')}}/images/half-9.png">
                <img src="{{asset('frontend/assets/el/dist')}}/images/half-9.png" width="100%" height="250" alt="Matrixator Main">
            </picture>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="check-item">
                    <h3 class="check-item-title check-item-title--check">{{aiTrans('Ανάληψη')}}</h3>
                    <div class="check-item-content">
                        <p>{{aiTrans('Σε αυτόν τον τύπο επενδύσεων, ένα άτομο αποθηκεύει ή καταβάλλει πληρωμές σε μια
                            ασφαλιστική εταιρεία για να τους πληρώσει αργότερα στη ζωή του. Ένα άτομο αρχίζει να
                            πληρώνεται μετά την ανακτητική αξίωση. Οι τύποι αναλήψεων είναι εξασφαλισμένοι
                            υπάλληλοι, μονόπλευρη ζωή, φορολογικά καταφύγια, κοινοί και επιζώντες, μεταβλητοί και
                            σταθεροί.')}}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="check-item">
                    <h3 class="check-item-title check-item-title--check">{{aiTrans('Πολύτιμα Μέταλλα')}}</h3>
                    <div class="check-item-content">
                        <p>{{aiTrans('Άτομα που ενδιαφέρονται για εκπαίδευση στις επενδύσεις πρέπει να κατανοήσουν ότι
                            περιουσιακά στοιχεία στα οποία μπορούν επίσης να επενδύσουν είναι τα πολύτιμα μέταλλα.
                            Τα πολύτιμα μέταλλα περιλαμβάνουν πλατίνα, χρυσό, ασήμι, παλλάδιο και ρουθήνιο. Για να
                            επενδύσει κάποιος σε αυτά τα μέταλλα, μπορεί να τα αγοράσει και να τα πωλήσει όταν οι
                            τιμές τους αυξηθούν ή όταν έχουν υψηλή ζήτηση στην αγορά.')}}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="check-item">
                    <h3 class="check-item-title check-item-title--check">{{aiTrans('Επιλογές')}}</h3>
                    <div class="check-item-content">
                        <p>{{aiTrans('Μια επιλογή είναι ένα συμβόλαιο επενδύσεων μεταξύ δύο μερών. Εδώ, ο κάτοχος μπορεί να
                            αγοράσει ή να πουλήσει ένα περιουσιακό στοιχείο σε μια ορισμένη τιμή εντός ενός χρονικού
                            πλαισίου. Η επένδυση απαιτεί κατάθεση, μέγεθος συμβολαίου, ημερομηνία λήξης και καμία
                            υποχρέωση να πωληθεί. Οι τύποι τους είναι κλήση, τοποθέτηση, Αμερικανική και Ευρωπαϊκή.')}}
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="check-item">
                    <h3 class="check-item-title check-item-title--check">{{aiTrans('ETFs (Κεφάλαια Εμπορεύσιμα στο Χρηματιστήριο)')}}</h3>
                    <div class="check-item-content">
                        <p>{{aiTrans('Οι επενδύσεις σε κεφάλαια εμπορεύσιμα στο χρηματιστήριο παρακολουθούν ένα συγκεκριμένο
                            κλάδο, περιουσιακό στοιχείο, δείκτη ή εμπορεύσιμο αγαθό. Ένα ETF είναι διαθέσιμο για
                            αγορά ή πώληση στο χρηματιστήριο. Αυτή η επένδυση μειώνει τους κινδύνους, καθώς
                            επιτρέπει την ποικιλομορφία του χαρτοφυλακίου. Οι τύποι των ETF είναι ETF ομολόγων, ETF
                            νομισμάτων, αντίστροφα ETF, ETF εμπορεύσιμων αγαθών, ETF μετοχών και ETF κλάδων.')}}</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="mt-3 mt-md-4" style="text-align: center;">
            <a href="#req-form-section" class="main-form-btn">{{aiTrans('ΜΑΘΕΤΕ ΠΕΡΙΣΣΟΤΕΡΑ')}}</a>
        </div>
    </div>
</section>

<section class="half-10">
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-4">
                <h2 class="title">{{aiTrans('Κατηγορίες Επενδύσεων')}}</h2>
                <p><b>{{aiTrans('Οι επενδύσεις υπάγονται σε τρεις ευρείες κατηγορίες: χαμηλού κόστους επενδύσεις, επενδύσεις σε
                        μετρητά ή ισοδύναμα μετρητά, και επενδύσεις σε σχέση με την ισοτιμία.')}}</b></p>
                <p>{{aiTrans('Οι χαμηλού κόστους επενδύσεις δίνουν μεγάλη σημασία στο να μειώνουν τα κόστη που σχετίζονται με
                    τη διαχείριση ενός χαρτοφυλακίου. Ένα άτομο μπορεί να επιλέξει ένα κεφάλαιο εμπορεύσιμο στο
                    χρηματιστήριο ή κορυφαία κεφάλαια για να μειώσει τα κόστη. Επίσης, ένας επενδυτής μπορεί να
                    μειώσει τις συναλλαγές και να αποφεύγει τις προμήθειες.')}}</p>
                <div class="group-text-wrap">
                    <input type="checkbox" id="group-text-4">
                    <div class="group-text">
                        <p>{{aiTrans('Οι επενδύσεις σε μετρητά ή ισοδύναμα μετρητά είναι περιουσιακά στοιχεία που μπορούν να
                            επενδυθούν για μικρό χρονικό διάστημα, να μετατραπούν σε μετρητά και να έχουν χαμηλούς
                            κινδύνους. Παραδείγματα ισοδυνάμων μετρητών είναι εμπορεύσιμα χρηματικά εργαλεία,
                            εμπορικά χαρτοφυλάκια, πιστοποιητικά καταθέσεων και επιταγές του ταμείου.')}}</p>
                        <p>{{aiTrans('Μια επένδυση σε σχέση με την ισοτιμία είναι η αγορά μετοχών μιας εταιρείας στο
                            χρηματιστήριο. Οι μετοχές αυτές μπορούν στη συνέχεια να διαπραγματευτούν σε ένα
                            χρηματιστήριο. Το πλεονέκτημα αυτής της κατηγορίας επένδυσης είναι η δυνατότητά της να
                            αυξηθεί στην αξία. Η πληθωρισμός, η ρευστότητα, οι νομισματικοί κίνδυνοι και οι κίνδυνοι
                            πιστώσεων είναι κοινοί κίνδυνοι των επενδύσεων σε ισοτιμία.')}}</p>
                        <p>
                            {{ aiTrans(
                                'Η εγγραφή στον [website_title] σας δίνει μια ευρύτερη κατανόηση αυτών των κατηγοριών όταν
                                σας συνδέουμε με έναν εκπαιδευτή.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                    <label for="group-text-4" class="group-text-more">{{aiTrans('Διαβάστε όλα')}} </label>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="half-11 bg-gray">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="title">{{aiTrans('Τι είναι Μια Εταιρεία Εκπαίδευσης στις Επενδύσεις;')}}</h2>
                <p><b>
                    {{ aiTrans(
                        'Πολλοί άνθρωποι φαίνεται ότι αγνοούν το γεγονός ότι η μάθηση για τις επενδύσεις είναι κάτι
                        σημαντικό. Όσο περισσότεροι άνθρωποι είναι αναίσθητοι σε αυτό το γεγονός, τόσο περισσότερο
                        κινδυνεύουν να πέσουν θύματα τρομερών προβλημάτων στον τομέα των επενδύσεων. Η αποφυγή αυτής
                        της κατάστασης είναι μία από τις βασικές ευθύνες των εταιρειών εκπαίδευσης στις επενδύσεις
                        που σας συνδέουν με τον [website_title].',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </b></p>
                <div class="group-text-wrap">
                    <input type="checkbox" id="group-text-5">
                    <div class="group-text">
                        <p>{{aiTrans('Μια εταιρεία εκπαίδευσης στις επενδύσεις επηρεάζει τους μαθητές με σταθερές γνώσεις για
                            τις επενδύσεις. Οι εκπαιδευτές αυτών των εταιρειών εφαρμόζουν τον πλούτο της εμπειρίας
                            τους για να δώσουν θεωρητική διδασκαλία και πρακτική εκπαίδευση.')}}</p>
                        <p>{{aiTrans('ΕΓΓΡΑΦΕΙΤΕ ΔΩΡΕΑΝ')}}</p>
                        <p>{{aiTrans('Regularly, the firms organize training for learners online and offline. Experts provide
                            quality training resources to support learning and set up practical sessions where
                            learners interact using investment terms, invest, and identify their risk tolerance
                            levels. With this, learners will gradually discard the get-rich-quick mindset, learn the
                            nitty-gritty of investments, and develop commendable and lasting investment skills.')}}</p>
                        <p>{{aiTrans('Through the training, learners will interact with and gain clarifications from the
                            investment industry experts. This way, they will learn from their mistakes and bold
                            steps they took in the past. In general, persons in investment education firms will
                            share fundamental and advanced knowledge about investment with learners.')}}</p>
                    </div>
                    <label for="group-text-5" class="group-text-more">{{aiTrans('Διαβάστε όλα')}} </label>
                </div>
            </div>
        </div>
        <div class="mt-3 mt-md-4" style="text-align: center;">
            <a href="#req-form-section" class="main-form-btn">{{aiTrans('ΕΓΓΡΑΦΕΙΤΕ ΔΩΡΕΑΝ')}}</a>
        </div>
    </div>
</section>

<section class="half-12">
    <div class="container">
        <div class="row">
            <div class="col-md-8 offset-md-4">
                <h2 class="title">{{aiTrans('Επενδύσεις έναντι Συναλλαγών')}}</h2>
                <p>
                    {{ aiTrans(
                        'Το [website_title] είναι ιδιαίτερα προσηλωμένο στο να φωτίζει αυτούς τους όρους. Η επένδυση
                        περιλαμβάνει την αγορά ενός περιουσιακού στοιχείου που είναι πιθανό να αυξηθεί σε κέρδος με την
                        πάροδο του χρόνου. Οι δύο βασικοί τύποι επενδύσεων είναι η ενεργητική επένδυση και η παθητική
                        επένδυση. Από την άλλη πλευρά, η συναλλαγή είναι η συχνή αγορά και πώληση περιουσιακών στοιχείων
                        για τη δημιουργία κέρδους σε βραχυπρόθεσμη βάση. Οι τύποι συναλλαγών περιλαμβάνουν την
                        αριθμητική αριθμητική, το scalping, την αγορά μετοχών, την ημερήσια συναλλαγή, κ.λπ.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </p>
                <p>
                    {{ aiTrans(
                        'Η βασική ομοιότητα μεταξύ των δύο έννοιών είναι ότι περιλαμβάνουν την αγορά και πώληση
                        περιουσιακών στοιχείων, τη δημιουργία κέρδους, την αντιμετώπιση και διαχείριση κινδύνων και τη
                        δυνατότητα απώλειας. Η συναλλαγή απαιτεί την αγορά ενός περιουσιακού στοιχείου για μικρό χρονικό
                        διάστημα. Αντίθετα, η επένδυση διαρκεί περισσότερο. Όταν εγγραφείτε στο [website_title], θα
                        κατευθυνθείτε σε μια εταιρεία που μπορεί να τα εξηγήσει από τη σκοπιά ενός ειδικού.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </p>
            </div>
        </div>
    </div>
</section>

<section class="bg-image-3 padding-60">
    <div class="container text-center mb-md-5">
        <h2 class="title white">{{aiTrans('Κίνδυνοι που Συνδέονται με τις Επενδύσεις')}}</h2>
        <div class="py-4 text-center">
            <picture>
                <source type="image/webp" srcset="{{asset('frontend/assets/el/dist')}}/images/half-13.webp">
                <source type="image/png" srcset="{{asset('frontend/assets/el/dist')}}/images/half-13.png">
                <img src="{{asset('frontend/assets/el/dist')}}/images/half-13.png" width="100%" height="250" alt="[website_title] Main">
            </picture>
        </div>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="info-item">
                    <input type="checkbox">
                    <h3 class="info-item-title">{{aiTrans('Κίνδυνος Πίστωσης')}}</h3>
                    <div class="info-item-content">
                        <p>{{aiTrans('Η προεπιλογή είναι συχνά αναπόφευκτη στην επένδυση. Οι εμπλεκόμενες πλευρές σε μια
                            επένδυση ενδέχεται να μην πληρώσουν το τέλος της σύμβασης τους, προκαλώντας έναν κίνδυνο
                            επένδυσης. Ο κίνδυνος πίστωσης εμφανίζεται όταν μια αξία πέφτει επειδή ένα άτομο δεν
                            καταβάλλει το κεφάλαιο ή τα τόκοι.')}}</p>
                    </div>
                </div>
                <div class="info-item">
                    <input type="checkbox">
                    <h3 class="info-item-title">{{aiTrans('Κίνδυνος Συναλλαγματικού Κινδύνου')}}</h3>
                    <div class="info-item-content">
                        <p>{{aiTrans('Αυτός ο κίνδυνος εμφανίζεται όταν κάποιος επενδύει σε μια διαφορετική χώρα από τη χώρα
                            καταγωγής του. Ο κίνδυνος συναλλαγματικού κινδύνου προκύπτει όταν μια επένδυση δεν
                            μπορεί να παράγει εισόδημα, κέρδος ή αποδόσεις επειδή η ξένη χώρα αντιμετωπίζει
                            προβλήματα όπως οικονομική ύφεση, πόλεμος, πληθωρισμός, κ.λπ.')}}</p>
                    </div>
                </div>
                <div class="info-item">
                    <input type="checkbox">
                    <h3 class="info-item-title">{{aiTrans('Κίνδυνος Συγκέντρωσης')}}</h3>
                    <div class="info-item-content">
                        <p>{{aiTrans('Η εστίαση σε ένα μόνο περιουσιακό στοιχείο μπορεί να αποτελέσει ανάστατο για την
                            επένδυση. Υπάρχει κίνδυνος συγκέντρωσης όταν ένα άτομο χάνει κέρδος όταν επενδύει μόνο
                            σε ένα ασφαλιστικό όργανο ή έναν τύπο ασφαλιστικού οργάνου. Η διαφοροποίηση είναι ένα
                            αποτελεσματικό μέσο για τη διαχείριση αυτού του κινδύνου.')}}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-item">
                    <input type="checkbox">
                    <h3 class="info-item-title">{{aiTrans('Κίνδυνος Πληθωρισμού')}}</h3>
                    <div class="info-item-content">
                        <p>{{aiTrans('Ο κίνδυνος πληθωρισμού είναι όταν μια επένδυση χάνει την αγοραστική της δύναμη επειδή δεν
                            μπορεί να δημιουργήσει υψηλότερο κέρδος από τον πληθωρισμό. Όταν ο πληθωρισμός μειώνει
                            το κέρδος μιας επένδυσης, οι επενδυτές θα χάσουν επίσης την ικανότητά τους να αντέξουν
                            τον κίνδυνο.')}}</p>
                    </div>
                </div>
                <div class="info-item">
                    <input type="checkbox">
                    <h3 class="info-item-title">{{aiTrans('Κίνδυνος Μακροζωίας')}}</h3>
                    <div class="info-item-content">
                        <p>{{aiTrans('Αυτός είναι ο κίνδυνος να υπερβεί κανείς τα κεφάλαιά του ή τα κέρδη της επένδυσής του ενώ
                            είναι ακόμα ζωντανός. Σε αυτήν την περίπτωση, το άτομο πρέπει να ψάξει για άλλη πηγή
                            εισοδήματος. Εάν δεν μπορούν να εργαστούν πλέον, δεν θα λαμβάνουν πλέον κέρδη.')}}</p>
                    </div>
                </div>
                <div class="info-item">
                    <input type="checkbox">
                    <h3 class="info-item-title">{{aiTrans('Κίνδυνος Ορίζοντα')}}</h3>
                    <div class="info-item-content">
                        <p>{{aiTrans('Ο κίνδυνος ορίζοντα είναι ο κίνδυνος μείωσης του αναμενόμενου χρόνου που ένας επενδυτής
                            θα πρέπει να κρατήσει ένα περιουσιακό στοιχείο λόγω μη προγραμματισμένων και ατυχών
                            συνθηκών. Αυτό μπορεί να οφείλεται στον χαμό ενός αγαπημένου ή την απώλεια της δουλειάς
                            τους. Η μείωση του χρόνου κατοχής μπορεί να οδηγήσει στην απώλεια αξίας της επένδυσης.')}}
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="half-14">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="title">{{aiTrans('Συνοψίζοντας')}}</h2>
                <p>{{aiTrans('Ο κόσμος των επενδύσεων είναι μεγαλύτερος και πιο επικίνδυνος για να εισέλθετε χωρίς να πάρετε
                    κατάλληλη εκπαίδευση. Η εκπαίδευση στις επενδύσεις εκθέτει τους ανθρώπους που επιθυμούν να
                    μάθουν για τις επενδύσεις σε όλα όσα πρέπει να ξέρουν. Οι εταιρείες εκπαίδευσης στις επενδύσεις
                    διασφαλίζουν ότι παρέχουν όλους τους πόρους για να καταστήσουν τη διαδικασία μάθησης
                    ενδιαφέρουσα και παραγωγική.')}}</p>
                <p>
                    {{ aiTrans(
                        'Καθώς η διαδικασία μάθησης στις επενδύσεις συνεχίζεται, οι μαθητές θα εξοικειωθούν με τους
                        κινδύνους των επενδύσεων και θα αναγνωρίσουν τη χωρητικότητά τους για ανοχή στον κίνδυνο.
                        Εγγραφείτε δωρεάν στο [website_title] σήμερα για να συμμετάσχετε σε αυτήν την πρωτοβουλία. Αφού
                        το κάνετε αυτό, ένας εκπρόσωπος από μια από τις εκπαιδευτικές εταιρείες επενδύσεων που
                        καταχωρίζονται στον κατάλογό μας θα επικοινωνήσει και θα σας καθοδηγήσει μέσω τηλεφώνου.',
                        $locale,
                        ['website_title' => $website_title],
                    ) }}
                    </p>
            </div>
        </div>
    </div>
</section>

<section class="padding-60 bg-gray">
    <div class="container text-center mb-md-5">
        <h2 class="title text-center">{{aiTrans('Συχνές Ερωτήσεις')}}</h2>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="faq-item">
                    <input type="checkbox">
                    <h3 class="faq-item-title">
                        {{ aiTrans(
                            'Τι θα με διδάξει το [website_title];',
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-item-content">
                        <p>
                            {{ aiTrans(
                                'Το [website_title] δεν θα σας διδάξει για τις επενδύσεις. Θα μοιραστούμε μόνο γενικές
                                πληροφορίες σχετικά με τις επενδύσεις στον ιστότοπό μας. Ο κύριος ρόλος μας είναι να σας
                                βοηθήσουμε να εγγραφείτε στον ιστότοπό μας, έτσι ώστε μια εταιρεία εκπαίδευσης στις
                                επενδύσεις να σας διδάξει.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                </div>
                <div class="faq-item">
                    <input type="checkbox">
                    <h3 class="faq-item-title"> {{aiTrans('Θα προσληφθώ ως ειδικός μετά τη μάθηση;')}}</h3>
                    <div class="faq-item-content">
                        <p>
                            {{ aiTrans(
                                'Το [website_title] εξασφαλίζει ότι καταχωρίζει εταιρείες οι οποίες παρέχουν βαθιά μαθήματα
                                επενδύσεων και δεν θα αφήσουν καμία πέτρα αναστραμμένη σε καμία συνεδρία. Μετά από
                                κάποιο χρονικό διάστημα μελέτης, θα έχετε εκτεταμένες γνώσεις σαν να βρίσκεστε στη
                                βιομηχανία εδώ και δεκαετίες.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="faq-item">
                    <input type="checkbox">
                    <h3 class="faq-item-title">{{aiTrans('Είναι ευέλικτο το πρόγραμμα;')}}</h3>
                    <div class="faq-item-content">
                        <p>
                            {{ aiTrans(
                                'Ναι, το πρόγραμμα διδασκαλίας σχεδιάζεται για να προσαρμόζεται στη διαθεσιμότητά σας. Το
                                [website_title] κατανοεί την ευελιξία, επομένως διασφαλίζει ότι οι εκπαιδευτικές
                                εταιρείες με τις οποίες συνεργάζεται σάς επιτρέπουν να συμμετέχετε στο μάθημά σας όποτε
                                είναι διαθέσιμοι, είτε λόγω εργασίας, κατάστασης υγείας, κ.λπ.',
                                $locale,
                                ['website_title' => $website_title],
                            ) }}
                            </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="text-center mt-3 mt-md-4">
            <a href="#req-form-section" class="main-form-btn">{{aiTrans('ΞΕΚΙΝΗΣΤΕ')}}</a>
        </div>
    </div>
</section>

<section class="padding-60 highlight-bg">
    <div class="container">
        <table class="table-highlight">
            <caption class="title">
                {{ aiTrans(
                    '[website_title] Highlights',
                    $locale,
                    ['website_title' => $website_title],
                ) }}</caption>
            <tbody id="emojtable">
                <tr>
                    <td>{{aiTrans('🤖 Registration Cost')}}</td>
                    <td>{{aiTrans('Free of Charge')}}</td>
                </tr>
                <tr>
                    <td>{{aiTrans('💰 Financial Charges')}}</td>
                    <td>{{aiTrans('No Additional Charges')}}</td>
                </tr>
                <tr>
                    <td>{{aiTrans('📋 Registration')}}</td>
                    <td>{{aiTrans('Quick and Straightforward Process')}}</td>
                </tr>
                <tr>
                    <td>{{aiTrans('📊 Education Opportunities')}}</td>
                    <td>{{aiTrans('Crypto, Mutual Funds, Forex, Stocks')}}</td>
                </tr>
                <tr>
                    <td>{{aiTrans('🌎 Supported Countries')}}</td>
                    <td>{{aiTrans('Available Worldwide, Excluding the USA')}}</td>
                </tr>
            </tbody>
        </table>
    </div>
</section>
@endsection
