@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title $website_name | Unsere Datenschutzseite" }}</title>
    <meta name="description" content="{{ "Unsere Datenschutzpraktiken auf $website_title: Eine vertiefte Untersuchung zur Verbesserung des Bewusstseins" }}" />
@endpush
@section('content')
    <section class="uk-section policy">
        <div class="uk-container">
            <h1 class="title-2 ">{{ aiTrans('Datenschutzrichtlinie') }} <span>{{ aiTrans('Zuletzt aktualisiert: 28.10.24') }}</span></h1>
            <p>{{ aiTrans('Wir / „Wir“, „Uns“ oder „Unser“ sind verpflichtet, Ihre personenbezogenen Daten und Ihre Privatsphäre zu schützen.') }}</p>
            <p>{{ aiTrans('Diese Datenschutzrichtlinie wurde erstellt, um Sie darüber zu informieren, wie wir die Informationen, die Sie im Zusammenhang mit der Website bereitstellen, verwalten, sammeln, speichern und verwenden') }}
                <span class="domain"></span> (die <b>„Website“</b>).
            </p>
            <p>{{ aiTrans('Wir werden die folgenden Prinzipien einhalten:') }}</p>
            <p class="dot">
                <b>{{ aiTrans('• Transparenz in Bezug auf die Erhebung und Verarbeitung personenbezogener Daten über Sie:') }}</b>
            </p>

            <p>{{ aiTrans('Es ist uns wichtig, dass Sie jederzeit alle Informationen haben, die erforderlich sind, um informierte Entscheidungen über die Verarbeitung personenbezogener Daten über Sie zu treffen, wenn Sie unsere Website besuchen oder wenn Sie zustimmen, mit einer Handelsplattform eines Drittanbieters zu handeln. Zu diesem Zweck werden wir verschiedene Techniken und Maßnahmen einsetzen, um Ihnen relevante Informationen über die Verarbeitung personenbezogener Daten über Sie in angemessener Weise und zum richtigen Zeitpunkt bereitzustellen.') }}
            </p>
            <p>{{ aiTrans('Darüber hinaus, wenn wir feststellen, dass Ihnen bestimmte Informationen zur Verfügung gestellt werden müssen, werden wir diese Ihnen zur passenden Zeit und am passenden Ort bereitstellen.') }}
            </p>
            <p>{{ aiTrans('Wir freuen uns auch, alle Fragen zu beantworten, die Sie möglicherweise haben, und Ihnen alle erforderlichen Klarstellungen zu geben, vorbehaltlich rechtlicher Einschränkungen. Zu diesem Zweck können Sie uns kontaktieren, indem Sie eine E-Mail an folgende Adresse senden:') }}
                <a href="mail:support{{ '@' . $website_title }}"
                    class="accent mail-link">support{{ '@' . $website_title }}<span class="domain"></span> </a>
            </p>


            <p class="dot">
                <b>{{ aiTrans('• Verarbeitung personenbezogener Daten über Sie ausschließlich zu den in der Richtlinie dargelegten Zwecken:') }}</b>
            </p>
            <p>{{ aiTrans('Die Zwecke, zu denen wir personenbezogene Daten über Sie verarbeiten können, umfassen unter anderem, die Website für Sie verfügbar zu machen und Ihnen eine Verbindung zu Handelsplattformen Dritter (die „Dienste“) bereitzustellen, um die Benutzererfahrung auf der Website zu verbessern, die Dienste (einschließlich der Website) zu optimieren, unsere Rechte und Interessen zu schützen, geschäftliche und administrative Aktivitäten durchzuführen, die die Bereitstellung der Dienste für die Nutzer der Website unterstützen, und/oder rechtlichen und/oder regulatorischen Anforderungen nachzukommen.') }}
            </p>
            <p>{{ aiTrans('Darüber hinaus werden wir personenbezogene Daten über Sie verarbeiten, um Ihre persönlichen Bedürfnisse und Vorlieben zu verstehen.') }}
            </p>
            <p class="dot">
                <b>{{ aiTrans('• Signifikante Ressourcen investieren, um Ihre Rechte in Bezug auf personenbezogene Daten über Sie zu respektieren:') }}</b>
            </p>
            <p>{{ aiTrans('Wir setzen erhebliche Ressourcen ein, damit Sie Ihre Rechte als betroffene Person ausüben können. Daher können Sie uns jederzeit kontaktieren, wenn Sie personenbezogene Daten über Sie einsehen, von uns ändern, löschen, deren Nutzung für bestimmte Zwecke oder allgemein einstellen oder sie an Sie oder an einen Dritten übertragen möchten. Wir werden Ihre Wünsche gemäß dem Gesetz erfüllen.') }}
            </p>
            <p class="dot"><b>{{ aiTrans('• Sicherheit personenbezogener Daten über Sie:') }}</b></p>
            <p>{{ aiTrans('Während wir keinen absoluten Schutz Ihrer personenbezogenen Daten versprechen können, können wir versichern, dass wir eine Vielzahl von Mitteln und Maßnahmen einsetzen und weiterhin einsetzen werden, um sicherzustellen, dass Ihre personenbezogenen Daten geschützt sind.') }}
            </p>
            <h2 class="title-3">{{ aiTrans('Unsere vollständige Datenschutzrichtlinie') }}</h2>
            <p><b>{{ aiTrans('1. Der Geltungsbereich?') }}</b></p>
            <p>{{ aiTrans('Diese Richtlinie beschreibt, welche Arten von personenbezogenen Daten das Unternehmen über natürliche Personen erhebt, wie es sie erhebt, verwendet, mit Dritten teilt, sichert, verarbeitet usw.') }}
            </p>
            <p>{{ aiTrans('In dieser Richtlinie bezieht sich „personenbezogene Daten“ auf alle Informationen, die sich auf eine identifizierte oder identifizierbare natürliche Person beziehen. Eine identifizierbare natürliche Person ist eine Person, die direkt oder in Kombination mit weiteren Informationen, die wir haben oder auf die wir Zugang haben, identifiziert werden kann.') }}
            </p>
            <p>{{ aiTrans('Unsere Dienste richten sich an ein allgemeines Publikum und sind nicht auf Kinder unter 18 Jahren ausgerichtet. Wir erheben oder fordern nicht wissentlich Informationen von Personen unter 18 Jahren an und erlauben solchen Personen nicht wissentlich den Zugang zu unseren Diensten. Wenn wir erfahren, dass Informationen über ein Kind erhoben wurden, werden wir angemessene Schritte unternehmen, um solche Informationen so schnell wie möglich zu löschen.') }}
            </p>
            <p><b>{{ aiTrans('2. Wann erheben wir personenbezogene Daten über Sie?') }}</b></p>
            <p>{{ aiTrans('Wir erheben personenbezogene Daten über Sie, wann immer Sie die Dienste nutzen, die Dienstkanäle nutzen und die Website verwenden. In einigen Fällen geben Sie uns aktiv die personenbezogenen Daten, und in anderen Fällen erheben wir personenbezogene Daten über Sie, indem wir Ihre Nutzung unserer Dienste und/oder unserer Dienstkanäle untersuchen und analysieren oder Ihre Daten von unseren Drittanbieterpartnern erhalten.') }}
            </p>
            <p><b>{{ aiTrans('3. Keine Verpflichtung zur Bereitstellung personenbezogener Daten an das Unternehmen und deren Auswirkungen') }}</b></p>
            <p>{{ aiTrans('Sie sind nicht verpflichtet, uns personenbezogene Daten über sich zur Verfügung zu stellen. In einigen Fällen kann jedoch die Nichtbereitstellung solcher personenbezogenen Daten verhindern, dass wir Ihnen die Dienste bereitstellen, kann Ihre Nutzung der Website verhindern und/oder dazu führen, dass die Dienste und die Website nicht ordnungsgemäß funktionieren.') }}
            </p>
            <p><b>{{ aiTrans('4. Welche Arten von personenbezogenen Daten erheben wir? Personenbezogene Daten, die wir bei jedem Browsen auf der Website erheben:') }}</b>
            </p>
            <p>{{ aiTrans('Diese Informationen umfassen Online-Aktivitätsprotokolle, Verkehrsinformationen (einschließlich, aber nicht beschränkt auf, IP-Adresse, Zugriffszeit, Zugriffsdatum, besuchte Web- und Mobilseite(n), verwendete Sprache, Softwareabsturzberichte und Art des verwendeten Browsers, Informationen über das von Ihnen verwendete Gerät. Einige dieser Informationen können Sie möglicherweise nicht persönlich identifizieren und stellen daher keine personenbezogenen Daten dar.') }}
            </p>
            <p><b>{{ aiTrans('Personenbezogene Daten, die wir von Ihnen erhalten:') }}</b>
                {{ aiTrans('alle personenbezogenen Daten, die Sie uns freiwillig zur Verfügung stellen, wenn Sie mit einer Handelsplattform eines Drittanbieters über uns in Kontakt treten.') }}
            </p>
            <p><b>{{ aiTrans('Personenbezogene Daten, die Sie speziell zur Übermittlung an Handelsplattformen von Drittanbietern bereitstellen:') }}</b>
                {{ aiTrans('Diese Informationen umfassen Ihren vollständigen Namen, Telefonnummer und E-Mail-Adresse.') }}</p>
            <p><b>{{ aiTrans('5. Die Zwecke der Verarbeitung personenbezogener Daten und deren Rechtsgrundlage') }}</b></p>
            <p>{{ aiTrans('Das Unternehmen verarbeitet Ihre personenbezogenen Daten zu einem oder mehreren der in diesem Abschnitt dargelegten Zwecke und gemäß der entsprechenden Rechtsgrundlage.') }}
            </p>
            <p>{{ aiTrans('Das Unternehmen wird personenbezogene Daten über Sie nicht verarbeiten, es sei denn, es gibt eine Rechtsgrundlage für diese Verarbeitung. Die Rechtsgrundlagen, gemäß denen das Unternehmen personenbezogene Daten über Sie verarbeiten kann, sind wie folgt:') }}
            </p>
            <ul>
                <li><b>{{ aiTrans('Sie haben Ihre Einwilligung zur Verarbeitung Ihrer personenbezogenen Daten zu einem oder mehreren spezifischen Zwecken gegeben. Dies bezieht sich auf Fälle, in denen Sie Ihre Daten über die Website bereitstellen, damit wir sie an eine Handelsplattform eines Drittanbieters übermitteln können.') }}</b>
                </li>
                <li><b>{{ aiTrans('Die Verarbeitung ist erforderlich, um die legitimen Interessen des Unternehmens oder eines Dritten zu verfolgen. Zum Beispiel zur Verbesserung unserer Dienste oder zur Geltendmachung oder Verteidigung rechtlicher Ansprüche.') }}</b>
                </li>
                <li><b>{{ aiTrans('Die Verarbeitung ist erforderlich, um einer rechtlichen Verpflichtung nachzukommen, der das Unternehmen unterliegt.') }}</b>
                </li>
            </ul>
            <p>{{ aiTrans('Wenn Sie weitere Informationen darüber wünschen, wie die Verarbeitung für die Verfolgung der legitimen Interessen des Unternehmens oder eines Dritten erforderlich ist, können Sie uns jederzeit kontaktieren, indem Sie eine Mitteilung an die unten angegebene E-Mail-Adresse senden.') }}
            </p>
            <p>{{ aiTrans('Die folgende Liste beschreibt die Zwecke, zu denen wir personenbezogene Daten über Sie verarbeiten können, sowie die Rechtsgrundlage für jede solche Verarbeitung:') }}
            </p>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <td></td>
                        <td><b>{{ aiTrans('Zweck') }}</b></td>
                        <td><b>{{ aiTrans('Rechtsgrundlage') }}</b></td>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>1</td>
                        <td>
                            <p><b>{{ aiTrans('Um Ihre Angaben auf Anfrage an Dritte weiterzuleiten') }}</b>
                                {{ aiTrans('um an digitale Handelsplattformen heranzutreten') }}</p>
                            <p>{{ aiTrans('Wir können personenbezogene Daten über Sie erheben, um sie Dritten zu übermitteln, wenn Sie dies ausdrücklich anfordern.') }}
                            </p>
                        </td>
                        <td>{{ aiTrans('Sie haben Ihre Einwilligung zur Verarbeitung Ihrer personenbezogenen Daten zu einem oder mehreren spezifischen Zwecken gegeben.') }}
                        </td>
                    </tr>
                    <tr>
                        <td>2</td>
                        <td>
                            <p><b>{{ aiTrans('Um auf Ihre Anfragen, Wünsche und/oder Beschwerden zu antworten') }}</b></p>
                            <p>{{ aiTrans('Die Verarbeitung personenbezogener Daten über Sie ist erforderlich, um auf Anfragen zu reagieren, die Sie bezüglich Ihrer Nutzung der Dienste haben.') }}
                            </p>
                        </td>
                        <td>{{ aiTrans('Die Verarbeitung ist erforderlich, um die legitimen Interessen des Unternehmens oder eines Dritten zu verfolgen.') }}
                        </td>
                    </tr>
                    <tr>
                        <td>3</td>
                        <td>
                            <p><b>{{ aiTrans('Um rechtlichen Verpflichtungen oder gerichtlichen oder administrativen Anordnungen nachzukommen') }}</b>
                            </p>
                            <p>{{ aiTrans('Wir verarbeiten personenbezogene Daten über Sie, um unseren verschiedenen rechtlichen Verpflichtungen nachzukommen.') }}
                            </p>
                        </td>
                        <td>{{ aiTrans('Die Verarbeitung ist erforderlich, um einer rechtlichen Verpflichtung nachzukommen, der das Unternehmen unterliegt.') }}
                        </td>
                    </tr>
                    <tr>
                        <td>4</td>
                        <td>
                            <p><b>{{ aiTrans('Um unsere Dienste zu verbessern') }}</b></p>
                            <p>{{ aiTrans('Wir können personenbezogene Daten über Sie verwenden, um unsere Dienste zu verbessern. Solche Verarbeitung umfasst unter anderem Protokolle zu Abstürzen oder andere Fehlermeldungen, die im Zusammenhang mit den Diensten erhalten wurden.') }}
                            </p>
                        </td>
                        <td>{{ aiTrans('Die Verarbeitung ist erforderlich, um die legitimen Interessen des Unternehmens oder eines Dritten zu verfolgen.') }}
                        </td>
                    </tr>
                    <tr>
                        <td>5</td>
                        <td>
                            <p><b>{{ aiTrans('Um Betrug und missbräuchliche Nutzung unserer Dienste zu verhindern') }}</b></p>
                        </td>
                        <td>{{ aiTrans('Die Verarbeitung ist erforderlich, um die legitimen Interessen des Unternehmens oder eines Dritten zu verfolgen.') }}
                        </td>
                    </tr>
                    <tr>
                        <td>6</td>
                        <td>
                            <p><b>{{ aiTrans('Um verschiedene Aktivitäten durchzuführen und aufrechtzuerhalten, die die Bereitstellung unserer Dienste unterstützen') }}</b>
                            </p>
                            <p>{{ aiTrans('Solche Aktivitäten umfassen Backoffice-Funktionen, Geschäftsentwicklungsaktivitäten, strategische Entscheidungsfindung, Überwachungsmechanismen usw.') }}
                            </p>
                        </td>
                        <td>{{ aiTrans('Die Verarbeitung ist erforderlich, um die legitimen Interessen des Unternehmens oder eines Dritten zu verfolgen.') }}
                        </td>
                    </tr>
                    <tr>
                        <td>7</td>
                        <td>
                            <p><b>{{ aiTrans('Um Analysen durchzuführen, einschließlich statistischer Analysen') }}</b></p>
                            <p>{{ aiTrans('Wir verwenden verschiedene analytische Maßnahmen (einschließlich statistischer) zur Entscheidungsfindung in verschiedenen Angelegenheiten.') }}
                            </p>
                        </td>
                        <td>{{ aiTrans('Die Verarbeitung ist erforderlich, um die legitimen Interessen des Unternehmens oder eines Dritten zu verfolgen.') }}
                        </td>
                    </tr>
                    <tr>
                        <td>8</td>
                        <td>
                            <p><b>{{ aiTrans('Um unsere und die Interessen, Rechte und Vermögenswerte Dritter zu schützen, einschließlich der Einleitung, Ausübung oder Verteidigung rechtlicher Ansprüche') }}</b>
                            </p>
                            <p>{{ aiTrans('Wir können personenbezogene Daten über Sie verarbeiten, um unsere Interessen, Rechte und Vermögenswerte oder die von Dritten gemäß geltendem Recht, Vorschriften oder Vereinbarungen zu schützen, einschließlich aller unserer Geschäftsbedingungen und Richtlinien.') }}
                            </p>
                        </td>
                        <td>{{ aiTrans('Die Verarbeitung ist erforderlich, um die legitimen Interessen des Unternehmens oder eines Dritten zu verfolgen.') }}
                        </td>
                    </tr>
                </tbody>
            </table>
            <p><b>{{ aiTrans('6. Übermittlung personenbezogener Daten an Dritte') }}</b></p>
            <p>{{ aiTrans('Das Unternehmen kann personenbezogene Daten über Sie auch mit Dritten teilen, die uns Dienstleistungen bereitstellen, wie z. B. Speicher- und Hosting-Anbieter, IP-Adresseninformationen, Analyse der Benutzererfahrung und Forschung, analytische, technische und diagnostische Dienstleistungen.') }}
            </p>
            <p>{{ aiTrans('Darüber hinaus können Sie ausdrücklich verlangen, dass wir bestimmte personenbezogene Daten über Sie an Handelsplattformen Dritter übermitteln. In solchen Fällen werden wir die personenbezogenen Daten, die Sie uns zu diesem Zweck bereitstellen, an solche Dritte weitergeben, und deren Nutzung Ihrer personenbezogenen Daten unterliegt ihren eigenen Datenschutzrichtlinien. Wir können Ihre personenbezogenen Daten mit mehreren Handelsplattformen Dritter teilen.') }}
            </p>
            <p>{{ aiTrans('Das Unternehmen kann personenbezogene Daten über Sie auch mit seinen verbundenen Unternehmen und Geschäftspartnern teilen, die dem Unternehmen Ressourcen zur Verfügung stellen, die es ermöglichen, die Qualität der Dienste und Produkte, die es seinen Nutzern anbietet, zu verbessern.') }}
            </p>
            <p>{{ aiTrans('Das Unternehmen kann personenbezogene Daten über Sie mit staatlichen, lokalen, offiziellen und regulatorischen Behörden teilen, sowie wenn eine solche Offenlegung erforderlich ist, um unsere und die Interessen, Rechte und Vermögenswerte Dritter zu schützen, einschließlich der Einleitung, Ausübung oder Verteidigung rechtlicher Ansprüche.') }}
            </p>
            <p>{{ aiTrans('Darüber hinaus können wir personenbezogene Daten über Sie potenziellen Käufern oder Investoren oder Kreditgebern des Unternehmens und/oder eines Unternehmens innerhalb der Unternehmensgruppe, zu der das Unternehmen gehört, oder im Falle einer ähnlichen Transaktion (einschließlich des Verkaufs von Vermögenswerten des Unternehmens und/oder eines Unternehmens innerhalb der Unternehmensgruppe, zu der das Unternehmen gehört) offenlegen, und/oder im Zusammenhang mit einer Fusion, Umstrukturierung, Konsolidierung oder Insolvenz des Unternehmens und/oder eines Unternehmens innerhalb der Unternehmensgruppe, zu der das Unternehmen gehört.') }}
            </p>
            <p><b>{{ aiTrans('7. Cookies und Dienstleistungen Dritter') }}</b></p>
            <p>{{ aiTrans('Wir können bestimmte Dienstleistungen Dritter nutzen, wie z. B. Analyseunternehmen oder Unternehmen, die Werbung auf unserer Website bereitstellen, die ebenfalls Cookies oder andere Technologien verwenden können, und diese Praktiken und Anbieter unterliegen ihren eigenen Richtlinien.') }}
            </p>
            <p>{{ aiTrans('Ein Cookie (das ist eine kleine Textdatei) wird auf dem Gerät installiert, über das Sie die Website besuchen oder darauf zugreifen. Die Cookies ermöglichen es, Informationen über Sie und Ihr Verhalten zu sammeln, um Ihre Benutzererfahrung zu verbessern, Ihre Präferenzen und Einstellungen zu speichern und Ihnen Produkte und Dienstleistungen anzubieten, die Sie interessieren könnten. Cookies können auch verwendet werden, um Statistiken zu sammeln und Analysen durchzuführen.') }}
            </p>
            <p>{{ aiTrans('Einige der Cookies, die wir verwenden können, sind Sitzungscookies, die vorübergehend auf Ihr Gerät heruntergeladen werden und bis zum Schließen Ihres Webbrowsers dauern, während andere persistent sind, die nach dem Ende Ihres Surfens auf der Website auf Ihrem Gerät bleiben und verwendet werden können, um die Website daran zu erinnern, dass Sie ein wiederkehrender Besucher sind, wenn Sie zur Website zurückkehren.') }}
            </p>
            <p><b>{{ aiTrans('Arten von Cookies:') }}</b></p>
            <p>{{ aiTrans('Die Cookies, die wir verwenden können, werden nach ihrer Funktionalität klassifiziert, wie folgt:') }}</p>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <td><b>{{ aiTrans('Art des Cookies') }}</b></td>
                        <td><b>{{ aiTrans('Zweck') }}</b></td>
                        <td><b>{{ aiTrans('Zusätzliche Informationen') }}</b></td>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>{{ aiTrans('Streng notwendige Cookies') }}</td>
                        <td>
                            <p>{{ aiTrans('Diese Cookies sind unbedingt erforderlich, damit Sie die Website navigieren und die von Ihnen angeforderten Funktionen nutzen können. Sie werden verwendet, um Ihnen die Inhalte, Produkte und Dienstleistungen bereitzustellen, die Sie angefordert haben.') }}
                            </p>
                            <p>{{ aiTrans('Solche Cookies sind notwendig, um Ihrem Gerät das Herunterladen oder Streamen von Informationen zu ermöglichen, damit Sie auf der Website navigieren, ihre Funktionen nutzen und zu zuvor besuchten Seiten zurückkehren können.') }}
                            </p>
                        </td>
                        <td>
                            <p>{{ aiTrans('Diese Cookies sammeln personenbezogene Daten über Sie, wie Benutzername und Datum des letzten Logins, und identifizieren Sie als eingeloggten Benutzer auf der Website.') }}
                            </p>
                            <p>{{ aiTrans('Diese Cookies werden gelöscht, wenn Sie Ihren Webbrowser schließen (Sitzungscookies).') }}
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td>{{ aiTrans('Funktionscookies') }}</td>
                        <td>{{ aiTrans('Diese Cookies werden verwendet, um Sie zu erkennen, wenn Sie zur Website zurückkehren, und ermöglichen es uns, sich an Ihre Auswahl und Präferenzen zu erinnern.') }}
                        </td>
                        <td>{{ aiTrans('Diese Cookies überstehen das Schließen Ihres Webbrowsers und halten bis zu ihrer jeweiligen Ablaufzeit an.') }}
                        </td>
                    </tr>
                    <tr>
                        <td>{{ aiTrans('Leistungscookies') }}</td>
                        <td>{{ aiTrans('Diese Cookies werden verwendet, um aggregierte Statistiken zur Leistung der Website bereitzustellen und diese Leistung zu testen und zu verbessern, um eine bessere Benutzererfahrung zu bieten. Darüber hinaus ermöglichen sie uns, analytische Funktionen auf der Website durchzuführen.') }}
                        </td>
                        <td>
                            <p>{{ aiTrans('Diese Cookies sammeln anonymisierte Daten, die sich nicht auf eine identifizierte oder identifizierbare natürliche Person beziehen.') }}
                            </p>
                            <p>{{ aiTrans('Diese Cookies haben unterschiedliche Gültigkeitsdauern; einige werden gelöscht, sobald Sie Ihren Browser schließen, während andere eine unbestimmte Gültigkeitsdauer haben.') }}
                            </p>
                        </td>
                    </tr>
                </tbody>
            </table>
            <p>{{ aiTrans('Blockieren und Entfernen von Cookies') }}</p>
            <p>{{ aiTrans('Sie können Ihre Browsereinstellungen ändern, um einige oder alle Cookies zu blockieren und zu löschen. Bitte siehe die folgenden Links zu Anleitungen, wie dies in Bezug auf einige der beliebtesten Webbrowser zu tun ist:') }}
            </p>
            <ul>
                <li>{{ aiTrans('Firefox') }}</li>
                <li>{{ aiTrans('Microsoft Edge') }}</li>
                <li>{{ aiTrans('Google Chrome') }}</li>
                <li>{{ aiTrans('Safari') }}</li>
            </ul>
            <p>{{ aiTrans('Bitte beachten Sie jedoch, dass einige oder alle Funktionen und Funktionalitäten der Website möglicherweise nicht wie beabsichtigt funktionieren, wenn Sie dies tun.') }}
            </p>
            <p><b>{{ aiTrans('ONLINE-TRACKING-HINWEIS') }}</b></p>
            <p><b>{{ aiTrans('ZUR ZEIT UNTERSTÜTZT DIESES SERVICE KEINE DO-NOT-TRACK-SIGNALE.') }}</b></p>
            <p><b>{{ aiTrans('8. Aufbewahrung personenbezogener Daten über Sie') }}</b></p>
            <p>{{ aiTrans('Das Unternehmen wird personenbezogene Daten über Sie so lange aufbewahren, wie dies erforderlich ist, um die Zwecke der Verarbeitung der personenbezogenen Daten, wie in dieser Richtlinie dargelegt, zu erfüllen, oder für einen längeren Zeitraum, wie es die geltenden Gesetze, Vorschriften, Richtlinien und Anordnungen, die auf uns zutreffen, erfordern.') }}
            </p>
            <p>{{ aiTrans('Wir werden Ihre Informationen für einen Zeitraum von 12 Monaten mit Handelsplattformen Dritter teilen und werden dies mit Ihrer Zustimmung für weitere 12 Monate tun.') }}
            </p>
            <p>{{ aiTrans('Um sicherzustellen, dass personenbezogene Daten über Sie nicht länger aufbewahrt werden, als erforderlich, überprüfen wir regelmäßig die von uns aufbewahrten personenbezogenen Daten, um zu prüfen, ob diese gelöscht werden können.') }}
            </p>
            <p><b>{{ aiTrans('9. Übertragung personenbezogener Daten in ein Drittland oder an eine internationale Organisation') }}</b>
            </p>
            <p>{{ aiTrans('Personenbezogene Daten über Sie können in ein Drittland (d. h. Jurisdiktionen, die nicht diejenige sind, in der Sie wohnen) oder an internationale Organisationen übertragen werden. In solchen Fällen wird das Unternehmen angemessene Schutzmaßnahmen ergreifen, um den Schutz personenbezogener Daten über Sie zu gewährleisten und sicherzustellen, dass durchsetzbare Rechte der betroffenen Personen und wirksame Rechtsbehelfe für betroffene Personen zur Verfügung stehen.') }}
            </p>
            <p>{{ aiTrans('Wenn Sie ein Bewohner des EWR (Europäischer Wirtschaftsraum) sind, beachten Sie bitte, dass diese Schutzmaßnahmen und -vorkehrungen verfügbar sein werden, wenn eine der folgenden Bedingungen erfüllt ist:') }}
            </p>
            <ul>
                <li>{{ aiTrans('Die Übertragung erfolgt in ein Drittland oder an eine internationale Organisation, für die die EU-Kommission entschieden hat, dass sie ein angemessenes Schutzniveau für die personenbezogenen Daten bietet, die gemäß Artikel 45(3) der Verordnung (EU) 2016/679 des Europäischen Parlaments und des Rates vom 27. April 2016 (die „DSGVO“) übertragen werden.') }}
                </li>
                <li>{{ aiTrans('Die Übertragung erfolgt gemäß einem rechtlich bindenden und durchsetzbaren Instrument zwischen öffentlichen Behörden oder Stellen gemäß Artikel 46(2)(a) der DSGVO; oder') }}
                </li>
                <li>{{ aiTrans('Die Übertragung erfolgt gemäß den Standardvertragsklauseln, die von der EU-Kommission gemäß Artikel 46(2)(c) der DSGVO angenommen wurden. Die von der EU-Kommission angenommenen Klauseln sind unter https://ec.europa.eu/info/law/law-topic/data-protection/data-transfers-outside-eu/model-contracts-transfer-personal-data-third-countries_en einsehbar.') }}
                </li>
            </ul>
            <p>{{ aiTrans('Sie können vom Unternehmen verlangen, dass es Ihnen Einzelheiten über die Maßnahmen zur Verfügung stellt, die es zum Schutz der personenbezogenen Daten über Sie ergriffen hat, die in ein Drittland oder an eine internationale Organisation übertragen wurden, indem Sie eine E-Mail an folgende Adresse senden:') }}
                <a href="mail:support{{ '@' . $website_title }}"
                    class="accent mail-link">support{{ '@' . $website_title }}<span class="domain"></span></a>
            </p>
            <p><b>{{ aiTrans('10. Schutz personenbezogener Daten über Sie') }}</b></p>
            <p>{{ aiTrans('Wir setzen geeignete technische und organisatorische Maßnahmen um, um ein angemessenes Sicherheitsniveau für personenbezogene Daten zu gewährleisten, wobei wir die Risiken berücksichtigen, die durch die Verarbeitung entstehen, insbesondere durch unbeabsichtigte oder unrechtmäßige Zerstörung, Verlust, Änderung, unbefugte Offenlegung oder Zugriff auf personenbezogene Daten, die übermittelt, gespeichert oder anderweitig verarbeitet werden.') }}
            </p>
            <p>{{ aiTrans('Wir können nicht garantieren und vertreten nicht, dass es keine fehlerfreien Leistungen in Bezug auf den Schutz Ihrer personenbezogenen Daten geben wird, und wir sind nicht haftbar für indirekte, zufällige, Folgeschäden oder Strafen, die sich aus der Nutzung oder Offenlegung personenbezogener Daten über Sie ergeben, einschließlich, aber nicht beschränkt auf die Offenlegung personenbezogener Daten aufgrund von Übertragungsfehlern, unbefugtem Zugriff Dritter oder anderen Ursachen, die außerhalb unserer zumutbaren Kontrolle liegen.') }}
            </p>
            <p>{{ aiTrans('Aufgrund rechtlicher oder anderer Verpflichtungen, die außerhalb unserer Kontrolle liegen, kann es erforderlich sein, personenbezogene Daten über Sie an Dritte zu übermitteln, wie z. B. an öffentliche Behörden. In solchen Fällen haben wir nur begrenzte Kontrolle über das Niveau des Schutzes, das Dritte für die personenbezogenen Daten über Sie bieten.') }}
            </p>
            <p>{{ aiTrans('Jede Übertragung personenbezogener Daten über das Internet kann nicht vollständig gesichert werden. Daher kann das Unternehmen den Schutz personenbezogener Daten über Sie bei der Übertragung über das Internet an uns nicht gewährleisten.') }}
            </p>
            <p><b>{{ aiTrans('11. Links zu Websites Dritter') }}</b></p>
            <p>{{ aiTrans('Die Website kann Links zu Websites und/oder Anwendungen Dritter bereitstellen. Das Unternehmen kontrolliert solche Websites und Anwendungen nicht, noch die Erhebung und/oder Verarbeitung personenbezogener Daten über Sie durch solche Websites und Anwendungen, und wir sind nicht verantwortlich für solche Websites und Anwendungen, noch für deren Datenschutz- und Datenschutzrichtlinien und -praktiken. Diese Richtlinie gilt nicht für Handlungen, die über solche Websites und/oder Anwendungen durchgeführt werden.') }}
            </p>
            <p>{{ aiTrans('Wann immer Sie auf solche Websites und/oder Anwendungen Dritter zugreifen, empfehlen wir Ihnen, deren Datenschutzrichtlinien sorgfältig zu überprüfen, bevor Sie solche Websites und/oder Anwendungen nutzen und bevor Sie personenbezogene Daten über Sie offenlegen.') }}
            </p>
            <p><b>{{ aiTrans('13. Ihre Rechte in Bezug auf die personenbezogenen Daten über Sie') }}</b></p>
            <p>{{ aiTrans('Im Allgemeinen haben Sie das Recht, von uns zu bestätigen, ob personenbezogene Daten über Sie verarbeitet werden, um diese Daten einzusehen, den Inhalt zu berichtigen, sofern dies zutreffend ist, und die personenbezogenen Daten, die nicht mehr von uns benötigt werden, zu löschen. Sie können auch Ihre Zustimmung zu bestimmten Verarbeitungen Ihrer personenbezogenen Daten einschränken.') }}
            </p>
            <p><b>{{ aiTrans('Wenn Sie ein EWR-Bewohner sind, lesen Sie bitte diesen Abschnitt unten:') }}</b></p>
            <p>{{ aiTrans('Sie haben die folgenden Rechte in Bezug auf die personenbezogenen Daten über Sie. Um diese Rechte auszuüben, können Sie einen Antrag zur Ausübung Ihrer Rechte an die folgende E-Mail-Adresse senden:') }}
            </p>
            <p><b>{{ aiTrans('Recht auf Zugang') }}</b></p>
            <p>{{ aiTrans('Sie haben das Recht, vom Unternehmen eine Bestätigung zu erhalten, ob personenbezogene Daten über Sie verarbeitet werden oder nicht, und, falls dies der Fall ist, Zugang zu den personenbezogenen Daten und folgenden Informationen zu erhalten: (1) die Zwecke der Verarbeitung; (2) die Kategorien personenbezogener Daten, die betroffen sind; (3) die Empfänger oder Kategorien von Empfängern, denen die personenbezogenen Daten offengelegt wurden oder offengelegt werden, insbesondere Empfänger in Drittstaaten außerhalb des Europäischen Wirtschaftsraums (EWR) oder internationale Organisationen; (4) wenn möglich, der vorgesehene Zeitraum, für den die personenbezogenen Daten gespeichert werden, oder, wenn dies nicht möglich ist, die Kriterien, die zur Festlegung dieses Zeitraums verwendet wurden; (5) das Bestehen des Rechts, vom Unternehmen die Berichtigung oder Löschung personenbezogener Daten oder die Einschränkung der Verarbeitung personenbezogener Daten über Sie zu verlangen oder der Verarbeitung solcher Daten zu widersprechen; (6) das Recht, bei einer Aufsichtsbehörde Beschwerde einzureichen; (7) wenn die personenbezogenen Daten nicht bei Ihnen erhoben wurden, alle verfügbaren Informationen über die Quelle; (8) das Bestehen von Profiling; und (9) wenn personenbezogene Daten in ein Drittland außerhalb des EWR oder an eine internationale Organisation übertragen werden, die angemessenen Schutzmaßnahmen, die für die Übertragung gelten.') }}
            </p>
            <p>{{ aiTrans('Das Unternehmen stellt eine Kopie der personenbezogenen Daten, die verarbeitet werden, zur Verfügung und kann eine angemessene Gebühr für weitere Kopien verlangen, die von Ihnen angefordert werden. Wenn Sie den Antrag elektronisch stellen und, sofern nicht anders von Ihnen gewünscht, wird die Information in einem allgemein verwendeten elektronischen Format bereitgestellt.') }}
            </p>
            <p>{{ aiTrans('Das Recht auf Erhalt einer Kopie der personenbezogenen Daten darf die Rechte und Freiheiten anderer nicht beeinträchtigen. Daher kann das Unternehmen Ihren Antrag nicht erfüllen oder nur in begrenztem Umfang erfüllen, wenn der Antrag die Rechte und Freiheiten anderer schädigt.') }}
            </p>
            <p><b>{{ aiTrans('Recht auf Berichtigung') }}</b></p>
            <p>{{ aiTrans('Sie haben das Recht, vom Unternehmen die Berichtigung ungenauer personenbezogener Daten über Sie zu verlangen. Unter Berücksichtigung der Zwecke der Verarbeitung haben Sie das Recht, unvollständige personenbezogene Daten über Sie zu vervollständigen, einschließlich durch Bereitstellung einer ergänzenden Erklärung.') }}
            </p>
            <p><b>{{ aiTrans('Recht auf Löschung') }}</b></p>
            <p>{{ aiTrans('Die folgenden Gründe gelten: (a) die personenbezogenen Daten sind für den Zweck, für den sie erhoben oder anderweitig verarbeitet wurden, nicht mehr erforderlich; (b) Sie ziehen Ihre Einwilligung zurück, auf der die Verarbeitung basiert, und es gibt keine andere rechtliche Grundlage für die Verarbeitung; (c) Sie widersprechen jederzeit aus Gründen, die sich auf Ihre besondere Situation beziehen, der Verarbeitung personenbezogener Daten über Sie, die auf den von uns oder einem Dritten verfolgten berechtigten Interessen basiert, und es gibt keine überwiegenden berechtigten Gründe für die Verarbeitung; (d) Sie widersprechen der Verarbeitung personenbezogener Daten über Sie zu Marketingzwecken; (e) die personenbezogenen Daten wurden rechtswidrig verarbeitet; oder (f) die personenbezogenen Daten über Sie müssen zur Einhaltung einer rechtlichen Verpflichtung im Recht der Europäischen Union oder eines Mitgliedstaats gelöscht werden, der das Unternehmen unterliegt.') }}
            </p>
            <p>{{ aiTrans('Dieses Recht ist nicht anwendbar, soweit die Verarbeitung erforderlich ist (a) zur Einhaltung einer rechtlichen Verpflichtung, die die Verarbeitung durch das Recht der Europäischen Union oder eines Mitgliedstaats, dem das Unternehmen unterliegt, erfordert; oder (b) zur Geltendmachung, Ausübung oder Verteidigung rechtlicher Ansprüche.') }}
            </p>
            <p><b>{{ aiTrans('Recht auf Einschränkung der Verarbeitung') }}</b></p>
            <p>{{ aiTrans('Sie haben das Recht, vom Unternehmen die Einschränkung der Verarbeitung personenbezogener Daten über Sie zu verlangen, wenn einer der folgenden Gründe zutrifft: (a) die Richtigkeit der personenbezogenen Daten wird von Ihnen bestritten, für einen Zeitraum, der es dem Unternehmen ermöglicht, die Richtigkeit der personenbezogenen Daten über Sie zu überprüfen; (b) die Verarbeitung ist rechtswidrig, und Sie widersprechen der Löschung der personenbezogenen Daten über Sie und verlangen stattdessen die Einschränkung ihrer Nutzung; (c) das Unternehmen benötigt die personenbezogenen Daten über Sie nicht mehr für die Zwecke der Verarbeitung, jedoch sind diese von Ihnen zur Geltendmachung, Ausübung oder Verteidigung rechtlicher Ansprüche erforderlich; (d) wenn die Verarbeitung personenbezogener Daten über Sie für die Verfolgung der berechtigten Interessen des Unternehmens oder eines Dritten erforderlich ist, es sei denn, wir können zwingende berechtigte Gründe für die Verarbeitung nachweisen, die Ihre Interessen, Rechte und Freiheiten überwiegen, oder zur Geltendmachung, Ausübung oder Verteidigung rechtlicher Ansprüche; oder (e) wenn die personenbezogenen Daten über Sie zu Marketingzwecken, einschließlich Profiling, verarbeitet werden, soweit es sich auf eine solche Direktvermarktung bezieht.') }}
            </p>
            <p>{{ aiTrans('Wenn die Verarbeitung personenbezogener Daten über Sie auf Ihren Antrag hin eingeschränkt wurde, dürfen diese personenbezogenen Daten, mit Ausnahme der Speicherung, nur mit Ihrer Zustimmung oder zur Geltendmachung, Ausübung oder Verteidigung rechtlicher Ansprüche oder zum Schutz der Rechte einer anderen natürlichen oder juristischen Person oder aus Gründen des wichtigen öffentlichen Interesses der Europäischen Union oder eines Mitgliedstaats verarbeitet werden.') }}
            </p>
            <p><b>{{ aiTrans('Recht auf Datenübertragbarkeit') }}</b></p>
            <p>{{ aiTrans('Sie haben das Recht, die personenbezogenen Daten über Sie, die Sie dem Unternehmen zur Verfügung gestellt haben, in einem strukturierten, allgemein verwendeten und maschinenlesbaren Format zu erhalten, sowie das Recht, diese personenbezogenen Daten an einen anderen Verantwortlichen zu übermitteln, wenn (a) die Verarbeitung auf Ihrer Einwilligung oder auf einem Vertrag beruht, zu dem Sie Partei sind, und (b) die Verarbeitung durch automatisierte Mittel erfolgt.') }}
            </p>
            <p>{{ aiTrans('Bei Ausübung Ihres Rechts auf Datenübertragbarkeit haben Sie das Recht, dass die personenbezogenen Daten über Sie direkt vom Unternehmen an einen anderen Verantwortlichen übermittelt werden, wenn dies technisch machbar ist. Die Ausübung Ihres Rechts auf Datenübertragbarkeit berührt nicht Ihre und die Rechte des Unternehmens gemäß Ihrem Recht auf Löschung. Darüber hinaus darf das Recht auf Datenübertragbarkeit nicht die Rechte und Freiheiten anderer beeinträchtigen.') }}
            </p>
            <p><b>{{ aiTrans('Recht auf Widerspruch') }}</b></p>
            <p>{{ aiTrans('Sie haben das Recht, jederzeit, aus Gründen, die sich auf Ihre besondere Situation beziehen, der Verarbeitung personenbezogener Daten über Sie, die auf den von uns oder einem Dritten verfolgten berechtigten Interessen beruht, zu widersprechen, einschließlich Profiling auf der Grundlage solcher berechtigter Interessen. In einem solchen Fall werden wir die personenbezogenen Daten über Sie nicht weiterverarbeiten, es sei denn, wir können zwingende berechtigte Gründe für die Verarbeitung nachweisen, die Ihre Interessen, Rechte und Freiheiten überwiegen oder zur Geltendmachung, Ausübung oder Verteidigung rechtlicher Ansprüche.') }}
            </p>
            <p>{{ aiTrans('Sie haben das Recht, jederzeit der Verarbeitung personenbezogener Daten über Sie zu Marketingzwecken, einschließlich Profiling, soweit es sich auf eine solche Direktvermarktung bezieht, zu widersprechen.') }}
            </p>
            <p><b>{{ aiTrans('Recht auf Widerruf der Einwilligung') }}</b></p>
            <p>{{ aiTrans('Sie können Ihre Einwilligung, die Sie uns zur Verarbeitung personenbezogener Daten über Sie gegeben haben, jederzeit widerrufen, ohne dass dies die Rechtmäßigkeit der Verarbeitung auf Grundlage Ihrer Einwilligung vor deren Widerruf beeinträchtigt.') }}
            </p>
            <p><b>{{ aiTrans('Recht, Beschwerde bei einer Aufsichtsbehörde einzureichen') }}</b></p>
            <p>{{ aiTrans('Sie haben das Recht, Beschwerde bei einer Aufsichtsbehörde einzureichen, die von einem Mitgliedstaat eingerichtet wurde, um die grundlegenden Rechte und Freiheiten natürlicher Personen im Zusammenhang mit der Verarbeitung personenbezogener Daten innerhalb der Europäischen Union zu schützen.') }}
            </p>
            <p>{{ aiTrans('Ihre Rechte in Bezug auf personenbezogene Daten über Sie, wie in diesem Abschnitt 13 dargelegt, können durch das Recht der Europäischen Union oder eines Mitgliedstaats, dem das Unternehmen unterliegt, eingeschränkt werden.') }}
            </p>
            <p>{{ aiTrans('Wir werden Ihnen die angeforderten Informationen gemäß Ihren in diesem Abschnitt 13 dargelegten Rechten unverzüglich und auf jeden Fall innerhalb eines Monats nach Eingang des Antrags zur Verfügung stellen. Dieser Zeitraum kann um zwei weitere Monate verlängert werden, wenn dies erforderlich ist, wobei die Komplexität und die Anzahl der Anträge berücksichtigt werden. Wir werden Sie innerhalb eines Monats nach Eingang Ihres Antrags über eine solche Verlängerung informieren, zusammen mit den Gründen für die Verzögerung.') }}
            </p>
            <p>{{ aiTrans('Die Informationen, die gemäß Ihren in diesem Abschnitt 13 dargelegten Rechten angefordert werden, werden kostenlos bereitgestellt, sofern in diesem Abschnitt 13 nichts anderes angegeben ist. Wenn Anträge offensichtlich unbegründet oder übermäßig sind, insbesondere aufgrund ihrer sich wiederholenden Natur, können wir entweder (a) eine angemessene Gebühr verlangen, wobei die Verwaltungskosten für die Bereitstellung der Informationen oder Kommunikation oder die Ergreifung der angeforderten Maßnahmen berücksichtigt werden; oder (b) uns weigern, dem Antrag nachzukommen.') }}
            </p>
            <p>{{ aiTrans('Das Unternehmen kann von Ihnen verlangen, dass Sie zusätzliche Informationen bereitstellen, die erforderlich sind, um Ihre Identität zu bestätigen, um Ihren Antrag gemäß Ihren in diesem Abschnitt 13 dargelegten Rechten zu erfüllen, wenn wir angemessene Zweifel an der Identität der natürlichen Person haben, die den Antrag stellt.') }}
            </p>
            <p><b>{{ aiTrans('12. Änderungen dieser Richtlinie') }}</b></p>
            <p>{{ aiTrans('Wir können von Zeit zu Zeit die Bestimmungen dieser Richtlinie ändern. Wenn wir diese Richtlinie ändern, werden wir Sie über solche Änderungen informieren, indem wir die aktualisierte Richtlinie auf der Website veröffentlichen. Darüber hinaus werden wir uns bemühen, Sie über wesentliche Änderungen dieser Richtlinie durch Kommunikationsmittel zu informieren, die wir für angemessen halten, um Sie über solche Änderungen zu informieren, und durch die Veröffentlichung einer Mitteilung über solche Änderungen auf der Website. Sofern nicht anders angegeben, treten alle Änderungen mit der Veröffentlichung der aktualisierten Richtlinie auf unserer Website in Kraft.') }}
            </p>

        </div>
    </section>
@endsection
