@extends('layouts.app')

@push('meta')
    <title>{{ "$website_title | Stránka O Podmínkách Uživatele" }}</title>
    <meta name="description" content="{{ "Vhodné je přečíst si podmínky použití $website_title, které formulují vaše práva a zaručují bezpečné a efektivní provedení našich služeb." }}" />
@endpush
@section('content')
<div class="container page-inner pt-5">
        <h1>{{aitrans('Podmínky použití')}}</h1>
        <main>
            <p><span style="font-weight: 400;">{{aitrans('Poskytovatel (dále jen “Společnost“, “nás“, “naše“ nebo “my“) poskytuje v zastoupení prostřednictvím svého určeného softwaru a webových stránek (dále jen “Webové stránky“) určité marketingové, reklamní, propagační a související služby (dále jen “Služba“; uživatelé Služby budou označováni jako “Uživatelé“, “vy“ nebo “váš“). Tyto Podmínky použití (dále jen “Podmínky“) upravují přístup a používání Webových stránek a Služeb uživateli. Uživatelé musí souhlasit s těmito Podmínkami před použitím Webových stránek.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Přečtěte si tyto Podmínky pečlivě. Tyto Podmínky upravují váš přístup k Webovým stránkám a jejich používání. Přístupem, registrací k použití, stahováním, sdílením nebo jiným způsobem používáním Webových stránek nebo používáním jakýchkoliv skriptů softwaru, které poskytujeme za účelem zpřístupnění nebo zpřístupnění Webových stránek, vyjadřujete svůj souhlas jak s těmito Podmínkami, tak s našimi Zásadami ochrany osobních údajů, které mohou být občas změněny nebo jinak upraveny podle našeho výhradního uvážení. Vaše pokračující používání Webových stránek se bude považovat za souhlas s takto upravenými nebo aktualizovanými podmínkami.')}}</span><span style="font-weight: 400;">{{aitrans('Pokud s těmito Podmínkami nesouhlasíte, prosím, neklikněte na “PŘIJMOUT” a nepoužívejte Webové stránky.')}}</span></p>
            <p><strong>{{aitrans('Webové stránky')}}</strong> {{ aiTrans(
                'odkazují na [website_title], přístupné z',
                $locale,
                ['website_title' => $website_title],
            ) }} <a href="{{ route('home', $country) }}">{{$website_title}}</a></p>
            <div id="toc_container" class="no_bullets">
                <ul class="toc_list">
                    <ul>
                        <li><a href="#1_Use_of_Website_and_Services"><span class="toc_number toc_depth_2">0.1</span> {{aitrans('1. Použití Webových stránek a Služeb')}}</a></li>
                    </ul>
                    <li><a href="#2_Restrictions"><span class="toc_number toc_depth_1">1</span>{{aitrans(' 2. Omezení')}}</a></li>
                    <li><a href="#3_Promotional_Materials_and_Newsletters"><span class="toc_number toc_depth_1">2</span>{{aitrans(' 3. Propagační materiály a zpravodaje')}}</a></li>
                    <li><a href="#4_Intellectual_Property"><span class="toc_number toc_depth_1">3</span>{{aitrans(' 4. Duševní vlastnictví')}}</a></li>
                    <li><a href="#5_Privacy"><span class="toc_number toc_depth_1">4</span>{{aitrans(' 5. Ochrana osobních údajů')}}</a></li>
                    <li><a href="#6_Links"><span class="toc_number toc_depth_1">5</span>{{aitrans(' 6. Odkazy')}}</a></li>
                    <li><a href="#7_Prohibited_Uses"><span class="toc_number toc_depth_1">6</span>{{aitrans(' 7. Zakázané použití')}}</a></li>
                    <li><a href="#8_Support"><span class="toc_number toc_depth_1">7</span>{{aitrans(' 8. Podpora')}}</a></li>
                    <li><a href="#9_Disclaimers"><span class="toc_number toc_depth_1">8</span>{{aitrans(' 9. Zřeknutí se odpovědnosti')}}</a></li>
                    <li><a href="#10_Limitation_of_Liability"><span class="toc_number toc_depth_1">9</span>{{aitrans(' 10. Omezení odpovědnosti')}}</a></li>
                    <li><a href="#11_Indemnification"><span class="toc_number toc_depth_1">10</span>{{aitrans(' 11. Odškodnění')}}</a></li>
                    <li><a href="#12_Miscellaneous"><span class="toc_number toc_depth_1">11</span>{{aitrans(' 12. Různé')}}</a></li>
                </ul>
            </div>
            <h5><span id="1_Use_of_Website_and_Services"><b>{{aitrans('1. Použití Webových stránek a Služeb')}}</b></span></h5>
            <p><span style="font-weight: 400;">{{aitrans('S výhradou podmínek uvedených zde můžete přistupovat k Webovým stránkám a používat je za účelem využití Služeb na neexkluzivním základě. Uznáváte, že Společnost může, dle vlastního uvážení a kdykoliv, upravit, aktualizovat nebo jinak změnit Webové stránky nebo Služby, včetně přerušení poskytování jakékoli části nebo všech Webových stránek a/nebo Služeb nebo úpravy či odstranění jakéhokoliv obsahu dostupného prostřednictvím Webových stránek nebo Služeb, bez předchozího upozornění.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Použití Webových stránek a Služeb je neplatné, kde je to zakázáno. Používáním Webových stránek a Služeb prohlašujete a zaručujete, že: (a) jakékoliv informace, které odešlete (je-li to relevantní), jsou pravdivé a přesné; (b) udržíte přesnost těchto informací; (c) jste alespoň ve věku zletilosti ve vaší jurisdikci; a (d) vaše použití Webových stránek nebo Služeb neporušuje ani nepodporuje porušení jakéhokoliv platného zákona nebo předpisu nebo jakékoli právní či smluvní povinnosti, kterou máte vůči třetí straně, a máte a budete po celou dobu dodržovat všechny platné zákony, pravidla a předpisy v souvislosti s vaším používáním Služeb a Webových stránek, jakýchkoli služeb zajištěných prostřednictvím Služeb a Webových stránek, včetně bez omezení takových služeb souvisejících jakýmikoliv způsobem s Produkty nebo Třetími stranami, jak jsou tyto pojmy zde definovány.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Podsekce (a)-(d) budou společně označovány jako')}} </span><b>{{aitrans('“Závazky a záruky uživatelů“')}}</b><span style="font-weight: 400;">.</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Používáním Služeb nebo Webových stránek chápete a souhlasíte, že Společnost může dle vlastního uvážení, ale není povinna, ověřit, zda jakékoliv nebo všechny Závazky a záruky uživatelů jsou splněny jakýmkoli Uživatelem, a dále souhlasíte, že Společnost nenese odpovědnost za zajištění splnění Závazků a záruk uživatelů nebo za jakékoli selhání pozastavit, ukončit nebo zabránit používání Služeb nebo Webových stránek uživateli, kteří nesplňují Závazky a záruky uživatelů. Chápete, že jste výhradně odpovědní za vlastní hodnocení, rozhodnutí a posouzení ohledně toho, zda se zapojit do jakýchkoli Třetích stran nebo jinak interagovat s jakýmikoli Třetími stranami jakýmkoli způsobem. Pokud se dozvíte o jakémkoli porušení Závazků a záruk uživatelů, doporučuje se to nahlásit Společnosti.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Společnost si vyhrazuje právo neposkytnout vám žádné Služby s nebo bez upozornění dle svého výhradního uvážení, ať už se dozví o jakémkoli porušení Závazků a záruk uživatelů (buď zprávami poskytnutými jí jinými Uživatel, nebo jakýmikoli jinými prostředky) vámi nebo jakýmikoli jinými Uživateli, nebo z jakéhokoli jiného důvodu. Aniž by tím byla dotčena výše uvedená ustanovení, Společnost výslovně odmítá a vy výslovně osvobozujete Společnost od jakékoli a veškeré odpovědnosti jakéhokoli druhu za jakékoli kontroverze, nároky, žaloby, zranění, ztráty, újmy a/nebo škody vyplývající a/nebo jakýmkoli způsobem související s: (i) jakoukoli nepřesností, neaktuálností nebo neúplností zastoupení Uživatele nebo Třetí strany; a (ii) nepravdivými prohlášeními a/nebo zkresleními, které učinily jakékoli Třetí strany nebo jiné Uživatele, Produkty nebo jinak. Používáním Webových stránek a Služeb chápete a souhlasíte, že Služby nabízejí pouze platformu určenou k tomu, aby pomohla Uživatelům dosáhnout, zakoupit a/nebo používat různé produkty a služby poskytované třetími dodavateli a/nebo poskytovateli služeb prostřednictvím reklam nebo propagací, které provozujeme (dále jen “Produkty” a “Třetí strany”, respektive).')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Chápete a souhlasíte, že Společnost: (a) nezaměstnává, nedoporučuje ani neschvaluje jakékoli Třetí strany nebo Produkty, jak je relevantní, nebo jakoukoli související stranu a nemá žádnou kontrolu nad činnostmi nebo opomenutími jakékoli Třetí strany, jejich podniky, jejich produkty nebo služby; (b) nedává žádná prohlášení ani záruky ohledně Třetích stran a Produktů, včetně jejich kvality, cen, kompatibility, dostupnosti nebo jakýchkoli dalších vlastností, ani ohledně vašich interakcí nebo obchodování s jakýmikoli Třetími stranami; (c) nedává žádná prohlášení ani záruky ohledně vlastnických práv nebo jiných práv či vlastností nebo regulačních aspektů souvisejících s Produkty, včetně jakýchkoli potřebných povolení, povolení nebo licencí pro nahrávání, sdílení nebo jinak zpřístupnění a pro používání, prodej a nákup takových Produktů; a (d) není odpovědná za výkon nebo chování jakéhokoli Uživatele nebo jiných třetích stran jakýmikoliv způsoby, které používají nebo používali Služby a/nebo na nebo mimo Webové stránky. Společnost není povinna kontrolovat ani jinak ověřovat jakékoli informace týkající se Třetích stran a/nebo Uživatelů, Produktů nebo jakýchkoli dalších funkcí souvisejících s Webovými stránkami nebo Službami, a proto byste měli být opatrní a provést vlastní vyšetřování a kontroly před tím, než se zapojíte s někým prostřednictvím Služeb nebo Webových stránek nebo jinak interagujete s někým.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Společnost výslovně odmítá a vy výslovně osvobozujete Společnost od jakékoli a veškeré odpovědnosti jakéhokoli druhu za jakékoli kontroverze, nároky, žaloby, zranění, ztráty, újmy a/nebo škody vyplývající a/nebo jakýmkoli způsobem související s Třetími stranami, Produkty, Službami a Webovými stránkami nebo vašimi interakcemi nebo obchodováním s jakýmikoli Třetími stranami, včetně, ale bez omezení, jakýchkoli činů a/nebo opomenutí Třetích stran jakýmikoliv způsoby souvisejících nebo připojených k Službám nebo Webovým stránkám. Používáním Služeb nebo Webových stránek potvrzujete, že jste výhradně odpovědní za takové použití a spojení, interakce, nákupy nebo jakékoli jiné akce, které provedete, a že veškeré používání Služeb nebo Webových stránek je na vaše výhradní riziko. Pro vyloučení jakýchkoli pochybností, Společnost neprodává, neuděluje licence ani jinak neposkytuje žádné Produkty nebo služby (kromě Služeb) a nebude mít žádnou odpovědnost za jakékoli Produkty nebo služby zakoupené vámi od jakékoli Třetí strany, včetně bez omezení, pokud jde o jakoukoli podporu a údržbu, závady, chyby, selhání, škody nebo náklady jakéhokoli druhu.')}}</span></p>
            <h4><span id="2_Restrictions"><span style="font-weight: 400;">{{aitrans('2. Omezení')}}</span></span></h4>
            <p><span style="font-weight: 400;">{{aitrans('Aniž by tím byla dotčena ustanovení oddílu 1, nesmíte a nesmíte povolit jakékoli třetí straně: (a) dekompilovat nebo se pokusit najít základní kód Webových stránek nebo Služeb; (b) používat Webové stránky nebo Služby v rozporu s jakýmikoliv platnými zákony nebo předpisy, včetně, ale nikoli omezeno na, zveřejňování, publikování, sdílení nebo jinak přenášení jakýchkoli nelegálních nebo urážlivých materiálů; (c) kopírovat, upravovat nebo vytvářet odvozené práce Webových stránek, Služeb nebo obsahu jakéhokoli z Webových stránek nebo Služeb; (d) pokusit se deaktivovat nebo obcházet jakýkoli mechanismus zabezpečení nebo kontrolního přístupu Webových stránek nebo Služeb; (e) navrhnout nebo pomoci při navrhování cheatů, exploitů, automatizačního softwaru, botů, hacků, módů nebo jakéhokoli jiného neoprávněného softwaru třetí strany k modifikaci nebo narušení Webových stránek nebo Služeb; (f) používat Webové stránky nebo Služby nebo se zapojit s jinými Uživatel pro jakýkoli účel, který je v rozporu s jakýmikoli platnými zákony nebo předpisy; (g) pokusit se získat neoprávněný přístup k Webovým stránkám nebo Službám, jiným uživatelským účtům, jak je definováno níže, nebo jinému zařízení, počítačovému systému, telefonním systémům nebo sítím připojeným k Webovým stránkám nebo Službám; a (h) sklízet nebo jinak shromažďovat informace o Uživatelích bez jejich souhlasu.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Pokud zveřejníte, publikujete, sdílíte nebo jinak přenesete jakýkoli obsah prostřednictvím Webových stránek a/nebo používáním Služeb, prohlašujete a zaručujete, že takový obsah poskytuje přesný a úplný obraz jakýchkoli produktů nebo služeb, které jsou zde popsány, vyhovuje těmto Podmínkám a neporušuje: (a) duševní vlastnictví, morální nebo reklamní práva jakékoli třetí strany; (b) neobsahuje žádný pomlouvačný, urážlivý, obscénní, sexuálně sugestivní nebo jinak urážlivý obsah (včetně materiálu, který podporuje nebo oslavuje nenávist, násilí nebo bigotnost); (c) neobsahuje žádné červy, viry nebo jiný škodlivý software; (d) neporušuje jakýkoli platný zákon nebo předpis, včetně jakéhokoliv zákona nebo předpisu týkajícího se reklamy nebo marketingu; a (e) neprovádí žádnou akci, která by ukládala nepřiměřenou nebo nepřiměřeně velkou zátěž na naši infrastrukturu.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Zveřejněním, nahráním, publikováním, sdílením nebo jiným přenosem jakéhokoli obsahu pomocí Webových stránek nebo Služeb tímto neodvolatelně udělujete Společnosti a jakýmikoli jejími dceřinými společnostmi a/nebo sublicencemi celosvětovou, nevýhradní, trvalou, bezplatnou licenci na publikaci, sdílení, zobrazování a jinak přenášení takového obsahu jakoukoli rozumnou formou podle vlastního uvážení Společnosti. Společnost si vyhrazuje právo odstranit, pozastavit přístup nebo trvale odstranit jakýkoli obsah dle svého výhradního uvážení bez předchozího upozornění, včetně, ale nikoli omezeno na, jakýkoli obsah, který porušuje výše uvedené záruky nebo obchodní zájmy Společnosti, a vy nebudete mít žádná práva ani nároky ohledně jakýchkoli takových rozhodnutí a akcí.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Společnost není a nebude odpovědná za jakýkoli obsah poskytnutý, zveřejněný, nahraný, sdílený nebo jinak zpřístupněný Uživately, jakékoli produkty nebo služby související s takovým obsahem poskytnutým, zveřejněným, nahraným, sdíleným nebo jinak zpřístupněným Uživately. Každý Uživatel používající Webové stránky nebo Služby tímto prohlašuje, že přebírá plnou odpovědnost za to a Společnost nenese žádnou odpovědnost za výše uvedené.')}}</span></p>
            <h4><span id="3_Promotional_Materials_and_Newsletters"><span style="font-weight: 400;">{{aitrans('3. Propagační materiály a zpravodaje')}}</span></span></h4>
            <p><span style="font-weight: 400;">{{aitrans('Kromě ustanovení oddílu 3 výše uživatel dává výslovný souhlas Společnosti k poskytování uživateli propagačních materiálů a zpravodajů (dále jen “Propagační materiály a zpravodaje“) jakýmikoliv dostupnými prostředky, včetně e-mailem, textovými a SMS zprávami, faxem, poštou, automatizovanými telefonními službami nebo jakýmikoli jinými prostředky, vše dle výhradního uvážení Společnosti, jak to bude čas od času, a přijímat takové Propagační materiály a zpravodaje.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Uživatel dále uznává, že Propagační materiály a zpravodaje mohou obsahovat reklamu třetích stran a výslovně souhlasí s příjmem takových reklam jako součásti Propagačních materiálů a zpravodajů. Uživatel může kdykoli kontaktovat Společnost tím, že pošle žádost e-mailem, v níž Společnost informuje o svém odmítnutí dále přijímat Propagační materiály a zpravodaje.')}}</span></p>
            <h4><span id="4_Intellectual_Property"><span style="font-weight: 400;">{{aitrans('4. Duševní vlastnictví')}}</span></span></h4>
            <p><span style="font-weight: 400;">{{aitrans('Společnost je vlastníkem všech celosvětových práv, titulů a zájmů v: (a) Webových stránkách a Službách, vylepšeních, odvozených verzích, opravách chyb nebo vylepšeních Webových stránek a Služeb; a (b) obchodních názvech, ochranných známkách a logách Společnosti, které zůstanou výhradně u Společnosti. Všechny odkazy v těchto Podmínkách nebo jakýchkoli jiných komunikacích na prodej, přeprodej nebo nákup výše uvedeného znamenají pouze právo používat Webové stránky a Služby v souladu s těmito Podmínkami. Uživatelé nesou výhradní odpovědnost za jakýkoli a veškerý obsah, včetně jakýchkoli práv duševního vlastnictví, který poskytnou, sdílejí nebo jinak zpřístupní Uživatelé používající Webové stránky a/nebo Služby, a Společnost nečiní žádná prohlášení ohledně takového obsahu. Společnost nebude odpovědná za jakékoli ztráty nebo škody vzniklé takovým obsahem a Uživatelé souhlasí s odškodněním a ochranou Společnosti před jakýmikoli škodami nebo ztrátami vyplývajícími z výše uvedeného.')}}</span></p>
            <h4><span id="5_Privacy"><span style="font-weight: 400;">{{aitrans('5. Ochrana osobních údajů')}}</span></span></h4>
            <p><span style="font-weight: 400;">{{aitrans('Zavazujete se nezachovávat, neshromažďovat ani jinak neudržovat ve svém vlastnictví a používat jakýkoli obsah poskytnutý Službami a Webovými stránkami bez předchozího písemného souhlasu Společnosti. Dále uznáváte, že Společnost si vyhrazuje právo, dle vlastního uvážení, uchovávat, shromažďovat nebo jinak udržovat ve svém vlastnictví a používat jakýkoli obsah a veřejné informace, včetně informací, které vás mohou osobně identifikovat nebo jakéhokoliv jiného Uživatel nebo Třetí stranu, nebo popisovat vaše osobní zájmy. Společnost si vyhrazuje právo provádět jakékoli a všechny povolené použití podle jakéhokoli platného zákona takového obsahu a veřejných informací, jak je uvedeno v Zásadách ochrany osobních údajů Společnosti. Aniž by tím byla dotčena ustanovení oddílu 1 výše, Společnost nezamýšlí přezkoumávat, testovat, potvrzovat, schvalovat ani jinak ověřovat jakýkoli takový obsah nebo veřejné informace. Každý Uživatel, který zveřejňuje, nahrává, sdílí nebo jinak zpřístupňuje takový obsah nebo veřejné informace, ponese výhradní odpovědnost za obsah nebo veřejné informace, včetně jakýchkoli a všech informací třetí strany a požadovaných souhlasů. Společnost nebude odpovědná za jakékoli ztráty nebo škody vzniklé nedodržením výše uvedeného a souhlasíte s odškodněním a ochranou Společnosti před jakýmikoli škodami nebo ztrátami vyplývajícími z výše uvedeného. BEZ OHLEDU NA VÝŠE UVEDENÉ CHÁPETE A POTVRZUJETE, ŽE SPOLČNOST NENÍ SLUŽBOU PRO ULOŽENÍ OBSAHU. SPOLČNOST NENÍ ODPOVĚDNÁ ZA JAKÝKOLI ZTRACENÝ NEBO SMAZANÝ OBSAH NEBO VEŘEJNÉ INFORMACE. Měli byste si být vědomi toho, že jakýkoli obsah, který je zveřejněn, nahrán, sdílen nebo jinak zpřístupněn, MŮŽE BÝT PŘEČTEN, SHROMAŽĎOVÁN A POUŽÍVÁN DALŠÍMI UŽIVATELI A MŮŽE BÝT POUŽIT K ODESÍLÁNÍ NEVYŽÁDANÝCH OBSAHŮ.')}}</span></p>
            <h4><span id="6_Links"><span style="font-weight: 400;">{{aitrans('6. Odkazy')}}</span></span></h4>
            <p><span style="font-weight: 400;">{{aitrans('Webové stránky nebo Služby mohou obsahovat odkazy nebo jiný obsah související se webovými stránkami, inzerenty, vydavateli nebo Produkty nabízenými třetími stranami. Společnost nemá kontrolu a nevydává žádná prohlášení ohledně těchto odkazů nebo jakýchkoli informací poskytnutých nebo přenášených prostřednictvím těchto odkazů, nebo jinak poskytnutých jakoukoli takovou třetí stranou. CHÁPETE A SOUHLASÍTE, ŽE POUŽITÍ TĚCHTO ODKAZŮ NEBO JINÉHO OBSAHU JE NA VAŠE VLASTNÍ RIZIKO, ŽE TYTO ODKAZY NEBO JINÝ OBSAH JSOU ŘÍZENY PODMÍNKAMI POUŽITÍ A ZÁSADAMI OCHRANY OSOBNÍCH ÚDAJŮ TĚCHTO TŘETÍCH STRAN A ŽE SPOLEČNOST NENÍ ODPOVĚDNÁ ZA OCHRANU OSOBNÍCH ÚDAJŮ NEBO OBCHODNÍ PRAKTIKY NEBO JINÉ POLITIKY TĚCHTO TŘETÍCH STRAN. Měli byste pečlivě zkontrolovat platné podmínky a politiky, které se vztahují na jakékoli Třetí strany. SPOLČNOST NENÍ ODPOVĚDNÁ ANI ZODPOVĚDNÁ JAKÝMKOLI ZPŮSOBEM ZA TAKOVÉ TŘETÍ STRANY NEBO ZA JAKÉKOLI ZTRÁTY NEBO ŠKODY JAKÉHOKOLI DRUHU VYPLÝVAJÍCÍ Z TOHO NEBO S TÍM SOUVISEJÍCÍMI A SPOLČNOST VÝSLOVNĚ ODMIČUJE A VY VÝSLOVNĚ OSVOBOZUJETE SPOLEČNOST OD JAKÉKOLI A VEŠKERÉ ODPovědnosti ZA JAKÉKOLI KONTROVERZE, NÁROKY, ŽALOBY, ZRANĚNÍ, ZTRÁTY, ÚJMY A/NEBO ŠKODY VYPLÝVAJÍCÍ A/NEBO JAKÝMKOLI ZPŮSOBEM SOUVISEJÍCÍMI S TAKOVÝMI TŘETÍMI STRANAMI, VČETNĚ BEZ OMEZENÍ TÝKAJÍCÍCH SE DOSTUPNOSTI, PODMÍNEK POUŽITÍ, OCHRANY OSOBNÍCH ÚDAJŮ, INFORMACÍ, OBSAHU, MATERIÁLŮ, REKLAM, POPLATKŮ, PRODUKTŮ A/NEBO SLUŽEB.')}}</span></p>
            <h4><span id="7_Prohibited_Uses"><span style="font-weight: 400;">{{aitrans('7. Zakázané použití')}}</span></span></h4>
            <p><span style="font-weight: 400;">{{aitrans('Webové stránky a Služby nesmějí být používány v souvislosti s žádnými komerčními podniky (pokud není jinak povoleno Společností při spojování Uživatelů s jakýmikoli Třetími stranami) bez výslovného písemného souhlasu Společnosti. Webové stránky a Služby nesmějí být používány žádnou osobou nebo organizací k najímání pro jinou webovou stránku, shánění, inzerování nebo jakýmikoli jinými formami kontaktování Uživatelů pro zaměstnání, smlouvy nebo jakýkoli jiný účel pro podnikání, které není spojeno se Společností bez výslovného písemného povolení Společnosti. Souhlasíte, že nebudete používat Služby a Webové stránky za účelem kontaktování, inzerování, shánění nebo prodeje jakémukoli jinému Uživateli bez jeho výslovného souhlasu, pokud není jinak povoleno podle těchto Podmínek.')}}</span></p>
            <h4><span id="8_Support"><span style="font-weight: 400;">{{aitrans('8. Podpora')}}</span></span></h4>
            <p><span style="font-weight: 400;">{{aitrans('Uživatelé mohou kontaktovat Společnost ohledně podpory pro Webové stránky a Služby zasláním e-mailu.')}}</span></p>
            <h4><span id="9_Disclaimers"><span style="font-weight: 400;">{{aitrans('9. Zřeknutí se odpovědnosti')}}</span></span></h4>
            <p><span style="font-weight: 400;">{{aitrans('Společnost vynakládá přiměřené úsilí, aby zajistila, že její technologie udržuje Webové stránky a Služby bezpečné a zabezpečené. Nicméně žádná technologie není 100% bezpečná. Proto, i když se snažíme používat komerčně přijatelné prostředky k ochraně vašich osobních informací, nemůžeme zaručit jejich absolutní bezpečnost. S výjimkou toho, co je výslovně uvedeno zde, používáte Webové stránky a Služby na své vlastní riziko. Webové stránky a Služby jsou poskytovány na základě “AS IS” a “AS AVAILABLE” bez záruk jakéhokoli druhu. Společnost výslovně odmítá veškeré implicitní nebo zákonné záruky jakéhokoli druhu týkající se Webových stránek a Služeb, včetně bez omezení záruk titulu, obchodovatelnosti, vhodnosti pro konkrétní účel, neporušení vlastnických práv, obchodního vztahu nebo průběhu výkonu. Společnost nedává žádné rady ohledně rizika nebo vhodnosti jakéhokoliv obchodu, transakce nebo zapojení. Společnost nenese odpovědnost za jakoukoli transakci nebo zapojení, které učiníte, a uznáváte, že jste výhradně odpovědní za hodnocení svých transakcí a zapojení. Nezapočítáte Společnost, její úředníky, zaměstnance nebo dceřiné společnosti za jakékoli volby transakcí nebo zapojení, které provedete. Žádná rada ani informace, ať už ústní nebo písemné, které od Společnosti nebo jejích úředníků, zaměstnanců nebo dceřiných společností obdržíte, nevytvoří žádnou záruku, která není výslovně uvedena v těchto Podmínkách. Pokud se rozhodnete spoléhat na takové informace, děláte to na své vlastní riziko. Některé státy nebo jurisdikce neumožňují vyloučení určitých záruk. Podle toho nemusí být některá z výše uvedených vyloučení použitelná na vás.')}}</span></p>
            <h4><span id="10_Limitation_of_Liability"><span style="font-weight: 400;">{{aitrans('10. Omezení odpovědnosti')}}</span></span></h4>
            <p><span style="font-weight: 400;">{{aitrans('Společnost nezaručuje hodnotu, kvalitu, kompatibilitu ani žádnou jinou vlastnost Třetích stran, Produktů nebo jakýchkoli dalších informací poskytnutých, spotřebovaných nebo jinak zpřístupněných (dále v této sekci: “Vlastnosti”). Jakákoli Vlastnost je výhradní odpovědností příslušné Třetí strany nebo Uživatele, který ji používá, jak je relevantní, nebo používá Služby nebo Webové stránky. Společnost se nezavazuje sledovat takové dodržování a může jednat, kde je detekováno nedodržení, jak bude rozhodnuto dle jejího výhradního uvážení, jak je uvedeno v těchto Podmínkách. Chápete a souhlasíte, že můžete být vystaveni obsahu nebo jiným informacím, které jsou nepřesné, neobjektivní, nevhodné pro děti nebo jinak nevhodné pro vás.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Společnost nenese odpovědnost za jakékoliv problémy nebo technické poruchy jakékoli telefonní sítě nebo linek, počítačových online systémů, serverů nebo poskytovatelů, počítačového vybavení, softwaru, selhání jakéhokoli e-mailu kvůli technickým problémům nebo dopravnímu přetížení na internetu nebo na jakýchkoli Webových stránkách nebo Službách nebo jejich kombinaci, včetně jakéhokoli zranění nebo poškození Uživatelů nebo jakékoli osoby počítače, mobilního telefonu nebo jakéhokoliv jiného zařízení souvisejícího nebo vyplývajícího z účasti nebo stahování materiálů v souvislosti s Webovými stránkami nebo Službami. V žádném případě nebude Společnost odpovědná za chování třetích stran, včetně jakýchkoli Uživatelů, ať už online nebo offline, a provozovatelů externích webových stránek.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Za žádných okolností nebude Společnost ani žádný z jejích úředníků, ředitelů, zaměstnanců nebo agentů odpovědný vůči vám za jakékoli nepřímé, náhodné, zvláštní, punitive nebo následné škody, vyplývající z nebo v souvislosti s vaším používáním Webových stránek nebo Služeb, bez ohledu na to, zda jsou škody předvídatelné a bez ohledu na to, zda byla Společnost upozorněna na možnost takových škod. Výše uvedené omezení odpovědnosti se vztahuje v největší míře povolené zákonem v příslušné jurisdikci.')}}</span></p>
            <h4><span id="11_Indemnification"><span style="font-weight: 400;">{{aitrans('11. Odškodnění')}}</span></span></h4>
            <p><span style="font-weight: 400;">{{aitrans('Budeš bránit, odškodnit a ochránit Společnost před jakýmikoliv a veškerými žalobami, řízeními, tvrzeními, škodami, náklady, odpovědnostmi nebo výdaji (včetně soudních nákladů a přiměřených poplatků za právní zastoupení), které Společnost může utrpět nebo nést v souvislosti s jakýmikoli skutečnými nároky, požadavky, akcemi nebo jinými řízeními jakékoli třetí strany vyplývajícími nebo souvisejícími s jakýmikoli porušeními těchto Podmínek z vaší strany nebo jakýmikoli vaším používáním Webových stránek nebo Služeb, které není v souladu s platným právem.')}}</span></p>
            <h4><span id="12_Miscellaneous"><span style="font-weight: 400;">{{aitrans('12. Různé')}}</span></span></h4>
            <p><span style="font-weight: 400;">{{aitrans('Tyto Podmínky se řídí právem Anglie, s výjimkou pravidel výběru práva, a bez ohledu na Úmluvu OSN o mezinárodním prodeji zboží. Vaše jednání může také podléhat jiným místním, státním a národním zákonům. Jakýkoli spor vznikající na základě těchto Podmínek nebo týkající se Webových stránek nebo Služeb bude konečně rozhodnut příslušnými soudy v Anglii. Nemůžete podávat žádné hromadné žaloby proti Společnosti a používáním Webových stránek nebo Služeb souhlasíte s tím, že se vzdáte svých práv na podání takových hromadných žalob.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Jakýkoli důvod k jednání proti Společnosti musí být podán do jednoho (1) roku od data, kdy takový důvod vznikl. V případě, že jakékoli ustanovení těchto Podmínek bude považováno za nevynutitelné, takové ustanovení bude nahrazeno vynutitelným ustanovením, které nejblíže dosahuje účinku původního ustanovení, a zbývající podmínky těchto Podmínek zůstanou v plné platnosti a účinnosti. Nic v těchto Podmínkách nevytváří žádný vztah zástupce, zaměstnání, společného podniku nebo partnerství mezi vámi a Společností nebo vám neumožňuje jednat jménem Společnosti. S výjimkou toho, co může být výslovně uvedeno v těchto Podmínkách, tyto Podmínky představují celou dohodu mezi Společností a vámi, která se týká předmětu zde uvedeného.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Jakákoli oznámení, která bychom vám mohli poskytnout, ať už podle zákona nebo podle těchto Podmínek, může Společnost poskytnout jakékoli kontaktní informace, které jste poskytli ve své informaci o účtu nebo jinak, buď přímo nebo nepřímo, včetně prostřednictvím e-mailu. Výslovně souhlasíte s přijetím takových komunikací a oznámení tímto způsobem.')}}</span></p>
            <p><span style="font-weight: 400;">{{aitrans('Nemůžete převést žádná práva podle této dohody bez našeho předchozího písemného souhlasu. Nic v těchto Podmínkách nebude vykládáno tak, aby omezovalo opatření nebo opravné prostředky, které mají Společnost k dispozici ohledně jakékoli zakázané činnosti nebo chování. Nevykonávání jakéhokoli termínu těchto Podmínek neznamená souhlas nebo vzdání se, a Společnost si vyhrazuje právo vynucovat takový termín podle svého výhradního uvážení. Žádné vzdání se jakéhokoli porušení nebo selhání podle této dohody nebude považováno za vzdání se jakéhokoli předchozího nebo následného porušení nebo selhání.')}}</span></p>
            <p> </p>
        </main>
    </div>
@endsection
