@extends('layouts.app')
@push('meta')
    <title>{{ "$website_title : معايير الاستخدام المقبولة" }}</title>
    <meta name="description" content="{{ "إذا كنت ترغب في الحصول على أقصى فائدة من خدماتنا والتعرف على حقوقك والتزاماتك فإن فهم القوانين والأحكام المتعلقة بـ $website_title هو الأساس." }}" />
@endpush
@section('content')
    <div class="container page-inner pt-5">
        <h1>{{ aiTrans('شروط الاستخدام') }}</h1>
        <main>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('مزود الخدمة ("الشركة"، "نحن"، "خاصتنا" أو "نحن") يقدم بشكل غير مباشر من خلال برامجه وموقعه الإلكتروني المعين ("الموقع الإلكتروني") بعض خدمات التسويق والإعلان والترويج والخدمات ذات الصلة ("الخدمة")؛ سيشار إلى مستخدمي الخدمة باسم "المستخدمين" أو "أنت" أو "خاصتك". تحكم هذه الشروط ("الشروط") وصول المستخدمين واستخدامهم للموقع والخدمات. يجب على المستخدمين الموافقة على هذه الشروط قبل استخدام الموقع.') }}</span>
            </p>
            <p><span style="font-weight: 400;">{{ aiTrans('يرجى قراءة هذه الشروط بعناية. تحكم هذه الشروط وصولك واستخدامك للموقع والخدمات. من خلال الوصول إلى الموقع أو التسجيل لاستخدامه أو تنزيله أو مشاركته أو استخدامه بأي طريقة أخرى، فإنك تشير إلى موافقتك على هذه الشروط وسياسة الخصوصية الخاصة بنا، والتي قد يتم تعديلها أو تغييرها من وقت لآخر حسب تقديرنا الخاص. سيتم اعتبار استمرارك في استخدام الموقع قبولًا لأي شروط معدلة أو محدثة.') }}
                </span><span
                    style="font-weight: 400;">{{ aiTrans('إذا كنت لا توافق على أي من هذه الشروط، يرجى عدم النقر على "قبول" وعدم استخدام الموقع.') }}</span>
            </p>
            <p><strong>{{ aiTrans('الموقع الإلكتروني') }}</strong> {{ aiTrans('يشير إلى [website_title]، المتاح من' ,$locale,['website_title' => $website_title]) }} <a
                    href="{{ route('home', $country) }}">{{$website_title}}</a></p>
            <div id="toc_container" class="no_bullets">
                <ul class="toc_list">
                    <ul>
                        <li><a href="#1_Use_of_Website_and_Services"><span class="toc_number toc_depth_2">0.1</span>
                                {{ aiTrans('1. استخدام الموقع والخدمات') }}</a></li>
                    </ul>
                    <li><a href="#2_Restrictions"><span class="toc_number toc_depth_1">1</span>
                            {{ aiTrans('2. القيود') }}</a></li>
                    <li><a href="#3_Promotional_Materials_and_Newsletters"><span class="toc_number toc_depth_1">2</span>
                            {{ aiTrans('3. المواد الترويجية والنشرات الإخبارية') }}</a></li>
                    <li><a href="#4_Intellectual_Property"><span class="toc_number toc_depth_1">3</span>
                            {{ aiTrans('4. الملكية الفكرية') }}</a></li>
                    <li><a href="#5_Privacy"><span class="toc_number toc_depth_1">4</span> {{ aiTrans('5. الخصوصية') }}</a>
                    </li>
                    <li><a href="#6_Links"><span class="toc_number toc_depth_1">5</span> {{ aiTrans('6. الروابط') }}</a></li>
                    <li><a href="#7_Prohibited_Uses"><span class="toc_number toc_depth_1">6</span>
                            {{ aiTrans('7. الاستخدامات المحظورة') }}</a></li>
                    <li><a href="#8_Support"><span class="toc_number toc_depth_1">7</span> {{ aiTrans('8. الدعم') }}</a>
                    </li>
                    <li><a href="#9_Disclaimers"><span class="toc_number toc_depth_1">8</span>
                            {{ aiTrans('9. إخلاء المسؤولية') }}</a></li>
                    <li><a href="#10_Limitation_of_Liability"><span class="toc_number toc_depth_1">9</span>
                            {{ aiTrans('10. تحديد المسؤولية') }}</a></li>
                    <li><a href="#11_Indemnification"><span class="toc_number toc_depth_1">10</span>
                            {{ aiTrans('11. التعويض') }}</a></li>
                    <li><a href="#12_Miscellaneous"><span class="toc_number toc_depth_1">11</span>
                            {{ aiTrans('12. متفرقات') }}</a></li>
                </ul>
            </div>
            <h5><span id="1_Use_of_Website_and_Services"><b>{{ aiTrans('1. استخدام الموقع والخدمات') }}</b></span></h5>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('رغم الشروط والأحكام المنصوص عليها هنا، يمكنك الوصول إلى الموقع واستخدامه بغرض استخدام الخدمات على أساس غير حصري. تقر بأن الشركة قد تقوم، حسب تقديرها الخاص وفي أي وقت، بتعديل أو تحديث أو تغيير الموقع أو الخدمات، بما في ذلك وقف تقديم أي جزء أو كل من الموقع و/أو الخدمات أو تعديل أو حذف أي محتوى متاح من خلال الموقع أو الخدمات، دون إشعار مسبق.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('استخدام الموقع والخدمات غير مسموح به حيثما كان محظورًا. من خلال استخدام الموقع والخدمات، فإنك تمثل وتضمن أن: (أ) أي معلومات تقدمها (إن وجدت) صحيحة ودقيقة؛ (ب) ستحتفظ بدقة تلك المعلومات؛ (ج) أنت في سن الرشد في اختصاصك؛ و (د) استخدامك للموقع أو الخدمات لا ينتهك أو يعزز انتهاك أي قانون أو لائحة سارية أو أي التزام قانوني أو تعاقدي قد يكون لديك تجاه طرف ثالث وأنك قد تمتثل في جميع الأوقات لجميع القوانين والقواعد واللوائح السارية فيما يتعلق باستخدامك للخدمات والموقع، وأي خدمات تم ترتيبها من خلال الخدمات والموقع، بما في ذلك دون حصر تلك الخدمات المرتبطة بأي شكل بالمنتجات أو الأطراف الثالثة، كما هو معرف هنا.') }}</span>
            </p>
            <p><span style="font-weight: 400;">{{ aiTrans('تُشار إلى الفقرات الفرعية (أ)-(د) معًا باسم') }}
                </span><b>{{ aiTrans('“التزامات وضمانات المستخدمين“') }}</b><span style="font-weight: 400;">.</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('من خلال استخدامك للخدمات أو الموقع، تفهم وتوافق على أن الشركة قد تقوم، حسب تقديرها الخاص، ولكنها غير ملزمة، بالتحقق من أن أي أو جميع التزامات وضمانات المستخدمين مستوفاة من قبل أي مستخدم، وتوافق بشكل أكبر على أن الشركة ليست مسؤولة عن ضمان أن التزامات وضمانات المستخدمين مستوفاة أو عن أي فشل في تعليق أو إنهاء أو منع استخدام الخدمات أو الموقع من قبل المستخدمين الذين لا يستوفون التزامات وضمانات المستخدمين. تفهم أنك المسؤول الوحيد عن إجراء تقييماتك وقراراتك وتقديراتك حول ما إذا كنت ستتفاعل مع أي أطراف ثالثة أو تتفاعل مع أي أطراف ثالثة بأي شكل من الأشكال. إذا أصبحت على علم بأي انتهاك للتزامات وضمانات المستخدمين، فإننا نشجعك على الإبلاغ عنه للشركة.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('تحتفظ الشركة بالحق في عدم تقديم أي خدمات لك مع أو بدون إشعار حسب تقديرها الخاص، سواء أصبحت على علم بأي انتهاك للتزامات وضمانات المستخدمين (سواء عن طريق التقارير المقدمة إليها من مستخدمين آخرين أو أي وسائل أخرى) من قبلك أو أي مستخدم آخر، أو لأي سبب آخر. دون الإخلال بما سبق، فإن الشركة تخلي مسؤوليتها صراحة، وتحررك صراحة من أي وجميع المسؤوليات المتعلقة بأي نزاعات أو مطالبات أو دعاوى أو إصابات أو خسائر أو أضرار من أي نوع كانت تنشأ عن و/أو تتعلق بأي شكل من الأشكال بـ: (ط) أي عدم دقة أو عدم تحديث أو عدم اكتمال لتمثيلات مستخدم أو طرف ثالث؛ و (ii) أي بيانات خاطئة و/أو تمثيلات غير دقيقة، سواء فيما يتعلق أو من قبل أي من الأطراف الثالثة أو مستخدمين آخرين، أو المنتجات أو خلاف ذلك. من خلال استخدامك للموقع والخدمات، فإنك تفهم وتوافق على أن الخدمات تقدم فقط منصة مخصصة لمساعدة المستخدمين على الوصول إلى وشراء و/أو استخدام منتجات وخدمات متنوعة مقدمة من بائعين و/أو مزودين طرف ثالث، من خلال الإعلانات أو العروض الترويجية التي نقدمها (على التوالي، "المنتجات" و "الأطراف الثالثة").') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('أنت تفهم وتوافق على أن الشركة: (أ) لا توظف أو توصي أو تدعم أي أطراف ثالثة أو منتجات، حسب الاقتضاء، أو أي طرف ذي صلة، وليس لديها سيطرة على تصرفات أو إغفالات أي طرف ثالث، أو أعمالهم أو منتجاتهم أو خدماتهم؛ (ب) لا تقدم أي تمثيلات أو ضمانات بشأن الأطراف الثالثة والمنتجات، بما في ذلك جودتها أو تسعيرها أو توافقها أو توافرها أو أي ميزات أخرى، أو بشأن تفاعلاتك أو معاملاتك مع أي أطراف ثالثة؛ (ج) لا تقدم أي تمثيلات أو ضمانات بشأن الحقوق الملكية أو حقوق أو ميزات أخرى أو جوانب تنظيمية تتعلق بالمنتجات، بما في ذلك أي تفويض مطلوب أو تصاريح أو تراخيص للتحميل أو المشاركة أو توفيرها بأي شكل من الأشكال، واستخدامها أو بيعها أو شرائها؛ و (د) ليست مسؤولة عن أداء أو سلوك أي مستخدم أو أي أطراف ثالثة في أي شكل من الأشكال باستخدام أو استخدام الخدمات، و/أو على أو خارج الموقع. ليست الشركة ملزمة بمراجعة أو التحقق من أي معلومات تتعلق بالأطراف الثالثة و/أو المستخدمين أو المنتجات أو أي ميزة أخرى تتعلق بالموقع أو الخدمات، وبالتالي، يجب عليك اتخاذ الحذر وإجراء الفحوصات والتقييمات الخاصة بك قبل التفاعل مع أي شخص من خلال الخدمات أو الموقع أو التفاعل مع أي شخص آخر.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('تخلي الشركة مسؤوليتها صراحة، وتحررك صراحة من أي وجميع المسؤوليات المتعلقة بأي نزاعات أو مطالبات أو دعاوى أو إصابات أو خسائر أو أضرار من أي نوع كانت تنشأ عن و/أو تتعلق بأي شكل من الأشكال بالأطراف الثالثة أو المنتجات أو الخدمات أو الموقع أو تفاعلاتك أو معاملاتك مع أي أطراف ثالثة، بما في ذلك على سبيل المثال لا الحصر أي تصرفات و/أو إغفالات للأطراف الثالثة بأي شكل من الأشكال باستخدام أو متصل بالخدمات أو الموقع. من خلال استخدامك للخدمات أو الموقع، تقر بأنك مسؤول وحدك عن هذا الاستخدام والتواصلات والتفاعلات والمشتريات أو أي إجراء آخر تقوم به، وأن كل استخدام للخدمات أو الموقع هو على مسؤوليتك الخاصة. ولتجنب أي شك، فإن الشركة لا تبيع أو ترخص أو توفر لك أي منتجات أو خدمات (بخلاف الخدمات) ولن تتحمل أي مسؤولية عن أي منتجات أو خدمات تشتريها من أي طرف ثالث، بما في ذلك دون حصر، فيما يتعلق بأي دعم وصيانة أو عيوب أو أخطاء أو فشل أو أضرار أو تكاليف من أي نوع.') }}</span>
            </p>
            <h4><span id="2_Restrictions"><span style="font-weight: 400;">{{ aiTrans('2. القيود') }}</span></span>
            </h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('دون الإخلال بأحكام القسم 1 أعلاه، يجب عليك، ويجب ألا تسمح لأي طرف ثالث، بـ: (أ) عكس هندسة أو محاولة العثور على الكود الأساسي للموقع أو الخدمات؛ (ب) استخدام الموقع أو الخدمات في انتهاك لأي قانون أو لائحة سارية، بما في ذلك على سبيل المثال لا الحصر، نشر أو مشاركة أو نقل أي مادة غير قانونية أو مسيئة؛ (ج) نسخ أو تعديل أو إنشاء أعمال اشتقاقية من الموقع أو الخدمات أو محتوى أي من الموقع أو الخدمات؛ (د) محاولة تعطيل أو التحايل على أي آلية أمان أو تحكم وصول للموقع أو الخدمات؛ (هـ) تصميم أو المساعدة في تصميم خدع أو استغلالات أو برامج أوتوماتيكية أو بوتات أو قرصنة أو أي برامج غير مصرح بها لتعديل أو التداخل مع الموقع أو الخدمات؛ (و) استخدام الموقع أو الخدمات أو التفاعل مع مستخدمين آخرين لأي غرض يتعارض مع أي قانون أو لائحة سارية؛ (ز) محاولة الوصول غير المصرح به إلى الموقع أو الخدمات، أو حسابات مستخدمين آخرين، كما هو معرف أدناه، أو أي جهاز أو نظام حاسوب أو أنظمة هاتف أو شبكات متصلة بالموقع أو الخدمات؛ و (ح) جمع أو غير ذلك من جمع المعلومات عن المستخدمين دون موافقتهم.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('إذا قمت بنشر أو مشاركة أو نقل أي محتوى عبر الموقع و/أو باستخدام الخدمات، فإنك تمثل وتضمن أن هذا المحتوى يقدم صورة دقيقة وكاملة عن أي منتجات أو خدمات موصوفة فيه، ويوافق على هذه الشروط، ولا: (أ) ينتهك الملكية الفكرية أو الحقوق المعنوية أو حقوق الدعاية لأي طرف ثالث؛ (ب) يحتوي على أي محتوى تشهيري أو قذف أو فاحش أو ذو إيحاءات جنسية أو غيره من المحتويات المسيئة (بما في ذلك المواد التي تروج أو تمجد الكراهية أو العنف أو التعصب)؛ (ج) يحتوي على أي ديدان أو فيروسات أو أي برامج خبيثة أخرى؛ (د) ينتهك أي قانون أو لائحة سارية، بما في ذلك أي قانون أو لائحة تتعلق بالإعلان أو التسويق؛ و (هـ) يقوم بأي إجراء يفرض عبئًا غير معقول أو كبير بشكل غير متناسب على بنيتنا التحتية.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('من خلال نشر أو تحميل أو مشاركة أو نقل أي محتوى باستخدام الموقع أو الخدمات، فإنك تمنح الشركة وأي من شركاتها التابعة و/أو المرخص لهم بموجبها ترخيصًا عالميًا، غير حصري، دائمًا، وخاليًا من حقوق الملكية لنشر ومشاركة وعرض ونقل هذا المحتوى بأي شكل معقول حسب تقدير الشركة الخاص. تحتفظ الشركة بالحق في إزالة أو تعليق الوصول إلى أو حذف أي محتوى وفقًا لتقديرها الخاص دون إشعار مسبق، بما في ذلك على سبيل المثال لا الحصر أي محتوى ينتهك الضمانات المنصوص عليها أعلاه أو المصالح التجارية للشركة، وليس لديك أي حق أو مطالبة فيما يتعلق بمثل هذه القرارات والإجراءات.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('لا تكون الشركة، ولن تكون، مسؤولة عن أي محتوى يتم تقديمه أو نشره أو تحميله أو مشاركته أو غيره من الم disponibil من قبل المستخدمين، أو أي منتجات أو خدمات تتعلق بمثل هذا المحتوى المقدمة أو المنشورة أو المحملة أو المشاركة من قبل المستخدمين. كل مستخدم يستخدم الموقع أو الخدمات يمثل هنا أنه يتحمل المسؤولية الكاملة في هذا الصدد، ولن تتحمل الشركة أي مسؤولية فيما يتعلق بما سبق.') }}</span>
            </p>
            <h4><span id="3_Promotional_Materials_and_Newsletters"><span
                        style="font-weight: 400;">{{ aiTrans('3. المواد الترويجية والنشرات الإخبارية') }}</span></span>
            </h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('بالإضافة إلى أحكام القسم 3 أعلاه، فإن المستخدم يعطي موافقته الصريحة للشركة لتزويد المستخدم بالمواد الترويجية والنشرات الإخبارية ("المواد الترويجية والنشرات الإخبارية") بواسطة أي وسيلة متاحة، بما في ذلك عبر البريد الإلكتروني، الرسائل النصية والرسائل القصيرة، الفاكس، البريد، خدمات الاتصال الآلي أو أي وسيلة أخرى، كل ذلك وفقًا لتقدير الشركة الخاص كما يتغير من وقت لآخر، ولتلقي مثل هذه المواد الترويجية والنشرات الإخبارية.') }}</span>
            </p>
            
            <p><span
                    style="font-weight: 400;">{{ aiTrans('يقر المستخدم أيضًا بأن المواد الترويجية والنشرات الإخبارية قد تتضمن إعلانات لأطراف ثالثة، ويوافق صراحةً على تلقي هذه الإعلانات كجزء من المواد الترويجية والنشرات الإخبارية. يمكن للمستخدم الاتصال بالشركة في أي وقت عن طريق إرسال طلب عبر البريد الإلكتروني notifying the Company برفضه تلقي المواد الترويجية والنشرات الإخبارية.') }}</span>
            </p>
            <h4><span id="4_Intellectual_Property"><span
                        style="font-weight: 400;">{{ aiTrans('4. الملكية الفكرية') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('تمتلك الشركة جميع الحقوق والعناوين والمصالح العالمية في: (أ) الموقع والخدمات، والتحسينات، والأعمال المشتقة، وإصلاحات الأخطاء أو التحسينات للموقع والخدمات؛ و (ب) أسماء التجارة، والعلامات التجارية، والشعارات الخاصة بالشركة، وستظل دائمًا ملكًا للشركة. تشير جميع الإشارات في هذه الشروط أو أي اتصالات أخرى إلى بيع أو إعادة بيع أو شراء ما سبق إلى حق استخدام الموقع والخدمات وفقًا لهذه الشروط. يتحمل المستخدمون المسؤولية الكاملة عن أي محتوى، بما في ذلك أي حقوق ملكية فكرية تتعلق به، يتم توفيره أو مشاركته أو توفيره بأي شكل من الأشكال بواسطة المستخدمين باستخدام الموقع و/أو الخدمات، ولا تقدم الشركة أي تمثيل يتعلق بمثل هذا المحتوى. لن تكون الشركة مسؤولة عن أي خسائر أو أضرار ناتجة عن هذا المحتوى، ويوافق المستخدمون على تعويض الشركة وإبراء ذمتها من أي ضرر أو خسارة تنشأ عن ذلك.') }}</span>
            </p>
            <h4><span id="5_Privacy"><span style="font-weight: 400;">{{ aiTrans('5. الخصوصية') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('تتعهد بعدم حفظ أو جمع أو الاحتفاظ أو استخدام أي محتوى تقدمه الخدمات والموقع دون الحصول على موافقة خطية مسبقة من الشركة. وتقر أيضًا بأن الشركة تحتفظ بالحق، حسب تقديرها الخاص، في حفظ أو جمع أو الاحتفاظ أو استخدام أي محتوى ومعلومات عامة، بما في ذلك المعلومات التي قد تحدد هويتك الشخصية أو أي مستخدم أو طرف ثالث أو تصف اهتماماتك الشخصية. تحتفظ الشركة بالحق في القيام بأي استخدام مسموح به بموجب أي قانون ساري لتلك المحتويات والمعلومات العامة كما هو موضح في سياسة الخصوصية الخاصة بالشركة. دون الإخلال بأحكام القسم 1 أعلاه، لا تقوم الشركة بمراجعة أو اختبار أو تأكيد أو الموافقة أو التحقق بأي شكل من الأشكال من أي محتوى أو معلومات عامة. يتحمل كل مستخدم يقوم بنشر أو تحميل أو مشاركة أو توفير أي محتوى أو معلومات عامة المسؤولية الكاملة عن المحتوى أو المعلومات العامة، بما في ذلك أي معلومات وحقوق طرف ثالث مطلوبة. لن تتحمل الشركة أي مسؤولية عن أي خسارة أو ضرر ناتج عن عدم الامتثال لما سبق، وتوافق على تعويض الشركة وإبراء ذمتها من أي ضرر أو خسارة تنشأ عن ذلك. رغم ما سبق، فإنك تفهم وتقر بأن الشركة ليست خدمة لتخزين المحتوى. لن تتحمل الشركة أي مسؤولية عن أي محتوى أو معلومات عامة مفقودة أو محذوفة. يجب أن تكون على علم بأن أي محتوى تم نشره أو تحميله أو مشاركته أو توفيره قد يتم قراءته أو جمعه أو استخدامه من قبل مستخدمين آخرين، وقد يتم استخدامه لإرسال محتوى غير مرغوب فيه.') }}</span>
            </p>
            <h4><span id="6_Links"><span style="font-weight: 400;">{{ aiTrans('6. الروابط') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('قد يحتوي الموقع أو الخدمات على روابط أو محتويات أخرى تتعلق بمواقع الويب أو المعلنين أو الناشرين أو المنتجات المقدمة من قبل أطراف ثالثة. ليس لدى الشركة أي سيطرة ولا تقدم أي تمثيل فيما يتعلق بذلك أو أي معلومات مقدمة أو تم نقلها عبر ذلك، أو بأي شكل آخر مقدم من قبل أي طرف ثالث. أنت تفهم وتوافق على أن استخدام تلك الروابط أو المحتويات الأخرى يكون على مسؤوليتك الخاصة، وأن تلك الروابط أو المحتويات الأخرى تخضع لشروط استخدام الأطراف الثالثة وسياسات الخصوصية، وأن الشركة ليست مسؤولة عن ممارسات الخصوصية أو الأعمال التجارية أو السياسات الأخرى لتلك الأطراف الثالثة. يجب عليك مراجعة الشروط والسياسات المعمول بها بعناية التي تنطبق على أي طرف ثالث. لا تتحمل الشركة أي مسؤولية أو التزام بأي شكل من الأشكال تجاه تلك الأطراف الثالثة، أو عن أي خسارة أو ضرر من أي نوع ينشأ نتيجة لذلك، وتخلي الشركة مسؤوليتها، وتحررك صراحة من أي وجميع المسؤوليات عن أي نزاعات أو مطالبات أو دعاوى أو إصابات أو خسائر أو أضرار، تنشأ عن و/أو تتعلق بأي شكل من الأشكال بتلك الأطراف الثالثة، بما في ذلك على سبيل المثال لا الحصر ما يتعلق بالتوافر والشروط والأحكام، الخصوصية، المعلومات، المحتوى، المواد، الإعلانات، الرسوم، المنتجات و/أو الخدمات.') }}</span>
            </p>
            <h4><span id="7_Prohibited_Uses"><span
                        style="font-weight: 400;">{{ aiTrans('7. الاستخدامات المحظورة') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('لا يجوز استخدام الموقع والخدمات فيما يتعلق بأي مشاريع تجارية (ما لم يتم السماح بذلك من قبل الشركة في ربط المستخدمين بأي أطراف ثالثة) دون الحصول على موافقة خطية صريحة من الشركة. لا يجوز استخدام الموقع والخدمات من قبل أي شخص أو منظمة لتجنيد لموقع آخر، أو الطلب، أو الإعلان، أو الاتصال بأي شكل من الأشكال بمستخدمين من أجل التوظيف، أو التعاقد، أو أي غرض آخر يتعلق بنشاط غير مرتبط بالشركة دون الحصول على إذن كتابي صريح من الشركة. توافق على عدم استخدام الخدمات والموقع من أجل الاتصال أو الإعلان أو الطلب أو البيع لأي مستخدم آخر دون موافقتهم الصريحة، ما لم يتم السماح بذلك وفقًا لهذه الشروط.') }}</span>
            </p>
            <h4><span id="8_Support"><span style="font-weight: 400;">{{ aiTrans('8. الدعم') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('يمكن للمستخدمين الاتصال بالشركة فيما يتعلق بالدعم للموقع والخدمات عن طريق إرسال بريد إلكتروني') }}</span>
            </p>
            <h4><span id="9_Disclaimers"><span style="font-weight: 400;">{{ aiTrans('9. إخلاء المسؤولية') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('تقوم الشركة ببذل جهود معقولة لضمان أن تقنيتها تحافظ على سلامة وأمان الموقع والخدمات. ومع ذلك، لا توجد تقنية آمنة بنسبة 100%. لذلك، بينما نسعى جاهدين لاستخدام وسائل مقبولة تجاريًا لحماية معلوماتك الشخصية، لا يمكننا ضمان أمانها المطلق. باستثناء ما هو منصوص عليه صراحة هنا، فإن استخدامك للموقع والخدمات يكون على مسؤوليتك الخاصة. يتم تقديم الموقع والخدمات على أساس "كما هي" و"متاحة" دون أي ضمانات من أي نوع. تخلي الشركة مسؤوليتها صراحة عن جميع الضمانات الضمنية أو القانونية من أي نوع تتعلق بالموقع والخدمات، بما في ذلك على سبيل المثال لا الحصر ضمانات الملكية، القابلية للتسويق، الملاءمة لغرض معين، عدم انتهاك حقوق الملكية، أو تاريخ التعامل أو الأداء. لا تقدم الشركة أي نصيحة بشأن المخاطر أو الملاءمة لأي تجارة أو صفقة أو مشاركة. لا تتحمل الشركة أي مسؤولية عن أي صفقة أو مشاركة تقوم بها، وتقر بأنك المسؤول الوحيد عن تقييم معاملاتك ومشاركاتك. لا يمكنك تحميل الشركة، أو موظفيها، أو مسؤوليها، أو الشركات التابعة لها أي مسؤولية عن أي خيارات تتعلق بالمعاملات أو المشاركات التي تقوم بها. لا يوجد نصيحة أو معلومات، سواء كانت شفهية أو مكتوبة، تم الحصول عليها منك من الشركة أو موظفيها، أو مسؤوليها، أو شركاتها التابعة، ستؤدي إلى إنشاء أي ضمان غير منصوص عليه صراحة في هذه الشروط. إذا اخترت الاعتماد على هذه المعلومات، فإنك تفعل ذلك على مسؤوليتك الخاصة. بعض الولايات أو الاختصاصات لا تسمح بإخراج بعض الضمانات. وفقًا لذلك، قد لا تنطبق عليك بعض من الاستثناءات المذكورة أعلاه.') }}</span>
            </p>
            <h4><span id="10_Limitation_of_Liability"><span
                        style="font-weight: 400;">{{ aiTrans('10. تحديد المسؤولية') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('لا تضمن الشركة قيمة أو جودة أو توافق أو أي ميزات أخرى للأطراف الثالثة أو المنتجات أو أي معلومات أخرى مقدمة أو مستهلكة أو متاحة بأي شكل من الأشكال (يشار إليها فيما يلي في هذا القسم باسم "الميزات"). أي ميزة تقع تحت المسؤولية الوحيدة للطرف الثالث المعني أو المستخدم الذي يستخدمها، حسب الاقتضاء، أو يستخدم الخدمات أو الموقع. لا تتحمل الشركة مسؤولية مراقبة الامتثال لهذه الشروط وقد تتصرف عندما يتم اكتشاف عدم الامتثال وفقًا لتقديرها الخاص، كما هو موضح في هذه الشروط. تفهم وتوافق على أنه قد يتم عرضك لمحتوى أو معلومات أخرى غير دقيقة أو غير مقبولة أو غير مناسبة للأطفال، أو غير مناسبة لك بأي شكل من الأشكال.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('لا تتحمل الشركة أي مسؤولية عن أي مشاكل أو أعطال فنية في أي شبكة هاتف أو خطوط، أو أنظمة الكمبيوتر عبر الإنترنت، أو الخوادم أو موفري الخدمة، أو معدات الكمبيوتر، أو البرمجيات، أو فشل أي بريد إلكتروني بسبب مشكلات فنية أو الازدحام المروري على الإنترنت أو في أي من الموقع أو الخدمات أو مجموعة من ذلك، بما في ذلك أي إصابة أو ضرر للمستخدمين أو لأي جهاز حاسوب أو هاتف محمول أو أي جهاز آخر متعلق أو ناتج عن المشاركة أو تنزيل المواد المتعلقة بالموقع أو الخدمات. لن تتحمل الشركة بأي حال من الأحوال مسؤولية تصرفات الأطراف الثالثة، بما في ذلك أي مستخدمين، سواء على الإنترنت أو خارجها، ومشغلي المواقع الخارجية.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('لا تكون الشركة، أو أي من موظفيها، أو مديريها، أو موظفيها، أو وكلائها مسؤولين تجاهك عن أي أضرار غير مباشرة، أو عرضية، أو خاصة، أو عقابية، أو تبعية، تنشأ من أو تتعلق باستخدامك للموقع أو الخدمات، سواء كانت الأضرار متوقعة أم لا، سواء تم إخطار الشركة بإمكانية حدوث مثل هذه الأضرار أم لا. ينطبق حد المسؤولية السابق على أقصى حد يسمح به القانون في الاختصاص المعني.') }}</span>
            </p>
            <h4><span id="11_Indemnification"><span
                        style="font-weight: 400;">{{ aiTrans('11. التعويض') }}</span></span></h4>

            <p><span
                    style="font-weight: 400;">{{ aiTrans('ستدافع وتعوض الشركة وتحميها من أي وكل الدعاوى أو الإجراءات أو التأكيدات أو الأضرار أو التكاليف أو الالتزامات أو النفقات (بما في ذلك تكاليف المحكمة وأتعاب المحاماة المعقولة) التي قد تتعرض لها أو تتحملها الشركة فيما يتعلق بأي مطالبة أو طلب أو إجراء أو أي قضية أخرى من طرف ثالث تنشأ عن أو تتعلق بأي انتهاك لهذه الشروط من قبلك أو أي استخدام من قبلك للموقع أو الخدمات لا يتوافق مع القانون الساري.') }}</span>
            </p>
            <h4><span id="12_Miscellaneous"><span
                        style="font-weight: 400;">{{ aiTrans('12. متفرقات') }}</span></span></h4>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('تخضع هذه الشروط لقوانين إنجلترا، مع استبعاد قواعد اختيار القانون، ودون اعتبار لاتفاقية الأمم المتحدة بشأن عقود البيع الدولي للبضائع. قد تخضع سلوكياتك أيضًا لقوانين محلية أو وطنية أخرى. سيتم تسوية أي نزاع ينشأ بموجب هذه الشروط أو يتعلق بالموقع أو الخدمة أخيرًا من قبل المحاكم المختصة في إنجلترا. لا يجوز لك تقديم أي دعاوى جماعية ضد الشركة، ومن خلال استخدامك للموقع أو الخدمات توافق على التنازل عن حقوقك في تقديم أي دعاوى جماعية.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('يجب تقديم أي سبب من أسباب الدعوى ضد الشركة في غضون سنة (1) واحدة من تاريخ نشوء هذا السبب. في حال تم اعتبار أي بند من هذه الشروط غير قابل للتنفيذ، فسيتم استبداله ببند قابل للتنفيذ يحقق أقرب تأثير للبند الأصلي، وستظل الشروط المتبقية من هذه الشروط سارية بالكامل. لا ينشئ أي شيء في هذه الشروط أي علاقة وكالة أو عمل أو مشروع مشترك أو شراكة بينك وبين الشركة أو يمكنك من التصرف نيابة عن الشركة. باستثناء ما قد يتم النص عليه صراحةً في هذه الشروط، تشكل هذه الشروط الاتفاق الكامل بين الشركة وبينك فيما يتعلق بالموضوع المذكور.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('يمكن تقديم أي إشعارات قد نكون مطالبين بتقديمها لك، سواء بموجب القانون أو وفقًا لهذه الشروط، من قبل الشركة إلى أي معلومات الاتصال التي قدمتها في معلومات حسابك أو غيرها، إما بشكل مباشر أو غير مباشر، بما في ذلك عبر البريد الإلكتروني. توافق صراحةً على تلقي مثل هذه الاتصالات والإشعارات بهذه الطريقة.') }}</span>
            </p>
            <p><span
                    style="font-weight: 400;">{{ aiTrans('لا يجوز لك نقل أي حقوق بموجب هذه الشروط دون موافقة خطية مسبقة من الشركة. لا ينبغي تفسير أي شيء وارد في هذه الشروط لتقييد الإجراءات أو التعويضات المتاحة للشركة فيما يتعلق بأي نشاط أو تصرف محظور. لا يشكل عدم تنفيذ أي بند من هذه الشروط موافقة أو تنازل، وتحتفظ الشركة بالحق في فرض هذا البند وفقًا لتقديرها الخاص. لا يعتبر تنازل عن أي انتهاك أو تقصير بموجب هذه الشروط تنازلاً عن أي انتهاك أو تقصير سابق أو لاحق.') }}</span>
            </p>
            <p> </p>
        </main>
    </div>

@endsection
