<x-ui::form :route="$route" :name="$formName" :breadcrumbs="$formBreadCrumbs">

    <div class="accordion" id="metronicAccordion">

        <!-- Basic Information -->
        <div class="accordion-item">
            <h2 class="accordion-header" id="headingBasicInfo">
                <button class="accordion-button fs-4 fw-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseBasicInfo" aria-expanded="true" aria-controls="collapseBasicInfo">
                    {{ __('Basic Information') }}
                </button>
            </h2>
            <div id="collapseBasicInfo" class="accordion-collapse collapse show" aria-labelledby="headingBasicInfo" data-bs-parent="#metronicAccordion">
                <div class="accordion-body">
                    <div class="row">
                        <div class="col-md-12">
                            <x-ui::form.input name="title" :label="__('Title')" />
                        </div>

                        <div class="col-md-12">
                            <x-ui::form.input type="textarea" class="tinymce" name="content" :label="__('Content')" rows="4" />
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </div>

    <x-slot:scripts>
        <script>
            $(document).ready(function () {
                // Function to generate slug with Arabic characters intact
                function generateSlug(text) {
                    return text
                        .trim()
                        .replace(/\s+/g, '-')        // Replace spaces with hyphens
                        .replace(/[^ء-يa-zA-Z0-9\-]+/g, '') // Remove special characters except Arabic, English, numbers, and hyphens
                        .replace(/-+/g, '-')         // Collapse multiple hyphens
                        .replace(/^-|-$/g, '');      // Remove leading and trailing hyphens
                }

                // Event listener for Arabic title
                $('input[name="title[ar]"]').on('input', function () {
                    const arabicSlug = generateSlug($(this).val());
                    $('input[name="slug[ar]"]').val(arabicSlug);
                });

                // Event listener for English title
                $('input[name="title[en]"]').on('input', function () {
                    const englishSlug = generateSlug($(this).val());
                    $('input[name="slug[en]"]').val(englishSlug);
                });
            });
        </script>

        <script src="{{asset('vendor/hsmfawaz/ui/metronic/assets/plugins/custom/tinymce/tinymce.bundle.js')}}"></script>

        <script>

            let options = {
                selector: ".tinymce",
                height: "480",
                plugins: "code link",
                toolbar: ' undo redo styleselect bold italic alignleft aligncenter alignright alignjustify | bullist numlist outdent indent code'

            };
            tinymce.init(options);
        </script>

        <script src="{{ asset('metronic/plugins/custom/tagify/tagify.bundle.js') }}"></script>
        <script>
            $(document).ready(function () {
                $('.tagify').each(function () {
                    const input = this;
                    const tagify = new Tagify(input);

                    // Update form data before submission
                    $(input).closest('form').on('submit', function () {
                        const tags = tagify.value.map(tag => tag.value); // Extract only the values
                        $(input).val(JSON.stringify(tags)); // Save as JSON array of strings
                    });
                });
            });

        </script>
    </x-slot:scripts>
</x-ui::form>
