<x-app-layout>
    <section class="confirm-area">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-6">

                    <div class="confirm-info">
                        <h2>@lang('Enter the verification code')</h2>
                        <p>@lang('Please, please enter the verification code you received. Thanks.')</p>
                    </div>
                    <div class="confirm-code-area">
                        <form action="{{route('login')}}" method="post">
                            <input type="hidden" name="phone" value="{{request('phone')}}">
                            <input type="hidden" name="identification" value="{{request('identification')}}">
                            @csrf
                            <ul class="veri_inputs">
                                <li>
                                    <input type="text" class="verify-input-field"
                                           id="digit-5" name="digit_5"
                                           data-next="digit-6"
                                           oninput="this.value=this.value.replace(/[^0-9]/g,'');"
                                           data-previous="digit-4" value="{{old('digit_5')}}"/>

                                    @error('digit_5')
                                    <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </li>
                                <li>
                                    <input type="text" class="verify-input-field"
                                           id="digit-4" name="digit_4" data-next="digit-5"
                                           oninput="this.value=this.value.replace(/[^0-9]/g,'');"
                                           data-previous="digit-3" value="{{old('digit_4')}}"/>
                                    @error('digit_4')
                                    <div class="text-danger">{{ $message }}</div> @enderror
                                </li>
                                <li>
                                    <input type="text" class="verify-input-field"
                                           oninput="this.value=this.value.replace(/[^0-9]/g,'');"
                                           id="digit-3" name="digit_3" data-next="digit-4"
                                           data-previous="digit-2" value="{{old('digit_3')}}"/>
                                    @error('digit_3')
                                    <div class="text-danger">{{ $message }}</div> @enderror
                                </li>
                                <li>
                                    <input type="text" class="verify-input-field"
                                           id="digit-2" name="digit_2" data-next="digit-3"
                                           oninput="this.value=this.value.replace(/[^0-9]/g,'');"
                                           data-previous="digit-1" value="{{old('digit_2')}}"/>
                                    @error('digit_2')
                                    <div class="text-danger">{{ $message }}</div> @enderror
                                </li>
                                <li>
                                    <input type="text" class="verify-input-field" max="1"
                                           oninput="this.value=this.value.replace(/[^0-9]/g,'');"
                                           id="digit-1" name="digit_1" data-next="digit-2" value="{{old('digit_1')}}"/>
                                    @error('digit_1')
                                    <div class="text-danger">{{ $message }}</div> @enderror
                                </li>
                            </ul>

                            <div class="btn-group">
                                <button class="btn">@lang('Send')</button>
                            </div>
                            @if(request('phone'))
                                <div class="hint text-center small mt-3">
                                    @lang("didn't Receive The Code")
                                    <a href="{{route('check-phone',
                                                ['phone'=>request('phone'),
                                                'identification'=>request('identification')
                                                ])}}" class="btn btn-primary">
                                        @lang('Resend Code')
                                    </a>
                                </div>
                            @endif
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!--======================= End register Page ==========================-->
    @push('js')
        <script>

            $('[data-index=1]').focus();

            const inputElements = [...document.querySelectorAll('input.verify-input-field')]

            inputElements.forEach((ele, index) => {
                ele.addEventListener('keydown', (e) => {
                    // if the keycode is backspace & the current field is empty
                    // focus the input before the current. Then the event happens
                    // which will clear the "before" input box.
                    if (e.keyCode === 8 && e.target.value === '') inputElements[Math.max(0, index - 1)].focus()
                })
                ele.addEventListener('input', (e) => {
                    // take the first character of the input
                    // this actually breaks if you input an emoji like 👨‍👩‍👧‍👦....
                    // but I'm willing to overlook insane security code practices.
                    const [first, ...rest] = e.target.value
                    e.target.value = first ?? '' // first will be undefined when backspace was entered, so set the input to ""
                    const lastInputBox = index === inputElements.length - 1
                    const didInsertContent = first !== undefined
                    if (didInsertContent && !lastInputBox) {
                        // continue to input the rest of the string
                        inputElements[index + 1].focus()
                        inputElements[index + 1].value = rest.join('')
                        inputElements[index + 1].dispatchEvent(new Event('input'))
                    }
                })
            })

            // mini example on how to pull the data on submit of the form

            // function onSubmit(e){
            // e.preventDefault()
            // const code = inputElements.map(({value})=>value).join('')
            // console.log(code)
            // }
        </script>
    @endpush
</x-app-layout>


