<?php

namespace Codebase\PageBuilder\Models;

use App\Support\Concerns\HasFactory;
use App\Traits\EscapeUniCodeJson;
use Codebase\PageBuilder\Concerns\HasEditablePage;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\Translatable\HasTranslations;

class StaticPage extends Model implements HasMedia
{
use HasFactory, InteractsWithMedia, HasEditablePage , HasTranslations , EscapeUniCodeJson;

    protected $guarded = [];
    protected $translatable = ['name'] ; 
    protected $casts = [
        'name' => 'json',
    ]; 

    
    public static function getByKey(string $key): ?StaticPage
    {
        return static::where('key', $key)->first();
    }

    public function getTemplateId(): string
    {
        return $this->template_id ?? '';
    }
}
