<?php

namespace Codebase\PageBuilder\Editor;

use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class GenerateBlocks
{
    private string $locale;

    public static function forModel($model, $localization = 'en')
    {
        return (new static())->fetch($model->getTemplateId(), $localization);
    }

    protected function fetch(string $identifier, string $localization)
    {
        $this->locale = $localization;
        $path = resource_path("views/page-builder/{$identifier}");

        $defaultPath = resource_path("views/page-builder/default");
        $this->directoryExist($path);

        $generalBlocksPath = $path.DIRECTORY_SEPARATOR."general";
        $localizationBlocksPath = $path.DIRECTORY_SEPARATOR.$localization;

        $default = $this->getBlocksFromDirectory($defaultPath, 'Default');
        $generalBlocks = $this->getBlocksFromDirectory($generalBlocksPath);
        $localizationBlocks = $this->getBlocksFromDirectory($localizationBlocksPath, 'Templates');

        return array_merge($generalBlocks, $localizationBlocks, $default);
    }

    private function getBlocksFromDirectory($directory, $group = 'General')
    {

        if (! File::isDirectory($directory)) {
            return [];
        }

        $files = File::allFiles($directory);

        $blocks = [];
        foreach ($files as $file) {
            $viewPath = str_replace(
                [resource_path('views/'), DIRECTORY_SEPARATOR], ['', '.'],
                $file->getPath()
            );
            $file_name = str_replace(".blade.php", "", $file->getBasename());
            $blocks [] = [
                'category' => $group,
                'id'       => 'block-'.$file->getFilename(),
                'label'    => Str::title(str_replace(["-"], " ", $file_name)),
                'content'  => view($viewPath.'.'.$file_name, $this->blockData())->render(),
                'media'    => '<svg viewBox="0 0 24 24"> <path d="M4 2h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2h-4l-4 4-4-4H4c-1.1 0-2-.9-2-2V4c0-1.1.9-2 2-2m0 2v12h4.83L12 19.17 15.17 16H20V4H4z"></path> </svg>',
            ];
        }

        return $blocks;
    }

    private function directoryExist($path)
    {
//        throw_if(! File::isDirectory($path), \RuntimeException::class,
//            "Cant find Blocks directory for the given model identifier");
    }

    private function blockData()
    {
        return [
            'locale' => $this->locale,
            '__'     => fn ($i) => __($i, [], $this->locale),
        ];
    }
}
