@props([
'name',
'options'=>[],
'label'=>'',
'id'=>'',
'class' => "",
'selected'=>null,
'selectedId'=>1,
'selectedIds'=>null,
'columnName'=>null,
'selectedColumnName'=>null,
'whereColumnName'=>null,
'whereColumnId'=>null,
'multiple'=>null,
'modelId'=>null,
'wrapperClass'=>null,
'currentClass'=>'',
'productId'=>'',
'variationId'=>'',
'dialogId'=>null
])
<div class="form-group row no-gutters {{$class}} {{$wrapperClass}}">
    <label
        class="col-sm-12 col-form-label text-left  {{ $errors->has(dotted_string($name)) ? 'text-danger' : '' }}">
        {{ $label }}
    </label>
    @php

        $splitAttributes = explode(' ',$attributes);
        $invalidClass =$errors->has(dotted_string($name)) ? 'is-invalid' : '';
        $defaultPlaceHolder = !$multiple ? __('Select') .' '. __(':name',['name'=>$label]) : null;
        // 'data-model-class'=>$modelClass,
       $properties = [
         'class'=>"dashboard-form-other-variations-ajax {$invalidClass} form-control" ,
         'id'=>"{$id}" ,
         'placeholder'=> $defaultPlaceHolder,
         ...$splitAttributes,
         'multiple'=>$multiple,
         'data-current-class'=>$currentClass,
         'data-placeholder-ajax'=>$defaultPlaceHolder,
         'data-model-dialog-id'=>$dialogId,
         'data-selected-id'=> $selectedId,
         'data-product-id'=> $productId,
         'data-variation-id'=> $variationId,
         'data-route'=> route('dashboard.catalog.get-variations-belongs-to-other'),
         //'data-selected-route'=> $selectedId !== null ? route('dashboard.core.selected-model-ajax',['modelClass'=>$modelClass,'id'=>$selectedId,'columnName'=>$columnName]) : '',
        ];

    @endphp

    <div class="col-sm-12">
        {!! !$slot->isEmpty() ?  $slot : Form::select($name,$options,$selected,$properties) !!}
        @error(dotted_string($name))
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
</div>


