@props([ 'name', 'type'=>'text', 'value'=>null, 'label'=>'', 'class'=>'','labelClass'=>null ,'wrapperClass'=>null])
@php
    $invalidClass =$errors->has(dotted_string($name)) ? 'is-invalid' : '';
    $splitAttributes = explode(' ',$attributes);
    $defaultPlaceHolder = __('Enter ').__(':name',['name'=>$label]);
    $properties = [
    'class'=>"form-control mb-2 mt-2 hijri-date-input {$invalidClass} {$class}" ,
    'placeholder'=> $defaultPlaceHolder,
    ...$splitAttributes,
    ];
@endphp
<div class="col-sm-12 {{$wrapperClass}}">
    <div class="form-group row no-gutters">
        <label
                class="col-sm-12 form-label text-left {{$labelClass}} {{ $errors->has(dotted_string($name)) ? 'text-danger' : '' }}">
            {{ $label }}
            @if($attributes['required'])
                <span class="text-danger align-items-center">*</span>
            @endif
        </label>
        <div class="col-sm-12" style="position: relative;">
            @if(!in_array($type,['file','password']))
                {!! Form::$type($name,$value,$properties) !!}
            @else
                {!! Form::$type($name,$properties) !!}
            @endif

            {{ $slot }}
            @error(dotted_string($name))
            <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>
    </div>
</div>
