<?php

namespace App\Support\Dashboard\Crud;

use Illuminate\Database\Eloquent\Model;
use Validator;

trait WithUpdate
{
    protected function updateAction(array $validated, Model $model)
    {
        $model->update($validated);

        return null;
    }

    public function update($id)
    {

        $model = ($this->model)::findOrFail($id);

        if (request()->ajax() && request()->updateStatus == 1) {
            return $this->updateStatusWithAjax($model, request()->status);
        }

        $validated = $this->validationAction();

        $action = $this->updateAction($validated, $model);

        return $action ?? $this->successfulRequest();
    }

    public function updateStatusWithAjax($model, $status)
    {
        // Validate the input
        $validator = Validator::make(
            ['status' => $status],
            ['status' => 'required|in:active,inactive']
        );

        if ($validator->fails()) {
            // Return the validation error response
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first(),
                'errors' => $validator->errors(),
            ], 422);
        }

        // Update the model status
        $model->status = $status;
        $model->save();

        // Return a success response
        return response()->json([
            'success' => true,
            'message' => __('Status updated successfully'),
            'status' => $model->status,
        ]);
    }
}