<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    public const HOME = '/';
    protected $namespace = 'App\\Http\\Controllers';

    public function boot()
    {
        $this->configureRateLimiting();

        $this->routes(function () {

//            foreach ($this->centralDomains() as $domain) {

                Route::prefix('api')->middleware(['api'])
                    ->namespace("{$this->namespace}\\API")
                    ->as('api.')
//                    ->domain($domain)
                    ->group(base_path('routes/api/api.router.php'));

                Route::middleware('web')
//                    ->domain($domain)
                    ->group(base_path('routes/dashboard/dashboard.router.php'));
                Route::middleware('web')
                    ->namespace($this->namespace)
//                    ->domain($domain)
                    ->group(base_path('routes/frontend/frontend.router.php'));
//            }

        });
    }

//    protected function centralDomains(): array
//    {
//        return config('tenancy.central_domains', []);
//    }

    /**
     * Configure the rate limiters for the application.
     *
     * @return void
     */
    protected function configureRateLimiting()
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });
    }
}
