<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class VerificationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $verificationUrl;

    public function __construct($verificationUrl)
    {
        $this->verificationUrl = $verificationUrl;
    }

    public function build()
    {
       $country = request('country')??'en'; // Get the first segment as the country
            if( request('country') == 'about'
                ||  request('country') == 'contact'
                || request('country')== 'terms-of-use'
                || request('country')== 'privacy-policy'
            ){
                $country = 'en';
            }
    
        return $this->subject(googleTrans('Please verify your email address', countryLang($country)))
            ->markdown("emails.{$country}.verification") // Create this view
            ->with([
                'url' => $this->verificationUrl
            ])
            ->tag('verification');
    }
}