<?php

namespace App\Http\Resources\API\User;

use Illuminate\Http\Resources\Json\JsonResource;

class WalletTransactionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $lang = config('app.locale');

        return [
            'id' => $this->id,
            'amount' => $this->amount,
            'type' => $this->type,
            'type_value' => __($this->type),
            'lang' => $lang,
            'description' => isset($this->meta['description']) && is_string($this->meta['description'])
                ? (json_decode($this->meta['description'])?->{$lang} ?? $this->meta['description'])
                : '',
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
        ];
    }
}
