<?php

namespace App\Http\Resources\API\User;

use App\Http\Resources\API\Core\BrandResource;
use App\Http\Resources\API\Core\CarTypeResource;
use App\Support\Resources\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class UserCarResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'brand' => new BrandResource($this->brand),
            'car_type' => new CarTypeResource($this->car_type),
            'manufacture_year' => $this->manufacture_year,
            'chassis_number' => $this->chassis_number,
            'is_default' => (boolean)$this->is_default,
            'created_at' => $this->created_at,
        ];
    }
}
