<?php

namespace App\Http\Resources\API\Order;

use App\Domain\Order\Actions\CanSelectServicesOrSparePartAction;
use App\Support\Traits\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceOrderResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {

        return [
            'id' => $this->id,
            'title' => $this->service?->title,
            'price' => $this->price,
            'description' => $this?->description,
            'qty' => $this->qty,
            'is_accepted' => $this->status === 'accepted',
            'allow_selectable' => $this->paid === 0 && (new CanSelectServicesOrSparePartAction())($this->order),
            'image' => !empty($this->service->getFirstMediaUrl('image')) ? $this->service->getFirstMediaUrl('image') : asset('brands/car-service.png'),

        ];
    }


}
