<?php

namespace App\Http\Resources\API\Order;

use App\Domain\Order\OrderStatus\Enums\AppointmentOrderStatusEnum;
use App\Domain\Order\OrderStatus\Enums\SparePartOrderStatusEnum;
use App\Domain\Order\OrderStatus\Enums\WenchOrderStatusEnum;
use App\Http\Resources\API\Order\ServiceOrderResource;
use App\Http\Resources\API\Job\OfferResource;
use App\Http\Resources\API\Order\SparePartOrderResource;
use App\Http\Resources\API\Job\SparePartResource;
use App\Http\Resources\API\User\VendorResource;
use App\Support\Traits\WithPagination;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $status = match (true) {
            ($this?->type == 'appointment' && $this->status) =>
            AppointmentOrderStatusEnum::{$this->status}()->value,
            ($this?->type == 'spare_part' && $this->status) =>
            SparePartOrderStatusEnum::{$this->status}()->value,
            ($this?->type == 'wench' && $this->status) =>
            WenchOrderStatusEnum::{$this->status}()->value,
            default => __('Status None')
        };
        return [
            'id' => $this->id,
            'order_num' => $this->order_num,
            'status' => $this->status,
            'status_value' => $status,
            'type' => $this->type,
            'type_for_customer' => __($this->type),
        ];
    }

}
