<?php

namespace App\Http\Requests\Dashboard\Order;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class OrderRequest extends FormRequest
{
    public function rules()
    {

        $rules = [
            'type' => 'required|string',
            'in_cart' => 'sometimes|nullable|string',
            'car_plate' => 'sometimes|nullable|string|max:15',
            'customer_tax_number' => 'sometimes|nullable|string',
            'brand_id' => 'required|integer|exists:brands,id',
            'car_type_id' => 'required|integer|exists:car_types,id',
            'branch_id' => 'required|integer|exists:branches,id',
            'user_id' => 'required|integer|exists:users,id',
            'problem_id' => 'required|integer|exists:problems,id',
            'company_id' => 'sometimes|nullable|integer|exists:companies,id',
            'discount_percentage' => 'required|integer',
            'delivery_direction' => 'sometimes|nullable|string',
            //'payment_method' => 'sometimes|nullable|string',
            //'payment_status' => 'sometimes|nullable|string',
            'customer_note' => 'sometimes|nullable|string',
            'maintenance_days' => 'sometimes|nullable|integer',
            'reservation_time' => 'required|date|after_or_equal:today',
            'address' => 'required_if:type,==,wench|sometimes|nullable|string',
            'lat' => 'required_if:type,==,wench|sometimes|nullable|string',
            'lng' => 'required_if:type,==,wench|sometimes|nullable|string',
            'address_return' => 'required_if:type,==,wench|sometimes|nullable|string',
            'lat_return' => 'required_if:type,==,wench|sometimes|nullable|string',
            'lng_return' => 'required_if:type,==,wench|sometimes|nullable|string',
        ];

        if (request()->isMethod('put')) {
            $rules['user_id'] = 'sometimes|nullable|integer|exists:users,id';
            $rules['branch_id'] = 'sometimes|nullable|integer|exists:branches,id';
            $rules['car_type_id'] = 'sometimes|nullable|integer|exists:car_types,id';
            $rules['brand_id'] = 'sometimes|nullable|integer|exists:brands,id';
            $rules['problem_id'] = 'sometimes|nullable|integer|exists:problems,id';
            $rules['type'] = 'sometimes|nullable|string';
            $rules['reservation_time'] = 'sometimes|nullable|date';
        }
        return $rules;

    }
}
