<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Mail\VerificationMail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Cache;
use Illuminate\Support\Facades\Log;
class SubmitFormApiController extends Controller
{
    const ANIME_CAMPAIGN_ID = 16041;
    const LEADS_DIGGERS_LINK_ID = 108;
    const ANIME_KEY = "TVRNek5qVmZOekl4WHpFek16WTFYdz09";
    const ANIME_PASSWORD = "0EqyCtjrpc";
    const ANIME_URL = "https://tracker.trackedtomouegde.com/repost.php?act=register";
    const LEADS_DIGGERS_URL = "https://tracking.leadsdiggers.com/api/v3/integration?api_token=0NBu8CIqKi77nQO7bWMec7mJELGwO2EHHI0q5QslgnssDEm0Q2SrMpALeVEV";

    const CLCKSON_URL = "https://clckson-api.com/api/v2/leads";
    const CLCKSON_API_KEY = "CE211EF6-B151-F7C6-1403-F7A7CE3E98AD";
    const ZEROBOUNCE_API_KEY = "27dc7b669f334a29b9143caa372b2286";
   
public function SubmitForm(Request $request)
{
    $country = $request->country;
    $customMessages = [
        'first_name.required' => googleTrans('First name is required.', countryLang($country)),
        'first_name.string' => googleTrans('First name must be text.', countryLang($country)),
        'last_name.required' => googleTrans('Last name is required.', countryLang($country)),
        'last_name.string' => googleTrans('Last name must be text.', countryLang($country)),
        'email.required' => googleTrans('Email address is required.', countryLang($country)),
        'email.email' => googleTrans('Please enter a valid email address.', countryLang($country)),
        'email.rfc' => googleTrans('The email format is invalid.', countryLang($country)),
        'email.dns' => googleTrans('The email domain does not exist or is not properly configured.', countryLang($country)),
        'phone.required' => googleTrans('Phone number is required.', countryLang($country)),
        'phone.string' => googleTrans('Phone number must be text.', countryLang($country)),
        'country_code.required' => googleTrans('Country code is required.', countryLang($country)),
        'country_code.string' => googleTrans('Country code must be text.', countryLang($country)),
        'country_name.required' => googleTrans('Country name is required.', countryLang($country)),
        'country_name.string' => googleTrans('Country name must be text.', countryLang($country)),
    ];

    $validator = Validator::make($request->all(), [
        'first_name' => 'required|string',
        'last_name' => 'required|string',
        'email' => [
            'required',
            'email:rfc,dns', // This validates that the domain has valid DNS records
            function ($attribute, $value, $fail) use ($country) {
                $parts = explode('@', $value);
                $domain = end($parts);

                $allowedDomains = [
                    'gmail.com',
                    'yahoo.com',
                    'hotmail.com',
                    'outlook.com',
                    'gmx.de',
                    'icloud.com',
                    'emaily.pro',
                    'mohmal.com'
                    // Add more domains as needed
                ];

                $blacklistDomains = [
                    'tem111pmail.com',
                    'disposta111ble.com'
                    // Add more blacklisted domains as needed
                ];

                // Check if domain is blacklisted
                if (in_array($domain, $blacklistDomains)) {
                    $fail(googleTrans('This email domain is not allowed.', countryLang($country)));
                    return;
                }

                // Check allowed domains only if configuration requires it
                if(config('form.check_domains') == 'yes'){
                    if (!in_array($domain, $allowedDomains)) {
                        $fail(googleTrans('This email domain is not allowed.', countryLang($country)));
                        return;
                    }
                }

                // ZEROBOUNCE API Integration
                $zerobounceEnabled = env('ZEROBOUNCE_ENABLED', true);
                $zerobounceApiKey = self::ZEROBOUNCE_API_KEY;

                if ($zerobounceEnabled && $zerobounceApiKey) {
                    try {
                        $verifyResponse = Http::get("https://api.zerobounce.net/v2/validate?email=$value&api_key=$zerobounceApiKey");
                        if ($verifyResponse->successful()) {
                            $status = $verifyResponse->json('status');
                            $subStatus = $verifyResponse->json('sub_status');

                            if ($status == 'valid') {
                                return;
                            } else if ($status == 'unknown') {
                                $fail(googleTrans('This email address could not be verified.', countryLang($country)));
                                return;
                            } else if ($status == 'invalid' && $subStatus == 'mailbox_not_found') {
                                $fail(googleTrans('This email address is invalid or does not exist.', countryLang($country)));
                                return;
                            } else {
                                $fail(googleTrans('This email is not allowed', countryLang($country)));
                                return;
                            }
                        } else {
                            $fail(googleTrans('ZeroBounce: Exception during email verification', countryLang($country)));
                            return;
                        }

                    } catch (\Exception $e) {
                        $fail(googleTrans('ZeroBounce: Exception during email verification', countryLang($country)));
                        return;
                    }
                }
            },
        ],
        'phone' => 'required|string',
        'country_code' => 'required|string',
        'country_name' => 'required|string',
    ], $customMessages);
   
    if ($validator->fails()) {
        return $this->apiResponse(false, $validator->errors()->first());
    }
    
    $verificationMode = config('form.verification_mode');
    $ip = $request->header('CF-Connecting-IP') ?? $request->header('X-Forwarded-For') ?? $request->ip();
   
    $request_data = [
        'first_name' => $request->input('first_name'),
        'last_name' => $request->input('last_name'),
        'phone' => $request->input('phone'),
        'email' => $request->input('email'),
        'ip' => $ip,
        'country_code' => $request->input('country_code'),
        'country_name' => $request->input('country_name'),
        'source_domain' => $request->getHost(),
        'country' => $country,
        'verification_mode' => $verificationMode,
        'website_title' => env('Website_title'),
        'language' => $request->input('lang', 'en'),
    ];


    $response = Http::withHeaders([
        'Content-Type' => 'application/json',
        'Accept-Language' => $country,
        'Accept' => 'application/json'
    ])->asForm()->post('https://omall1.com/api/submit-form', $request_data);

    $result = $response->body();
    $jsonResult = $response->json();
    
    if ($response->successful()) {
        return $jsonResult;
    } else {
        return response()->json(['error' => 'API request failed'], $response->status());
    }
}

    private function handleVerification(Request $request, $isRetry = false)
    {
       
        $validator = Validator::make($request->all(), [
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'email' => 'required|email',
            'phone' => 'required|string',
            'country_code' => 'required|string',
            'country_name' => 'required|string',
        ]);

        if ($validator->fails()) {
            return $this->apiResponse(false, $validator->errors()->first());
        }

        // Generate unique hash for this submission
        $submissionHash = md5($request->input('phone') . $request->input('email'));
        session(['last_submission_hash' => $submissionHash]);

        // إضافة الـ IP إلى البيانات
        $requestData = $request->all();
        $requestData['ip'] =  $request->header('CF-Connecting-IP') ?? $request->header('X-Forwarded-For') ?? $request->ip();
        $requestData['submission_hash'] = $submissionHash;

        $verificationCode = Str::random(40);

        $submissionData = [
            'data' => $requestData,
            'code' => $verificationCode,
            'created_at' => now(),
        ];

        Storage::put("verifications/{$verificationCode}.json", json_encode($submissionData));

        $this->sendVerificationEmail($request->email, $verificationCode);
        return response()->json([
            'success' => false,
            'type' => 'email_sent',
            'message' => googleTrans('Verification email has been sent successfully', countryLang($request->country)),
            'data' => null
        ], 200);
    }

    public function verifySubmission($code)
    {
        $filePath = "verifications/{$code}.json";

        if (!Storage::exists($filePath)) {
            return $this->apiResponse(false, 'Invalid verification code');
        }

        $data = json_decode(Storage::get($filePath), true);

        
        $response = $this->processSubmission(new Request($data['data']));
       
        $content = json_decode($response->getContent(), true);
        if(isset($content['url'])){

              return redirect($content['url']);
        }else{
            return $content['message'];
        }
    }

    private function processSubmission(Request $request)
    {
        $country = $request->input('country');

        // Generate a unique hash for the submission
        $submissionHash = md5($request->input('phone') . $request->input('email'));

        // Retrieve the hash from the session to check for retries
        $previousHash = session('last_submission_hash');

        // If the current hash matches the previous hash, mark as a retry
        $isRetry = $previousHash === $submissionHash;

        $validator = Validator::make($request->all(), [
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'email' => 'required|email',
            'phone' => 'required|string',
            'country_code' => 'required|string',
            'country_name' => 'required|string',
        ]);

        if ($validator->fails()) {
            return $this->apiResponse(false, googleTrans($validator->errors()->first(), countryLang($country)));
        }

        // Update session with the current hash
        session(['last_submission_hash' => $submissionHash]);

        $countryRatios = [
            'gg' => ['anime' => 0, 'leads_diggers' => 50, 'clckson' => 50],
            'gg' => ['anime' => 30, 'leads_diggers' => 35, 'clckson' => 35],
        ];

        $defaultRatios = ['anime' => 100, 'leads_diggers' => 0, 'clckson' => 0];

        $ratios = $countryRatios[$request->input('country_name')] ?? $defaultRatios;

        $endpoints = [
            ['type' => 'anime', 'percentage' => $ratios['anime']],
            ['type' => 'leads_diggers', 'percentage' => $ratios['leads_diggers']],
            ['type' => 'clckson', 'percentage' => $ratios['clckson']],
        ];

        $random = mt_rand(1, 100);
        $selectedEndpoint = null;
        $cumulativePercentage = 0;

        foreach ($endpoints as $endpoint) {
            $cumulativePercentage += $endpoint['percentage'];
            if ($random <= $cumulativePercentage) {
                $selectedEndpoint = $endpoint;
                break;
            }
        }
         switch ($selectedEndpoint['type']) {
                case 'anime':
                    return $this->handleAnimeAPI($country, $isRetry, $request);
                case 'leads_diggers':
                    return $this->handleLeadsDiggersAPI($country, $isRetry, $request);
                case 'clckson':
                    return $this->handleClcksonAPI($country, $isRetry, $request);
                default:
                    throw new \Exception('Invalid endpoint selected');
            }
        try {
           
        } catch (\Exception $e) {
            \Log::error('API Request Failed', ['error' => $e->getMessage(), 'trace' => $e->getTrace()]);
            return $this->apiResponse(false, 'An unexpected error occurred. Please try again later.', null, null, null, 500);
        }
    }


    private function updateIpLog($ip)
    {
        $ipLogPath = storage_path('app/ips.json');
        $ips = file_exists($ipLogPath)
            ? json_decode(file_get_contents($ipLogPath), true)
            : [];

        // Store IP with timestamp and expiration (30 days)
        $ips[$ip] = [
            'first_verified' => now()->toDateTimeString(),
            'last_verified' => now()->toDateTimeString(),
            'expires_at' => now()->addDays(30)->toDateTimeString()
        ];

        file_put_contents($ipLogPath, json_encode($ips, JSON_PRETTY_PRINT));
    }

    private function sendVerificationEmail($email, $code)
    {
        $verificationUrl = route('verify.submission', [
            'code' => $code,
            'utm_campaign' => 'verification'
        ]);
    
        try {
            Mail::to($email)
                ->send(new VerificationMail($verificationUrl));
            
            // Optional: Log successful email sending
            \Log::info("Verification email sent to {$email}");
            
        } catch (\Exception $e) {
            \Log::error("Failed to send verification email to {$email}: " . $e->getMessage());
            throw $e; // Or handle gracefully depending on your needs
        }
    }
 

    private function handleAnimeAPI($country, $isRetry, Request $request)
    {
        if ($isRetry && $this->hasRetryFlag($request, 'anime')) {
            return $this->apiResponse(false, 'Anime API already retried.', null, null, null, 400);
        }

        list($firstname, $lastname, $email, $phone, $country_code, $country_name, $ip, $language, $pageName) = $this->AllData($request);

        $request_data = [
            'ApiKey' => self::ANIME_KEY,
            'ApiPassword' => self::ANIME_PASSWORD,
            'Email' => $email,
            'FirstName' => $firstname,
            'LastName' => $lastname,
            'IP' => $ip,
            'CampaignID' => self::ANIME_CAMPAIGN_ID,
            'PhoneNumber' => $country_code . $phone,
            'Page' => $pageName,
            'brand' => $pageName,
            'Language' => $language,
        ];

        $response = Http::asForm()->post(self::ANIME_URL, $request_data);

        if ($response->successful()) {
            $data = $response->json();

            if (isset($data['ret_code'])) {
                switch ($data['ret_code']) {
                    case "200":
                        $this->createClient([
                            'first_name' => $firstname,
                            'last_name' => $lastname,
                            'phone' => $country_code . $phone,
                            'country_code' => $country_name,
                            'email' => $email,
                            'ip' => $ip
                        ]);
                        if (config('form.verification_mode') === 'email_and_ip' ||config('form.verification_mode')=== 'ip_only') {
                            $this->updateIpLog($ip);
                        }
                        return $this->apiResponse(true, null, null, route('thank-you', [
                            'country' => $country,
                            'redirect_url' => urlencode($data['url']),
                        ]));
                    case "404":
                        $message = match ($data['ret_message']) {
                            "Invalid Phone" => googleTrans('Invalid Phone', countryLang($country)),
                            "Invalid Email" => googleTrans('Invalid Email', countryLang($country)),
                            "No brand found" => googleTrans('No brand found', countryLang($country)),
                            default => googleTrans('Unknown error', countryLang($country)),
                        };
                        return response()->json(['success' => false, 'message' => googleTrans($message, countryLang($country)), 'data' => null], 200);
                    case "409":
                        return response()->json(['success' => false, 'type' => 'duplicate', 'message' => googleTrans('Duplicate Lead!', countryLang($country)), 'data' => null], 200);
                    case "201":
                         $this->createClient([
                            'first_name' => $firstname,
                            'last_name' => $lastname,
                            'phone' => $country_code . $phone,
                            'country_code' => $country_name,
                            'email' => $email,
                            'ip' => $ip
                        ]);
                        if (config('form.verification_mode') === 'email_and_ip' || config('form.verification_mode')=== 'ip_only') {
                           $this->updateIpLog($ip);
                        }
                        return $this->apiResponse(false, googleTrans('Brand is closed now', countryLang($country)), 'brand_closed', url(countryRedirectOnError($country)), null, 200);

                }
            }
        }

        return $this->apiResponse(false, $response->body(), null, null, null, $response->status());
    }
    
    public function createClient($data)
    {
      
         try {
            $response = Http::asForm()->withHeaders([
                'Accept' => 'application/json',
            ])->post('https://omall1.com/api/clients', $data);
            if($response){
                 \Log::info('saved data to server:', ['data' => $response->json()]);
                 return true;
            }
        } catch (\Exception $e) {
             \Log::error('API Client Request Failed', ['error' => $e->getMessage(), 'trace' => $e->getTrace()]);
            return false;
        }
      
    }

    private function handleLeadsDiggersAPI($country, $isRetry, Request $request)
    {

        list($firstname, $lastname, $email, $phone, $country_code, $country_name, $ip, $language, $pageName) = $this->AllData($request);

        $request_data = [
            'link_id' =>  self::LEADS_DIGGERS_LINK_ID,
            'email' => $email,
            'fname' => $firstname . ' ' . $lastname,
            'ip' => $ip,
            'fullphone' => '+' . $country_code . $phone,
            'source' => $pageName,
            'country' => Str::upper($country_name),
            'language' => $language,
        ];

        $response = Http::asForm()->post(self::LEADS_DIGGERS_URL, $request_data);

        if ($response->successful()) {
            $data = $response->json();

            if ($data['success']) {
                 $this->createClient([
                            'first_name' => $firstname,
                            'last_name' => $lastname,
                            'phone' => $country_code . $phone,
                            'country_code' => $country_name,
                            'email' => $email,
                            'ip' => $ip
                        ]);
               if (config('form.verification_mode') === 'email_and_ip' || config('form.verification_mode') === 'ip_only') {
                           $this->updateIpLog($ip);
                        }
                return $this->apiResponse(true, null, null, route('thank-you', [
                    'country' => $country,
                    'redirect_url' => urlencode($data['autologin']),
                ]));
            }
        }

        $this->setRetryFlag($request, 'leads_diggers');
        return $this->handleAnimeAPI($country, true, $request);
    }
    private function handleClcksonAPI($country, $isRetry, Request $request)
    {
        if ($isRetry && $this->hasRetryFlag($request, 'clckson')) {
            return response()->json([
                'success' => false,
                'message' => googleTrans('Clckson API already retried.', countryLang($country)),
                'data' => null
            ], 200);
        }

        list($firstname, $lastname, $email, $phone, $country_code, $country_name, $ip, $language, $pageName) = $this->AllData($request);

        // Generate a random password if not provided
        // Generate a password that only contains letters and numbers
        $password = $request->input('password', function() {
            $length = 10;
            $uppercase = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $lowercase = 'abcdefghijklmnopqrstuvwxyz';
            $numbers = '0123456789';

            $password = '';
            // Ensure at least one uppercase
            $password .= $uppercase[rand(0, strlen($uppercase) - 1)];
            // Ensure at least one lowercase
            $password .= $lowercase[rand(0, strlen($lowercase) - 1)];
            // Ensure at least one number
            $password .= $numbers[rand(0, strlen($numbers) - 1)];

            // Fill the rest with random characters (only letters and numbers)
            $characters = $uppercase . $lowercase . $numbers;
            for ($i = 3; $i < $length; $i++) {
                $password .= $characters[rand(0, strlen($characters) - 1)];
            }

            // Shuffle the password
            return str_shuffle($password);
        });
        $request_data = [
            'email' => $email,
            'firstName' => $firstname,
            'lastName' => $lastname,
            'password' => $password,
            'ip' => $ip,
            'phone' => $phone,
            'areaCode' => $country_code,
            'offerName' => $pageName,
        ];

        try {
            $response = Http::withHeaders([
                'Api-Key' => self::CLCKSON_API_KEY,
            ])->post(self::CLCKSON_URL, $request_data);

            $data = $response->json();
            \Log::info('Clckson API Response:', ['data' => $data]);

            // Success case - has redirect URL
            if (isset($data['details']['redirect']['url'])) {
                 $this->createClient([
                            'first_name' => $firstname,
                            'last_name' => $lastname,
                            'phone' => $country_code . $phone,
                            'country_code' => $country_name,
                            'email' => $email,
                            'ip' => $ip
                        ]);
                        if (config('form.verification_mode') === 'email_and_ip' || config('form.verification_mode')=== 'ip_only') {
                           $this->updateIpLog($ip);
                        }
                return response()->json([
                    'success' => true,
                    'data' => $data,
                    'url' => route('thank-you', [
                        'country' => $country,
                        'redirect_url' => urlencode($data['details']['redirect']['url']),
                    ])
                ], 200);
            }

            // Handle registration errors
            if (isset($data['code']) && $data['code'] === 30000) {
                if (!empty($data['errors'])) {
                    $this->setRetryFlag($request, 'clckson');
                    return $this->handleAnimeAPI($country, true, $request);
                }
            }

            // Rate limit error
            if (isset($data['message']) && str_contains($data['message'], 'attempts for registration')) {
                $this->setRetryFlag($request, 'clckson');
                return $this->handleAnimeAPI($country, true, $request);

            }

            // Location error
            if (isset($data['errors']) && !empty($data['errors'])) {
                $this->setRetryFlag($request, 'clckson');
                return $this->handleAnimeAPI($country, true, $request);
            }
            $this->setRetryFlag($request, 'clckson');
            return $this->handleAnimeAPI($country, true, $request);


        } catch (\Exception $e) {

            \Log::error('Clckson API Exception:', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);

            $this->setRetryFlag($request, 'clckson');
            return $this->handleAnimeAPI($country, true, $request);

            return response()->json([
                'success' => false,
                'message' => googleTrans('Service temporarily unavailable. Please try again later.', countryLang($country)),
                'data' => null
            ], 200);
        }
    }

    private function AllData(Request $request)
    {

        return [
            $request->input('first_name'),
            $request->input('last_name'),
            $request->input('email'),
            str_replace(' ', '', $request->input('phone')),
            $request->input('country_code'),
            $request->input('country_name'),
            $request->header('CF-Connecting-IP') ?? $request->header('X-Forwarded-For') ?? $request->ip(),
            strtoupper(substr($request->server('HTTP_ACCEPT_LANGUAGE', 'en'), 0, 2)),
            env('Website_title', 'test name'),
        ];
    }

    private function apiResponse($success, $message = null, $type = null, $url = null, $data = null, $status = 200)
    {
        return response()->json(compact('success', 'message', 'type', 'url', 'data'), $status);
    }

    private function setRetryFlag(Request $request, $api)
    {
        $request->merge(["retry_{$api}" => true]);
    }

    private function hasRetryFlag(Request $request, $api)
    {
        return $request->has("retry_{$api}");
    }
}
