<?php

namespace App\Http\Controllers\Frontend;

use App\Domain\Company\Models\Chart;
use App\Domain\Company\Models\Committee;
use App\Domain\Company\Models\Director;
use App\Domain\Core\Models\Plan;
use App\Domain\Core\Models\Service;
use App\Domain\FormsBuilder\Models\Form;
use App\Domain\Ticket\Models\Ticket;
use App\Domain\Ticket\Models\TicketsType;
use App\Http\Controllers\Controller;
use Codebase\PageBuilder\Models\StaticPage;
use Codebase\PageBuilder\PageBuilder;
use SEOMeta;

class PageController extends Controller
{
    public $page;

    public function getPage($key)
    {

        $this->page = PageBuilder::getPage($key);

        $page_title = StaticPage::where('key', $key)->first()?->name ?? " ";
        SEOMeta::setTitle($page_title);

        match ($key) {
            'about-us' => $this->defaultPage(),
            'contact-us' => $this->defaultPage(),
            default => $this->defaultPage()
        };

        $page = $this->page;

        return view('frontend.pages.show', compact('page'));
    }

    public function defaultPage()
    {
        $NotFoundRender = view('frontend.pages.default')->render();
        PageBuilder::addPlaceholder($this->page->html, 'packages', $NotFoundRender);
    }

}
