<?php

namespace App\Http\Controllers\Frontend\Order;

use App\Domain\Order\Models\Order;
use App\Http\Controllers\Controller;
use PDF;


class InvoiceController extends Controller
{
    public function __invoke($order_id)
    {
        $order = Order::find($order_id);
        $html = view('frontend.order.invoice', compact('order',))->render();
        // Generate the PDF
        $pdf = PDF::loadHtml($html);

        if (request('download')) {
            return $pdf->download('invoice - ' . $order->order_num . ' . pdf');
        }
        // Save or output the PDF
        return $pdf->stream('invoice - ' . $order->order_num . ' . pdf');
    }
}
