<?php

namespace App\Http\Controllers\API;

use App\Support\Utils\ResponseUtil;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Response;

class ApiController extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function sendResponse($result, $message) {
        return Response::json(ResponseUtil::makeResponse($message, $result));
    }

    public function sendError($error, $code = 200) {
        return Response::json(ResponseUtil::makeError($error), $code);
    }

    public function sendSuccess($message) {
        return Response::json([
            'status' => true,
            'message' => $message,
        ], 200);
    }
}
