<?php

namespace App\Exceptions;

use Illuminate\Auth\AuthenticationException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Response;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * A list of exception types with their corresponding custom log levels.
     *
     * @var array<class-string<\Throwable>, \Psr\Log\LogLevel::*>
     */
    protected $levels = [
        //
    ];

    /**
     * A list of the exception types that are not reported.
     *
     * @var array<int, class-string<\Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     *
     * @return void
     */
    public function register()
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    public function report(Throwable $exception)
    {
        if ($this->shouldReport($exception)) {
            $this->sendEmail($exception); // Sends an email
        }
        parent::report($exception);
    }

    protected function sendEmail(Throwable $exception)
    {
        if(env('app_env') == 'production'){
            try {
                \Mail::send('emails.exception', ['exception' => $exception], function ($message) {
                    $message->to('myhishamad2@gmail.com', 'hisham hilmy')
                        ->subject('SME Application Exception');
                });
            } catch (Throwable $ex) {
                logger()->error('Exception occurred when sending email', ['exception' => $ex]);
            }
        }
    }

    protected function unauthenticated($request, AuthenticationException $exception)
    {
        if ($request->expectsJson()) {
            return Response::json([
                'status' => false,
                'message' => 'Unauthenticated',
            ], 401);
        }
        return redirect()->guest($exception->redirectTo() ?? route('login'));
    }
}
