<?php

namespace App\Domain\User\Datatables;

use App\Domain\Core\Models\Administration\User;
use App\Domain\User\Models\Wench;
use App\Support\Dashboard\Datatables\BaseDatatable;
use App\Support\Dashboard\Datatables\Columns\ImageColumn;
use App\Support\Dashboard\Datatables\Columns\StatusColumn;
use App\Support\Dashboard\Datatables\Columns\UserColumn;
use HsmFawaz\UI\Services\RolesAndPermissions\RolesEnum;
use Illuminate\Database\Eloquent\Builder;
use Yajra\DataTables\Html\Column;

class AdminDatatable extends BaseDatatable
{
    public function query(): Builder
    {

        return User::whereHas('roles', function ($q) {
            $q->whereNotIn('name', ['company','Super Admin']);
        });
    }

    protected function columns(): array
    {
        return [
            Column::make('name')->title(__('User')),
            Column::make('phone')->title(__('Phone')),
            Column::make('email')->title(__('Email')),
            Column::computed('roles')->title(__('Roles')),
        ];
    }

    protected function orders(): array
    {
        return [
            'name' => fn($i, $k) => $i->orderBy('name', $k),
        ];
    }

    protected function filters(): array
    {
        return [
            'name' => function ($q, $k) {
                $q->where('name', 'like', "%$k%")
                    ->orWhere('last_name','LIKE',"%{$k}%")
                    ->orWhere('first_name','LIKE',"%{$k}%");
            },
        ];
    }

    protected function customColumns(): array
    {
        return [
            'name' => UserColumn::render(),
            'roles' => static function ($model) {
                $roles = [];
                foreach ($model->getRoleNames() as $name) {
                    if (in_array($name, RolesEnum::toValues(), true)) {
                        continue;
                    }
                    $roles[] = StatusColumn::render('success', $name);
                }
                if (count($roles) === 0) {
                    $roles[] = StatusColumn::render('secondary', __('No Role'));
                }

                return implode(' ', $roles);
            },
        ];
    }
}
