<?php

namespace App\Domain\Core\Models;

use App\Support\Concerns\HasFactory;
use Illuminate\Database\Eloquent\Model;
use JeroenG\Explorer\Application\Aliased;
use JeroenG\Explorer\Application\BePrepared;
use JeroenG\Explorer\Application\Explored;
use JeroenG\Explorer\Application\IndexSettings;
use JeroenG\Explorer\Domain\Analysis\Analysis;
use JeroenG\Explorer\Domain\Analysis\Analyzer\StandardAnalyzer;
use JeroenG\Explorer\Domain\Analysis\Filter\SynonymFilter;
use Laravel\Scout\Searchable;

class Article extends Model implements Explored, BePrepared, IndexSettings, Aliased
{
    use HasFactory;
    use Searchable;

    protected $guarded = [];
    protected $casts = ['tags' => 'json'];

    public function mappableAs(): array
    {
        return [
            'id' => 'keyword',

            'title' => [
                'type' => 'text',
                'analyzer' => 'synonym',
            ],

            'body' => [
                'type' => 'text',
                'analyzer' => 'synonym',
            ],
            'place' => 'keyword',
            'lifespan' => 'text',
            'period' => 'nested',
        ];
    }

    public function prepare($searchable): array
    {
        if ($searchable['place'] === 'Sicily') {
            $searchable['place'] = ['Italy', 'Sicily'];
        }
        dd($searchable);
        return $searchable;
    }

    public function toSearchableArray(): array
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'body' => $this->body,
            'place' => $this->place,
            'lifespan' => $this->lifespan,
            'period' => [
                'name' => $this->period_name,
            ],
        ];
    }

    public function indexSettings(): array
    {
        $synonymFilter = new SynonymFilter();
        $synonymFilter->setSynonyms(['mona lisa => leonardo']);

        $synonymAnalyzer = new StandardAnalyzer('synonym');
        $synonymAnalyzer->setFilters(['lowercase', $synonymFilter]);

        return (new Analysis())
            ->addAnalyzer($synonymAnalyzer)
            ->addFilter($synonymFilter)
            ->build();
    }
}
