<?php

namespace App\Domain\Core\Datatables;

use App\Domain\Core\Models\City;
use App\Support\Dashboard\Datatables\BaseDatatable;
use App\Support\Dashboard\Datatables\CustomFilters;
use Illuminate\Database\Eloquent\Builder;
use Yajra\DataTables\Html\Column;

class CityDatatable extends BaseDatatable
{
    public function query(): Builder
    {
        return City::query();
    }


    protected function filters(): array
    {
        return [
            'title.ar' => function ($q, $keyword) {
                return $q->where('title', 'like', '%' . $keyword . '%');
            }, 'title.en' => function ($q, $keyword) {
                return $q->where('title', 'like', '%' . $keyword . '%');
            },
        ];
    }

    protected function columns(): array
    {
        return [
            Column::make('title.ar')->title(__('Title') . ' ' . __('Ar'))
                ->content(''),
            Column::make('title.en')->title(__('Title') . ' ' . __('En'))
                ->content(''),

        ];
    }
}
