<?php

namespace App\Domain\Blog\Datatables;

use App\Domain\Blog\Models\Post;
use App\Support\Dashboard\Datatables\BaseDatatable;
use Illuminate\Database\Eloquent\Builder;
use Yajra\DataTables\Html\Column;

class PostDatatable extends BaseDatatable
{
    protected ?string $actionable = 'edit|delete|show';

    protected bool $indexer = false;

    protected ?int $defaultOrder = 1;

    public function query(): Builder
    {
        // Fetch posts with category relationship if needed
        return Post::with('category');
    }

    protected function columns(): array
    {
        return [
            Column::make('id')->title(__('Id')),
            Column::make('title')->title(__('Title')),
          /*
           *   Column::make('slug')->title(__('Slug')),
            Column::make('category.name.'.app()->getLocale())->title(__('Category')),
            Column::make('is_published')->title(__('Published')),
            Column::make('published_at')->title(__('Published At')),
            Column::make('seo_title.'.app()->getLocale())->title(__('SEO Title')),
           */

        ];
    }

    protected function customColumns(): array
    {
        return [
            'published_at' => function ($model) {
                return $model->published_at ? $model->published_at->format('Y-m-d') : __('N/A');
            },
            'is_published' => function ($model) {
                return $model->is_published ? __('Yes') : __('No');
            },
        ];
    }
}
