<?php

namespace App\Channels;

use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Log;
use Msegat;

class MsegatChannel
{
    protected $msegat;

    public function __construct(Msegat $msegat)
    {
        $this->msegat = $msegat;
    }

    public function send($notifiable, Notification $notification)
    {
        $GetNotification = \App\Domain\Marketing\Models\Notification::where('id', $notification->id)->first();
        $data = json_decode($GetNotification->data, true);

        $message = $notification->toMsegat($notifiable);
        $recipient = $notifiable->routeNotificationFor('msegat');
        // Send the message using the Msegat API
        Log::info($message . ' Has been sent to ' . $recipient);
        /*
         *  $msg = $this->msegat->sendMessage($recipient, $message);
         $statusCode = 'n' . $msg->code;
         if ($msg->code == 1) {
             $statusMessage = 'Sms success';
             $statusCode = 'M0000';
         } else {
             $statusMessage = 'Sms failed';
         }
         */
        $statusCode = 'n-1';
        $statusMessage = 'Sms Failed';
        $GetNotification->update([
            'data' => json_encode(array_merge($data, ['status_code_sms' => $statusCode, 'status_message_sms' => $statusMessage]))
        ]);

    }
}